/*****************************************************************
 *      Copyright (c) 1992 by Hughes LAN Systems
 *
 *      Program Name:   FDDI Concentrator application
 *
 *      Filename:       defalarm.h
 *
 *      Description: This file contains constants used by alarms and events
 *					 functions. It also contains the prototypes of routines 
 *					 used for defining alarms and events.
 *
 *	$Log:   /usr/shasta/pvcs/fddicon/include/defalarm.h_v  $
 * 
 *    Rev 1.7   14 Apr 1993 14:16:18   shekhar
 * changed FDPORT_ALARM_INTERVAL to 1 sec.
 * 
 *    Rev 1.6   16 Mar 1993 14:59:40   shekhar
 * 
 *    Rev 1.5   01 Mar 1993 13:42:36   shekhar
 * 
 *    Rev 1.4   26 Feb 1993 12:04:30   shekhar
 * 
 *    Rev 1.3   22 Feb 1993 13:54:22   jang
 * 
 *    Rev 1.2   22 Feb 1993 12:08:20   shekhar
 * 
 *    Rev 1.1   19 Feb 1993 16:19:44   shekhar
 * 
 *    Rev 1.0   17 Feb 1993 15:46:10   shekhar
 * Initial revision.
 * 
 *	1-000		2-16-93		Shekhar Ambe
 *		- Original
 *
 *******************************************************************
 */

#ifndef __DEFALARM_H_

#define __DEFALARM_H_

#define MAX_OIDCOMP_LEN		32		/* max oid len 							*/
#define MAX_STRCOMP_LEN		128		/* max string len 						*/
#define	MAX_AL_SUPPORTED	10		/* max user defined alarms supported	*/
#define MAX_EV_SUPPORTED	10		/* max user defined events supported    */ 

/* space elements is required for 2 alarms objects (alarmVariable & Owner )
   and 3 event objects (Owner, Community and Decription).					*/
#define MAX_ALEV_ELES	(2 * MAX_AL_SUPPORTED +  3 * MAX_EV_SUPPORTED)

#define	ALARM_ABS_VAL			1
#define ALARM_DELTA_VAL			2

#define RISING_ALARM			1
#define FALLING_ALARM			2
#define RISINGORFALLING_ALARM	3

/* definitions of alarm interval */
#define SMT_CFSTATE_INTERVAL    	30
#define FDPORT_ALARM_INTERVAL   	1	
#define CONFIG_CHG_INTERVAL			30
#define	UNDESIRED_CONN_INTERVAL 	30
#define PATH_TRACE_INTERVAL			30
#define	NEIGHBOR_CHANGE_INTERVAL 	30
#define MAC_FRAMEERR_INTERVAL		30
#define	PORT_LER_INTERVAL			30
#define MAC_NOTCP_INTERVAL			30
#define MAC_DUP_ADDR_INTERVAL		30
#define PORT_EBERR_INTERVAL			30

/* structure to store strings and oids related to alarms and events. */
typedef struct 
	{
	int		inuse;
	union 	{
			char		a_string[MAX_STRCOMP_LEN];
			UINT_32_T	a_oid[MAX_OIDCOMP_LEN];
			}	a_storage;
	} ALEV_SPACE_ELE;

#define MAX_OWNER_LEN		128	
#define	MAX_COMMUNITY_LEN	128		
#define	MAX_DESCR_LEN		128	

/* structure used to store alarms in nvram */
typedef struct
	{
	uint	Index;
	uint	Interval;
	uint	Type;
	uint	Startupalarm;
	uint	RisingThreshold;
	uint	FallingThreshold;
	uint	RisingEventIndex;
	uint	FallingEventIndex;
	uint	OidLen;
	uint	Oids[MAX_OIDCOMP_LEN];
	char	Owner[MAX_OWNER_LEN];
	uint	Status;
	} NVR_ALARM_ENTRY;

/* structure used to store events in nvram */
typedef struct
	{
	uint	Index;
	uint	Type;
	char	Descr[MAX_DESCR_LEN];
	char	Community[MAX_COMMUNITY_LEN];	
	char	Owner[MAX_OWNER_LEN];
	uint	Status;
	} NVR_EVENT_ENTRY;
	

/* external definitions */
extern int 	create_nvr_alarms();
extern int 	create_nvr_events();
extern int 	PutAlarmRec();
extern int 	PutEventRec();

extern int 	init_userdefined_alev();
extern void *get_alev_space_ele();
extern void free_alev_space_ele( void *ptr);
extern int	init_alarm_record();
extern int	init_event_record();
extern int  delete_alarm_entry();
extern int  delete_event_entry();
extern int	update_alarm_nvram();
extern int	update_event_nvram();
extern int  IsAlarmEntriesFull();
extern int  IsEventEntriesFull();
extern int 	svc_def_alInterval(uint Interval);
extern int  svc_def_StartupAlarm(uint StartupAlarm);
extern int  svc_def_OwnerAlarm(char *Owner);
extern int 	svc_def_alarm_entry(uint alIndex, uint *alVar, uint alVarLen, 
							   uint alInterval, uint alSampleType, 
							   uint alStartup, uint alRisingTh, 
							   uint alFallingTh, uint alRisingEvIndex, 
							   uint alFallingEvIndex);
extern int 	svc_def_event_entry(uint evIndex, uint evType, char *evDescr, 
							   char *evCommunity);
extern int svc_purge_alarm_entry(uint alIndex);
extern int svc_purge_event_entry(uint evIndex);


#endif


