/**************************************************************************
 *  File        drv.h
 *
 *  Description
 *      Contains all the export defines to the rest of the modules. All
 *      the modules wants to access to the FDDI driver has to include
 *      this header file.
 *
 *  Copyright (c) 1992, 1993 Hughes Lan Systems
 *
 *  Author:     J. Jang
 *************************************************************************/


#ifndef  _DRV_H_
#define  _DRV_H_

#include <types.h>
#include <fddi.h>
#include <dbd.h>
#include <fddihdr.h>
#include <smtdefs.h>
#include <smttypes.h>
#include <csphdr.h>
#include <pkt.h>

#ifdef __FEBRIDGE
#define DRV_TXBUF_CNT           5          /* max tx DBDs */
#else
#define DRV_TXBUF_CNT           38          /* max tx DBDs */
#endif
#define DRV_BUF_SIZE            4096        /* data buffer size */
#define CWI_REPEAT_MAX          5           /* max # of writing CWI bit */

#define BSI_STACK_SIZE          2048

#define DRV_FROM_BOOT           0           /* from boot code */
#define DRV_FROM_APP            1           /* from application code */

/* for self test */
#define DRV_BEACON_TEST         0x0001      
#define DRV_CLAIM_TEST          0x0002
#define DRV_FRAME_TEST          0x0004


/* return code from DRV_SendFrame() */
#define DRV_TX_MAC_STOP         -1
#define DRV_TX_BSI_BUSY         -2
#define DRV_TX_ILLEGAL_PARAM    -3


/***************************************************************************
control request
****************************************************************************/
#define SM_MA_CTRL_RESET                1   /* reset mac */
#define SM_MA_CTRL_EXTER_BEACON         2   /* prohibit recovery required */
#define SM_MA_CTRL_INTER_BEACON         3   /* allow recovery */     
#define SM_MA_CTRL_BEACON_REQ           4   /* send beacon frame */
#define SM_MA_CTRL_CLAIM_REQ            5   /* claim request */
#define SM_MA_CTRL_SET_TMIN             6   /* set T_Min */
#define SM_MA_CTRL_SET_TBID             7   /* change mac T_bid */
#define SM_MA_CTRL_PHY2MAC              8   /* connect/disconnect to PHY */
#define SM_MA_CTRL_CONFIG_MAC           9   /* set mac to RUN/STOP mode */
#define SM_MA_CTRL_SET_T_REQ            10  /* set T_req */
#define SM_MA_CTRL_PATH_TEST            11  /* start path test */
#define SM_MA_CTRL_MAC_INT              12  /* enable/disable mac interrupts */
#define SM_MA_CTRL_MAC_FRAME_STATUS     13  /* fddiMACFrameStatus ????? */
#define MAC_AC_NONE                     1   /* don't change A/C bit */
#define MAC_AC_COPIED                   2   /* set C, reset A if copied */
#define MAC_AC_RESET                    4

#define SM_MA_CTRL_SET_LONG_ADDR        14  /* change mac address */
#define SM_MA_CTRL_SET_SHORT_ADDR       15
#define SM_MA_CTRL_ADD_LONG_ALIASES     16
#define SM_MA_CTRL_ADD_SHORT_ALIASES    17
#define SM_MA_CTRL_REMOVE_LONG_ALIASES  18
#define SM_MA_CTRL_REMOVE_SHORT_ALIASES 19
#define SM_MA_CTRL_ADD_LONG_GRPADDR     20
#define SM_MA_CTRL_ADD_SHORT_GRPADDR    21
#define SM_MA_CTRL_REMOVE_LONG_GRPADDR  22
#define SM_MA_CTRL_REMOVE_SHORT_GRPADDR 23
#define SM_MA_CTRL_SET_TMAX             24
#define SM_MA_CTRL_SET_TVX              25

#define SM_MA_CTRL_COPY_MODE            26  /* set bsi copy mode */
#define DRV_COPY_PROMISC                1   /* promiscuous mode */
#define DRV_COPY_NON_PROMISC            2   /* non promiscuous mode */
#define DRV_ALL_BSI                     10  /* set to all the BSIs */


#define SM_PH_CTRL_LEM_THRESHOLD        31  /* set LEM threshold */
#define SM_PH_CTRL_LEM_CONFIG           32  /* enable/disable LEM interrupt */
#define SM_PH_CTRL_CONFIG               33  /* isolated/insert_p.... */
#define SM_PM_CTRL_TX_REQ               34  /* disable/enable transmitter */
#define SM_PM_CTRL_SILS_REQ             35  /* enable/disable SILS interrupt */
#define SM_PM_CTRL_BYPASS_REQ           36  /* by pass request */
#define SM_PM_CTRL_TX_SYMBOL            37  /* tx symbols. pass Line States */
#define SM_PH_CTRL_LCT                  38  /* start/stop Link Confidence Test */
#define SM_PM_CTRL_EBUF                 39  /* start/stop elasticity buffer */
#define SM_PH_CTRL_INT                  40  /* enable phy interrupt */

#define HLS_CTRL_MAC_STRIP              80   /* to do the mac strip */


/*****
    status request
*****/    
#define SM_MA_STATUS_DUP_ADDR           100     /* duplicate address status */
#define SM_MA_STATUS_R_FLAG             101     /* current R_Flag setting */
#define SM_PH_STATUS_LEM_COUNT          102     /* # of remaining count */
#define SM_PM_STATUS_RX_LINE_STATE      103     /* ??? */
#define SM_MA_STATUS_T_NEG              104     /* MAC T_Neg */
#define SM_MA_STATUS_FRAME_CT           105     /* macFrameRxCount */
#define SM_MA_STATUS_COPIED_CT          106     /* macFrameCopiedCount */
#define SM_MA_STATUS_TX_CT              107     /* macFrameTxCount */
#define SM_MA_STATUS_TOKEN_CT           108     /* macTokenRxCount */
#define SM_MA_STATUS_ERROR_CT           109     /* macErrIsloateCount */
#define SM_MA_STATUS_LOST_CT            110     /* macLostFrameCount */
#define SM_MA_STATUS_TVX_EXPIRED_CT     111     /* macTVXExpiredCount */
#define SM_MA_STATUS_NOT_COPIED_CT      112     /* macFrameNotCopiedCount */
#define SM_MA_STATUS_RING_OP_CT         113     /* macRingOpCount */
#define SM_MA_STATUS_LATE_CT            114     /* macLateCount */
#define SM_PH_STATUS_ELBUF_ERROR        115     /* overflow/underflow */
#define SM_PM_STATUS_TX_LINE_STATE      116
#define SM_PH_STATUS_PTYPE              117     /* phy port type */


/*
 *---------------------------------------------------------------------------
 *  drvier local mibs
 *---------------------------------------------------------------------------
 */
#define DRVMIB_PTYPE                 1  /* change port type */
#define DRVMIB_MACSTATUS             2  /* mac status */
#define DRVMIB_RINGTYPE              3
#       define RING_ISO                     1
#       define RING_WRAP                    2
#       define RING_THRU                    3

#ifndef DRV_ENABLE
#define DRV_ENABLE                 1
#endif

#ifndef DRV_DISABLE
#define DRV_DISABLE                0
#endif

#ifndef DRV_START
#define DRV_START                  1     /* same as DRV_ENABLE */
#endif

#ifndef DRV_STOP
#define DRV_STOP                   0    /* same as DRV_DISABLE */
#endif

#define DRV_DEV_DOWN               DRV_STOP  /* device is down */
#define DRV_DEV_UP                 DRV_START /* device is operational */

/***
error code      for internal testing only
***/
#ifdef DRV_DEBUG
#define DBD_TOO_SMALL_ERR	1
#define BSI_CH_ERR              2
#define BSI_PSP_TOO_BIG_ERR     3
#define BSI_NULL_DESC           4
#define DRV_NO_MEMORY           5
#define BSI_IDUD_ERR            6
#define BSI_DBD_ERR             7
#define BSI_SEC_LLC_ERR   8 /* secondary ring rx llc frame */
#define BSI_CNFQ_ERR            9
#define BSI_HW_INSTOP           10  /* INSTOP in STAR is set */
#define BSI_HW_RQSTOP           11
#define BSI_HW_SPSTOP           12
#endif      /* DRV_DEBUG */

#define DRV_10MSEC              1    /* 1 ticks is 10 msec */
#define DRV_1SEC                100



#define DRV_MODE_RUN                1
#define DRV_MODE_STOP               2
#define DRV_SET                     1
#define DRV_RESET                   0

/***
A, C, and E indicator bit map which will be put in GenericMsgType frame_status
field. The frame_status is an unsigned int. Bits 0 and 1 for C indicator,
bits 2,3 for A indicator, bits 4,5 for E indicator. SET means receives set
symbol, RESET means receives reset symbol, and TERMINATE means receives
terminated symbol.
***/
#define DRV_FS_C_MASK           0x00000003
#define DRV_FS_C_NONE           0
#define DRV_FS_C_RESET          0x00000001
#define DRV_FS_C_SET            0x00000002
#define DRV_FS_C_TERMINATE      0x00000003
#define DRV_FS_A_MASK           0x0000000c
#define DRV_FS_A_NO             0
#define DRV_FS_A_RESET          0x00000004
#define DRV_FS_A_SET            0X00000008
#define DRV_FS_A_TERMINATE      0X0000000C
#define DRV_FS_E_MASK           0x00000030
#define DRV_FS_E_NO             0
#define DRV_FS_E_RESET          0X00000010
#define DRV_FS_E_SET            0X00000020
#define DRV_FS_E_TERMINATE      0X00000030
#define DRV_FS_E_INDICATOR      0
#define DRV_FS_A_INDICATOR      1
#define DRV_FS_C_INDICATOR      2
#define DRV_FS_INDICATORS       3       /* 3 indicators: E, A, and C */

/***
port number used by SNMP and UI. map to SMT port number
***/
#define PORT_A                  0       /* SMT PHY 0 */
#define PORT_B                  1       /* SMT PHY 1 */
#define PORT_MASTER_BA          2     /* backplane port A */
#define PORT_M2                 3
#define PORT_M3                 4
#define PORT_M4                 5
#define PORT_M5                 6
#define PORT_MASTER_BB          7     /* backplane port B */


#define FDDI_HEADER_LEN         13  /* fddi header: 1 FC + 6 DA + 6 SA */
#define FDDI_FCS_BYTES          4
#define FDDI_FC_OFFSET          3   /* 3 bytes of dummy FC */
#define FDDI_DA_OFFSET          (FDDI_FC_OFFSET+1)   /* 4 bytes to DA field in fddi header */
#define FDDI_SA_OFFSET          (FDDI_DA_OFFSET+6) 




/* Line States */
#define DRV_ACTIVE_LS	0	/* Active Line State */
#define DRV_IDLE_LS	1	/* Idle Line State */
#define DRV_NO_SIGNAL	2	/* No Signal Detect */
#define DRV_MASTER_LS	4	/* Master Line State */
#define DRV_HALT_LS     5	/* Halt Line State */
#define DRV_QUIET_LS	6	/* Quiet Line State */
#define DRV_NOISE_LS	7	/* Noise Line State */

 /* Request Class Values */
#define DRV_REQ_RQCLS_NONE	0	/* None */
#define DRV_REQ_RQCLS_APR1	1	/* Async Priority 1 */
#define DRV_REQ_RQCLS_APR2	2	/* Async Priority 2 */
#define DRV_REQ_RQCLS_APR3	3	/* Async Priority 3 */
#define DRV_REQ_RQCLS_SYN	4	/* Sync */
#define DRV_REQ_RQCLS_IMM	5	/* Immediate, issue no token */
#define DRV_REQ_RQCLS_IMMN	6	/* Immediate, issue non-restrict tok */
#define DRV_REQ_RQCLS_IMMR	7	/* Immediate, issue restricted token */
#define DRV_REQ_RQCLS_ASYN	8	/* Async */
#define DRV_REQ_RQCLS_RBEG	9	/* Restricted Begin */
#define DRV_REQ_RQCLS_REND	10	/* Restricted End */
#define DRV_REQ_RQCLS_RCNT	11	/* Restricted Continue */
#define DRV_REQ_RQCLS_ASYND	12	/* Async without THT */
#define DRV_REQ_RQCLS_RBEGD	13	/* Restricted Begin without THT */
#define DRV_REQ_RQCLS_RENDD	14	/* Restricted End without THT */
#define DRV_REQ_RQCLS_RCNTD	15	/* Restricted Continue with THT */

#if 0
/***
Message type. All the message exchange with driver has to follow the
DRV_GENERIC_MSG type.
***/
#define DRV_EVENT_MSG_TYPE 1
#define DRV_RX_MSG_TYPE    2  /* received frame */
#define DRV_SM_MA_ST_MSG_TYPE  3

typedef struct drv_generic_msg_struct {
  struct drv_generic_msg_struct *next;
  uint32 marker;
  uint32 msg_type;
  uint32 dev_num;       /* device num - mac or phy */
  byte *ptr;            /* to message */
  bool  fragment;       /* flag to indicate fragment frame */
} DRV_GENERIC_MSG;
#endif  /* if 0 */


/*---------------------------------------------------------------------
Those mibs variables are changable by the driver.
----------------------------------------------------------------------*/
typedef struct _fddi_dynamic_mibs {
    /* following mibs will be changed by the driver */
    /* MAC mibs */
    uint32 *macFrameRxCount;
    uint32 *macErrIsolateCount;
    uint32 *macLostFrameCount;
    uint32 *macFrameCopiedCount;    
    uint32 *macFrameNotCopiedCount;
    uint32 *macFrameTxCount;
    uint32 *macTokenRxCount;
    uint32 *macRingLatencyCount;
    uint16 *macLateCount;
    uint32 *macTVXExpiredCount;
    uint32 *macRingOpCount;
    uint32 *macTREQ;
#if 0
    /* those mibs need to be added later. The mib name is unknown at this
       time */
    uint32 *phyElasticityBufErrorCount;
    uint32 *macLCTCount;
    uint32 *macStripping;  /* not implemented yet */
#endif    
}   DRV_FDDI_MIBS;

typedef struct _static_drv_mib {
    /* following mibs can not be changed by the driver */
    byte   *mac_addr;
    uint32 t_bid;
    uint32 tmax;
    uint32 tvx;
    unsigned char  *swRingOp;     /* s/w ring operational flag */
} STATIC_DRV_MIB;

typedef struct _fddi_init_mib {
    uint32 board_id;    /* hardware board ID */
    uint32 mac_num;     /* number of MAC chips */
    uint32 port_num;    /* # of ports - M and A,B ports. no backplane ports */
    STATIC_DRV_MIB  s_mib[MAX_MAC_COUNT];
    DRV_FDDI_MIBS   d_mib[MAX_MAC_COUNT];
}   DRV_INIT_MIB;
extern DRV_INIT_MIB init_mibs;


/***
these data structures are used by the driver only
***/
/*** this is a proptietary mib ***/
typedef struct _drv_mibs {
    uint32  macTRTExpiredCount;
    uint32  macDupTokenCount;       /* duplicate token count */
    uint32  macTokenCaptureCount;   /* token capture count */
    uint32  macTokenPassCount;      /* token pass count */
    uint32  bsiTxErrCount;          /* frame is not tx properly */
    
} DRV_MIBS_TYPE;

/***
this data structure recored some fatal errors in the driver
***/
typedef struct _drv_errors {
    uint16  reset_reason;       /* record the reset reason */
#define ERR_MAC_RX_STATE_MACHINE    1   /* internal receive state machine */
#define ERR_MAC_TX_STATE_MACHINE    2
} DRV_ERROR_RECORD;
 
/*** this is used by the driver during initialization ***/
typedef struct _fddi_con_ {
    uint32 id;              /* FDDI concentrator revision */
    uint32 bsi_num;         /* # of BSI in this concentrator */
    uint32 bmac_num;        /* # of BMAC in this concentrator */
    uint32 phy_num;         /* # of PLAYERs in this concentrator */
    uint32 bkport0;         /* backplane port 0 - backplane port B */
    uint32 bkport1;         /* backplane port 1 - backplane port A */
    uint32 type;            /* [FDDICON_MASTER | FDDICON_SLAVE] */
    uint32 active_bsi;      /* active bsi number - primary*/
    uint32 inactive_bsi;    /* secondary bsi */
} FDDI_CON_TYPE;






/** return code defines used by the driver only **/
#define BSI_POLL_TIMEOUT        -1


/* from fddihdr.h */
#define	PC_TYPE_A           PC_Type_A
#define	PC_TYPE_B           PC_Type_B
#define	PC_TYPE_S           PC_Type_S
#define	PC_TYPE_M           PC_Type_M
#define	PC_TYPE_UNKNOWN     PC_Type_Unknown
#define	PC_TYPE_NONE        PC_Type_None




/*** from csphdr.h ***/
#define	SIG_CONNECT     SIG_Connect	
#define	SIG_DISCONNECT  SIG_Disconnect	
#define	SIG_TRACE_PROP  SIG_Trace_Prop
#define	SIG_PATH_TEST   SIG_Path_Test	
#define	SIG_EC_TEST_BP  SIG_EC_Test_BP	
#define	SIG_EC_NO_FLAG  SIG_EC_NO_Flag	
#define	SIG_EC_TIMER    SIG_EC_Timer	

#define	SIG_PC_START    SIG_PC_Start	
#define	SIG_PC_MAINT    SIG_PC_Maint	
#define	SIG_PC_TRACE    SIG_PC_Trace	
#define	SIG_PC_STOP     SIG_PC_Stop	
#define	SIG_PC_SIGNAL   SIG_PC_Signal	
#define	SIG_PC_JOIN     SIG_PC_Join	
#define	SIG_LINE_STATE  SIG_Line_State	
#define	SIG_NOISE_EVENT SIG_Noise_Event	
#define	SIG_NOISE_TIMER SIG_Noise_Timer	
#define	SIG_PC_SCRUB_START  SIG_PC_Scrub_Start

#define	SIG_PC_SCRUB_COMPLETE   SIG_PC_Scrub_Complete
#define	SIG_PC_ENABLE   SIG_PC_Enable	
#define	SIG_PC_DISABLE  SIG_PC_Disable	
#define	SIG_PC_LEM_FAIL SIG_PC_LEM_Fail	
#define	SIG_PC_RE_FLAG  SIG_PC_RE_Flag	
#define	SIG_PC_TIMER	SIG_PC_Timer	

#define	SIG_CF_LOOP     SIG_CF_Loop	
#define	SIG_CF_JOIN     SIG_CF_Join	
#define	SIG_CF_WRAP_AB  SIG_CF_Wrap_AB	
#define	SIG_CF_TIMER    SIG_CF_Timer	

#define	SIG_RM_LOOP     SIG_RM_Loop	
#define	SIG_RM_JOIN     SIG_RM_Join	
#define	SIG_RING_OP     SIG_Ring_OP	
#define	SIG_MAC_INTERRUPT SIG_MAC_Interrupt
#define	SIG_DUP_ADDR    SIG_Dup_Addr
#define	SIG_RM_DA_FLAG  SIG_RM_DA_Flag	
#define	SIG_RM_RE_FLAG  SIG_RM_RE_Flag	
#define	SIG_RM_TIMER    SIG_RM_Timer	

#define	SIG_LEM_START   SIG_LEM_Start	
#define	SIG_LEM_STOP    SIG_LEM_Stop	
#define	SIG_LCT_START	SIG_LCT_Start	
#define	SIG_LCT_STOP    SIG_LCT_Stop
#define	SIG_LEM_THRESHOLD   SIG_LEM_Threshhold


/*********************************************************************
	CSP Defined Values
*********************************************************************/

/*
*	MAC Interrupt Types
*/

#define	MAC_MY_CLAIM            MAC_My_Claim
#define	MAC_MY_BEACON           MAC_My_Beacon
#define	MAC_OTHER_BEACON        MAC_Other_Beacon
#define	MAC_TRT_IN_T4T5         MAC_TRT_In_T4T5	
#define	MAC_RMODE               MAC_Rmode	

/** from smtdefs.h ***/
#define	NOISE_LINE_STATE                Noise_Line_State		
#define	MASTER_LINE_STATE               Master_Line_State		
#define	IDLE_LINE_STATE                 Idle_Line_State			
#define	SUPER_IDLE_LINE_STATE           Super_Idle_Line_State		
#define	HALT_LINE_STATE                 Halt_Line_State			
#define	QUIET_LINE_STATE                Quiet_Line_State		
#define	ACTIVE_LINE_STATE               Active_Line_State		
#define	TRANSMIT_PHY_DATA_REQUEST       Transmit_PHY_Data_Request	


#define	SIG_LE_TIMER    SIG_LE_Timer




/***
The trace mask uses the bit 12-15 as the module ID. We can trace total
16 different modules. The bits 0 - 11 are reserved for each module.
***/
#ifdef _TRACE_
#define FDDI_TRACE_MASK     0xF000
#define FDDI_TRACE_DRV      0           /* driver */
#define FDDI_TRACE_SMTIF    0x1000      /* smt interface */
#define FDDI_TRACE_LLC      0x2000      /* llc and snap module */
#endif








extern bool DRV_ChkRingWrap(uint32,byte *);
extern status_type DRV_Init(int);
extern int DRV_ControlReq(uint32,uint32,int);
extern int DRV_StatusReq(uint32,uint32,uint32 *);
extern void DRV_DriverStart(void);
extern void DRV_DriverStop(void);
extern int DRV_SelfTest(uint32,uint32);
extern void DRV_SetParityCheck(void);
extern void DRV_FreeTxBufs(void);
extern void DRV_ClearParityCheck(void);
extern int DRV_SendFrame(PKT *,uint32,uint32);
extern void DRV_InitFddiCon();


extern PKT *DRV_GetOneRxPkt(uint32);


#endif   /* _DRV_H_ */

