	.globl	_FDDIChipIsr
	.globl	_Timer3Isr
	.globl	_PlayerIsrAsm
	.globl	_MacBsiIsrAsm
	.globl _FddiConPriMacIsr
	.globl _FddiConSecMacIsr

# isr routine for the FDI chip set interrupts
_FDDIChipIsr:
	ldconst 64, r4
	addo sp, r4, sp
	stq  g0, -64(sp)
	stq  g4, -48(sp)
	stq  g8, -32(sp)
	stt  g12, -16(sp)

	mov  0, g14

	mov	1,g0
	mov	1,g1
	modpc	g0, g0, g1	/* enable trace */

	callx _FDDI_Isr

	ldq  -64(sp), g0
	ldq  -48(sp), g4
	ldq  -32(sp), g8
	ldt  -16(sp), g12
	mov  r3, sf1		/* re_enable the int mask */
	ret

# isr routine for the primary mac
_FddiConPriMacIsr:
	ldconst 64, r4
	addo sp, r4, sp
	stq  g0, -64(sp)
	stq  g4, -48(sp)
	stq  g8, -32(sp)
	stt  g12, -16(sp)

	mov  0, g14

	mov	1,g0
	mov	1,g1
	modpc	g0, g0, g1	/* enable trace */

	callx _BMAC_PriIsr

	ldq  -64(sp), g0
	ldq  -48(sp), g4
	ldq  -32(sp), g8
	ldt  -16(sp), g12
	mov  r3, sf1		/* re_enable the int mask */
	ret

# isr routine for the primary mac
_FddiConSecMacIsr:
	ldconst 64, r4
	addo sp, r4, sp
	stq  g0, -64(sp)
	stq  g4, -48(sp)
	stq  g8, -32(sp)
	stt  g12, -16(sp)

	mov  0, g14

	mov	1,g0
	mov	1,g1
	modpc	g0, g0, g1	/* enable trace */

	callx _BMAC_SecIsr

	ldq  -64(sp), g0
	ldq  -48(sp), g4
	ldq  -32(sp), g8
	ldt  -16(sp), g12
	mov  r3, sf1		/* re_enable the int mask */
	ret



# isr routine for the Timer counter 2
_Timer3Isr:
	ldconst 64, r4
	addo sp, r4, sp
	stq  g0, -64(sp)
	stq  g4, -48(sp)
	stq  g8, -32(sp)
	stt  g12, -16(sp)

	mov  0, g14

	mov	1,g0
	mov	1,g1
	modpc	g0, g0, g1	/* enable trace */

	callx _DRV_Counter2ISR

	ldq  -64(sp), g0
	ldq  -48(sp), g4
	ldq  -32(sp), g8
	ldt  -16(sp), g12
	mov  r3, sf1		/* re_enable the int mask */
	ret

# FOR THE FDDI_ETHERNET BRIDGE
# We have 2 int. levels assigned to the FDDI chip set.  The PLAYERS
# are all tied to 1 interrupt, and the MAC and BSI share another.
_PlayerIsrAsm:
	ldconst 64, r4
	addo sp, r4, sp
	stq  g0, -64(sp)
	stq  g4, -48(sp)
	stq  g8, -32(sp)
	stt  g12, -16(sp)

	mov  0, g14

	mov	1,g0
	mov	1,g1
	modpc	g0, g0, g1	/* enable trace */

	callx _PlayerIntHandler

	ldq  -64(sp), g0
	ldq  -48(sp), g4
	ldq  -32(sp), g8
	ldt  -16(sp), g12
	mov  r3, sf1		/* re_enable the int mask */
	ret

_MacBsiIsrAsm:
	ldconst 64, r4
	addo sp, r4, sp
	stq  g0, -64(sp)
	stq  g4, -48(sp)
	stq  g8, -32(sp)
	stt  g12, -16(sp)

	mov  0, g14

	mov	1,g0
	mov	1,g1
	modpc	g0, g0, g1	/* enable trace */

	callx _MacBsiIntHandler

	ldq  -64(sp), g0
	ldq  -48(sp), g4
	ldq  -32(sp), g8
	ldt  -16(sp), g12
	mov  r3, sf1		/* re_enable the int mask */
	ret
