/***********************************************************************
 *  File  cam.h - for fddi concentrator
 *
 *  Description:
 *    The base address of CAMs is in fddimap.h
 *
 *  Copyright (c) 1993
 *
 *  $Log:   /usr/shasta/pvcs/fddicon/drv/include/cam.h_v  
 * 
 *    Rev 1.0   31 Mar 1993 18:33:00   jang
 * Initial revision.
 **********************************************************************/



#ifndef _CAM_H_
#define _CAM_H_

#include <fddi.h>


#define CAM_ONLINE          0x0001
#define CAM_EASET           0x0002
#define CAM_COPYSET         0x0004
#define CAM_ADDSIZE         0x0010
#define CAM_SRCEN           0x0020
#define CAM_DESTEN          0x0040
#define CAM_SRCINV          0x0080
#define CAM_DESTINV         0x0100
#define CAM_UNUSED_MASK     0xfe08



/** function prototype ***/
extern void CAM_InitCAM(void);
extern void CAM_ActiveCAM(uint32);
extern int CAM_SetFrameStatus(uint32,uint32);


#endif
