	.text
	.globl	_send_sysctl

	.align 4
_send_sysctl:
	sysctl	g0, g1, g2
	mov	g0,g0		/* a nop needed due to the anomaly in 960 */
	ret

	.globl	_modpc

	.align 4
_modpc:
	modpc	g0, g0, g1
	mov	g1, g0
	ret


	.globl	_eat_time
	.align 4
_eat_time:
	ldconst	0,r4
	mov	r4,r3
	b	L2
L1:
	addi	1,r4,r4
	addi	1,r3,r3
L2:
	muli	20,g0,r15
	cmpibl	r3,r15,L1

	ret	

	.globl	init_dram

	.align 4
init_dram:
	bx	(g0)

	.globl	_wait_15

	.align 4
_wait_15:
	ldconst		0xff,g0
_lp15:
	subo		1,g0,g0
	cmpobne		0,g0,_lp15
	ret


#
# -- Flash Timer Interrupt.
#

	.globl	_usecInt
	.align 4
_usecInt:
	addo sp, 4, sp
	st  g0, 0x40(fp)

	ld	_usec_ticks,g0
	addo	g0,1,g0
	st	g0,_usec_ticks

	ld  0x40(fp), g0
	mov  r3, sf1			/* re_enable the int mask */
	ret

	.globl	_msecInt
	.align 4
_msecInt:
	addo sp, 4, sp
	st  g0, 0x40(fp)

	ld	_msec_ticks,g0
	addo	g0,1,g0
	st	g0,_msec_ticks

	ld  0x40(fp), g0
	mov  r3, sf1			/* re_enable the int mask */
	ret

	.globl _enable_imsk
	.align 4

_enable_imsk:
	or	g0, sf1, sf1
	ret

	.globl _disable_imsk
	.align 4

_disable_imsk:
	andnot	g0, sf1, sf1
	ret

	.globl _clear_ipnd
	.align 4

_clear_ipnd:
	andnot	g0, sf0, sf0
	ret

	.globl _get_ipnd
	.align 4

_get_ipnd:
	mov	sf0, g0
	ret

	.globl	_FlkLedInt
	.align 4
_FlkLedInt:
	ldconst 64, r4
	addo sp, r4, sp
	stq  g0, -64(sp)
	stq  g4, -48(sp)
	stq  g8, -32(sp)
	stt  g12, -16(sp)
	mov  0, g14

	mov	1,g0
	mov	1,g1
	modpc	g0, g0, g1	/* enable trace */

	callx _flk_leds
	ldq  -64(sp), g0
	ldq  -48(sp), g4
	ldq  -32(sp), g8
	ldt  -16(sp), g12
	mov  r3, sf1		/* re_enable the int mask */
	ret

	.globl	_BasicNmiInt
	.align 4
_BasicNmiInt:
	ldconst 64, r4
	addo sp, r4, sp
	stq  g0, -64(sp)
	stq  g4, -48(sp)
	stq  g8, -32(sp)
	stt  g12, -16(sp)
	mov  0, g14

	mov	1,g0
	mov	1,g1
	modpc	g0, g0, g1	/* enable trace */

	call _BasicNmiInt_c
	ldq  -64(sp), g0
	ldq  -48(sp), g4
	ldq  -32(sp), g8
	ldt  -16(sp), g12
	mov  r3, sf1			/* re_enable the int mask */
	ret


	.globl	_NmiInt
	.align 4
_NmiInt:
	ldconst 64, r4
	addo sp, r4, sp
	stq  g0, -64(sp)
	stq  g4, -48(sp)
	stq  g8, -32(sp)
	stt  g12, -16(sp)
	mov  0, g14

	mov	1,g0
	mov	1,g1
	modpc	g0, g0, g1	/* enable trace */

	call _NmiInt_c
	ldq  -64(sp), g0
	ldq  -48(sp), g4
	ldq  -32(sp), g8
	ldt  -16(sp), g12
	mov  r3, sf1			/* re_enable the int mask */
	ret
