
/**
 *	Program Name:	nim960 program
 *
 *	Filename:	timer.c
 *
 *	$Log:   /b/gregs/bridge/util/timer.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:20:06   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:39:54   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:16:26   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 10:36:02   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:30:10   franks
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:44:48   pvcs
 * Initial revision.
 *
 *	Comment:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems.
 **/
#include  <types.h>
#include  <krnl.h>
#include  <target.h>
#include  <tmr.h>

#define	COUNTER_0	TIMERIO + 0x0
#define	COUNTER_1	TIMERIO + 0x4
#define	COUNTER_2	TIMERIO + 0x8
#define	CONTROL_REG	TIMERIO + 0xc
#define	TEN_MS		20000
#define	TEN_US		20

static int counter_1_count = 0;

volatile int usec_ticks, msec_ticks;
extern word ram_control_table[];
extern word ram_int_table[];
extern usecInt();
extern msecInt();


init_timers(TicksInt, SliceInt, ticks_time, slice_time)
int (*TicksInt)();		/* subroutine to call on expiration */
int (*SliceInt)();		/* subroutine to call on expiration */
int ticks_time;			/* 10-ms ticks */
int slice_time;			/* 10-us slice */
{
	int	value;
	byte	*counter;
	byte	control;

	init_hw_int(0, 18, TicksInt);
	init_hw_int(1, 34, SliceInt);

	/* counter io for timer 0 */
	counter = (byte *)COUNTER_0;
	value = TEN_MS * ticks_time;
	/* square wave rate generator */
	control = ((0x0 & 0x3) << 6) | 0x36;
	store_byte(control, CONTROL_REG);
	store_byte((value & 0xff), counter);
	store_byte(((value >> 8) & 0xff), counter);

	/* counter io for timer 1 */
	counter = (byte *)COUNTER_1;
	value = TEN_US * slice_time;
	if (value > 0xffff)
		value = 0;
	/* software trigger */
	control = ((0x1 & 0x3) << 6) | 0x38;
	store_byte(control, CONTROL_REG);
	store_byte((value & 0xff), counter);
	store_byte(((value >> 8) & 0xff), counter);
}


retriggerTimerForPktGen(slice_time)
int slice_time;
{
	int value;

	value = TEN_US * slice_time;
	store_byte(0x78, CONTROL_REG);
	store_byte((value & 0xff), COUNTER_1);
	store_byte(((value >> 8) & 0xff), COUNTER_1);
}


Init_timers()
{
	/* Program Timer */
	stc_control(STC_MASTER_RESET);
	stc_control(STC_LOD_CNT | STC_S5 | STC_S4 | STC_S3 | STC_S2 | STC_S1);
	stc_control(STC_ENA_16BIT_BUS);
	stc_control(STC_LOD_DAT_PTR | STC_CTL_GRP | STC_MST_MOD_REG);
	stc_data(STC_DIV1 | STC_16BIT_BUS | STC_MM_F1);
}

#define RATE_GENERATOR	1
#define ONE_SHOT	2

prog_timers(timer, timerInt, timer_type, time_period)
int timer;
int (*timerInt)();		/* subroutine to call on expiration */
int timer_type;
int time_period;
{
	byte stc_sn;
	int value;
	byte *counter;
	byte control;

	if (timer == 1)
		init_hw_int(0, 18, timerInt);
	else if (timer == 2)
		init_hw_int(1, 34, timerInt);
	else if (timer == 3)
		init_hw_int(3, 66, timerInt);

	counter = (byte *)(COUNTER_0 + 4*(timer - 1));
	if (timer_type == RATE_GENERATOR)
	/* turn on counter 0 for clock, mode 3 */
	{
		value = TEN_MS * time_period;
		control = (((timer - 1) & 0x3) << 6) | 0x36;
		store_byte(control, CONTROL_REG);
		store_byte((value & 0xff), counter);
		store_byte(((value >> 8) & 0xff), counter);
	}
	else if (timer_type == ONE_SHOT)
	/* counter 1 - software triggered one shot, mode 1 */
	{
		counter_1_count = TEN_US * time_period;
		if (counter_1_count > 0xffff)
			counter_1_count = 0;
		control = (((timer - 1) & 0x3) << 6) | 0x38;
		store_byte(control, CONTROL_REG);
		store_byte((counter_1_count & 0xff), counter);
		store_byte(((counter_1_count >> 8) & 0xff), counter);
	}
}


stop_timers()
{
#ifndef ZEBRA
	stc_control(STC_MASTER_RESET);
#endif
}


FlashDelay10Us()
{
#ifdef notdef
	usec_ticks = 0;
	stc_control(STC_LOD_CNT | STC_S2);
	stc_control(STC_ARM_CNT | STC_S2);
	while (usec_ticks < 1)
		;
#else
	int i, j;
	/* This makes a 3 instruction loop.  Assuming 1 clk per instruction,
	and given that 6 mics is 150 clks, we need a loop count of 50. */
	for(i=0; i<120; i++)
		j = *(volatile int*)SRAM;
#endif
}


FlashDelay10Ms()
{
	int	ticks = RealTimeTicks();

	while ((RealTimeTicks() - ticks) <= 2)
		ReSchedule();
}

RetriggerTimeSliceTimer()
{
	store_byte(0x78, CONTROL_REG);
	store_byte((counter_1_count & 0xff), COUNTER_1);
	store_byte(((counter_1_count >> 8) & 0xff), COUNTER_1);
}


Wait(ticks)
{
	int 	tick1;

	tick1 = RealTimeTicks();
	while ( (RealTimeTicks() - tick1) < ticks )
		ReSchedule();
	return;
}
