
/**
 *	Program Name:	nim960 program
 *
 *	Filename:	led.c
 *
 *	$Log:   /b/gregs/bridge/util/led.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:20:04   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:39:50   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:16:22   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 10:34:24   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:30:08   franks
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:44:46   pvcs
 * Initial revision.
 *
 *	Comment:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems.
 **/
#include <types.h>
#include <memory.h>
#include <led.h>
#include <sys.h>

#define LEDFDDIIO 0x90000040

extern ushort chnl_flk_rx_led;
extern ushort chnl_flk_tx_led;

int led_test_in_progress = 0;

set_leds(type, mask, value)
register word type;
register word mask;
register word value;
{
	register word val;
	volatile register ushort *led_port;
	register SYS *sys_ptr = &sys;

	if (type == LED_MONO)
	{
		led_port = (volatile ushort *)LEDMIO;
		val = sys_ptr->sys_ledm & 0x00ff;
		val &= ~mask;
		val |= value;
		sys_ptr->sys_ledm = val;
		*led_port = (ushort)val;
	}
	else
	{
		led_port = (volatile ushort *)LEDBIO;
		val = sys_ptr->sys_ledb;
		val &= ~mask;
		val |= value;
		sys_ptr->sys_ledb = val;
		*led_port = (ushort)val;
	}
}
set_fddi_leds(type, mask, value)
register word type;
register word mask;
register word value;
{
	register word val;
	volatile  ushort  *led_port; 
	register SYS *sys_ptr = &sys;

		led_port = (volatile ushort *)LEDFDDIIO;
		val = sys_ptr->sys_ledm >> 8;
		val &= ~mask;
		val |= value;
		sys_ptr->sys_ledm |= val << 8;
		*led_port = (ushort)val & 0xf0;
}

flk_led(type, flk_req)
register word type;
register word flk_req;
{
	register SYS *sys_ptr = &sys;

	if (type == LED_MONO)
		sys_ptr->sys_flk_ledm |= flk_req;
	else
		sys_ptr->sys_flk_ledb |= flk_req;
}


/* This routine was rewritten because on the FDDI-eth bridge the 'bi-color'
LED register now contains some LEDs that are blinked based on bits in the
'sys.sys_flk_ledm' location */
/* This routine is called every tick */
flk_leds()
{
	word or_flk, xor_flk;

	if (led_test_in_progress)
		return;

	if( sys.sys_flk_cnt == 0 )	/* if time to flicker */
	{
		sys.sys_flk_cnt = 0xfffffff8;		/* restart flicker counter */

		FlickerFddiActLeds();		/* rearrange a few bits */
		*(ushort *)LEDMIO = (ushort)(sys.sys_flk_ledm ^ sys.sys_ledm);
		sys.sys_flk_ledm = 0;
		/* Flickering of the RDY or ACT leds is done by OR'ing
			their bit fields in sys_ledb with those in
			sys_flk_ledb.  But, flickering of the Fddi RXB and RXA
			LEDs is done by XOR'ing their bit fields in sys_ledb 
			with those in sys_flk_ledb. */
		or_flk = (sys.sys_ledb & (LED_RDY | LED_ACT)) |
				(sys.sys_flk_ledb & (LED_RDY | LED_ACT));
		xor_flk = (sys.sys_ledb & ~(LED_RDY | LED_ACT)) ^
				(sys.sys_flk_ledb & ~(LED_RDY | LED_ACT));
		*(ushort *)LEDBIO = (ushort)(or_flk | xor_flk);
		sys.sys_flk_ledb = 0;
	}
	else if (++sys.sys_flk_cnt == 0xfffffffe)	/* if time to stop flicker */
	{
		*(ushort *)LEDMIO = (ushort)sys.sys_ledm;
		*(ushort *)LEDBIO = (ushort)sys.sys_ledb;
	}
}

test_led()
{
	register SYS *sys_ptr = &sys;
	register word ledm = sys_ptr->sys_ledm;
	int	i;

	/*---------------------------------
	 * Set the flag to disable the led
	 * flikering by the kernel during
	 * led test.
	 *---------------------------------
	 */
	led_test_in_progress = 1;

	set_leds(LED_BI, LED_BI_COLOR, 0);
	set_leds(LED_MONO, LED_MONO_COLOR, 0);
	sec_delay();

	printf("\nBi-color leds test sequence (Ready - Active):=\n");
	printf("OFF-RED -> OFF-GRN -> RED-OFF -> GRN-OFF -> OFF-OFF\n");
	sec_delay();

	set_leds(LED_BI, LED_BI_COLOR, LED_RDY_OFF | LED_ACT_RED);
	sec_delay();

	set_leds(LED_BI, LED_BI_COLOR, LED_RDY_OFF | LED_ACT_GRN);
	sec_delay();

	set_leds(LED_BI, LED_BI_COLOR, LED_RDY_RED | LED_ACT_OFF);
	sec_delay();

	set_leds(LED_BI, LED_BI_COLOR, LED_RDY_GRN | LED_ACT_OFF);
	sec_delay();

	set_leds(LED_BI, LED_BI_COLOR, 0);
	sec_delay();

	printf("\nMono color leds test sequence:=\n");
	printf("Tx1 -> Tx2 -> Tx3 -> FDDI_BRx -> FDDI_BTx -> FDDI_B P/T -> \
	FDDI_B LE\n");
	
	printf("Rx1 -> Rx2 -> Rx3 -> FDDI_ARx -> FDDI_ATx -> FDDI_A P/T -> \
	FDDI_A LE\n");
	sec_delay();

	/*---------------------------------
	 * turn Ethernet TX leds on and off
	 *---------------------------------
	 */
	set_leds(LED_MONO, LED_MONO_COLOR, LED_TX1);
	sec_delay();
	set_leds(LED_MONO, LED_MONO_COLOR, LED_TX2);
	sec_delay();
	set_leds(LED_MONO, LED_MONO_COLOR, LED_TX3);
	sec_delay();
	set_leds(LED_MONO, LED_MONO_COLOR, 0);
		

	/*------------------------------
	 * turn FDDI RX B led on and off
	 *------------------------------
	 */
	set_fddi_leds(LED_MONO, LED_MONO_COLOR, 0x40); 
	sec_delay();
	set_fddi_leds(LED_MONO, LED_MONO_COLOR, 0x00);

	/*------------------------------
	 * turn FDDI TX B led on and off
	 *------------------------------
	 */
	set_leds(LED_MONO, LED_MONO_COLOR, LED_TXB);
	sec_delay();
	set_leds(LED_MONO, LED_MONO_COLOR, 0);

	/*-------------------------------------
	 * turn FDDI Peer Tree B led on and off
	 *-------------------------------------
	 */
	SetPTLedOn(1);	
	sec_delay();
	SetPTLedOff(1);	

	/*------------------------------
	 * turn FDDI LE B led on and off
	 *------------------------------
	 */
	set_fddi_leds(LED_MONO, LED_MONO_COLOR, 0x80);
	sec_delay();
	set_fddi_leds(LED_MONO, LED_MONO_COLOR, 0x00);


	/*---------------------------------
	 * turn Ethernet RX leds on and off
	 *---------------------------------
	 */
	set_leds(LED_MONO, LED_MONO_COLOR, LED_RX1);
	sec_delay();
	set_leds(LED_MONO, LED_MONO_COLOR, LED_RX2);
	sec_delay();
	set_leds(LED_MONO, LED_MONO_COLOR, LED_RX3);
	sec_delay();
	set_leds(LED_MONO, LED_MONO_COLOR, 0);

	/*------------------------------
	 * turn FDDI RX A led on and off
	 *------------------------------
	 */
	set_fddi_leds(LED_MONO, LED_MONO_COLOR, 0x10);
	sec_delay();
	set_fddi_leds(LED_MONO, LED_MONO_COLOR, 0x00);

	/*------------------------------
	 * turn FDDI TX A led on and off
	 *------------------------------
	 */
	set_leds(LED_MONO, LED_MONO_COLOR, LED_TXA);
	sec_delay();
	set_leds(LED_MONO, LED_MONO_COLOR, 0);

	/*-------------------------------------
	 * turn FDDI Peer Tree A led on and off
	 *-------------------------------------
	 */
	SetPTLedOn(0);	
	sec_delay();
	SetPTLedOff(0);	

	/*------------------------------
	 * turn FDDI LE A led on and off
	 *------------------------------
	 */
	set_fddi_leds(LED_MONO, LED_MONO_COLOR, 0x0020);
	sec_delay();
	set_fddi_leds(LED_MONO, LED_MONO_COLOR, 0x0000);


	sec_delay();
	sec_delay();
	set_leds(LED_BI, LED_BI_COLOR, LED_TESTER);
	set_leds(LED_MONO, LED_MONO_COLOR, ledm);

	/*------------------------------------
	 * Clear the flag to enable flikering. 
	 *------------------------------------
	 */
	led_test_in_progress = 0;
}


sec_delay()
{
	#ifdef 0
	register word tmr_ticks = RealTimeTicks();

	while ((tmr_ticks + 50) > RealTimeTicks())
		;
	#endif

	delay(30);
}

FlkActLed()
{
	flk_led(LED_BI, LED_ACT);
	if (sys.sys_remote_console)
		flk_led(LED_BI, LED_RDY);
}

ClearPortLedStatus()
{
	chnl_flk_rx_led = 0;
	chnl_flk_tx_led = 0;
}

FlkPortLeds()
{
	flk_led(LED_MONO, (chnl_flk_tx_led << 4) + chnl_flk_rx_led);
}

#include "../../fddi/fddicon/smt/headers/fddihdr.h"
/* This routine blinks the appropriate rx and tx LEDs on the front
	panel, depending upon our configuration (there is a rx/tx 
	pair of LEDs for each port). */

#define	FDDI_TX	0x80	/* FDDI tx bit in sys.sys_flk_ledm */
#define	FDDI_RX	0x08	/* FDDI rx bit in sys.sys_flk_ledm */
FlickerFddiActLeds()
{
	ushort fddi_flk;

	fddi_flk = sys.sys_flk_ledm & (FDDI_RX | FDDI_TX);	/* get tx/rx bits */
	/* clr FDDI bits in sys_flk_ledm, shift enet bits into correct position */
	sys.sys_flk_ledm = (sys.sys_flk_ledm & 0x77) << 1;
	switch( GetFddiCFState() )	/* switch on fddi config */
	{
	case CF_ISOLATED:		/* not connected */
		break;
	case CF_WRAP_A:			/* only port A is active */
		/* rx is from port A, and tx is to port A */
		if( fddi_flk & FDDI_RX )	/* if FDDI rx bit is set */
			sys.sys_flk_ledb |= LED_RXA;	/* set port A rx LED */
		if( fddi_flk & FDDI_TX )	/* if FDDI tx bit is set */
			sys.sys_flk_ledm |= LED_TXA;	/* set port A tx LED */
		break;
	case CF_WRAP_B:			/* only port B is active */
		/* rx is from port B, and tx is to port B */
		if( fddi_flk & FDDI_RX )	/* if FDDI rx bit is set */
			sys.sys_flk_ledb |= LED_RXB;	/* set port B rx LED */
		if( fddi_flk & FDDI_TX )	/* if FDDI tx bit is set */
			sys.sys_flk_ledm |= LED_TXB;	/* set port B tx LED */
		break;
	case CF_THRU:			/* normal dual-attach case */
		/* rx is from port A, and tx is to port B */
		if( fddi_flk & FDDI_RX )	/* if FDDI rx bit is set */
			sys.sys_flk_ledb |= LED_RXA;	/* set port A rx LED */
		if( fddi_flk & FDDI_TX )	/* if FDDI tx bit is set */
			sys.sys_flk_ledm |= LED_TXB;	/* set port B tx LED */
	} /* end switch */
} /* end FlickerFddiActLeds() */


/* This routine should be called at startup and whenever the FDDI 
	config changes.  It turns on the appropriate rx and tx LEDs for
	the FDDI port. */
FddiLedsOn()
{
	/* clear all rx and tx LEDs first */
	sys.sys_ledb &= ~(LED_RXA | LED_RXB);	
	sys.sys_ledm &= ~(LED_TXA | LED_TXB);	
	/* Now set the appropriate LEDs for our config */
	switch( GetFddiCFState() )	/* switch on fddi config */
	{
	case CF_ISOLATED:		/* not connected */
		break;
	case CF_WRAP_A:			/* only port A is active */
		/* rx is from port A, and tx is to port A */
		sys.sys_ledb |= LED_RXA;
		sys.sys_ledm |= LED_TXA;
		break;
	case CF_WRAP_B:			/* only port B is active */
		/* rx is from port B, and tx is to port B */
		sys.sys_ledb |= LED_RXB;
		sys.sys_ledm |= LED_TXB;
		break;
	case CF_THRU:			/* normal dual-attach case */
		/* rx is from port A, and tx is to port B */
		sys.sys_ledb |= LED_RXA;
		sys.sys_ledm |= LED_TXB;
	} /* end switch */
} /* end FddiLedsOn */

FddiTxLedsOff()
{
	sys.sys_ledm &= ~(LED_TXA | LED_TXB);
} /* end FddiLedsOff() */


SetPTLedOn(port)		/* set 'peer/tree' LED for given port */
int port;
{
	if( port == 0)
		set_ctrl1(CTRL1_FDDIA_PT, PEER_TREEA_ON);
	else
		set_ctrl1(CTRL1_FDDIB_PT, PEER_TREEB_ON);
} /* end SetPTLedOn() */


SetPTLedOff(port)		/* clr 'peer/tree' LED for given port */
int port;
{
	if( port == 0)
		set_ctrl1(CTRL1_FDDIA_PT, PEER_TREEA_OFF);
	else
		set_ctrl1(CTRL1_FDDIB_PT, PEER_TREEB_OFF);
} /* end SetPTLedOff() */


SetLELedOn(port)		/* set 'link error' LED for given port */
int port;
{
	if( port == 0)
		sys.sys_ledb = sys.sys_ledb | LED_LEA;
	else
		sys.sys_ledb = sys.sys_ledb | LED_LEB;
} /* end SetPTLedOn() */


SetLELedOff(port)		/* clr 'link error' LED for given port */
int port;
{
	if( port == 0)
		sys.sys_ledb = sys.sys_ledb & ~LED_LEA;
	else
		sys.sys_ledb = sys.sys_ledb & ~LED_LEB;
} /* end SetPTLedOff() */
