/***********************************************************
 *
 *	Program Name:	nim960 multiport token ring bridge
 *
 *	Filename:
 *
 *	$Log:   /b/gregs/bridge/tr_util/hw_sled.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:17:30   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:39:14   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:15:32   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 10:27:02   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:28:32   franks
 * Initial revision.
 *
 *	Creation Date:
 *
 *	Date:
 *
 *	Programmers:	Yan Ke
 *
 *	Modifications:
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 *
 ************************************************************/


#include	"types.h"
#include	"sys.h"
#include	"tr_sled.h"
#include	"../include/memory.h"


static byte sled_value[16] =
{
	SLED_DIGIT_0, SLED_DIGIT_1, SLED_DIGIT_2, SLED_DIGIT_3,
	SLED_DIGIT_4, SLED_DIGIT_5, SLED_DIGIT_6, SLED_DIGIT_7,
	SLED_DIGIT_8, SLED_DIGIT_9, SLED_DIGIT_A, SLED_DIGIT_B,
	SLED_DIGIT_C, SLED_DIGIT_D, SLED_DIGIT_E, SLED_DIGIT_F
};

extern SYS	sys;

/*------------------------------------------------------------------
* light the 7-segment led with the given number
* returns nothing
*------------------------------------------------------------------*/
HW_SLed(number)
int number;
{
	register SYS	*sys_ptr = &sys;
	register word	val;

	val = sys_ptr->sys_ledsg & 0x1;
	if (number == 16)
		val |= 0xfe;
	else
		val |= sled_value[number];
	sys_ptr->sys_ledsg = val;

	*(byte *)TR_SLED_REG = val;
	return 0;
}



/*------------------------------------------------------------------
* light the 7-segment led with the given number
* returns nothing
*------------------------------------------------------------------*/
Set7SegLed(value)		
int value;
{
	HW_SLed(value);
}


/*------------------------------------------------------------------
* blink the 7-segment led with the given number FOREVER.
* NEVER RETURNS
*------------------------------------------------------------------*/
Blink7SegLed(value)
int value;
{
	for (;;)
	{
		volatile word i;

		HW_SLed(0x10);
		for (i=0; i<0x8ffff; i++);

		HW_SLed(value);
		for (i=0; i<0x8ffff; i++);
	}
}


ShowSLed(value, delay)
int value;
int delay;
{
	volatile word i;

	HW_SLed(value);
	for (i=0; i<delay; i++);
}


FlashSLed(value)
int value;
{
	Blink7SegLed(value);
}



#ifdef notdef		/* GJS GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG */
	This module NOT yet converted to the fddi-eth bridge hw.;

/*------------------------------------------------------------------
* turn dot on or off
*------------------------------------------------------------------*/
HW_SLed_Dot(port1, on)
int port1;	/* port number */
int on;		/* 1->dot on, 0->dot off */
{
	register byte	*led_reg;
	register SYS	*sys_ptr = &sys;
	register word	val;
	register word	port;

	port = port1_to_port[port1];

	if (port < 0 || port > 3)
		return 1;

	val = sys_ptr->sys_ledsg[port] & 0xfe;
	if (!on)
		val |= 0x1;
	sys_ptr->sys_ledsg[port] = val;

	led_reg = (byte *)(TR_SLED_REG + 20*port);
	*led_reg = val;
	return 0;
}


/*------------------------------------------------------------------
* called from bp_ring
*------------------------------------------------------------------*/
set_seven_segment_display(port)
{
}
#endif			/* GJS GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG */
