
/**
 *	Program Name:	nim960 bridge
 *	
 *	Filename:	testnvram.c
 *
 *	$Log:   /b/gregs/bridge/tester/testnvram.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 09:22:56   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 09:45:12   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:25:58   franks
 * Initial revision.
 * 
 *    Rev 1.1   13 Apr 1992 12:22:34   kwok
 * Save the contents of the nvram before performing any test.
 * 
 *    Rev 1.0   30 Mar 1992 17:42:32   pvcs
 * Initial revision.
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

#include <types.h>
#include <memory.h>
#include <eeprecs.h>

static unsigned char *TestNvramLock(unsigned char *LastPage);

/*
 *	Test the Nvram 
 */
int TestNvram()

	{
	unsigned char	*ErrorAddress;
	unsigned char	*LastPage;	/*	of eeprom 	*/
	int	ret;
	EEP_MFG	*MfgPtr = &eep_mfg_rec; 
	static	char	*buffer = NULL;
	int	BufferSize = MfgPtr->eep_nvram_size;

	/*
	 *	Get a buffer to save the nvram first.
	 */
	if (buffer == NULL)
		{
		buffer = (char *)lmalloc(BufferSize);
		if (buffer == NULL)
			{
			printf("Error: No memory\n");
			return 1;
			}
		}
	/*
	 *	Save the nvram 
	 */
	memcpy(buffer, (char *)NVRAM, BufferSize);
	EnableNvram();
	ret = RamTest(NVRAM, BufferSize, "NVRAM");
	memcpy((char *)NVRAM, buffer, BufferSize);
	if (memcmp(NVRAM, buffer, BufferSize) != 0)
		{
		printf("Error: Cannot restore content of NVRAM\n");
		}
	DisableNvram();
	if (ret != 0)
		return ret;

	/*
	 *	Test the last page only.
	 */
	LastPage =  (unsigned char *)NVRAM + MfgPtr->eep_nvram_size - EEP_PAGE_SIZE; 
	if ((ErrorAddress = TestNvramLock(LastPage)) != NULL)
		{
		printf("\nNVRAM error: Protection circuitry failed\n");
		return 1;
		}
	return 0;
	}


static unsigned char *TestNvramLock(unsigned char *LastPage)

	{
	unsigned char	data[EEP_PAGE_SIZE];
	int	RecordSize;

	/*
	 *	Save the original data
	 */
	memcpy(data, LastPage, EEP_PAGE_SIZE);
	/*
	 *	Write to the nvram without releasing the lock.
	 */
	DisableNvram();	/* make sure it is disabled	*/
	for (RecordSize = 0; RecordSize < EEP_PAGE_SIZE; RecordSize++)
		{
		LastPage[RecordSize] = ~data[RecordSize];
		}
	/*
	 *	Since we have not release the lock, the data should 
	 *	not be changed at all.
	 */
	for (RecordSize = 0; RecordSize < EEP_PAGE_SIZE; RecordSize++)
		{
		if (LastPage[RecordSize] != data[RecordSize])
			{
			/*
			 *	Record has been modified, we have to
			 *	restore data and return an error
			 */
			memcpy(LastPage, data, EEP_PAGE_SIZE);
			return LastPage + RecordSize;
			}
		}
	return NULL;
	}
