/**			       
*
*	Program Name:	TESTER for stanley
*
*	Filename:	memhelp.c
*
*	$Log:   /b/gregs/bridge/tester/memhelp.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 09:22:46   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 09:45:04   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:25:50   franks
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:42:24   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		6.17.91
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	This is the help function for the memory editor. 
*			It is based on the nindy user interface.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/


/******************************************************************/
/* 		Copyright (c) 1990, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/


#include "defines.h"

static const char
help_all[] =
	".                 - repeat previous command\n"
	"? [cmd]           - help info for optional cmd\n"
	"db address#bytes  - display one or more bytes\n"
	"di address#words  - display one or more words\n"
	"ds address#shorts - display one or more shorts\n"
	"ex                - exit the memory editor\n"
	"fb address address data - fill memory with byte value\n"
	"fi address address data - fill memory with word value\n"
	"fs address address data - fill memory with short value\n"
	"he [cmd]          - help info for optional cmd\n"
	"mb address        - modify a byte in memory \n"
	"mi address        - modify a word in memory \n"
	"ms address        - modify a short in memory \n"
	;

static const char
dot_help[] =
	".\n"
	"  Repeat previous command.\n";

static const char
db_help[] =
	"db <address>[#<bytes>]\n\n"
	"  Display one or more bytes beginning at the address given.\n"
	"  Also displays bytes as ASCII characters if printable.\n";

static const char
di_help[] =
	"di <address>[#<words>]\n\n"
	"  Display a whole word beginning at the address given.\n";

static const char
ds_help[] =
	"ds <address>[#<shorts>]\n\n"
	"  Display one or more shorts beginning at the address given.\n";

static const char
ex_help[] =
	"ex\n\n"
	"  Exit the memory editor and return to the main menu.\n";

static const char
fb_help[] =
	"fb <address1> <address2> <data>\n\n"
	"  Fill memory from address1 to address2 inclusive with byte of data value.\n"
	"  If address1 = address2 then one byte is filled at address1\n";

static const char
fi_help[] =
	"fi <address1> <address2> <data>\n\n"
	"  Fill memory from address1 to address2 inclusive with word of data value.\n"
	"  If address1 = address2 then one word is filled at address1\n";

static const char
fs_help[] =
	"fs <address1> <address2> <data>\n\n"
	"  Fill memory from address1 to address2 inclusive with short word of data value.\n"
	"  If address1 = address2 then one short word is filled at address1\n";

static const char
he_help[] =
	"he[lp] [<command>]\n"
	"? [<command>]\n"
	"  Gives help for optional 'command'.  If no 'command' is specified\n"
	"  or unknown 'command', print short version of all commands.\n";

static const char
mb_help[] =
	"mb <address>\n\n"
	"  Modify a byte in memory (does not read byte first).\n";

static const char
mi_help[] =
	"mi <address>\n\n"
	"  Modify a word in memory (does not read word first).\n";

static const char
ms_help[] =
	"ms <address>\n\n"
	"  Modify a short word in memory (does not read short word first).\n";


const char *
memhelp_table[] = {
	help_all, dot_help, db_help, di_help, ds_help, 
	ex_help, fb_help, fi_help, 
	fs_help, he_help, mb_help, mi_help, ms_help,
	NULL
};


