/**			       
*
*	Program Name:	TESTER for stanley
*
*	Filename:	memedit.c
*
*	$Log:   /b/gregs/bridge/tester/memedit.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 09:22:44   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 09:45:02   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:25:48   franks
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:42:24   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		6.17.91
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	This is the memory editor. It is based on
*			the nindy user interface.
*			It allows the user to:-
*			1	display memory in byte, short or word			1	display memory in bytes, shorts or words
*			2	modify memory in byte, short or word
*			3	fill memory in byte, short or word
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include <menuparse.h>
/*
 *	memory editor functions
 */
extern	int mem_display();
extern	int mem_exit();
extern	int mem_fill();
extern	int mem_modify();
extern	int mem_help();
/*
 *	eeprom editor functions
 */
extern	int eeedit_clear();
extern	int eeedit_update();
extern	int eeedit_display();
extern	int eeedit_edit();
extern	int eeedit_exit();
extern	int eeedit_show();
extern	int eeedit_help();

/*
 *	Help table for memory editor
 */
extern const char *memhelp_table[];

/*
 *	Help table for eeprom editor
 */
extern const char *eehelp_table[];

/************************************************************************
 * COMMAND TABLE
 *
 * The following table describes the keyboard commands.
 * The fields in each entry have the following meanings:
 *
 * cmd_name
 *	Name of command as a '\0'-terminated string.  Only the number of
 *	leading characters required for a match with user-entered input
 *	appear here,
 *
 * cmd_action
 *	Function that actually performs the command.  It should be
 *	invoked with the following arguments, in order:
 *		- the cmd_internal_arg from the command entry.
 *		- the number of following arguments that are valid on
 *			this call (some arguments may be optional).
 *		- one or more user-entered arguments, already parsed
 *			according to the corresponding cmd_argtypes.
 *
 * cmd_internal_arg
 *	First argument to be passed to the command action function.
 *
 * cmd_argtypes
 *	A '\0'-terminated list of characters describing the legal
 *	user-entered arguments to the command.  The ascii version
 *	of each argument should be translated into the corresponding
 *	type before it is passed to the action function.  Valid types are:
 *
 *	D  The text may be either a decimal constant (it should be
 *	   converted to binary before being passed) or a register name
 *	   (the register's contents should be passed).
 *
 *	H  The text may be either a hexadecimal constant (it should be
 *	   converted to binary before being passed) or a register name
 *	   (the register's contents should be passed).
 *
 *	S  The ASCII string should be passed unchanged to the action function.
 *
 *	Upper case letters indicate required arguments, lower case letters
 *	indicated optional arguments.  It is assumed that all required
 *	arguments always precede all optional ones.
 *
 ************************************************************************/

/*
 *	command table for memory editor
 */

static const struct cmd
mem_cmd_table[] = {
	{ ".",  0,		0,			"",	},
	{ "db", mem_display,	BYTE,			"Sd",	},
	{ "di", mem_display,	INT,			"Sd",	},
	{ "ds", mem_display,	SHORT,			"Sd",	},
	{ "ex", mem_exit,	0,			"",	},
	{ "fb", mem_fill,	BYTE,			"HHH",	},
	{ "fi", mem_fill,	INT,			"HHH",	},
	{ "fs", mem_fill,	SHORT,			"HHH",	},
	{ "?",  menuparse_help,	(int)memhelp_table,	"s",	},
	{ "he", menuparse_help,	(int)memhelp_table,	"s",	},
	{ "mb", mem_modify,	BYTE,			"Sd",	},
	{ "mi", mem_modify,	INT,			"Sd",	},
	{ "ms", mem_modify,	SHORT,			"Sd",	},
	{ NULL, 0 }
};

/*
 *	command table for eeprom editor
 *	K Kong
 */

static const struct cmd
eeedit_cmd_table[] = {
	{ "cl", eeedit_clear,	0,			"D",	},
	{ "up", eeedit_update,	0,			"D",	},
	{ "di", eeedit_display,	0,			"D",	},
	{ "ed", eeedit_edit,	0,			"D",	},
	{ "ex", eeedit_exit,	0,			"",	},
	{ "?",  menuparse_help,	(int)eehelp_table,	"s",	},
	{ "he", menuparse_help,	(int)eehelp_table,	"s",	},
	{ "sh", eeedit_show,	0,			"",	},
	{ NULL, 0 }
};
/*
 *	memory editor menu shell
 */
TestMemEdit()

	{
	MenuParse("\n\t\tMemory Editor\nCopyright (c) 1991, \
Hughes LAN Systems\n", mem_cmd_table);
	}

/*
 *	Eeprom editor shell
 */	 
TestEepEdit()

	{
	eeedit_init();
	MenuParse("\n\t\tEEPROM Editor\nCopyright (c) 1993, \
Hughes LAN Systems\n", eeedit_cmd_table);
	}
