/**			       
*
*	Program Name:	BOOTER
*
*	Filename:	tdummy.c
*
*	Creation Date:	4.29.91
*
*	Date:		4.29.91
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	This file contains some dummy functions for
*			the BOOTER. 
*			This file will be discarded on the final 
*			program.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <types.h>
#include <krnl.h>
#include <uart.h>
#include <eeprecs.h>
#include <dips.h>
#include <prcctl.h>
#include <nvrdummy.h>
#include <sys.h>
#include <brip.h>
#include "../i960/bp_ring/scc_defs.h"
#include "../i960/bp_ring/scc_buff.h"

int fddi_smt_stats_tbl[64];
byte frontPanelLed[16];
int *MACHost[64];
NVR_BOOT nvr_boot_rec;

word
chnl_init(int);

tcb_malloc(size)
word	size;
	{
	return smalloc(size);
	}

stk_malloc(size)
word	size;

	{
	return smalloc(size);
	}

nmalloc(size)
word	size;

	{
	return lmalloc(size);
	}
nmres_init()
	{
	return 0;
	}
DBD *snc_get_dbd()
{
	return (DBD *)get_dbd();
}

snc_put_dbd(dbd)
DBD *dbd;
{
	return free_dbd(dbd);
}
FlickerLeds()
	{
	}

IsMyPortIp(long ip)
	{
	return 0;
	}

IsSlipPacket()
	{
	return FALSE;
	}

getBatchCnt()
{
  return(BATCH);
}
DequeTmr()
{
}
EnqueTmr()
{
}

tcp_transmit_complete(){}
get_rs_entry(){}
PutBootRec(){}

get_ring_number()
{
	/* if ring number in eeprom is 0xffff, use the DIP switches */
   if (eep_boot_rec.eep_ring_number == 0xffff)	/* gjs zzz */
		return( (sys.sys_switch & DIP_RING_NUM) >> RING_NUM_SHIFT );
   else
		return(eep_boot_rec.eep_ring_number);
}


/*
* Returns:	1 = debug mode is on
*		0 = debug mode is off
*/
get_debug()
{
	int	debug;

#ifdef notdef		/* GJS */
	/*
	* if the debug is defined in the boot record
	* it overrides the dip switch
	*/
	if (nvr_boot_rec.nvr_debug != -1)
		debug = nvr_boot_rec.nvr_debug;

	else
#endif
		/*
		* get start up mode code from the debug dip switch
		*/
		debug = ~Dip_read() & DIP_DEBUG_ON;

	return(debug);
}

/*
chnl_free_dbd(int* dbd)
{
  f_free_dbd(dbd);
}
*/

strobe_wdt(){}

int port_tx_flkcnt;
int fddi_port_pstats_tbl[150];
int fddi_if_pstats_tbl[150];


long
crit_on()
{
	long value;
	extern word ram_control_table[];

	/*
	* Setup Interrupt control Register ICON
	*/
	value = (ram_control_table[7] & 0x400);

	ram_control_table[7] |= 0x400; /* global interrupt disable */
	send_sysctl(0x401, 0, 0);

	return(value);
}

crit_off(long old_value)
{
	extern word ram_control_table[];

	/*
	* Setup Interrupt Control Register ICON
	*/
	if (old_value == 0)
		{
		ram_control_table[7] &= 0xfbff; /* global interrupt enable */
		send_sysctl(0x401, 0, 0);
		}

	return;
}

int fddiHost_control_tbl[150];
int *PortInitState;
byte  MacIDWaitResponse = 0;  /* dummy var, used by application */
byte UI2PortMap[100];
LED_SetInterfaceLED (){}
int NumberOfPorts;
int MonpMbox[16];
static int init_if_flag = FALSE;
int media_state = FALSE;
byte* port_num2lst;
byte* port_lst2num;

TurnOnAllLed (){return 0;}
TurnOffAllLed (){return 0;}
send_portdisable_trap(){}
#ifdef 0
ProcessEchoResponse (){return 0;}	/* from mapproc.o */
#endif
MONP_Diag (){return 0;}
MONP_Init (){return 0;}
MONP_hash (){return 0;}
MONP_PstatsDataPkt (){return 0;}
MONP_PstatsMACPkts (){return 0;}
MONP_MLstats (){return 0;}
MONP_get_free_pstats (){return 0;}
MONP_get_free_monp_msg (){return 0;}
MONP_Process (){return 0;}
MONP_UpdateSMTStats (){return 0;}
DebugStrBreak(){enter_debug(0xbad123);}

#define FDDI_RX_BUF_CNT         128
#define FDDI_SHRAM_START		0x50030000

InitPSPMem() {
 	int retCode;
        if( (retCode = MEM_InitPSPPool(FDDI_SHRAM_START, FDDI_RX_BUF_CNT)) != 0 )
                printf("MEM_InitPSPPool() returned error\n");
        return(retCode);

}

init_if()
{
	if (init_if_flag)   /* if it has been called */
	{
		printf("fddi chnl has been init\n");
		return 1;
	}
	
	if(InitPSPMem() != 0) {
		return(0);
	}

	/*
    	* initialize the media interface
	*/
	if (chnl_init(1) == 0) /* Init for the bridge application */
	{
		/*
		* unable to initialize the media interface
		*/
		printf("Unable to initialize Fddi media interface\n");
		return 0;
	}
	
	init_if_flag = TRUE;
	return(1);
}


word
chnl_init(source)
int source;   /* 0 from booter, 1 from application */
{

  if (media_state)
    return(TRUE);
		
  media_state = TRUE;

  if (InitPortList() == FALSE)
    return FALSE;


  if (!init_fddi(source))
    return FALSE;


  DoConnect();        /* Activate FDDI */
  return TRUE;

}


InitPortList ()
{
#if 0
  int max_ports, i;

  if ((port_num2lst = (byte *)lmalloc(sizeof(byte)*(NumberOfPorts+1)))==NULL) {
    if (get_debug() )
      printf("Error: no memory for num2list table\n");
    return FALSE;
  }
  max_ports = 1 << (NumberOfPorts+1);
  if ((port_lst2num = (byte *)lmalloc(sizeof(byte) * max_ports)) == NULL) {
    if (get_debug() )
      printf("Error: no memory for list2num table\n");
    return FALSE;
  }
  for (i=0; i < max_ports; i++)
    port_lst2num[i] = 0;
  for (i=0; i < (NumberOfPorts+1); i++)  {
    port_num2lst[i] = 1 << i;
    port_lst2num[1 << i] = i;
  }
#endif
  return TRUE;
}

/* dummies to satisfy the linker  -  they shouldn't be called */
RaiseVoltage() { }
LowerVoltage() { }

/*
* support routines for scc
*/
#ifdef notdef		/* gjs zzz */
get_device_type() {return 2;}
get_media_type() {return 2;}
get_media_speed() {return 2;}
#endif

set_seven_segment_display(value)
char value;
{
	HW_SLed(value);
}

void switch_rcv_line(short x, byte y) {}

/*
* Called from brip receive task.
* Intercept and print every frame we receive and transmit
* if sccMonitor is set
*/
static int sccMonitor = 0;

SetSccMonitor(on)
int on;
{
	sccMonitor = on;
}

PrintSccFrame(frame)
KA_FRAME	*frame;
{
	char	*frmTypeFiltMsg[5] = {"REQ", "RSP", "RMV", "INS", "KA"};

	if (sccMonitor)
	{
		int	type;

		if (frame->frame_type_hi == BRIP_FRAME_TYPE)
			type = frame->frame_type_lo - 10 - 1;

		if (frame->src_slot == GetSlotID())
			printf("* ");		/* my frame */

		printf("(%d,%d) (%d,%d) (%d,%d) (%d,",
			frame->src_slot, frame->src_line,
			frame->dst_slot, frame->dst_line,
			frame->dsn_line, frame->usn_line,
			frame->hub_ring);

		if (0 <= type && type <= 4)
		{
			printf("%s)\n", frmTypeFiltMsg[type]);
		}
		else	/* unknown type, print value */
		{
			printf("%d)\n", type);
		}
	}
}

DebugStr() {
}
