/***************************************************************************
*	Program Name:	nim960 bridge
*
*	Filename:	sncxmt.c
*
*       $Log:   /b/gregs/bridge/sonic/sncxmt.c_v  $
 * 
 *    Rev 1.6   14 Oct 1993 10:36:34   franks
 * Removed a couple of debug statements.
 * 
 *    Rev 1.5   12 Oct 1993 09:05:16   franks
 * 
 *    Rev 1.4   29 Sep 1993 08:48:46   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 08:42:42   franks
 * 
 *    Rev 1.2   10 Sep 1993 15:08:02   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 09:45:52   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:05:00   franks
 * Initial revision.
 * 
 *    Rev 1.1   06 Jul 1993 14:17:48   sammyc
 * 
 *    Rev 1.0   05 Apr 1993 17:20:48   ramki
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:40:06   pvcs
 * Initial revision.
*
*	Comments:	Port to i960 platform.
*
*
*       This module contains the routines frequently invoked by the user
*
*       Functions are: 
*       Transmit frame - send a frame, handle by RDA or by PKT
*       Retransmit frame - send a frame again, handle by TDA
*       Get receive - get a received frame
*
*	Copyright (c) 1991 by Hughes LAN Systems
 ******************************************************************/

#include <krnl.h>
#include <target.h>
#include <sncvar.h>
#include <led.h>

extern SO *sv_so;
extern word *flick_tx;
extern word *flick_rx;
extern shrt chnl_flk_rx_led;

/**********************************************************************
snc_transmit_sncr(sncr,ptrlst,length)
Description:
     This routing is called by packet process routine to
     transmit the packet base on the sncr
***********************************************************************/
extern byte *snctrda;

void snc_transmit_sncr(sncr,portlst,length)
register SNCR *sncr;		/* local frame descriptor pointer */
register word portlst;
register word length;
	{
	register SDV *sdvp;
	register SNCT *snct;
	register port;
	register port_num;
	register cnt=0;
	register sncr_blo = *(word *)&sncr->sncr_blo;
	register sncr_seq = sncr->sncr_seq;

	portlst &= sv_so->so_prt_ena; 
	for(port=1,port_num=0; port_num< NumberOfSonicPort  ;port <<= 1,port_num++)
        {
	  if(!(port & portlst))
	    continue;
	  
	  /* only send out to thouse port are specific && enable */
	  sdvp=&sv_sdvs[port_num];
	  /* need to check more here to see if snct is available */
	  if(++sdvp->sv_var_loc->sv_txqlen < SV_NMBR_SNCT)
	    cnt++;
	  else
	    {
	      sdvp->sv_var_loc->sv_txqlen=SV_NMBR_SNCT;   /* run out of SNCT */
	      continue;
	    }
	  snct=(SNCT *)((*(word *)&(sdvp->sv_xmttl->snct_nxt))&0xfffffffe); 
	  
	  /* build the SNCT */
	  snct->snct_hom = sncr_seq;
	  snct->snct_blo = sncr_blo;
	  snct->snct_bhi = sncr_blo >> 16; 
	  snct->snct_len = length;	       /* packet length */
	  snct->snct_bln = length;	       /* frag length (= pkt length) */
	  snct->snct_nxt |= SNCT_NXT_EOL;      /* mark it as end of list */
	  /* queue immediately */
	  sdvp->sv_xmttl->snct_nxt = (shrt)( (word)snct);/* link and clr EOL */
	  sdvp->sv_snc->snc_cr = SNC_CR_TXP;  /* start transmit cmnd */
	  sdvp->sv_xmttl = snct;              /* this is the new tail  */
	  /* check if multicast address */
	  if(!(*(char *)sncr_blo & 1))          
	    sdvp->sv_var_loc->sv_outu++;
	  else
	    sdvp->sv_var_loc->sv_outm++;
	}
	/* if can't transmit free it */
	if(!(snctrda[sncr_seq] = cnt))
	    snc_put_frame(sncr,port);
      }


/**********************************************************************
snc_transmit_pkt(pkt,freeit)
Description:
     This routing is called by packet process routine to
     transmit the packet base on the pkt
***********************************************************************/
#define SNC_NXT_EOL 0x00000001
word *txpkt_link_eol; /* the location of txpkt.link and EOL */

void snc_transmit_pkt(pkt_head,freeit)
PKT *pkt_head;
word freeit;
	{
	register SDV *sdvp;
	register SNCT *snct;
	register portbit;
	register portnum;
	register PKT *pkt;
	register XmtPort;
	register cnt = 0;
	extern FreePkt();
	extern PKT  *FreePktHead; 

	pkt_head->pktXmtPort &= sv_so->so_prt_ena; 
	XmtPort = pkt_head->pktXmtPort;
	
	/* check if it is broute packet( broute packet: the packet xmit by bridging process)
	   yes : free the packet header use snctrda
	   no  : use packet header */

	if(pkt_head->pktUseCount & PKTBROUT)
	  {
	    register DriverInfo = pkt_head->pktDriverInfo;

	    for(portbit=1,portnum=0;portnum< NumberOfSonicPort;portbit <<= 1,portnum++)
	      {
		if(!(portbit & XmtPort))
		  continue;
		sdvp = &sv_sdvs[portnum];
		/* need to check more here to see if snct is available */
		if(++sdvp->sv_var_loc->sv_txqlen >= SV_NMBR_SNCT)
		  {
		    sdvp->sv_var_loc->sv_txqlen = SV_NMBR_SNCT;   /* run out of SNCT */
		    pkt_head->pktXmtPort &= ~portbit;  /* clear the port */
		    continue;
		  }
		cnt++;
		snct=(SNCT *)((*(word *)&(sdvp->sv_xmttl->snct_nxt))&0xfffffffe); 

		/* check if multicast address (for SNMP purpose ) */
		if(!(*(pkt_head->pktBufPtr)& 1))          
		  sdvp->sv_var_loc->sv_outu++;
		else
		  sdvp->sv_var_loc->sv_outm++;	  
		
		/* build the SNCT */
		snct->snct_hom = (shrt)DriverInfo; 
		snct->snct_frg = 1;
		snct->snct_blo = LO(pkt_head->pktDataPtr);
		snct->snct_bhi = HI(pkt_head->pktDataPtr); 
		snct->snct_len = snct->snct_bln = pkt_head->pktDataSize;
		snct->snct_pkt = NULL;    /* point to the packet struct */
		/* assume no chain buffer for brout packet */
		snct->snct_lnk[0] = snct->snct_nxt | SNC_NXT_EOL;

		/* queue immediately  and link to previouse snct's txpkt.link */
		if(sdvp->sv_xmttl->snct_lnk[0] & SNC_NXT_EOL)
		  sdvp->sv_xmttl->snct_lnk[0] =(shrt)( (word)snct);
		else
		  sdvp->sv_xmttl->snct_lnk[txpkt_link_eol[(sdvp->sv_xmttl->snct_frg-1)]]=(shrt)((word)snct);
		sdvp->sv_snc->snc_cr = SNC_CR_TXP;  /* start transmit cmnd */
		sdvp->sv_xmttl = snct;              /* this is the new tail  */
	      }
	    /* if can't transmit it free the packet header & buffer */
	    if(!(snctrda[DriverInfo] = cnt))
	      pkt_head->pktFree(pkt_head);
	    else /* free the packet header only */
	      {
#ifdef sammy /* !!!!!can't call FreePkt here too expensive */
		FreePkt(pkt_head);
#endif
		pkt_head->pktUseCount -= 1;
		if(!(pkt_head->pktUseCount & 0xff)) /* free it when no use count */
		  {
			pkt_head->pktXmtPort = 0;
			pkt_head->pktMsgHdr.mh_link = (MSGHDR *)FreePktHead;
			FreePktHead = pkt_head;
		  }

	      }
	  }
       
	else /* not brout packet case */
	  {
	    register word savePC;
	    register i;

	    savePC = modpc(0x001f0000,0x001f0000); /* disable interrupt */
	    if(!freeit)
	      pkt_head->pktUseCount++;
	    
	    for(portbit=1,portnum=0; portnum< NumberOfSonicPort ;portbit <<= 1,portnum++)
	      {
		if(!(portbit & XmtPort))
		  continue;
		/* only send out to those ports that are specified && enabled */
		sdvp=&sv_sdvs[portnum];
		/* need to check more here to see if snct is available */
		if(++sdvp->sv_var_loc->sv_txqlen >= SV_NMBR_SNCT)
		  {
		    sdvp->sv_var_loc->sv_txqlen=SV_NMBR_SNCT;   /* run out of SNCT */
		    pkt_head->pktXmtPort &= ~portbit;  /* clear the port */
		    continue;
		  }
		cnt++;
		snct=(SNCT *)((*(word *)&(sdvp->sv_xmttl->snct_nxt))&0xfffffffe); 

		/* check if multicast address (for SNMP purpose ) */
		if(!(*(pkt_head->pktBufPtr)& 1))          
		  sdvp->sv_var_loc->sv_outu++;
		else
		  sdvp->sv_var_loc->sv_outm++;	  
		/* build the SNCT */
		snct->snct_frg = 1;
		snct->snct_blo = LO(pkt_head->pktDataPtr);
		snct->snct_bhi = HI(pkt_head->pktDataPtr); 
		snct->snct_len = pkt_head->pktTotalSize; /* packet length */
		snct->snct_bln = pkt_head->pktDataSize; /*frag length */
		snct->snct_pkt = pkt_head;    /* point to the packet struct */
		if(pkt_head->pktBufLink == NULL)
		  {  /* only one */
		    snct->snct_lnk[0] = snct->snct_nxt | SNC_NXT_EOL;
		  }
		/* chain buffer case */
		else 
		  {
		    pkt = pkt_head->pktBufLink;
		    for(i=0; pkt ; pkt = pkt->pktBufLink)
		      {
			snct->snct_frg++;
			snct->snct_lnk[i] =   LO(pkt->pktDataPtr);
			snct->snct_lnk[i+2] = HI(pkt->pktDataPtr); 
			snct->snct_lnk[i+4] = pkt->pktDataSize;
			i+=6;                           /* move index */
		      }
#ifdef debug
		    /* ###for debuging purpose ####*/
		    if(i > 12)
		      enter_debug(0x1111,pkt_head);
		    /* ###for debuging purpose ####*/
#endif
		    snct->snct_lnk[i] = snct->snct_nxt | SNC_NXT_EOL;
		  }
		/* queue immediately , attach snct to txpkt.link */
		sdvp->sv_xmttl->snct_lnk[txpkt_link_eol[(sdvp->sv_xmttl->snct_frg-1)]] =(shrt)((word)snct);
		sdvp->sv_snc->snc_cr = SNC_CR_TXP;  /* start transmit cmnd */
		/******** MYDEBUG *******************
		 if( (word)snct & 1)
				enter_debug(0xbad, sdvp,snct);
		**************************************/
		sdvp->sv_xmttl = snct;              /* this is the new tail  */
		/******** MYDEBUG *******************
		if( (word) sdvp->sv_xmttl & 0x01)
			enter_debug(0x0bad1,sdvp,snct,sdvp->sv_xmttl);
		*************************************************/
	      }
	    /* if can't transmit free it */
	    if(!cnt)
	      {
		for( pkt = pkt_head; pkt_head ; pkt_head = pkt)
		  {
		    /* advanced pkt to next first(the orig will free back) */
		    pkt = pkt_head->pktBufLink;
		    (pkt_head->pktFree)(pkt_head);
		  }
		modpc(0x001f0000, savePC);
		return;
	      }
	    pkt_head->pktUseCount |= PKTINXMT;
	    modpc(0x001f0000, savePC);
	  }
      }







/*
 * Return a received frame
 */
/* 1.snc_receive is only move the receive head to next one, this routine
     will not be used in real chnl driver 
     sammy 5/30/91
   2.the sncr also need not to return
   3.the routine propabibly will never been called
*/
#define SNC_RCR_BMC (SNC_RCR_BC | SNC_RCR_MC) 
#define DISABLE 2

PKT *snc_receive(sdvp,port,portbit)
register SDV *sdvp;
register word port;
register word portbit;    /*for flick led purpose */
{
	register SNCR *sncr = (SNCR *)(sdvp->sv_rcvhd);
	register sncr_seq = (*(word *)&sncr->sncr_seq & RDA_POOL_SEQ_MASK);
	register PKT *pkt;
	extern PKT  *FreePktHead; 
	extern PKT *GetPkt();
	extern int snc_put_pkt();
	extern int FreePktBuf();
  	extern int FreeThisPktBuf();
  	extern Nop();

	/* set up the rx led flicker */
	chnl_flk_rx_led |= (ushort)portbit;

	
#ifdef sammy  /* !!!!! can't call GetPkt() over here too expensive */
	if((pkt=GetPkt())==NULL)
	  {
	  /*  enter_debug(0x1212);   */
	    return(NULL);
	  }
#endif 

	if((pkt = FreePktHead) == NULL)
	  return(NULL);
	FreePktHead = (PKT *)pkt->pktMsgHdr.mh_link;
	/********* MYDEBUG *********
	pkt->pktMsgHdr.mh_link = 1;
	***************************/
	pkt->pktBufLink = NULL;
	pkt->pktFree = (void *)FreeThisPktBuf;
	pkt->pktXmtPort = 0;
	pkt->pktRcvPort = port;
	pkt->pktDataPtr = pkt->pktBufPtr = (char *)SNCADDR(port,sncr->sncr_blo);
	pkt->pktTotalSize = pkt->pktBufLen = pkt->pktDataSize = sncr->sncr_len - 4; 
	pkt->pktDriverFree = (void *)snc_put_pkt;
	pkt->pktDriverInfo = sncr_seq| port << 11;
	pkt->pktUseCount = (1 | PKTBROUT);

	/* advance the sonic receive head */
	sdvp->sv_rcvhd = (SNCR *)((*(word *)&sncr->sncr_nxt) & 0xfffffffe);

	/* set up pool count & pool index */
	sdvp->sv_plnus[sdvp->sv_plind = (sncr_seq >> 8)]++; 

	sdvp->sv_rxcnt++;
	sdvp->sv_rxqlen++;
	sdvp->sv_var_loc->sv_inb += pkt->pktDataSize;

	if(!( sncr->sncr_sta & SNC_RCR_BMC))/*unicast addr*/
	  {
	    sdvp->sv_var_loc->sv_inu++;
	  }
	else
	  {
	    sdvp->sv_var_loc->sv_inm++;
	    /* if disable multicast receive */
	    if(sdvp->sv_var_loc->sv_multi == DISABLE)
	      {
		pkt->pktFree(pkt);
		return(0);
	      }
	  }
	return(pkt);
}



/*
 * Transmit a pkt frame onto the network for testing purpose
   Describe:
   the difference between snc_transmit_pkt & snc_transmit_pkt_test is
   snc_transmit_pkt_test() using the local pkt buffer and for testing purpose
   only.
   snc_transmit_pkt() using the user pkt buffer for IP/UDP/TCP stack
 */
snc_transmit_pkt_test(pkt,length,portlst)
PKT *pkt;		/* packet descriptor pointer */
word length;
word portlst;
	{
	register SDV *sdvp;
	register SNCT *snct;
	register port;
	register port_num;

	portlst &= sv_so->so_prt_ena; 
	for(port=1,port_num=0;port_num<NumberOfSonicPort;port <<= 1,port_num++)
        {
	  /* only send out to thouse port are specific && enable */
	  if(!(port & portlst))  
	    continue;
	  sdvp=&sv_sdvs[port_num];
	  if(sdvp->sv_var_loc->sv_txqlen >= SV_NMBR_SNCT) /* if xmit descripter used up */
	      return(-1);
	  snct=(SNCT *)( (*(word *)&(sdvp->sv_xmttl->snct_nxt)) & 0xfffffffe); 

	  /* build the SNCT */
	  if(sdvp->sv_txcnt <= SV_NMBR_SNCT)
	    {
	      snct->snct_blo = LO(pkt->pktBufPtr);
	      snct->snct_bhi = HI(pkt->pktBufPtr);
	      snct->snct_adr = snct->snct_bhi;
	      snct->snct_frg = 1;   		 /* number frags (always 1) */
	      snct->snct_len = length;		/* packet length */
	      snct->snct_bln = length;	       /* frag length (= pkt length) */
	      snct->snct_lnk[0] = snct->snct_nxt | SNC_NXT_EOL;
	    }
	  snct->snct_nxt |= SNCT_NXT_EOL;	/* mark it as end of list */
	  sdvp->sv_var_loc->sv_txqlen++; 
	  
	  /* queue immediately */
	  sdvp->sv_xmttl->snct_lnk[0] = (shrt)( (word)snct);
	  sdvp->sv_xmttl->snct_nxt = (shrt)( (word)snct);/* link and clr EOL */
	  sdvp->sv_snc->snc_cr = SNC_CR_TXP;  /* start transmit cmnd */
	  sdvp->sv_xmttl = snct;              /* this is the new tail  */
	}
	return(0);
      }







