/***************************************************************************
*	Program Name:	nim960 bridge
*
*	Filename:	sncutil.c
*
*       $Log:   /b/gregs/bridge/sonic/sncutil.c_v  $
 * 
 *    Rev 1.6   20 Oct 1993 10:33:10   franks
 * Uncommented snc_init=0 in snc_disable().
 * 
 *    Rev 1.5   12 Oct 1993 09:05:14   franks
 * No change.
 * 
 *    Rev 1.4   07 Oct 1993 13:24:20   gregs
 * Replaced Di() and Ei() with MaskAllInts and RestoreIntMask().
 * 
 *    Rev 1.3   29 Sep 1993 08:48:22   franks
 * 
 *    Rev 1.2   10 Sep 1993 15:08:00   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 09:45:48   franks
 * First SIT release
 * 
 *    Rev 1.0   30 Jul 1993 13:05:00   franks
 * Initial revision.
 * 
 *    Rev 1.2   06 Jul 1993 14:17:42   sammyc
 * 
 *    Rev 1.1   07 Apr 1993 19:08:50   sammyc
 * provide get_shmalloc_addr() for main.c 
 * 
 *    Rev 1.0   05 Apr 1993 17:20:46   ramki
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:40:04   pvcs
 * Initial revision.
*
*	Comments:	Port to i960 platform.
*       This section contains some utilties
*
*       Functions are: 
*       clear counters - suck the counters from the SONIC
*       reset WDT - reset the watch dog timers
*       flush frames - remove & free all queued frames from a port.
*
*       All calls are by port, numbered 1 thru 1<<N.
*       Config returns the sv structure so the applic can see counters.
*
*	Copyright (c) 1991 by Hughes LAN Systems
 ******************************************************************/

#include <krnl.h>
#include <target.h>
#include <memory.h>
#include <sncvar.h>
#include <sys.h>
#include <led.h>

extern int getBatchCnt();
/*
 * Clear the counters on a port
 */
snc_clear_cnt(port)
word port;
	{
	register SDV *sdvp=&sv_sdvs[port];
	register SV *svp = sdvp->sv_var_loc;

	sdvp->sv_txcnt = 0;
	sdvp->sv_rxcnt = 0;
	svp->sv_outb = 0;
	svp->sv_inb = 0;
	svp->sv_outu = 0;
	svp->sv_inu = 0;
	svp->sv_outm = 0;
	svp->sv_inm = 0;
	svp->sv_clsn = 0;
	svp->sv_crc = 0;
	svp->sv_aln = 0;
	svp->sv_lst = 0;
	svp->sv_rcvlk = 0;
	svp->sv_xmtlk = 0;
	svp->sv_tstrpt = 0;
	}


/*
 * utility to let other code reset the deadman timers
 */
snc_reset_wdt(port)
word port;
	{
	register SV *svp = &sv_vars[port];

	svp->sv_rcvwdr = svp->sv_inu + svp->sv_inm;  /* rst rx wdt rx cntr */
	svp->sv_rcvwdx = svp->sv_outu+svp->sv_outm;  /* rst rx wdt tx cntr */
	svp->sv_xmtwdc = svp->sv_xmtwdt;	/* reset xmt wdt  */
	}



/*
 * Utility to flush all xmt waiting and xmt pending frames from a port
 */
snc_flush_xmt(port)
word port;
	{
	register SDV *sdvp = &sv_sdvs[port];
	register SV *svp = sdvp->sv_var_loc;
	register SNCT *snct;
	register PKT *pkt;
	extern int snc_put_snct();

	/* flush the waiting frames */
#ifdef sammy
	while (svp->sv_outhd)
	  {
	    snct = svp->sv_outhd;			       /* next frame */
	    svp->sv_outhd=(SNCT *)SNCADDR(port,snct->snct_nxt);/* detach */
	    pkt = snct->snct_pkt;
	    /*pkt->pktDriverFree(pkt->pktDriverInfo); */
	    pkt->pktFree(pkt);
	  }
	/* flush the pending frames */
	while ((sdvp->sv_xmthd != (SNCT *)SNCT_NXT_EOL) && 
	       sdvp->sv_xmthd->snct_sta)
#endif

	for(;sdvp->sv_var_loc->sv_txqlen; sdvp->sv_var_loc->sv_txqlen--)
	  {
	    /* detach from queue */
	    snct = sdvp->sv_xmthd;			       /* next frame */
	    sdvp->sv_xmthd=(SNCT *)(*(word *)&snct->snct_nxt & 0xfffffffe);
	    snct->snct_sta = 0;
	    /* free the packet header buffer */
		if(pkt = snct->snct_pkt)
			if(!pkt->pktXmtPort) {
				continue;
			}
	     snc_put_snct(snct,(1 << port)); 
	  }
}


/*
 * Utility to flush all rcv waiting frames
 */
snc_flush_rcv(port)
word port;
	{
	register SDV *sdvp = &sv_sdvs[port];
	register SNCR *sncr;

	/* flush the received frames */
	while ( (sncr = sdvp->sv_rcvhd) && !(sncr->sncr_nus) ) 
		{
		sdvp->sv_rcvhd = (SNCR *)((*(word *)&sncr->sncr_nxt) & 0xfffffffe);
		snc_put_frame(sncr,port);		  /* free it */
		}
	}


snc_flush_cnt(port)
word port;
{
          register SV *svp = &sv_vars[port];
	  
	  svp->sv_crc += svp->sv_snc->snc_crct; /* read crc err cntr */
	  svp->sv_snc->snc_crct = 0xffff;       /* clear crc err cntr */
	  svp->sv_aln += svp->sv_snc->snc_faet;
	  svp->sv_snc->snc_faet = 0xffff;
	  svp->sv_lst += svp->sv_snc->snc_mpt;  /* read lost packets cntr */
	  svp->sv_snc->snc_mpt = 0xffff;        /* clear lost packets cntr */
}

snc_tx_sta_cnt(status,port_num)
word status;
word port_num;
{
  register SV *svp = &sv_vars[port_num];

      if(status & 0xfffe)
	{
	  if((status >>11) == 1)
	    svp->sv_tx_scol++;
	  else
	    if((status >>11) >1)
	      svp->sv_tx_mcol++;
	  if(status & SNC_TCR_DEF)
	    svp->sv_tx_def++;
	  if(status & SNC_TCR_OWC)
	    svp->sv_tx_owc++;
	  if(status &(SNC_TCR_NCRS | SNC_TCR_CRSL))
	    svp->sv_tx_crs++;
	}
}

word exc_col_flag=0;
snc_tx_fail_cnt(status,port_num,snct)
word status;
word port_num;
SNCT *snct;
{
  register SV *svp = &sv_vars[port_num];

      if(status & SNC_TCR_EXC)
	{
	  svp->sv_tx_exc++;
	  exc_col_flag=1;
	}
      else if(status & SNC_TCR_EXD)
	svp->sv_tx_exd++;
      else if(status & SNC_TCR_FU)
	svp->sv_tx_fu++;
      else
	svp->sv_tx_bcm++;  
}



#define EMU_RDA_SIZE  768
extern byte *snctrda;
extern word *flick_tx;    
extern word *flick_rx;    
extern word *port_num2lst;
extern word *port_lst2num;
extern word *txpkt_link_eol;
extern SSDV[];
/* clear the internal sonic data structure */
word batch;
snc_clear()
{
        register SV *svp;
	register indx=0;
	register port;
	extern word snc_init;

	if(snc_init) /* if driver already start then reset it */
	  {
	    snc_init=0;
	    for(indx=0,port=1;indx < NumberOfSonicPort;indx++,port <<=1)
	      {
		/* if(sv_so->so_prt_ena & port) */
		  {
		    svp=&sv_vars[indx];
		    svp->sv_snc->snc_cr=SNC_CR_RXDIS;/* disable the receiver */
		    cam_wt();
		    svp->sv_snc->snc_cr=SNC_CR_RST;   /* reset the SONIC */
		    cam_wt();
		  }
		  if(!(svp->sv_snc->snc_cr & SNC_CR_RST))
		    printf("port %d can't do software reset\n",indx);
	      }
	  }
	memset(sv_vars, 0, sizeof(SV)*(1+NumberOfSonicPort));
	memset(sv_so, 0, sizeof(SO));
	memset(sv_sdvs,0,sizeof(SDV) * NumberOfSonicPort);
	batch = getBatchCnt();
	memset(snctrda,0,(sizeof(byte) * (NumberOfSonicPort * SV_NMBR_POOL * 256)));
	/* clear all the port variable */
	flick_tx[0]=LED_TX1;
	flick_tx[1]=LED_TX2;
	flick_tx[2]=LED_TX3;
	flick_rx[0]=LED_RX1;
	flick_rx[1]=LED_RX2;
	flick_rx[2]=LED_RX3;

	port_num2lst[0]=1;
	port_num2lst[1]=2;
	port_num2lst[2]=4;
	port_num2lst[3]=8;

	port_lst2num[0]=0;
	port_lst2num[1]=0;
	port_lst2num[2]=1;
	port_lst2num[3]=0;
	port_lst2num[4]=2;
	port_lst2num[5]=0;
	port_lst2num[6]=0;
	port_lst2num[7]=0;
	port_lst2num[8]=3;

	txpkt_link_eol[0] = 6*0;
	txpkt_link_eol[1] = 6*1;
	txpkt_link_eol[2] = 6*2;
	txpkt_link_eol[3] = 6*3;
      }

char *mallocOB_dramstart_addr;
char *malloc_shrambufstart_addr;
/* for initmalloc() & initshmalloc() */

snc_malloc(word NumberOfPort)
{

        static int snc_malloc_flag=0;
        word batch;

	if(!snc_malloc_flag)
	  {
	    NumberOfSonicPort = NumberOfPort;
	    sv_sdvs=(SDV *)SSDV;    /* start location for 960 data ram */
	    sv_vars=(SV *)smalloc(sizeof(SV) * (1+NumberOfSonicPort));
	    /*clear the structure */
	    sv_so=(SO *)smalloc(sizeof(SO));
	    batch = getBatchCnt();
	    snctrda = (byte *)smalloc((sizeof(byte) * (NumberOfSonicPort * SV_NMBR_POOL * 256)));
	    
	    flick_tx=(word *)smalloc(sizeof(word) *4);
	    flick_rx=(word *)smalloc(sizeof(word) *4);
	    port_num2lst=(word *)smalloc(sizeof(word) *4);
	    port_lst2num=(word *)smalloc(sizeof(word) *(1<<4) );
	    txpkt_link_eol = (word *)smalloc(sizeof(word) * 4);
	    /* clear the data structure and set up */
	    snc_clear();
	    /* initialize the shmalloc and malloc */
	    malloc_shrambufstart_addr=(char *)SHRAM+SV_TOTL_PCTL+SV_TOTL_LCTL; 
	    snc_malloc_flag=1;
	    return(0);
	  }
	return(0);
      }

get_shmalloc_addr(word *ptr,word *size)
{
  *ptr = SHRAM+SV_TOTL_PCTL+SV_TOTL_LCTL;
  *size = SV_TOTL_LBUF;
}

snc_disable()
{

extern word snc_init;


	set_ctrl1(( CTRL1_LR1 | CTRL1_LR2 | CTRL1_LR3), (DISABLE_LR1 | DISABLE_LR2 | DISABLE_LR3));

	/** Since the FDDI driver may also have possession of some
	 ** sonic receive buffers, we need to flush it also.
	 **/
	BSI_AbortTx(0); 

	set_ctrl1((CTRL1_LR1 | CTRL1_LR2 | CTRL1_LR3), (ENABLE_LR1 | ENABLE_LR2 | ENABLE_LR3));

    snc_init=0; 
}

snc_reena(int PromiscuousMode)
{
  register word saveMask;
  int	ret = 0;
  int	PortNo;
  int	PortsFailed = 0;/* 	how many ports have failed */
  int	i;
  register portnum;
  register KRNL *krnl_ptr = &krnl;
  register SV *svp;
  register rcvmode;
  register start_addr;
  register io_addr;
  extern word snc_init;

	MaskAllInts(saveMask);
	/*
	 *	Config the sonic driver 
	 *	 
	 */
	sv_so->so_prt_ena = 0;
 	for(portnum=0; portnum< NumberOfSonicPort; portnum++)
		snc_flush_xmt(portnum);
       snc_store_counters();
        for(portnum=0 ; portnum< NumberOfSonicPort ; portnum++)
	  {
	    svp = &sv_vars[portnum];
	    rcvmode    = (word)svp->sv_rcvmd;
	    start_addr = (word)svp->sv_sncp;
	    io_addr    = (word)svp->sv_snc;
	    snc_config(portnum,rcvmode,start_addr,io_addr);
	  }
        for(portnum=0 ; portnum < NumberOfSonicPort ; portnum++)
	  {
	    if(snc_start(portnum))
	      {
		printf(" snc can't start\n");
		RestoreIntMask(saveMask);
		return(SV_TEST_FAIL_BADSNC);
	      }
	  }
        RestoreIntMask(saveMask);
        snc_resotre_counters();
        snc_init=1;
	/*
	 *	Return ok if at least one port is
	 *	working.
	 */
        return(0);
	}

SV save_sv_vars[4];
snc_store_counters()
{
word port;
  for(port=0;port<NumberOfSonicPort;port++)
    {
	register SDV *sdvp=&sv_sdvs[port];
	register SV *svp = sdvp->sv_var_loc;

	save_sv_vars[port].sv_txcnt=sdvp->sv_txcnt; 
	save_sv_vars[port].sv_rxcnt=sdvp->sv_rxcnt; 
	save_sv_vars[port].sv_outb=svp->sv_outb; 
	save_sv_vars[port].sv_inb=svp->sv_inb;
	save_sv_vars[port].sv_outu=svp->sv_outu;
	save_sv_vars[port].sv_inu=svp->sv_inu;
	save_sv_vars[port].sv_outm=svp->sv_outm;
	save_sv_vars[port].sv_inm=svp->sv_inm;
	save_sv_vars[port].sv_clsn=svp->sv_clsn;
	save_sv_vars[port].sv_crc=svp->sv_crc;
	save_sv_vars[port].sv_aln=svp->sv_aln;
	save_sv_vars[port].sv_lst=svp->sv_lst;
	save_sv_vars[port].sv_rcvlk=svp->sv_rcvlk;
	save_sv_vars[port].sv_xmtlk=svp->sv_xmtlk; 
	save_sv_vars[port].sv_tstrpt=svp->sv_tstrpt;
	save_sv_vars[port].sv_txfail=svp->sv_txfail;
      }
    
}

snc_resotre_counters()
{
word port;
  for(port=0;port<NumberOfSonicPort;port++)
    {
	register SDV *sdvp=&sv_sdvs[port];
	register SV *svp = sdvp->sv_var_loc;

	sdvp->sv_txcnt=save_sv_vars[port].sv_txcnt; 
	sdvp->sv_rxcnt=save_sv_vars[port].sv_rxcnt; 
	svp->sv_outb=save_sv_vars[port].sv_outb; 
	svp->sv_inb=save_sv_vars[port].sv_inb;
	svp->sv_outu=save_sv_vars[port].sv_outu;
	svp->sv_inu=save_sv_vars[port].sv_inu;
	svp->sv_outm=save_sv_vars[port].sv_outm;
	svp->sv_inm=save_sv_vars[port].sv_inm;
	svp->sv_clsn=save_sv_vars[port].sv_clsn;
	svp->sv_crc=save_sv_vars[port].sv_crc;
	svp->sv_aln=save_sv_vars[port].sv_aln;
	svp->sv_lst=save_sv_vars[port].sv_lst;
	svp->sv_rcvlk=save_sv_vars[port].sv_rcvlk;
	svp->sv_xmtlk=save_sv_vars[port].sv_xmtlk; 
	svp->sv_tstrpt=save_sv_vars[port].sv_tstrpt;
	svp->sv_txfail=save_sv_vars[port].sv_txfail;
      }
}

snc_reinit(portnum)
word portnum;
{
  register port;
  register i;

  
  for(i=0,port=1;i<NumberOfSonicPort;i++,port >>= 1)
    {
	register SDV *sdvp=&sv_sdvs[i];
	register SV *svp = sdvp->sv_var_loc;

	sdvp->sv_snc->snc_cr = SNC_CR_RST; /*software reset the sonic */
	snc_flush_rcv(i);
	snc_flush_xmt(i);
      }
  snc_clear_cnt(portnum);    /* clear the counters */
  for(i=0,port=1;i<NumberOfSonicPort;i++,port >>= 1)
    {
	register SDV *sdvp=&sv_sdvs[i];
	register SV *svp = sdvp->sv_var_loc;

	sdvp->sv_snc->snc_cr = 0; /*out of software reset */
      }
}


/* enable or disable the sonic xmtter & receiver */
#define ENABLE 1
#define DISABLE 2
snc_txrx(portnum,value)
word portnum;
word value;
{
  register SDV *sdvp=&sv_sdvs[portnum];
  register SV *svp = sdvp->sv_var_loc;
  extern SO *sv_so;
  
  if( value == ENABLE) /* enable */
    {
      if(svp->sv_init == DISABLE)
	{
	  sdvp->sv_snc->snc_cr = 0; /* out of reset mode */
	  cam_wt();
	  sdvp->sv_snc->snc_cr = SNC_CR_RXEN;
	  cam_wt();
	  sv_so->so_prt_ena |= (1 << portnum);
	  svp->sv_init = ENABLE;
	}
    }
  else if(value == DISABLE) /*disable */
    {
      if(svp->sv_init == ENABLE)
	{
	  sdvp->sv_snc->snc_cr = SNC_CR_RXDIS;
          cam_wt();
	  sdvp->sv_snc->snc_cr = SNC_CR_RST;
	  cam_wt();
	  sv_so->so_prt_ena &= ~( 1 << portnum);
	  svp->sv_init = DISABLE;
	  snc_flush_xmt(portnum); 
	}
    }
  else                /* do'nt know the command */
    ;                  
}


/* enable or disable sonic transmitter */
snc_tx(portnum,value)
word portnum;
word *value;
{
  register SDV *sdvp=&sv_sdvs[portnum];
  register SV *svp = sdvp->sv_var_loc;
  extern SO *sv_so;
  
  if( *value == ENABLE) /* enable */
    {
      if(svp->sv_txen == DISABLE)
	{
	  sv_so->so_prt_ena |= (1 << portnum);
	  svp->sv_txen = ENABLE;
	}
    }
  else if(*value == DISABLE) /*disable */
    {
      if(svp->sv_init == ENABLE)
	{
	  sv_so->so_prt_ena &= ~( 1 << portnum);
	  svp->sv_txen = DISABLE;
	  snc_flush_xmt(portnum);
	}
    }
  else                /* do'nt know the command */
    ;                  
}

void *snc_ifstat_loc(word if_number)
{
  return( (void *)&(sv_vars[if_number].sv_admin_status) );
}


free_pending_pkt()
{
	word plst=0;
	word i;
	PKT *pkt;
	extern PKT *pktstart_addr;

	for(i=0;i<NumberOfSonicPort; i++)
	plst |= 1<<i;
	pkt = pktstart_addr;
	for(i=0; i<255;i++)
	{
	pkt->pktUseCount &= ~PKTINXMT;
	if(pkt->pktXmtPort)
	{
		pkt->pktXmtPort &= ~plst;
		pkt->pktUseCount &= ~PKTINXMT;
		if(! pkt->pktXmtPort)
			pkt->pktFree(pkt);
		else
			enter_debug(0x3131,pkt,pkt->pktXmtPort,plst);
	}	
	else
	{
	if(pkt->pktUseCount)
	pkt->pktFree(pkt);
	}
	pkt++;
	}
}
