/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file defines the MIB tree for RFC1286-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBPRSE.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
                                                                           
 *************************************************************************/

#include <asn1.h>
#include <priv_tbl.h> 
#include <snmp.h>
#include <mib.h>
#include <libfuncs.h>
#include <syteksnm.h>
#include <rfc1286.h>


static MIBLEAF_T dot1dBaseBridgeAddress_leaf = LEAF( VT_STRING,RO,49,svc_dot1dBaseBridgeAddress );

static MIBLEAF_T dot1dBaseNumPorts_leaf = LEAF( VT_NUMBER,RO,49,svc_dot1dBaseNumPorts );

static MIBLEAF_T dot1dBaseType_leaf = LEAF( VT_NUMBER,RO,49,svc_dot1dBaseType );

static MIBLEAF_T dot1dBasePort_leaf = LEAF( VT_NUMBER,RO,49,svc_dot1dBasePort );

static MIBLEAF_T dot1dBasePortIfIndex_leaf = LEAF( VT_NUMBER,RO,49,svc_dot1dBasePortIfIndex );

static MIBLEAF_T dot1dBasePortCircuit_leaf = LEAF( VT_OBJECT,RO,49,svc_dot1dBasePortCircuit );

static MIBLEAF_T dot1dBasePortDelayExceededDiscards_leaf = LEAF( VT_COUNTER,RO,49,svc_dot1dBasePortDelayExceededDiscards );

static MIBLEAF_T dot1dBasePortMtuExceededDiscards_leaf = LEAF( VT_COUNTER,RO,49,svc_dot1dBasePortMtuExceededDiscards );

static MIBARC_T dot1dBasePortEntry_arcs[] = { 
				ARC(1,dot1dBasePort_leaf),
				ARC(2,dot1dBasePortIfIndex_leaf),
				ARC(3,dot1dBasePortCircuit_leaf),
				ARC(4,dot1dBasePortDelayExceededDiscards_leaf),
				ARC(5,dot1dBasePortMtuExceededDiscards_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T dot1dBasePortEntry_node = NODE (dot1dBasePortEntry_arcs);

static MIBARC_T dot1dBasePortTable_arcs[] = { 
				ARC(1,dot1dBasePortEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T dot1dBasePortTable_node = NODE (dot1dBasePortTable_arcs);

static MIBLEAF_T dot1dStpProtocolSpecification_leaf = LEAF( VT_NUMBER,RO,49,svc_dot1dStpProtocolSpecification );

static MIBLEAF_T dot1dStpPriority_leaf = LEAF( VT_NUMBER,RW,49,svc_dot1dStpPriority );

static MIBLEAF_T dot1dStpTimeSinceTopologyChange_leaf = LEAF( VT_TIMETICKS,RO,49,svc_dot1dStpTimeSinceTopologyChange );

static MIBLEAF_T dot1dStpTopChanges_leaf = LEAF( VT_COUNTER,RO,49,svc_dot1dStpTopChanges );

static MIBLEAF_T dot1dStpDesignatedRoot_leaf = LEAF( VT_STRING,RO,49,svc_dot1dStpDesignatedRoot );

static MIBLEAF_T dot1dStpRootCost_leaf = LEAF( VT_NUMBER,RO,49,svc_dot1dStpRootCost );

static MIBLEAF_T dot1dStpRootPort_leaf = LEAF( VT_NUMBER,RO,49,svc_dot1dStpRootPort );

static MIBLEAF_T dot1dStpMaxAge_leaf = LEAF( VT_NUMBER,RO,49,svc_dot1dStpMaxAge );

static MIBLEAF_T dot1dStpHelloTime_leaf = LEAF( VT_NUMBER,RO,49,svc_dot1dStpHelloTime );

static MIBLEAF_T dot1dStpHoldTime_leaf = LEAF( VT_NUMBER,RO,49,svc_dot1dStpHoldTime );

static MIBLEAF_T dot1dStpForwardDelay_leaf = LEAF( VT_NUMBER,RO,49,svc_dot1dStpForwardDelay );

static MIBLEAF_T dot1dStpBridgeMaxAge_leaf = LEAF( VT_NUMBER,RW,49,svc_dot1dStpBridgeMaxAge );

static MIBLEAF_T dot1dStpBridgeHelloTime_leaf = LEAF( VT_NUMBER,RW,49,svc_dot1dStpBridgeHelloTime );

static MIBLEAF_T dot1dStpBridgeForwardDelay_leaf = LEAF( VT_NUMBER,RW,49,svc_dot1dStpBridgeForwardDelay );

static MIBLEAF_T dot1dStpPort_leaf = LEAF( VT_NUMBER,RO,49,svc_dot1dStpPort );

static MIBLEAF_T dot1dStpPortPriority_leaf = LEAF( VT_NUMBER,RW,49,svc_dot1dStpPortPriority );

static MIBLEAF_T dot1dStpPortState_leaf = LEAF( VT_NUMBER,RO,49,svc_dot1dStpPortState );

static MIBLEAF_T dot1dStpPortEnable_leaf = LEAF( VT_NUMBER,RW,49,svc_dot1dStpPortEnable );

static MIBLEAF_T dot1dStpPortPathCost_leaf = LEAF( VT_NUMBER,RW,49,svc_dot1dStpPortPathCost );

static MIBLEAF_T dot1dStpPortDesignatedRoot_leaf = LEAF( VT_STRING,RO,49,svc_dot1dStpPortDesignatedRoot );

static MIBLEAF_T dot1dStpPortDesignatedCost_leaf = LEAF( VT_NUMBER,RO,49,svc_dot1dStpPortDesignatedCost );

static MIBLEAF_T dot1dStpPortDesignatedBridge_leaf = LEAF( VT_STRING,RO,49,svc_dot1dStpPortDesignatedBridge );

static MIBLEAF_T dot1dStpPortDesignatedPort_leaf = LEAF( VT_STRING,RO,49,svc_dot1dStpPortDesignatedPort );

static MIBLEAF_T dot1dStpPortForwardTransitions_leaf = LEAF( VT_COUNTER,RO,49,svc_dot1dStpPortForwardTransitions );

static MIBARC_T dot1dStpPortEntry_arcs[] = { 
				ARC(1,dot1dStpPort_leaf),
				ARC(2,dot1dStpPortPriority_leaf),
				ARC(3,dot1dStpPortState_leaf),
				ARC(4,dot1dStpPortEnable_leaf),
				ARC(5,dot1dStpPortPathCost_leaf),
				ARC(6,dot1dStpPortDesignatedRoot_leaf),
				ARC(7,dot1dStpPortDesignatedCost_leaf),
				ARC(8,dot1dStpPortDesignatedBridge_leaf),
				ARC(9,dot1dStpPortDesignatedPort_leaf),
				ARC(10,dot1dStpPortForwardTransitions_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T dot1dStpPortEntry_node = NODE (dot1dStpPortEntry_arcs);

static MIBARC_T dot1dStpPortTable_arcs[] = { 
				ARC(1,dot1dStpPortEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T dot1dStpPortTable_node = NODE (dot1dStpPortTable_arcs);

static MIBARC_T dot1dStp_arcs[] = { 
				ARC(1,dot1dStpProtocolSpecification_leaf),
				ARC(2,dot1dStpPriority_leaf),
				ARC(3,dot1dStpTimeSinceTopologyChange_leaf),
				ARC(4,dot1dStpTopChanges_leaf),
				ARC(5,dot1dStpDesignatedRoot_leaf),
				ARC(6,dot1dStpRootCost_leaf),
				ARC(7,dot1dStpRootPort_leaf),
				ARC(8,dot1dStpMaxAge_leaf),
				ARC(9,dot1dStpHelloTime_leaf),
				ARC(10,dot1dStpHoldTime_leaf),
				ARC(11,dot1dStpForwardDelay_leaf),
				ARC(12,dot1dStpBridgeMaxAge_leaf),
				ARC(13,dot1dStpBridgeHelloTime_leaf),
				ARC(14,dot1dStpBridgeForwardDelay_leaf),
				ARC(15,dot1dStpPortTable_node),
			END_OF_ARC_LIST};

static MIBNODE_T dot1dStp_node = NODE (dot1dStp_arcs);

static MIBARC_T dot1dBase_arcs[] = { 
				ARC(1,dot1dBaseBridgeAddress_leaf),
				ARC(2,dot1dBaseNumPorts_leaf),
				ARC(3,dot1dBaseType_leaf),
				ARC(4,dot1dBasePortTable_node),
			END_OF_ARC_LIST};

static MIBNODE_T dot1dBase_node = NODE (dot1dBase_arcs);

static MIBARC_T dot1dBridge_arcs[] = { 
				ARC(1,dot1dBase_node),
				ARC(2,dot1dStp_node),
			END_OF_ARC_LIST};

       MIBNODE_T dot1dBridge_node = NODE (dot1dBridge_arcs);

