/**
 *	Program Name:	nim960 bridge
 *
 *	Filename:	snmpbr.c
 *
 *	$Log:   /b/gregs/bridge/snmp/routines/snmpbr.c_v  $
 * 
 *    Rev 1.2   26 Oct 1993 17:22:50   vinay
 * fixed the traps disabling problem in GetSnmpMgr()
 * .
 * 
 *    Rev 1.1   19 Aug 1993 15:14:22   vinay
 * changed the product id to 171014
 * 
 *    Rev 1.0   20 Jul 1993 09:37:14   franks
 * Initial revision.
 * 
 *    Rev 1.4   18 May 1992 09:58:12   franks
 * 1). Fixed bug in Handle_reset so that a software crash is not logged when
 *     a snmp reset is performed.
 * 
 *    Rev 1.3   11 May 1992 10:52:52   kwok
 * calling the function "reset" rather than "jmp_reset" to reset the module.
 * 
 *    Rev 1.2   11 May 1992 09:29:12   franks
 * No change.
 * 
 *    Rev 1.1   10 Apr 1992 16:50:48   kwok
 * Adding SysObjectID support.1.3.6.1.4.1.26.28.1.70.171003 for stanley.
 * 
 *    Rev 1.0   30 Mar 1992 17:37:42   pvcs
 * Initial revision.
 *
 *	Comment:	This file contains modules for SNMP on the bridge 
 *
 *	Copyright (c) 1992 by Hughes LAN Systems.
 **/

#include <types.h> 
#include <target.h>
#include <krnl.h>
#include <bitmask.h>
#include <bridges.h>
#include <snmp.h>
#include <asn1.h>
#include <syteksnm.h>
#include <nvrecs.h>
#include <nim960h.h>

extern	int	NumberOfSonicPort;
extern	NIM960_HDR	Nim960Header;
extern	SaveBStatus();

/**********************************************************************
 *
 * Define the various SNMP management variables used in this system.
 *
 * This file should closely match snmpvars.h
 *
 **********************************************************************/
char		snmp_get_request_community[CSIZE] = "public";

char		snmp_set_request_community[CSIZE] = "private";


unsigned int   snmp_product_id[] = {
	/* ISO */			1,
	/* ORG */			3,
	/* DOD */			6,
	/* INTERNET */		        1,
	/* PRIVATE */		        4,
	/* ENTERPRISES */	        1,
	/* SYTEK */		       26,
	/* Admin  */			28,
	/* DOC control*/		1,
	/* HLS Specification */		70,
	/* 836 is this	*/		171014};

int	snmp_product_id_count =
		sizeof(snmp_product_id)/sizeof(unsigned int);



unsigned int   dot3MibObjectId[] = {
	/* ISO */			1,
	/* ORG */			3,
	/* DOD */			6,
	/* INTERNET */		        1,
	/* MGMT */		        2,
	/* MIB-2 */	        	1,
	/* transmission */		10,
	/* dot3  */			7};
		

unsigned int   fddiObjectId[] = {
	/* ISO */			1,
	/* ORG */			3,
	/* DOD */			6,
	/* INTERNET */		        1,
	/* MGMT */		        2,
	/* MIB-2 */	        	1,
	/* transmission */		10,
	/* fddi  */			15};

unsigned int   adminBusObjectId[] = {
	/* ISO */			1,
	/* ORG */			3,
	/* DOD */			6,
	/* INTERNET */		        1,
	/* PRIVATE */		        4,
	/* ENTERPRISES */	        1,
	/* SYTEK */		       26,
	/* adminBus	*/		29};

/*********************************************************************
**
**      GET_USER ROUTINE
**
*********************************************************************/
int
get_user(userp,pswd_key,len,priv)
char  *userp;
byte  *pswd_key;
int len;
int *priv;
{
	int index;

	*priv = 0;
	memset((byte  *)pswd_key,0,8);
	if(strncmp(userp,"master",6) == 0)
	{
		strcpy(pswd_key, BridgeStatus->SNMPPassword);;
		*priv = 0xf;
		return TRUE;
	}
	return FALSE;
}
/*********************************************************************
**
**      SNMP_ACCESS ROUTINE
**
*********************************************************************/
int
snmp_access()
{
	return  BridgeStatus->SNMPAuthentication;	
}


/*
 *	Returns a pointer to the ADM structure
 */
void *
get_adm(int size)
{
	return((void *)lmalloc(size));
}

/*
 *	Handle the Server Reset
 */
HandleReset(fromIP)
in_name	fromIP;
{
	int	ticks = RealTimeTicks();
        extern  APPL apl;

	/*
	 *	Wait for 2 seconds such that all warning messages
	 *	can be printed out before it resets itself.
	 */
	while (RealTimeTicks() - ticks < 200)
		{
		if (IsTelnetActive())
			{
			CloseTelnet();
			break;
			}
		ReSchedule();
		}
        apl.run_appl = APPL_RESET;
	reset();

}

/*
 *	Returns the Interface description
 */
get_ifdescr(lenp,value)
int	*lenp;
OCTET_P	value;
{
	strcpy(value, "802.3 - Ethernet");
	*lenp = strlen(value);
}

/*
 *	Returns the Media Type
 */
GetIfType()
{
	return 6;
}

/*
 *	Returns the Speed of the Physical Media
 */
get_ifspeed(value)
UINT_32_T	*value;
{
	*value = ETHER10M;
}

/*
 *	Returns the Physical Address of the Interface
 */
get_ifaddr(lenp,value)
int	*lenp;
OCTET_P	value;
{
	ncopy(value, MyNid(0));
	*lenp = 6;
}

/*
 *	Returns the System Description
 */
get_sysdescr(lenp,value)
int	*lenp;
OCTET_P	value;
{
	strcpy(value, BridgeStatus->Name);
	*lenp = strlen( BridgeStatus->Name);
}

/*
 *	Set/Return the Contact Address string for the System.
 *	If the flag value is non-zero Set the Contact string
 *	else return the Contact string
 */
gs_syscontact(lenp,value,flag)
int  *lenp;
OCTET_P value;
int		flag;
{

	if(flag)
	{
		/*
		 *	Set system contact
		 */
		memset(BridgeStatus->Contact, 0, 60);;
		memcpy((POINTER)BridgeStatus->Contact, (OCTET_P)value, *lenp);
		SaveBStatus();
	}
	else
	{
		*lenp = strlen(BridgeStatus->Contact);
		memcpy((OCTET_P)value, (POINTER)BridgeStatus->Contact, *lenp);
	}
}

/*
 *	Set/Return the System Name.
 *	If the flag value is non-zero, Set the the System Name
 *	else return the System Name
 */
gs_sysname(lenp,value,flag)
int  *lenp;
OCTET_P value;
int		flag;
{

	if(flag)
	{
		/*	set	*/
		memset(BridgeStatus->Name, 0, 60);
		memcpy((POINTER)BridgeStatus->Name, (OCTET_P)value, *lenp);
		SaveBStatus();
	}
	else
	{
		*lenp = strlen(BridgeStatus->Name);
		memcpy((OCTET_P)value, (POINTER)BridgeStatus->Name, *lenp);
	}
}

/*
 *	Return a string which identifies the System Location
 */
gs_syslocation(lenp,value,flag)
int  *lenp;
OCTET_P value;
int	flag;
{
	if(flag)
	{
		/*	set	*/
		memcpy(BridgeStatus->Location, value, *lenp);
		SaveBStatus();
	}
	else
	{
		*lenp = strlen(BridgeStatus->Location);
		memcpy((OCTET_P)value, (POINTER)BridgeStatus->Location, *lenp);
	}
}

/*
 *	return the system services
 */

get_sysservices()
	{
	return (2 + 8);	/* bridge + ip hosta	*/
	}

get_ifSpecific(uint index, uint *value, int *length)

	{
	if (index <= NumberOfSonicPort)
		{
		/*
		 *	These ports are ethernets.
		 */
		memcpy(value, dot3MibObjectId, sizeof(dot3MibObjectId));
		*length = sizeof(dot3MibObjectId);
		}
	else if (index == NumberOfSonicPort + 1) /* FDDI PORT */
		{
		/*
		 *	This is admin bus and there is no
		 *	object id yets!
		 */
		memcpy(value, fddiObjectId, sizeof(fddiObjectId));
		*length = sizeof(fddiObjectId);
		}
	else
		{
		memcpy(value, adminBusObjectId, sizeof(adminBusObjectId));
		*length = sizeof(adminBusObjectId);
		}
	}
/*
 *   	startup_alarm()
 *	Send Start up Alarm
 */
startup_alarm()
{
	int	BootType = WARM_START;	

	if (nvr_sys.nvr_reset != 0xff)
		{
		/*
		 *	If not software reset,
		 *	then this is cold boot
		 */
		BootType = COLD_START;
		}
	generic_trap(BootType);
	
}

CheckPrivilege(windx,priv)
int	windx;
int	priv;
{
	return TRUE;
}

find_pr_code()
{
	return 0;
}

void *
get_tag(int size)
{
	static	void	*tagpointer = 0;

	if(tagpointer)
		return tagpointer;
	return(tagpointer = (void *)lmalloc(size));
}

free_tag()
{
}

init_adm(bp,size)
byte	*bp;
int	size;
{
	memset(bp,0,size);
}

verify_community(char *community)
{
	char	password[MAXPSWD + 1];	/* password is the community */
	char	*p = password;

	if (strlen(community) > MAXPSWD)
		return -1;
	while(*community != 0)
		*p++ = ~*community++;
	*p = '\0';
	if (strcmp(password, BridgeStatus->ConsolePassword) != 0)
		return -1;
	return 0;
}

gs_snmpauthtrap(int value, int flag)
{
}

SetRouterAddr(in_name ipaddr)
{
}

GetSnmpMgr(in_name *mgr1, in_name *mgr2, int TrapType, int TrapNo)
{
	*mgr1 = *mgr2 = 0;
	if (BridgeStatus->SnmpMgr[0] != 0)
		{
		if (TrapType == GENERIC_TRAP)
			{
			if (BridgeStatus->GenericTrap[0] & (1 << TrapNo))
				*mgr1 = BridgeStatus->SnmpMgr[0];
			}
		else
			{
			if (BridgeStatus->SpecificTrap[0] & (1 << TrapNo))
				*mgr1 = BridgeStatus->SnmpMgr[0];
			}
		}
	if (BridgeStatus->SnmpMgr[1] != 0)
		{
		if (TrapType == GENERIC_TRAP)
			{
			if (BridgeStatus->GenericTrap[1] & (1 << TrapNo))
				*mgr2 = BridgeStatus->SnmpMgr[1];
			}
		else
			{
			if (BridgeStatus->SpecificTrap[1] & (1 << TrapNo))
				*mgr2 = BridgeStatus->SnmpMgr[1];
			}
		}
}

/****************************************************************************
**
**   CHK_IFINDEX ROUTINE
**
**   Check the instance of a tabular object which is indexed by if number.
**
**   Return: 0:            If instance count 1 and instance value is between
**                         1 and NumberofSoincPort + 1.
**           NO_SUCH_NAME: All other conditions.
**
****************************************************************************/


chk_ifindex(int inst_len, uint index)

	{
	if (inst_len != 1 || index < 1 || index > (NumberOfSonicPort + 2))
		return NO_SUCH_NAME;
	return 0;
	}


/****************************************************************************
**
**   GET_NXTIFIDX ROUTINE
**
**   Increment the instance of a tabular object which is indexed
**   by if number.
**
**   Return: 0:            If instance count 1 and instance value is between
**                         1 and NumberofSoincPort + 1.
**           NO_SUCH_NAME: All other conditions.
**
****************************************************************************/

get_nxtifindex( uint *inst_len, uint *index, int retval )

	{
	if (*inst_len == 0)
		{
		*inst_len = 1;
		*index = 1;
		}
	else if ((retval != 0 ) || ((++(*index)) > (NumberOfSonicPort + 2)))
		return(ERR_INSTANCE);
	return(0);
	}
