/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file contains the service routines for FOURPORTETHERNETBRIDGE-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBSVC.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
                                                                           
 *************************************************************************/

#define FOURPORTETHERNETBRIDGE-MIB_SVC

#include <types.h> 
#include <target.h>
#include <krnl.h>
#include <dbd.h>
#include <snmp.h>
#include <asn1.h>
#include <syteksnm.h>
#include <prcctl.h>

/* Additional include files */
#include <bridges.h>
#include <prcadr.h>
#include <nvrecs.h>
#include "834CmdSnmp.h"
#include <sncvar.h>

/* Global Definintions */
uint MODEL = NIM960_834;
int FilterTableEntries = 0;
int NvFilterTabEntries = 0;

/* External Definitions */
extern NVR_NID_RECS *NvramNids;
extern NVR_BSTATUS  *BridgeStatus;
extern PRCCTL       prc;
extern TIMER        SortTblTimer; 
extern ADR          *NidSortAry;
extern ADR          *NvFilterTab;
extern SV           sv_var[];

extern PRCCTL *prcctl;
extern InvalidTbl(uint *);


/**************************************************************************
*  Procedure    :   svc_ramAddrTab834Entry
*  Path         :   1.3.6.1.4.1.26.2.24.1.1
*  Access       :   RW
*  Syntax       :   OCTET VT_STRING
*  Description  :   
*                          "An instance of this object-type exists for each
*                          entry in the RAM-resident Address Table in a HLS
*                          4 port ethernet/ethernet Bridge.  The format of 
*                          the OCTET STRING is:
*  
*                          1st octet:  1 = Static flag set
*                                      0 = Static flag not set
*  
*                          2nd octet:  1 = Restrict Outbound flag port 1 set
*                                      0 = Restrict Outbound flag port 1 
*                                          not set
*  
*                          3rd octet:  1 = Restrict Outbound flag port 2 set
*                                      0 = Restrict Outbound flag port 2
*                                          not set
*  
*                          4th octet:  1 = Restrict Outbound flag port 3 set
*                                      0 = Restrict Outbound flag port 3 
*                                          not set
*  
*                          5th octet:  1 = Restrict Outbound flag port 4 set
*                                      0 = Restrict Outbound flag port 4 
*                                          not set
*  
*                          6th octet:  1 = Restrict Inbound Uni-Cast flag set
*                                      0 = Restrict Inbound Uni-Cast flag 
*                                          not set
*  
*                          7th octet:  1 = Rstrict Inbound Multi-Cast flag set
*                                      0 = Restrict Inbound Multi-Cast flag
*                                          not set
*  
*                          8th octet:  0 = Local bridge address
*                                      1 = Address on Channel 1
*                                      2 = Address on Channel 2
*                                      3 = Address on Channel 3
*                                      4 = Address on Channel 4
*  
*                          Setting an instance of this object-type to a value
*                          of ASN.1 type NULL, causes the identified entry in
*                          the RAM-resident Address Table to be deleted."
*
**************************************************************************/

int svc_ramAddrTab834Entry(service, compc, compl, lenp, value, index)
unsigned int service;
byte         *compc;
unsigned int *compl;
int          *lenp;
UINT_32_T    *value;
int          index;
{
    register int retval = 0;
    uint i;
    uint *temp  = compl;
    char *temp1 = (char *)value;
	uint hash;
    char MacAddr[6];
    ADR  *AdrRec;
	ADR  *NewAdrNode;
    ADR  AdrRec2;
    char valbuf[8];
    RECORDMASK FilterMask;
    FILTERREC DummyRec;
    static int NumEntries;
    static uint FirstTime  = TRUE;
    static uint nextEntry  = 0;

    memset(MacAddr, NULL, sizeof(MacAddr));
    for( i = 0; i < *compc; i++ ) {
         MacAddr[i] = *temp++;
    }

    switch(service)
    {
        case SNMP_TEST:
            if(*compc != 6 || *lenp != 8) 
                return(retval = NO_SUCH_NAME);
            break;

        case SNMP_GETNXT:
			/* 
			printf("\ncompc: %d\n", *compc);
			 
            if(*compc != 0) 
                return(retval = NO_SUCH_NAME);
           */ 
            /* Pad address with 0's if necessary. */
            for( i = *compc; i < 6; i++)
                MacAddr[i] = 0;
            *compc = 6;

			/* 
			for( i = 0; i < 6; i++)
			    printf("MacAddr: %d\n", MacAddr[i]);
            */
            /* was smaller, now=6; if bigger than 6, drop off excess
               bytes. The reason we can drop off bytes is the extra
               bytes act like a decimal point for an integer. Since
               we are working with whole address ( and add 1, next
               sub call) we can in essence drop the decimal or 
               fraction part.
            */
                
            /* If this is the first get-next of a series then, 
               build a table of addresses that match the get-next
               specifier and sort the table.
            */

                
            if( FirstTime == TRUE ) {

                NumEntries = 0;
                StopLearning();
                NumEntries = BuildNidTbl( NidSortAry , MacAddr, RAM);
                SortNidTbl( NidSortAry, 0, NumEntries-1 );  
                StartLearning();
                nextEntry = 0;
                FirstTime = FALSE;
            }
            /*  PrintTbl( NidSortAry , NumEntries);  */
      

            /* If there were no matching entries */
            if( (NumEntries < 1) || (NumEntries <= nextEntry) ) {
                FirstTime = TRUE;
                return(NO_SUCH_NAME);
            }

            StartTimerCall( &SortTblTimer, 2000, InvalidTbl, &FirstTime);
            temp = compl;
            if( GetEntry( NidSortAry, valbuf, temp, &nextEntry, NumEntries)) {
                FirstTime = TRUE;
                return(NO_SUCH_NAME);
            }
            nextEntry++;

            /* Return the value of the address record flags */
            memcpy( value, valbuf, 8);
            *lenp = 8;

            return(0);
            
        case SNMP_GET:  

            /* must = 6 for a get, only have a MAC adr */
            if( *compc != 6 || *compl != 0 )
                return(retval = NO_SUCH_NAME);

           memcpy(&(AdrRec2.adr_low), MacAddr, 6);

           /* Will Find the address record if it             */
           /* exists and copy record information into AdrRec */
           if( FindNid(&AdrRec2, &AdrRec) )
               return(NO_SUCH_NAME);

           /* Convert addr rec info to octet string */
           AdrFlg2Octet(AdrRec, valbuf); 

           /* Return info */
           memcpy(value, valbuf, 8);
           *lenp = 8;

            break;

        case SNMP_SET:
            if(*compc != 6 || *lenp != 8) 
                return(retval = NO_SUCH_NAME);

           memcpy(&(AdrRec2.adr_low), MacAddr, 6);

           /* if the address already exists and value is null then the record */
		   /* will be deleted. Otherwise the flags will be modified.          */
           if( FindNid(&AdrRec2, &AdrRec)  == NULL ) {

               /* If value is null, delete the address */
               memset(valbuf, NULL, 8);
               if(memcmp(temp1, valbuf, 8) == 0) {
                   DeleteNid(AdrRec, &i);
               }
                   /* If valid flag information, modify the address record */
               else
               if( Octet2Filter(&DummyRec, temp1, &FilterMask) )
                   return(BADVAL);

               else
               if((FilterMask.PortMask != PORT1 ) ||
                  (FilterMask.PortMask != PORT2 ) ||
                  (FilterMask.PortMask != PORT3 ) ||
                  (FilterMask.PortMask != PORT4 )) {
                      return(BADVAL);
               }
               else 
                   SNMPSetAdrFlags(AdrRec, &FilterMask);
			}
            /* Otherwise if the address is not already in the address table */
			/* add the address with the appropriate flags.                  */
			else {
		       
			   /* Get the hash value */
			   hash = HashNid(&AdrRec2.adr_low);
               StopLearning();
			   /* Get a new address node for this address */
			   NewAdrNode = prc_get_addr();
			   if( NewAdrNode == (ADR *)NULL ) {
				   StartLearning();
				   return(BADVAL);
			   }

			   /* Check flag information */
               if( Octet2Filter(&DummyRec, temp1, &FilterMask) ) {
				   prc_put_addr( NewAdrNode );
				   StartLearning();
                   return(BADVAL);
               }

			   /* Check flag information */
               else
               if((FilterMask.PortMask != PORT1 ) ||
                  (FilterMask.PortMask != PORT2 ) ||
                  (FilterMask.PortMask != PORT3 ) ||
                  (FilterMask.PortMask != PORT4 )) {
				      prc_put_addr( NewAdrNode );
					  StartLearning();
                      return(BADVAL);
               }
			   /* Finish adding address and flag information  */
               else  {
                   SNMPSetAdrFlags(AdrRec, &FilterMask);
				   SetInUse( NewAdrNode );
				   memcpy(&NewAdrNode->adr_low, &AdrRec2.adr_low, 6);
				   AddToHashTbl( hash, NewAdrNode );
			   }
		       StartLearning();
	        }

            break;
       
        default:
            retval = NO_SUCH_NAME;
            break;
    }       /* end of main switch */
    return(retval);
}  /* end of svc_ramAddrTab834Entry */

/**************************************************************************
*  Procedure    :   svc_ramAddrTab834Filter
*  Path         :   1.3.6.1.4.1.26.2.24.2
*  Access       :   RW
*  Syntax       :   OCTET VT_STRING
*  Description  :   
*                          "Setting this value causes the re-creation of
*                          the filtered subset (see the object
*                          ramAddrTab834FilterEntry) of the RAM-resident
*                          Address Table in a HLS 834 Bridge.  The filtered
*                          subset consists of all entries which matched the
*                          filter value at the time of the last write to
*                          this object.  The format of the OCTET STRING is:
*  
*                    1st octet:  0 = must not have Static flag set
*                                1 = must have Static flag set
*  
*                    2nd octet:  0 = must not have Restrict Outbound flag set
*                                    on port 1 
*                                1 = must have Restrict Outbound flag set 
*                                    on port 1 
*                                
*                    3rd octet:  0 = must not have Restrict Outbound flag set
*                                    on port 2 
*                                1 = must have Restrict Outbound flag set 
*                                    on port 2 
*  
*                    4th octet:  0 = must not have Restrict Outbound flag set
*                                    on port 3 
*                                1 = must have Restrict Outbound flag set 
*                                    on port 3 
*  
*                    5th octet:  0 = must not have Restrict Outbound flag set
*                                    on port 4 
*                                1 = must have Restrict Outbound flag set 
*                                    on port 4 
*  
*                    6th octet:  0 = must not have Restrict Inbound Multi-
*                                    cast flag set
*                                1 = must have Restrict Inbound Multi-cast
*                                    flag set
*  
*                    7th octet:  0 = must not have Restrict Inbound Multi-
*                                    cast flag set
*                                1 = must have Restrict Inbound Multi-cast
*                                    flag set
*  
*                    8th octet:  0 = Address must be on channel 1 
*                                1 = Address must not be on channel 1
*                    
*                    9th octet:  0 = Address must be on channel 2 
*                                1 = Address must not be on channel 2
*                    
*                    10th octet: 0 = Address must be on channel 3 
*                                1 = Address must not be on channel 3
*                    
*                    11th octet: 0 = Address must be on channel 4 
*                                1 = Address must not be on channel 4
*                    
*
**************************************************************************/

int svc_ramAddrTab834Filter(service, compc, compl, lenp, value, index)
unsigned int service;
byte         *compc;
unsigned int *compl;
int          *lenp;
UINT_32_T    *value;
int          index;
{

    uint             i;
    register int     retval = 0;
    char             *temp = (char *)value;
    int             NumEntries;
    RECORDMASK       FilterMask;
    static FILTERREC AdrFilterRec = {0};


    switch(service)
    {
        
        case SNMP_TEST:
            
            if(*compc != 1 || *compl != 0 ) 
                return(retval = NO_SUCH_NAME);
            break;
            
        case SNMP_GETNXT:
            if(*compc != 0) 
                return(retval = NO_SUCH_NAME);
        
            *compc = 1;
            *compl     = 0;
            
            /* fall through to GET */
            
        case SNMP_GET:  

            if( *compc != 1 || *compl != 0 )
                return(retval = NO_SUCH_NAME);

            Filter2Octet(&AdrFilterRec, temp);
            *lenp = 11;
            break;

        case SNMP_SET:
            
            if( *compc != 1 || *compl != 0  || *lenp != 11 )
                return(retval = NO_SUCH_NAME);
            
            if( Octet2Filter(&AdrFilterRec, temp, &FilterMask) )
                return(BADVAL);
            
            FilterTableEntries = BuildFilterTbl(NidSortAry, &FilterMask);
            SortNidTbl( NidSortAry, 0, FilterTableEntries-1 );  
            /* PrintTbl( NidSortAry , NumEntries);  */
            break;
            return(retval);

        
        default:
            retval = NO_SUCH_NAME;
            break;

    }       /* end of main switch */
    return(retval);
}  /* end of svc_ramAddrTab834Filter */



/**************************************************************************
*  Procedure    :   svc_ramAddrTab834FilterNum
*  Path         :   1.3.6.1.4.1.26.2.24.3
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                          "The current number of entries in the filtered
*                          subset of entries in the RAM-resident Address
*                          Table in a HLS 80xx Bridge.  The filtered subset
*                          consists of allentries which matched the filter
*                          value at the time ofthe last write to the object:
*                          ramAddrTab834Filter."
*
**************************************************************************/

int svc_ramAddrTab834FilterNum(service, compc, compl, lenp, value, index)
unsigned int service;
byte         *compc;
unsigned int *compl;
int          *lenp;
UINT_32_T    *value;
int          index;
{
    register int     retval = 0;
    switch(service)
    {
        
        case SNMP_TEST:
            
            return(retval = NO_SUCH_NAME);
            
        case SNMP_GETNXT:
            if(*compc != 0) 
                return(retval = NO_SUCH_NAME);
        
            *compc = 1;
            *compl     = 0;
            
            /* fall through to GET */
            
        case SNMP_GET:  

            if( *compc != 1 || *compl != 0 )
                return(retval = NO_SUCH_NAME);

            *(uint *)value = FilterTableEntries;
            break;

        default:
            retval = NO_SUCH_NAME;
            break;

    }       /* end of main switch */
    return(retval);
}  /* end of svc_ramAddrTab834FilterNum */


/**************************************************************************
*  Procedure    :   svc_ramAddrTab834FilterEntry
*  Path         :   1.3.6.1.4.1.26.2.24.4.1
*  Access       :   RO
*  Syntax       :   OCTET VT_STRING
*  Description  :   
*                          "An instance of this object-type exists for each
*                          entry in the filtered subset of entries in the
*                          RAM-resident Address Table in a HLS 4 Port 
*                          Ethernet/Ethernet Bridge. The filtered subset 
*                          consists of a copy of those entries in 
*                          ramAddrTab834Tab which matched the filter value
*                          at the time of the last write to the object: 
*                          ramAddrTab834Filter.  The format of the
*                          OCTET STRING is:
*  
*                          octets 1-6:  the MAC address of this entry
*  
*                          7th octet:  1 = Static flag set
*                                      0 = Static flag not set
*  
*                          8th octet:  1 = Restrict Outbound flag port 1 set
*                                      0 = Restrict Outbound flag port 1 
*                                          not set
*  
*                          9th octet:  1 = Restrict Outbound flag port 2 set
*                                      0 = Restrict Outbound flag port 2
*                                          not set
*  
*                          10th octet: 1 = Restrict Outbound flag port 3 set
*                                      0 = Restrict Outbound flag port 3 
*                                          not set
*  
*                          11th octet: 1 = Restrict Outbound flag port 4 set
*                                      0 = Restrict Outbound flag port 4 
*                                          not set
*  
*                          12th octet: 1 = Restrict Inbound Uni-Cast flag set
*                                      0 = Restrict Inbound Uni-Cast flag 
*                                          not set
*  
*                          13th octet: 1 = Rstrict Inbound Multi-Cast flag set
*                                      0 = Restrict Inbound Multi-Cast flag
*                                          not set
*  
*                          14th octet: 0 = Local bridge address
*                                      1 = Address on Channel 1
*                                      2 = Address on Channel 2
*                                      3 = Address on Channel 3
*                                      4 = Address on Channel 4
*  
*
**************************************************************************/

int svc_ramAddrTab834FilterEntry(service, compc, compl, lenp, value, index)
unsigned int service;
byte         *compc;
unsigned int *compl;
int          *lenp;
UINT_32_T    *value;
int          index;
{

    register int retval = 0;
    ADR  *AdrRec;
    ADR  *NidTbl;
	int  indx;
    char valbuf[14];
    uint NumEntries = FilterTableEntries;

    switch(service)
    {
        case SNMP_TEST:
                return(retval = NO_SUCH_NAME);

        case SNMP_GETNXT:
            get_nxtportidx((int *)compc,
                    (unsigned int *)compl, retval);

            /* If there were no matching entries */
            if( (NumEntries < 1) || (NumEntries <= *compl) ) {
                return(NO_SUCH_NAME);
            }
            
			indx = (*compl) - 1;
            if( GetFilterEntry( NidSortAry, valbuf, &indx, NumEntries)) {
                return(NO_SUCH_NAME);
            }
            *compl = indx+1;

            /* Return the value of the address record flags */
            memcpy( value, valbuf, 14);
            *lenp = 14;

            return(0);

        case SNMP_GET:  

            if((*compl < 1) || (*compl > NumEntries) ) 
                return(NO_SUCH_NAME);
           
			indx = (*compl) - 1;
			/*
			printf("\nIndex: %d", indx);
             Get a single entry from the sorted address filter table 
			PrintNid((NID *)&(NidSortAry[indx].adr_low));
            memcpy(value, (char *)&(NidSortAry[indx].adr_low), 6);
            AdrFlg2Octet(&NidSortAry[indx], &value[6]);
		    */	
            GetSingleFilterEntry( NidSortAry, valbuf, &indx );

            /* Return the value of the address record flags */
            memcpy( value, valbuf, 14);
            *lenp = 14;
            return(0);

        default:
            retval = NO_SUCH_NAME;
            break;
    }       /* end of main switch */
    return(retval);
}  /* end of svc_ramAddrTab834FilterEntry */


/**************************************************************************
*  Procedure    :   svc_ramAddrTab834Delete
*  Path         :   1.3.6.1.4.1.26.2.24.5
*  Access       :   WO
*  Syntax       :   OCTET VT_STRING
*  Description  :   
*                          "Setting this object to a value causes the
*                          immediate deletion of a subset of the entries in
*                          the RAM-resident Address Table in a HLS 834
*                          Bridge.  The subset of entries to be deleted is
*                          selected by using the value (to which this object
*                          is set) as a filter against which all entries are
*                          matched, with all entries matching the filter
*                          being deleted.  The format of the OCTET STRING is:
*  
*                  1st octet:  0 = must not have Static flag set
*                              1 = must have Static flag set
*  
*                  2nd octet:  0 = must not have Restrict Outbound flag set
*                                  on port 1 
*                              1 = must have Restrict Outbound flag set 
*                                  on port 1 
*                                
*                  3rd octet:  0 = must not have Restrict Outbound flag set
*                                  on port 2 
*                              1 = must have Restrict Outbound flag set 
*                                  on port 2 
*  
*                  4th octet:  0 = must not have Restrict Outbound flag set
*                                  on port 3 
*                              1 = must have Restrict Outbound flag set 
*                                  on port 3 
*  
*                  5th octet:  0 = must not have Restrict Outbound flag set
*                                  on port 4 
*                              1 = must have Restrict Outbound flag set 
*                                  on port 4 
*  
*                  6th octet:  0 = must not have Restrict Inbound Multi-
*                                  cast flag set
*                              1 = must have Restrict Inbound Multi-cast
*                                  flag set
*  
*                  7th octet:  0 = must not have Restrict Inbound Multi-
*                                  cast flag set
*                              1 = must have Restrict Inbound Multi-cast
*                                  flag set
*  
*                  8th octet:  0 = Address must be on channel 1 
*                              1 = Address must not be on channel 1
*                    
*                  9th octet:  0 = Address must be on channel 2 
*                              1 = Address must not be on channel 2
*                    
*                  10th octet: 0 = Address must be on channel 3 
*                              1 = Address must not be on channel 3
*                    
*                  11th octet: 0 = Address must be on channel 4 
*                              1 = Address must not be on channel 4
*                    
*
**************************************************************************/

int svc_ramAddrTab834Delete(service, compc, compl, lenp, value, index)
unsigned int service;
byte         *compc;
unsigned int *compl;
int          *lenp;
UINT_32_T    *value;
int          index;
{

    register int     retval = 0;
    uint             cnt;
    char             *temp = (char *)value;
    RECORDMASK       FilterMask;
    FILTERREC        DummyFRec;

    switch(service)
    {
        case SNMP_TEST:
            if(*compc != 1 || *compl != 0 || *lenp != 11) 
                return(retval = NO_SUCH_NAME);
            break;

        case SNMP_SET:
            if(*compc != 1 || *compl != 0 || *lenp != 11)
                return(NO_SUCH_NAME);

            if( Octet2Filter(&DummyFRec, temp, &FilterMask) )
                return(BADVAL);
            
            DelMultiNids(&FilterMask, &cnt);

            break;
        default:
            retval = NO_SUCH_NAME;
            break;
    }       /* end of main switch */
    return(retval);
}  /* end of svc_ramAddrTab834Delete */


/**************************************************************************
*  Procedure    :   svc_nvramAddrTab834Entry
*  Path         :   1.3.6.1.4.1.26.2.24.6.1
*  Access       :   RW
*  Syntax       :   OCTET VT_STRING
*  Description  :   
*                          "An instance of this object-type exists for each
*                          entry in the Address Table stored in Non-Volatile
*                          RAM in a HLS 834 4 port Bridge.  The format of the
*                          OCTET STRING is:
*                          1st octet:  1 = Static flag set
*                                      0 = Static flag not set
*  
*                          2nd octet:  1 = Restrict Outbound flag port 1 set
*                                      0 = Restrict Outbound flag port 1 
*                                          not set
*  
*                          3rd octet:  1 = Restrict Outbound flag port 2 set
*                                      0 = Restrict Outbound flag port 2
*                                          not set
*  
*                          4th octet:  1 = Restrict Outbound flag port 3 set
*                                      0 = Restrict Outbound flag port 3 
*                                          not set
*  
*                          5th octet:  1 = Restrict Outbound flag port 4 set
*                                      0 = Restrict Outbound flag port 4 
*                                          not set
*  
*                          6th octet:  1 = Restrict Inbound Uni-Cast flag set
*                                      0 = Restrict Inbound Uni-Cast flag 
*                                          not set
*  
*                          7th octet:  1 = Rstrict Inbound Multi-Cast flag set
*                                      0 = Restrict Inbound Multi-Cast flag
*                                          not set
*  
*                          8th octet:  0 = Local bridge address
*                                      1 = Address on Channel 1
*                                      2 = Address on Channel 2
*                                      3 = Address on Channel 3
*                                      4 = Address on Channel 4
*  
*
**************************************************************************/

int svc_nvramAddrTab834Entry(service, compc, compl, lenp, value, index)
unsigned int service;
byte         *compc;
unsigned int *compl;
int          *lenp;
UINT_32_T    *value;
int          index;
{
    register int retval = 0;
    uint i;
    uint *temp  = compl;
    char *temp1 = (char *)value;
    char MacAddr[6];
    ADR  *AdrRec;
    ADR  *AdrRec2;
    char valbuf[8];
    RECORDMASK FilterMask;
    FILTERREC DummyRec;
    static int NumNvrEntries;
    static uint FirstTime  = TRUE;
    static uint nextEntry  = 0;

    memset(MacAddr, NULL, sizeof(MacAddr));
    for( i = 0; i < *compc; i++ ) {
         MacAddr[i] = *temp++;
    }

    switch(service)
    {

        case SNMP_GETNXT:
			/* 
            if(*compc < 1) 
                return(retval = NO_SUCH_NAME);
           */

            /* Pad address with 0's if necessary. */
            for( i = *compc; i < 6; i++)
                MacAddr[i] = 0;
            *compc = 6;

            /* was smaller, now=6; if bigger than 6, drop off excess
               bytes. The reason we can drop off bytes is the extra
               bytes act like a decimal point for an integer. Since
               we are working with whole address ( and add 1, next
               sub call) we can in essence drop the decimal or 
               fraction part.
            */
                
            /* If this is the first get-next of a series then, 
               build a table of addresses that match the get-next
               specifier and sort the table.
            */

                
            if( FirstTime == TRUE ) {
                NumNvrEntries = 0;
                NumNvrEntries = BuildNidTbl( NvFilterTab , MacAddr, NVRam);
                SortNidTbl( NvFilterTab, 0, NumNvrEntries-1 );  
                nextEntry = 0;
                FirstTime = FALSE;
                /* Start 30sec timer to determine validity of table */
            }
            /*  PrintTbl( NvFilterTab , NumNvrEntries);  */
      

            /* If there were no matching entries */
            if( (NumNvrEntries < 1) || (NumNvrEntries <= nextEntry) ) {
                FirstTime = TRUE;
                return(NO_SUCH_NAME);
            }

            StartTimerCall( &SortTblTimer, 2000, InvalidTbl, &FirstTime);
            temp = compl;
            if( GetEntry( NvFilterTab,valbuf,temp,&nextEntry, NumNvrEntries)) {
                FirstTime = TRUE;
                return(NO_SUCH_NAME);
            }
            nextEntry++;

            /* Return the value of the address record flags */
            memcpy( value, valbuf, 8);
            *lenp = 8;

            return(0);
            
        case SNMP_GET:  

            /* must = 6 for a get, only have a MAC adr */
            if( *compc != 6 || *compl != 0 )
                return(retval = NO_SUCH_NAME);

           /* Find the address record in the Nvram table if it  */
           /* exists and copy record information into AdrRec.   */

           for( i=0; i < NVRADR_REC_CNT; i++)  {
           
               /* Look for matching entry in the NVRAM address table */
               if(memcmp(MacAddr, (char *)&(NvramNids->nvr_nids[i])) == 0) {

                   /* Convert addr rec info to octet string */
                   AdrFlg2Octet(&(NvramNids->nvr_nids[i]), valbuf);
           
                   /* Return info */
                   memcpy(value, valbuf, 8);
                   *lenp = 8;
                   return(retval);
                }
           }
           retval = NO_SUCH_NAME;
           break;

        default:
            retval = NO_SUCH_NAME;
            break;
    }       /* end of main switch */
    return(retval);
}  /* end of svc_nvramAddrTab834Entry */



/**************************************************************************
*  Procedure    :   svc_nvramAddrTab834Filter
*  Path         :   1.3.6.1.4.1.26.2.24.7
*  Access       :   RW
*  Syntax       :   OCTET VT_STRING
*  Description  :   
*                          "Setting this value causes the re-creation
*                          of the filtered subset (see the object
*                          nvramAddrTab834FilterEntry) of the Address
*                          Table stored in Non-Volatile RAM in a HLS
*                          Local/Remote Bridge.  The filtered subset
*                          consists of all entries which matched the
*                          filter value at the time of the last write to
*                          this object.  The format of the OCTET STRING is:
*  
*                  1st octet:   0 = must not have Static flag set
*                               1 = must have Static flag set
*  
*                  2nd octet:  0 = must not have Restrict Outbound flag set
*                                  on port 1 
*                              1 = must have Restrict Outbound flag set 
*                                  on port 1 
*                                
*                  3rd octet:  0 = must not have Restrict Outbound flag set
*                                  on port 2 
*                              1 = must have Restrict Outbound flag set 
*                                  on port 2 
*  
*                  4th octet:  0 = must not have Restrict Outbound flag set
*                                  on port 3 
*                              1 = must have Restrict Outbound flag set 
*                                  on port 3 
*  
*                  5th octet:  0 = must not have Restrict Outbound flag set
*                                  on port 4 
*                              1 = must have Restrict Outbound flag set 
*                                  on port 4 
*  
*                  6th octet:  0 = must not have Restrict Inbound Multi-
*                                  cast flag set
*                              1 = must have Restrict Inbound Multi-cast
*                                  flag set
*  
*                  7th octet:  0 = must not have Restrict Inbound Multi-
*                                  cast flag set
*                              1 = must have Restrict Inbound Multi-cast
*                                  flag set
*  
*                  8th octet:  0 = Address must be on channel 1 
*                              1 = Address must not be on channel 1
*                    
*                  9th octet:  0 = Address must be on channel 2 
*                              1 = Address must not be on channel 2
*                    
*                  10th octet: 0 = Address must be on channel 3 
*                              1 = Address must not be on channel 3
*                    
*                  11th octet: 0 = Address must be on channel 4 
*                              1 = Address must not be on channel 4
*                    
*
**************************************************************************/

int svc_nvramAddrTab834Filter(service, compc, compl, lenp, value, index)
unsigned int service;
byte         *compc;
unsigned int *compl;
int          *lenp;
UINT_32_T    *value;
int          index;
{
    uint             i;
    register int     retval = 0;
    char             *temp = (char *)value;
    int              NumEntries;
    RECORDMASK       FilterMask;
    static FILTERREC AdrFilterRec = {0};


    switch(service)
    {
        
        case SNMP_TEST:
            
            if(*compc != 1 || *compl != 0 ) 
                return(retval = NO_SUCH_NAME);
            break;
            
        case SNMP_GETNXT:
            if(*compc != 0) 
                return(retval = NO_SUCH_NAME);
        
            *compc = 1;
            *compl = 0;
            
            /* fall through to GET */
            
        case SNMP_GET:  

            if( *compc != 1 || *compl != 0 )
                return(retval = NO_SUCH_NAME);

            Filter2Octet(&AdrFilterRec, temp);
            *lenp = 11;
            break;

        case SNMP_SET:
            
            if( *compc != 1 || *compl != 0  || *lenp != 11 )
                return(retval = NO_SUCH_NAME);
            
            if( Octet2Filter(&AdrFilterRec, temp, &FilterMask) )
                return(BADVAL);
            
            NvFilterTabEntries = BuildNvFilterTbl(NvFilterTab, &FilterMask);
            /* SortNidTbl( NvFilterTab, 0, NvFilterTabEntries-1 );   */
            /* PrintTbl( NvFilterTab, NvFilterTabEntries);  */
            break;
            return(retval);

        
        default:
            retval = NO_SUCH_NAME;
            break;

    }       /* end of main switch */
    return(retval);
}  /* end of svc_nvramAddrTab834Filter */




/**************************************************************************
*  Procedure    :   svc_nvramAddrTab834FilterNum
*  Path         :   1.3.6.1.4.1.26.2.24.8
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                          "The current number of entries in the filtered
*                          subset of entries in the Address Table in
*                          Non-Volatile RAM in a HLS Local/Remote Bridge.
*                          The filtered subset consists of all entries
*                          which matched the filter value at the time of the
*                          last write to the object: nvramAddrTab834Filter."
*
**************************************************************************/

int svc_nvramAddrTab834FilterNum(service, compc, compl, lenp, value, index)
unsigned int service;
byte         *compc;
unsigned int *compl;
int          *lenp;
UINT_32_T    *value;
int          index;
{

    register int retval = 0;

    switch(service)
    {
        
        case SNMP_TEST:
            
            return(retval = NO_SUCH_NAME);
            
        case SNMP_GETNXT:
            if(*compc != 0) 
                return(retval = NO_SUCH_NAME);
        
            *compc = 1;
            *compl     = 0;
            
            /* fall through to GET */
            
        case SNMP_GET:  

            if( *compc != 1 || *compl != 0 )
                return(retval = NO_SUCH_NAME);

            *(uint *)value = NvFilterTabEntries;
            break;

        default:
            retval = NO_SUCH_NAME;
            break;

    }       /* end of main switch */
    return(retval);
}  /* end of svc_nvramAddrTab834FilterNum */



/**************************************************************************
*  Procedure    :   svc_nvramAddrTab834FilterEntry
*  Path         :   1.3.6.1.4.1.26.2.24.9.1
*  Access       :   RO
*  Syntax       :   OCTET VT_STRING
*  Description  :   
*                          "An instance of this object-type exists for each
*                          entry within the filtered subset of the Address
*                          Table in Non-Volatile RAM in a HLS Local/Remote
*                          Bridge.  The filtered subset consists of all
*                          entries which matched the filter value at the
*                          time of the last write to the object:
*                          nvramAddrTab834Filter.  The format of the OCTET
*                          STRING is:
*  
*                          octets 1-6:  the MAC address of this entry
*  
*                          7th octet:   1 = Static flag set
*                                       0 = Static flag not set
*  
*                          8th octet:  1 = Restrict Outbound flag port 1 set
*                                      0 = Restrict Outbound flag port 1 
*                                          not set
*  
*                          9th octet:  1 = Restrict Outbound flag port 2 set
*                                      0 = Restrict Outbound flag port 2
*                                          not set
*  
*                          10th octet: 1 = Restrict Outbound flag port 3 set
*                                      0 = Restrict Outbound flag port 3 
*                                          not set
*  
*                          11th octet: 1 = Restrict Outbound flag port 4 set
*                                      0 = Restrict Outbound flag port 4 
*                                          not set
*  
*                          12th octet: 1 = Restrict Inbound Uni-Cast flag set
*                                      0 = Restrict Inbound Uni-Cast flag 
*                                          not set
*  
*                          13th octet: 1 = Rstrict Inbound Multi-Cast flag set
*                                      0 = Restrict Inbound Multi-Cast flag
*                                          not set
*  
*                          14th octet: 0 = Local bridge address
*                                      1 = Address on Channel 1
*                                      2 = Address on Channel 2
*                                      3 = Address on Channel 3
*                                      4 = Address on Channel 4
*  
*
**************************************************************************/

int svc_nvramAddrTab834FilterEntry(service, compc, compl, lenp, value, index)
unsigned int service;
byte         *compc;
unsigned int *compl;
int          *lenp;
UINT_32_T    *value;
int          index;
{

    register int retval = 0;
    ADR  *AdrRec;
    ADR  **NidTbl;
    char valbuf[14];
	int  indx;
    uint NumEntries = NvFilterTabEntries;

    switch(service)
    {
        case SNMP_TEST:
                return(retval = NO_SUCH_NAME);

        case SNMP_GETNXT:

            get_nxtportidx((int *)compc,
                    (unsigned int *)compl, retval);

            /* If there were no matching entries */
            if( (NumEntries < 1) || (NumEntries <= *compl) ) {
                return(NO_SUCH_NAME);
            }

			indx = (*compl) - 1;
            if( GetFilterEntry( NvFilterTab, valbuf, &indx, NumEntries)) {
                return(NO_SUCH_NAME);
            }
            *compl = indx+1;

            /* Return the value of the address record flags */
            memcpy( value, valbuf, 14);
            *lenp = 14;

            return(0);

        case SNMP_GET:  

            if((*compl < 1) || (*compl > NumEntries) ) 
                return(NO_SUCH_NAME);
           
			indx = (*compl) - 1;
			 /*
             Get a single entry from the sorted address filter table 
            *NidTbl = NvFilterTab;     
            memcpy(value, (char *)&(NidTbl[*compl]->adr_low), 6);
            AdrFlg2Octet(NidTbl[*compl], &value[6]);
            */

            GetSingleFilterEntry( NvFilterTab, valbuf, &indx );

            /* Return the value of the address record flags */
            memcpy( value, valbuf, 14);
            *lenp = 14;
            return(0);

        default:
            retval = NO_SUCH_NAME;
            break;
    }       /* end of main switch */
    return(retval);
}  /* end of svc_nvrramAddrTab834Entry */



/**************************************************************************
*  Procedure    :   svc_nvramAddrTab834Update
*  Path         :   1.3.6.1.4.1.26.2.24.11
*  Access       :   WO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                            "Setting this object to a value causes an update
*                            of the Address Table in Non-Volatile RAM in a
*                            HLS 4 Port Bridge.  This update is the
*                            combination of the deletion of all existing
*                            entries in Non-Volatile RAM table, followed by
*                            the addition of a set of new entries.  The set
*                            of new entries is a subset of the current
*                            entries in the bridge's RAM-resident Address
*                            Table.  That subset is selected by using the
*                first 800 addresses marked as static in the
*                            RAM-resident Address Table.  
*
**************************************************************************/

int svc_nvramAddrTab834Update(service, compc, compl, lenp, value, index)
unsigned int service;
byte         *compc;
unsigned int *compl;
int          *lenp;
UINT_32_T    *value;
int          index;
{

    register int retval = 0;

    switch(service)
    {
        
        case SNMP_TEST:
            if( *compc != 1 || *compl != 0 )    
                return(retval = NO_SUCH_NAME);
            
        case SNMP_SET:
            if( *compc != 1 || *compl != 0 )    
                return(retval = NO_SUCH_NAME);
            
            SaveStaticRecs();
            break;
        default:
            retval = NO_SUCH_NAME;
            break;

    }       /* end of main switch */
    return(retval);
}  /* end of svc_nvramAddrTab834Update */




/*****************************************************************************/

GET_NEXT1(compc1, compl1)
byte *compc1;    /* length of the instance in word       */
int *compl1;        /* instance or index                    */
{
    if(*compc1 == 0)
    {
        *compc1 = 1;
        *compl1 = 1;
    } 
    else
        *compl1 += 1;
}
