/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file contains the service routines for RFC1286-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBSVC.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
                                                                           
 *************************************************************************/

#define RFC1286-MIB_SVC

#include <types.h> 
#include <target.h>
#include <krnl.h>
#include <bridges.h>
#include <dbd.h>
#include <snmp.h>
#include <asn1.h>
#include <syteksnm.h>
#include <prcctl.h>
#include <sncvar.h>

/**************************************************************************
*  Procedure    :   svc_dot1dStaticAddress
*  Path         :   1.3.6.1.2.1.17.5.1.1.1
*  Access       :   RW
*  Syntax       :   MacAddress VT_STRING
*  Description  :   
*                 "The destination MAC address in a frame to which
*                 this entry's filtering information applies.  This
*                 object can take the value of a unicast address, a
*                 group address or the broadcast address."
*
**************************************************************************/

int svc_dot1dStaticAddress(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		{
			/* FILL IN ACTUAL SET OPERATIONS HERE */
		}
		break;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
			/* FILL IN ACTUAL TEST OPERATIONS HERE */
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dStaticReceivePort
*  Path         :   1.3.6.1.2.1.17.5.1.1.2
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                 "Either the value '0', or the port number of the
*                 port from which a frame must be received in order
*                 for this entry's filtering information to apply.
*                 A value of zero indicates that this entry applies
*                 on all ports of the bridge for which there is no
*                 other applicable entry."
*
**************************************************************************/

int svc_dot1dStaticReceivePort(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		{
			/* FILL IN ACTUAL SET OPERATIONS HERE */
		}
		break;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
			/* FILL IN ACTUAL TEST OPERATIONS HERE */
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dStaticAllowedToGoTo
*  Path         :   1.3.6.1.2.1.17.5.1.1.3
*  Access       :   RW
*  Syntax       :   OCTET VT_STRING
*  Description  :   
*                 "The set of ports to which frames received from a
*                 specific port and destined for a specific MAC
*                 address, are allowed to be forwarded.  Each octet
*                 within the value of this object specifies a set of
*                 eight ports, with the first octet specifying ports
*                 1 through 8, the second octet specifying ports 9
*                 through 16, etc.  Within each octet, the most
*                 significant bit represents the lowest numbered
*                 port, and the least significant bit represents the
*                 highest numbered port.  Thus, each port of the
*                 bridge is represented by a single bit within the
*                 value of this object.  If that bit has a value of
*                 '1' then that port is included in the set of
*                 ports; the port is not included if its bit has a
*                 value of '0'.  (Note that the setting of the bit
*                 corresponding to the port from which a frame is
*                 received is irrelevant.)"
*
**************************************************************************/

int svc_dot1dStaticAllowedToGoTo(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		{
			/* FILL IN ACTUAL SET OPERATIONS HERE */
		}
		break;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
			/* FILL IN ACTUAL TEST OPERATIONS HERE */
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dStaticStatus
*  Path         :   1.3.6.1.2.1.17.5.1.1.4
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                 "This object indicates the status of this entry.
*                      other(1) - this entry is currently in use but
*                           the conditions under which it will
*                           remain so are different from each of the
*                           following values.
*                      invalid(2) - writing this value to the object
*                           removes the corresponding entry.
*                      permanent(3) - this entry is currently in use
*                           and will remain so after the next reset
*                           of the bridge.
*                      deleteOnReset(4) - this entry is currently in
*                           use and will remain so until the next
*                           reset of the bridge.
*                      deleteOnTimeout(5) - this entry is currently
*                           in use and will remain so until it is
*                           aged out."
*
**************************************************************************/

int svc_dot1dStaticStatus(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		{
			/* FILL IN ACTUAL SET OPERATIONS HERE */
		}
		break;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
			/* FILL IN ACTUAL TEST OPERATIONS HERE */
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

