/*****************************************************************
 *      Copyright (c) 1992 by Hughes LAN Systems
 *
 *      Program Name:   FDDI Concentrator application
 *
 *      Filename:       mibmisc.c
 *
 *      Description:    This file contains miscellaneous functions
 *						required for rfc1285.
 *
 *      $Log:   /b/gregs/bridge/snmp/fddi_routines/mibmisc.c_v  $
 * 
 *    Rev 1.0   30 Jul 1993 13:21:42   franks
 * Initial revision.
 * 
 *    Rev 1.3   20 May 1993 19:00:20   jlin
 * Working
 * 
 *    Rev 1.2   19 May 1993 11:07:26   shekhar
 * 
 *    Rev 1.1   19 May 1993 10:26:38   shekhar
 * 
 *    Rev 1.0   18 May 1993 16:21:26   shekhar
 * Initial revision.
 * 
 * Initial Version.
 *
 *      Revision:
 *      1-000           May 17 1993      Shekhar Ambe
 *                      
 *******************************************************************
 */

#include <types.h>
#include <asn1.h>
#include <snmp.h>
#include <syteksnm.h>

#include <smtdefs.h>
#include <mibdefs.h>
#include <smttypes.h>
#include <fddihdr.h>
#include <nvrecs.h>

/*
#define SVCDEBUG
*/


/* export */ int ChangePortPcType (uint portno, uint PcType)
	{
        NVR_FDDI *FddiRec = &nvr_fddi_rec;
	uChar    resetNeeded = FALSE;
	uint	 ringno;
        byte     *UIPcType, *otherUIPcType; 
	uInt16 i;

	if (PcType > PC_Type_M)
	{
	   printf("Port Type number %d is known\n", PcType);
	   return 0;
	}

	if (portno == 1) 
	{
	   UIPcType      = &nvr_fddi_rec.UI_Defaults.Port1_PC_Type;
	   otherUIPcType = &nvr_fddi_rec.UI_Defaults.Port6_PC_Type;
	}
	else
	{
	   UIPcType      = &nvr_fddi_rec.UI_Defaults.Port6_PC_Type;
	   otherUIPcType = &nvr_fddi_rec.UI_Defaults.Port1_PC_Type;
	}


	if (*UIPcType == PcType)
	{ /* no type change */
	   return 0;
	}

	*UIPcType = (byte)PcType;

	if (PcType == PC_Type_A)
	{ /* must be port 1 */
	   if (NVR_FDDI_PORT[PHY_A].PC_Type != PC_Type_A)
	   { /* it is not an A port in NVR */
	      if (*otherUIPcType != PC_Type_M)
	      {
	         *otherUIPcType = PC_Type_B;
	      }
	      NVR_FDDI_PORT[PHY_A].PC_Type = PC_Type_A;
	      NVR_FDDI_PORT[PHY_B].PC_Type = PC_Type_B;
	      resetNeeded = TRUE;
	   }
	}
	else if (PcType == PC_Type_B)
	{ /* must be port 6 */
	   if (NVR_FDDI_PORT[PHY_B].PC_Type != PC_Type_B)
	   { /* it is not an B port in NVR */
	      if (*otherUIPcType != PC_Type_M)
	      {
	         *otherUIPcType = PC_Type_A;
	      }
	      NVR_FDDI_PORT[PHY_A].PC_Type = PC_Type_A;
	      NVR_FDDI_PORT[PHY_B].PC_Type = PC_Type_B;
	      resetNeeded = TRUE;
	   }
	}
	else if (PcType == PC_Type_S)
	{
	   if (NVR_FDDI_PORT[((portno==1) ? PHY_A : PHY_B)].PC_Type 
	       != PC_Type_S)
	   { /* it is not a S port in NVR */
	      
	      if (*otherUIPcType != PC_Type_M)
	      {
	         *otherUIPcType = PC_Type_S;
	      }

	      NVR_FDDI_PORT[PHY_A].PC_Type
		= NVR_FDDI_PORT[PHY_B].PC_Type 
		  = PC_Type_S;
	      for (i=0; i < MAX_PORT_COUNT; i++)
	      {
		 NVR_FDDI_PORT[i].pathRequested = PA_PRIMARY;
	      }
	      resetNeeded = TRUE;
	   }
	}


	/* now update the nvram */
	PutFDDIRec(&nvr_fddi_rec);
	
        if (resetNeeded)
	{
	   printf("\n\n\nWarning: ");
	   printf("Resetting the system is required for this new port type change.\n\n\n");
	}
	else
	{
	   /* insert into the ring */
	   ringno = get_ring_number();
	   insert_hub_ring (0, ringno);
	}

	return 0;	
	}
	
