/**			       
*
*	Program Name:	Bridge
*
*	Filename:	netio.c
*
*	$Log:   /b/gregs/bridge/netio/netio.c_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:13:44   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 09:36:40   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:17:50   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 10:54:34   franks
 * No change.
 * 
 *    Rev 1.1   12 Aug 1993 14:28:52   vinay
 * put StartTimercall for telnet inactivity timeout
 * 
 *    Rev 1.0   30 Jul 1993 13:09:24   franks
 * Initial revision.
 * 
 *    Rev 1.2   13 Apr 1992 18:54:52   kwok
 * Prompt the user for the CONSOLE password after the telnet 
 * connetion is opened.
 * 
 *    Rev 1.1   10 Apr 1992 16:52:42   kwok
 * Send a "echo" REQ rather than "echo" IND on tn_opened().
 * 
 *    Rev 1.0   30 Mar 1992 17:32:22   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		6.5.91
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	This file contains the remote console io
*			functions.  All these functions interfaces with
*			telnet.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <types.h>
#include <krnl.h>
#include <task.h>
#include <netbuf.h>
#include <ip.h>
#include <mtcp.h>
#include <mtcpblk.h>
#include <tcpip.h>
#include <telnet.h>
#include <error.h>
#include <sys.h>
#include "netio.h"
#include <nvrecs.h>
#include <param.h>
#include <834parser.h>

extern	SEM	RemoteDisconnected;

extern	int	ConsoleActive;
extern  RAM_PIT rampit;
extern TIMER InactivityTimer;

telnet *tnc = NULL;		/* a pointer to telnet structure */
int tnc_permit = 1;	/* a permission to open telnet session */
int tnc_valid = 0;	/* telnet session active indicator */
int local_echo = 1;	/* local echo indicator */
int close_abort;	/* closed / aborted session indicator */

/*
 *	Check if telnet is active or not
 */
IsTelnetActive()
	{
	return tnc_valid;
	}
/*
 *	Close the telnet session.
 *	This function is called when we pass control to a 
 *	new program that has just been tftped .
 */
CloseTelnet()
	{
	int	i;

	if (tnc_valid)
		{
		tn_close(tnc, 10);
		i = RealTimeTicks();
		while ((RealTimeTicks() - i) < 50 && tnc_valid)
			ReSchedule();
		}
	}
/*
 *	UP CALLS 
 *	These functions will be called by telnet.
 */

/*
 * name		tn_opened
 *
 * synopsis	tn_opened(tn, tag)
 *		telnet	*tn; <<	the tcp connection control block
 *		void	*tag;<<	the tag returned from 
 *
 * description	It is an upcall from Telnet.  This function is called 
 *		when the connection between the session and the foreign host
 *		has been established.  Data can be exchanged from both
 *		ends from this point on.
 *		It will set up all data such that it is in a state to
 *		exchange data.
 *
 * returns	nothing
 */

tn_opened(tn, tag)
telnet	*tn;
void	*tag;

	{
	void TimedOut();
	tnc = tn;

	tnc_permit = 0;         /* indicates no more sessions are allowed */
/**	DebugMessage("*tn_opened**");   */
	/* disable_events();*/	 /* disable all the events type */
	tn_set_eol(tn, '\r', '\0');
	local_echo = 1;	     /* the default -  local echo enabled */
	/* a request to keep the local echo */
/**	tn_option(tnc, TN_WILL, TN_ECHO, IND); **/
	tn_option(tnc, TN_WILL, TN_ECHO, REQ); 
	NetPuts("\r\nWelcome to Hughes LAN Systems Remote Console");
	NetPuts("\r\nSession Opened by: ");
	NetPuts(inet_ntoa(tnc->tn_fhst)); 
	NetPuts("\r\n\r\n");
	StartTimerCall(&InactivityTimer, (BridgeStatus->TimeOut*6000),
			(void *)TimedOut,(int)&rampit);
	NetPuts("Please Enter CONSOLE password: ");
	tnc_valid = 1;	        /* indicates that one session is active */
	IOpath = IO_TELNET;	/* stdio is the telnet session 	*/
	sys.sys_remote_console = 1;
	/*
	 *	send a trap to the trap manager,
	 */
	specific_trap(6, PS_TCPIP, &tn->tn_fhst, tn->tn_lskt, tn->tn_fskt, 0, 0, 0);
	}

/*
 * name		tn_closed
 *
 * synopsis	tn_closed(tn, tag)
 *		telnet	*tn; <<		this telnet connection
 *		void	*tag; <<	application tag
 *
 * description	This is an upcall from telnet to confirm that the
 *		local telnet session is in the closed state.
 *		The local process must do whatever it requires to tidy
 *		up
 *
 * returns	nothing
 */


tn_closed(tn, tag)
telnet	*tn;
void	*tag;

	{
/**	DebugMessage("tn_closed*"); **/
	close_abort = 1;	/* indicate close	*/
	tnc_permit = 1;		/* indicates a new session is allowed */
	tnc_valid = 0;		/* flag that session is gone	*/ 
	tnc = NULL;
	IOpath = IO_UART;	/* stdio returns to the uart	*/
	sys.sys_remote_console = 0;
	specific_trap(7, PS_TCPIP, &tn->tn_fhst, tn->tn_lskt, tn->tn_fskt, 
		tn->tn_inbytes, tn->tn_outbytes, 0);
	}


/*
 * name		tn_fclosed
 *
 * synopsis	tn_fclosed(tn, tag)
 *		telnet	*tn; <<		this telnet connection
 *		void	*tag; <<	application tag
 *
 * description	This is an upcall from telnet to confirm that the
 *		foreign host is in the closed state.
 *		The local process must do whatever it requires to tidy
 *		up.
 *
 * returns	nothing
 */

tn_fclosed(tn, tag)
telnet	*tn;
void	*tag;
	{
	
/**	DebugMessage("tn_fclosed **"); */

	if (tn == tnc)
		{
		tn_close(tnc, 300);	/* in 3 seconds */
		/*
		 *	Tell the command task to ask for the
		 *	password.
		 */
		SendSignal(&RemoteDisconnected);
		}
	}

/*
 * name		tn_faulted
 *
 * synopsis	tn_faulted(tn, tag, status)
 *
 * description
 *
 * returns
 */

tn_faulted(tn, tag, status)
telnet	*tn;
void	*tag;
int	status;

	{
	/*DebugMessage("tn_faulted**"); */
	close_abort = 0;	/* indicate abort */
	tnc_valid = 0;		/* flag that session is gone */ 
	tnc_permit = 1;		/* indicates a new session is allowed */
	IOpath = IO_UART;	/* stdio returns to the uart	*/
	sys.sys_remote_console = 0;
	specific_trap(8, PS_TCPIP, &tn->tn_fhst, tn->tn_lskt, tn->tn_fskt, 
		tn->tn_inbytes, tn->tn_outbytes, 0);
	/*
	 *	Tell the command task to ask for the
	 *	password.
	 */
	SendSignal(&RemoteDisconnected);
	}
/*
 * name		tn_received
 *
 * synopsis	tn_received(tn, tag)
 *		telnet	*tn; <<	the telnet connection
 *		void	*tag; << of the telnet 
 *
 * description	This is upcalled when data is received. 
 *
 * returns	nothing
 */

tn_received(tn, tag)
telnet	*tn;
void	*tag;

	{
	/*DebugMessage("tn_received");*/
	return;
	}

/*
 * name		tn_evented
 *
 * synopsis
 *
 * description
 *
 * returns
 */

tn_evented(tn, tag, event)
telnet	*tn;
void	*tag;
int	event;

	{

	return;
	}

/*
 * name		tn_optioned
 *
 * synopsis
 *
 * description
 *
 * returns
 */

tn_optioned(tn, tag, sta, opt, ind)
telnet	*tn;
int	tag;
int	sta;
int	opt;
int	ind;

	{
	if (ind == IND)
		{
		if ((opt == TN_ECHO) && (sta == TN_DONT))
			local_echo = 0;	/* remote disagree, local echo disabled */
          	tn_option(tn, sta, opt, RSP);
		}
	}

/*
 * name		filter_con
 *
 * synopsis	filter_con(tn, pid, fhost, fport, lport, lhost)
 *		TcpCon	tn; <<	the tcp connection 
 *		int	pid;<<	what protocol is this one, 
 *				i.e. TCP, LAT or V2
 *		in_name	fhost;<<	ip address of the foreign host
 *		uint	fport;<<	incoming port number
 *		uint	lport;<<	the destination port number
 *		in_name	lhost;<<	op address of the receiver, me
 *
 * description	It decides whether to accept an incoming call or not.
 *		This function is called whenever a request to open call
 *		packet (TCP SYN packet) is received.
 *		Accept the call if 
 *		-	this is the telnet port
 *		-	this is no active telnet session
 *		-	the local console is inactive, and
 *		-	the admin bus console is inactive
 *
 * returns	NULL		do not accept the call
 *		otherwise	tag in the Telnet control block
 */

filter_con(tn, pid, fhost, fport, lport, lhost)
telnet	*tn;
int	pid;
in_name fhost;
uint	fport;
uint	lport;
in_name	lhost;

	{
	int	ret;
	/* accept call when permitted */
/*	DebugMessage("*filter_con*"); */
#ifdef KKDEBUG
	if (lport != 23)
		DebugMessage("lport != 23");
	else if (tnc_permit == 0)
		DebugMessage("tnc_permit = 0");
	else if (IOpath != IO_UART)
		DebugMessage("IOpath != UART");
	else if (ConsoleActive != 0)
		DebugMessage("ConsoleActive != 0");
	else
		DebugMessage("Accepting Telnet\n");
#endif
	ret = (lport == 23 && tnc_permit && IOpath == IO_UART 
		&& !ConsoleActive);
	if (ret == 0)
		specific_trap(5, PS_TCPIP, &fhost, lport, fport, 0, 0, 0);
	else
		{
		tn->tn_lskt = 23;
		tn->tn_inbytes = 0;
		tn->tn_outbytes = 0;
		}
	return ret;
        }


/* send character to telnet  */
NetPutch(c)
byte	c;
	{
	static int outcnt = 0;

	if (tn_putstr(tnc, (byte *)&c, 1))
		return -1;
	if (++outcnt == 512)
		{
		outcnt = 0;
		ReSchedule();
		}
	return 0;
	}

/* send string to telnet */
NetPuts(s)
char	*s;

	{
	if (tn_putstr(tnc, (byte *)s, strlen(s)))
		return -1;
/*	ReSchedule();*/
	return 0;
	}

/*
 * name		DebugMessage	- print a message to the console
 *
 * synopsis	DebugMessage(message)
 *		char	*message; <<	message to be printed 
 *
 * description	It prints a message directly to the console.  This
 *		is for printing out debugging message. It will NOT
 *		ReSchedule the current task. 
 *
 * returns	nothing
 */


DebugMessage(char *message)

	{
	while (*message != '\0')
		{
		if (UartPutch(*message) != -1)
			message++;
		}
	}

/*********************************************************************
**
**      TELNET DUMMY ROUTINES
**	=====================
**
**  The following dummy routines prevent unresolved symboles during 
**  the compilation. 	
**********************************************************************/

/*
 * name		tn_syteked
 *
 * synopsis
 *
 * description
 *
 * returns
 */


tn_syteked()

	{
	return;
	}

/*
 * name		tn_statused
 *
 * synopsis
 *
 * description
 *
 * returns
 */


tn_statused()
	
	{
	return;
	}

/*
 * name		handle_termtype
 *
 * synopsis
 *
 * description
 *
 * returns
 */


handle_termtype()

	{
	return;
	}

/*
 * name		is_server
 *
 * synopsis	is_server(void)
 *
 * description	It tests if the current local telnet connection is 
 *		a server or not.
 *
 * returns	TRUE	the current local connection is a server
 *		FALSE	the current local connection is a client
 */


is_server()

	{
	return 1;
	}

/*
 * name		option_conf
 *
 * synopsis
 *
 * description
 *
 * returns
 */


option_conf()

	{
	return;
	}


/*
 * name		option_ind
 *
 * synopsis
 *
 * description
 *
 * returns
 */

option_ind()
	
	{
	return 1;
	}

