/*
**   FILE: init.c
**   
**   Date: 28 April 1993
**
**   By:   Frank Salzmann
**
**   Description: This is the init.c file for the FDDI / Ethernet Bridge.
**
*/

#include <krnl.h>
#include <types.h>
#include <target.h>
#include <time.h>
#include <sys.h>
#include <malloc.h>
#include <nvrecs.h>
#include <dips.h>
#include <led.h>
#include <sncvar.h>
#include <netbuf.h>
#include <tcpip.h>
#include <ether.h>
#include <nim960h.h>
#include <eeprecs.h>
#include <sockets.h>
#include <log.h>
#include <error.h>
#include <udp.h>
#include <tftpboot.h>
#include <lme.h>
#include <asn1.h>
#include <snmp.h>
#include <syteksnm.h>
#include <memory.h>


#define	DBD_COUNT	    	20
#define	DBD_BUFFER_SIZE		1520
#define FRONT			1
#define BACK			2

/**** External Variable Declarations ****/

extern MBOX         ReceiveMbox;
extern int          EntryFromTftp;
extern word         snc_init;
extern int          reset_type;
extern int          NumberOfSonicPort;
extern NIM960_HDR   Nim960Header;		/* My nim960 header	*/
extern NVR_BSTATUS  *BridgeStatus;
extern NVR_RESETLOG *RstLog;
extern int          A_Port_Config_State;
extern int          B_Port_Config_State;
extern unsigned int Fddi_Rcv_Pkt;

TIMER EchoReqTimer;
TIMER TopologyChangeTimer;
TIMER NewRootTimer;

int EepromError = 0;

/**** External Function Declarations ****/

extern int (*pkt_proc_upcall)();
extern Nop();
extern init();

/**** Global Variable Declarations ****/

int	          UpdateMode;
int	          InBootStage;
SEM	          NotInSnmpStack;
SEM	          SwUpdateFromSnmp;	
APPL          apl;
tcpip	      my_tcpip;
EEP_MFG		  eep_mfg_rec;
EEP_BOOT	  eep_boot_rec;
IF_ENTRY      *AdmIfentry;
static   int  FirstTimeToBridge;
unsigned long BootUpSeconds = 0;


/**** Non-External Function Declarations ****/

static void	SnmpUpCall();
char		Port4EthNid[6];
int			PollPacket();

/*
*  scc tasks
*/
extern void brip_free_task();
extern void brip_rcv_task();

/*
* stacks for scc tasks
*/
word brip_free_stk[256];
word brip_rcv_stk[256];


/****** Code Starts ******/

init()
{
	long	myip;
	int application;
	register SYS *sys_ptr = &sys;
	byte	*start_dbd;
	int	i;
	char tmp[10];
	
		
	UpdateMode = TFTP_MODE_AUTO;
	NumberOfSonicPort = 3;
	application = APPL_BRIDGE;


    /*** Let's put the DBDs in DRAM since now they are only
    **** used for stack purposes. 
    ***/
	if ((start_dbd = (byte *)malloc((sizeof(DBD) + DBD_BUFFER_SIZE) * DBD_COUNT)) == NULL)
	{
		printf("Malloc failure : dbd buffer\n");
		InitAbort();
	}

	SetMyNids();

	pktInit();     /* Initialize the sonic driver and structures */

	init_dbd(start_dbd, DBD_BUFFER_SIZE, DBD_COUNT);

	/*
	* Initialize SCC driver
	*/
	scc_init_chnl_a();


	if(nvr_fddi_rec.UI_Defaults.Port1_PC_Type == 3)	
		A_Port_Config_State = BACK;
	else
		A_Port_Config_State = FRONT;
	
	if(nvr_fddi_rec.UI_Defaults.Port6_PC_Type == 3)
		B_Port_Config_State = BACK;
	else
		B_Port_Config_State = FRONT;

	/*
	* init fddi driver
	*/
	Fddi_Rcv_Pkt = 0;
	init_if();

	/* Init_offline_phys(); */

	CamInit();

	ProtocolStackInit();
	InstallSonic(PollPacket, 0); 


	if ((BridgeStatus = (NVR_BSTATUS *)malloc(sizeof(NVR_BSTATUS))) == NULL)
	{
		printf("Malloc failure : BridgeStatus\n");
		InitAbort();
	}

	/*	Clear the BridgeStatus structure  */
	memset(BridgeStatus, NULL, sizeof(NVR_BSTATUS));

	/*  Get the BridgeStatus from NVRAM */
	/*  If unable to get status then re-initialize this portion of NVRAM */
	if( GetBStatus() )  {
		STP_dft_rst();        /* spanning tree parameters */
		SetBridgeDefault();   /* bridge parameters */
		printf("Bridge Parameters Initialized To Default Values.\n\n");
	}

	if ((RstLog = (NVR_RESETLOG *)malloc(sizeof(NVR_RESETLOG))) == NULL)
	{
		printf("Error: malloc RstLog\n");
		InitAbort();
	}

	/*	Clear the reset log structure  */
	memset(RstLog, NULL, sizeof(NVR_RESETLOG));

	/* Initialize the reset event log from nvram */
	if(GetRstLog())
	{
		memset(RstLog, NULL, sizeof(NVR_RESETLOG));
		printf("Reset Log Initialized.\n\n");
		SaveRstLog();
	}

	/* Can only be called after the initialization of BridgeStatus. */
	InitSnmp();

	if (AdmBusInit(ADMRAM))
		printf("Malloc failure : Admin Bus\n");

	CreatTimer(&EchoReqTimer);
	CreatTimer(&TopologyChangeTimer);
	CreatTimer(&NewRootTimer);
	if(EepromError)
	{
		EepromError = 0;
		printf("\nEEPROM Error\n");
		PutEEP_HDR();
		PutEEP_MFG();
		PutEEP_BOOT();
	}

	InitFddi_to_Eth_Buffers();  

	/*** TEMP DISABLE WATCHDOG TIMER 
	disable_wdt();
	*/
	FirstTimeToBridge = 1;
    apl.run_appl = APPL_BRIDGE;
	application = call_bridge(FirstTimeToBridge);


#ifdef FSTAKEOUT
	for(;;)
	{
		if (!application)
		{
			main_menu();
			printf("\nEnter Programme Number > ");
			scanf("%d", &application);
		}

		switch (application)
		{
		case APPL_BRIDGE:
		case APPL_CONFIG:
		case APPL_PACKET:
		case APPL_TFTP:
			application = call_appl(apl.run_appl = application);
			apl.run_appl = APPL_KRNL;
			set_leds(LED_BI, LED_BI_COLOR, LED_RDY_GRN | LED_ACT_OFF);
			InstallSonic(PollPacket, 0);
			break;
		case APPL_RESET:
			reset();
		default:
			application = 0;
			break;
		}

	}
#endif
}

main_menu()
{
	printf("\n\t\t\t\tHLS NIM960 BRIDGE MAIN MENU\n\n");
	printf("\t\t\t 1) Bridge Programme\n");
	printf("\t\t\t 2) Configuration and Test Programme\n");
	printf("\t\t\t 3) Packet Generator and Monitor\n");
	printf("\t\t\t 4) TFTP Loader\n");
	printf("\t\t\t 5) Reset\n");
}

#ifdef FSTAKEOUT

call_appl(application)
int application;
{
	register ALLOC *mallocp = &alloc;
	char *sram_alc_lo = mallocp->sram_alc_lo;
	char *sram_alc_hi = mallocp->sram_alc_hi;
	char *dram_alc_lo = mallocp->dram_alc_lo;
	char *dram_alc_hi = mallocp->dram_alc_hi;
	int	port = NumberOfSonicPort;

	switch (application)
	{
	case APPL_BRIDGE:
		application = call_bridge(FirstTimeToBridge);
		FirstTimeToBridge = 0;
		break;
	case APPL_CONFIG:
		/*
		 *	disable the channel driver before
		 *	we pass control to the tester.
		 */
		while(port--)
			chnl_stop(port);
		disable_wdt();
		application = tester();
		enable_wdt();
		break;
	case APPL_PACKET:
		application = call_packet_gen();
		break;
	case APPL_TFTP:
		application = UpdateImage(UpdateMode);
		UpdateMode = TFTP_MODE_AUTO;
		break;
	default:
		application = 0;
		break;
	}
	mallocp->sram_alc_lo = sram_alc_lo;
	mallocp->sram_alc_hi = sram_alc_hi;
	mallocp->dram_alc_lo = dram_alc_lo;
	mallocp->dram_alc_hi = dram_alc_hi;

	return application;
}
#endif

ProtocolStackInit()
{
	static	int	inited = 0;
	int	code;
	EEP_BOOT	*boot;

	if (inited != 0)
		return TRUE;
	inited++;
	boot = &eep_boot_rec; 
	my_tcpip.numtcps = 2;  /* 1 for telnet, the other for sending the
				* connection refused packet.
				*/
	my_tcpip.numudps = 4;
	my_tcpip.tn_bufs = 512;
	my_tcpip.tn_maxw= 512;
	my_tcpip.tn_minw= 256;
	my_tcpip.ifNumber = NumberOfSonicPort + 2; /* including the admin bus */
	/*
	 *	#####	We may have to use bootp to
	 *	get my ip address in the first boot up time
	 */
	if (boot->eep_marker == EEP_MARKER)
	{
		my_tcpip.in_me = boot->eep_IP;
		my_tcpip.net_mask = boot->eep_NetMask;
		my_tcpip.net_gway = boot->eep_RouterIP[0];
		my_tcpip.net_gway2 = boot->eep_RouterIP[1];
	}
	if ((code = tcpip_init(&my_tcpip)) != 0)
	{
		/*	abort	*/
		printf("Cannot start tcpip (%d): %s\n", code, TcpipError(code));
		inited--;
		return FALSE;
	}
	return TRUE;
}
/*
 *	Add all of my MAC addresses into the cam for soninc port
 *	number "PortNo".
 */
static AddMyAddressesToCam(int PortNo)
{
	int	i;
	int	ret;

	for (i = 0; i < NumberOfSonicPort; i++)
	{
		if ((ret = snc_cam_add(PortNo, MyNid(i))) != 0)
			break;
	}
	return ret;
}

static char SpanningTreeAdd[] = {0x01, 0x80, 0xc2, 0x00, 0x00, 0x00};


/*
 *	Packet processing for the KERNEL.
 *	This function will be called by the sonic driver whenever
 *	there is at least a packet received.
 */
PollPacket()
{
	register SNCR *sncr;
	register SDV *sdvp;
	register DBD *dbd;
	register int PortNum;
	register int PortBit;
	register PKT *pp;

	if (!snc_init)
		return 0;

	ClearPortLedStatus();
	for(PortNum=0, PortBit = 1; PortNum < NumberOfSonicPort; PortNum++, PortBit <<= 1)
	{
	  chnl_receive(PortNum);
	}

	pp = (PKT *)GetFddiPkt();
	if(pp) {
		pp->pktDataPtr++;
		pp->pktDataSize  += 4;
		pp->pktTotalSize += 4;
		SendMessage((MSGHDR *)pp, (MBOX *)&ReceiveMbox);
	}
	return 0;
}

jmp_reset()
{
	Di();
	reset();
}

extern APPL apl;

log_reset()
{
	if ((apl.run_appl == APPL_BRIDGE) && (apl.inited[APPL_BRIDGE]))
	{
	printf("Log_Reset..\n");
	ReSchedule();
		RecordRst(RSTMSG3);
		}
}


call_packet_gen()
{
	PktGen();
}


LoadEeprom()

	{
	char	*nodate = "00-00-00";
        if(GetEeprom(EEP_HDR_ADDR, &Eeprom_header, EEP_HDR_SIZE) != EEPROM_AOK)
		   {
		   EepromError = 1;
		   printf("Error reading EEPROM header.\n");
		   memset(&Eeprom_header,0, sizeof(EEP_HDR));
		   Eeprom_header.eep_recs[0].offset = EEP_HDR_ADDR;
		   Eeprom_header.eep_recs[0].size = EEP_HDR_SIZE;
		   /*
		   Eeprom_header.eep_recs[1].offset = EEP_MFG_ADDR;
		   Eeprom_header.eep_recs[1].size =EEP_MFG_SIZE;
		   Eeprom_header.eep_recs[2].offset =EEP_BOOT_ADDR;
		   Eeprom_header.eep_recs[2].size =EEP_BOOT_SIZE;
			*/
			 }

	if(GetEeprom(EEP_MFG_ADDR, &eep_mfg_rec, EEP_MFG_SIZE) != EEPROM_AOK)
		{
		EepromError = 1;
		printf("EEPROM Error: Cannot read the manufacturer record\n");
		printf("Please run the TESTER to initialize the manufacturer record\n");
		memset(&eep_mfg_rec, 0, sizeof(EEP_MFG));
		Default_eep_mfg(); /* DEFAULT THE EEPROM FOR TIME BEING */
		}
	if (GetEeprom(EEP_BOOT_ADDR, &eep_boot_rec, EEP_BOOT_SIZE) != EEPROM_AOK)
		{
		EepromError = 1;
		memset(&eep_boot_rec, 0, sizeof(EEP_BOOT));
		strcpy(eep_boot_rec.eep_request_file, "h836");
		memcpy(eep_boot_rec.eep_BurnDate, nodate, 8);
		memcpy(eep_boot_rec.eep_BurnTime, nodate, 8);
		/*
		 *	Default to the transcevier if one is
		 *	there.
		 */
		eep_boot_rec.eep_ThinNet = 0;
		printf("EEPROM Error: Cannot read the BOOT record\n");
		}
}


Default_eep_mfg()
{
	MfgErrSetDefault();
#ifdef 0
	if (PutEeprom(EEP_MFG_ADDR, &eep_mfg_rec, EEP_MFG_SIZE) != EEPROM_AOK)
				printf("EEPROM Error: Cannot default the MFG record\n");
#endif
	return;

}

MfgErrSetDefault()
{
		printf("Defaulting the EEP mfg record.\n");
		memset(&eep_mfg_rec, 0, sizeof(EEP_MFG));
		eep_mfg_rec.eep_marker = 0;
		eep_mfg_rec.eep_sram_size = 0x80000;/* 512 K        */
		eep_mfg_rec.eep_dram_size =0x400000;   /* 4 M          */
		eep_mfg_rec.eep_shram_size =0x100000;   /* 1 M        */
		eep_mfg_rec.eep_nvram_size =0x20000;   /* 128 K        */
		eep_mfg_rec.eep_eeprom_size =0x2000;   /* 8 K          */
		eep_mfg_rec.eep_fprom_size =0xc0000;  /* 786 K          */
				
		SetEEP_FDDIDefaults();
}

PutEEP_MFG()
{
	if (PutEeprom(EEP_MFG_ADDR, &eep_mfg_rec, EEP_MFG_SIZE) != EEPROM_AOK)
				printf("EEPROM Error: Cannot default the MFG record\n");
}
PutEEP_BOOT()
{
	if (PutEeprom(EEP_BOOT_ADDR, &eep_boot_rec, EEP_BOOT_SIZE) != EEPROM_AOK)
				printf("EEPROM Error: Cannot default the BOOT record\n");
}
PutEEP_HDR()
{
	if (PutEeprom(EEP_HDR_ADDR, &Eeprom_header, EEP_HDR_SIZE) != EEPROM_AOK)
				printf("EEPROM Error: Cannot default the HDR record\n");
}
InitSnmp()

	{
	static	int initd = 0;


	if (initd == 0)
		{
		if (udp_open(UDP_SNMP, SnmpUpCall, 0) == NULL)
			{
			printf("Error: cannot open SNMP port\n");
			return 0;
			}
		initd++;
		}
	if (init_snmp() == -1)
		{
		printf("Error: cannot init SNMP\n");
		return 0;
		}
	CreatSemaphore(&NotInSnmpStack, 1);
	CreatSemaphore(&SwUpdateFromSnmp, 0);
	return 1;
	}

/*
 * name		SnmpUpCall	snmp receive upcall
 *
 * synopsis	SnmpUpCall(pkt, length, fhost, sport, dport, tag)
 *		PACKET	pkt; <<		incoming packet
 *		int	length; <<	of snmp data in "pkt".
 *		in_name	fhost; <<	"pkt" is from this host, the 
 *					snmp server
 *		uint	sport; <<	"pkt" is from this port number
 *		uint	dport; <<	"pkt" is to this port number
 *		void	tag; <<		unused
 *		in_name	lhost; <<	ip address of the receiver, me
 *
 * description	This is called by the udp module when a snmp 
 *		packet is received.  
 *
 * returns	nothing
 */

static void SnmpUpCall(pkt, length, fhost, sport, dport, tag, lhost)
PACKET	pkt;		/*	receiving packet		*/
int	length;		/*	of data in number of bytes	*/
in_name	fhost;		/*	ip address of the sender	*/
uint	sport;		/*	source port			*/
uint	dport;		/*	destination port		*/
void	*tag;		/* 	not used			*/
in_name	lhost;

	{
	/*
	 *	Make sure there is only one task in the
	 *	snmp stack at any one time. 
	 */
	RcvSignal(&NotInSnmpStack);
	proc_snmp_pkt(fhost, sport, dport, pkt->nb_prot, length, lhost);
	in_free(pkt);
	/*
	 *	We have finished with the snmp stack,
	 *	we have to wake up any task waiting to 
	 *	get into the snmp stack.
	 */
	SendSignal(&NotInSnmpStack);
	}

MyBootpServer()
	{
	return eep_boot_rec.eep_BootpServer;;
	}

MyBootFilename(char *buffer, int buflen)
	{
	strncpy(buffer, eep_boot_rec.eep_request_file, buflen);
	buffer[buflen - 1] = '\0';
	}

MyDeviceName(char *name, int namelen)
	{
	strncpy(name, Nim960Header.name, namelen);
	name[namelen - 1] = '\0';
	}

MyDeviceDescription(char *device, int devicelen)
	{
	sprintf(device, "Hughes LAN System %s Version %s", Nim960Header.name,
		Nim960Header.version);
	}

InitAdmConMap(char map[])
	{
	/*
	 *	I connect to all 3 ethernets
	 */
	map[1] = map[2] = map[3] = 1;
	}

PowerRequired()
	{
	return 55;	/* watts	*/
	}

MySnmpCommunity(char *community, int len)
	{
	uchar	*pw = (uchar *)BridgeStatus->ConsolePassword;

	if (strlen(pw) < len)
		{
		while(*pw != 0)
			{
			*community++ = ~*pw++;
			}
		}
	*community = '\0';
	}

ifEntryInit(IF_ENTRY *ifp, int number) {

	
	int	i;

	/*
	 *	The last interface is the admin. bus port
	 */
	memset(ifp, '\0', sizeof(IF_ENTRY) * number);
	for (i = 0; i < 3; i++, ifp++) {
		
		/*
		 *	These are all sonic port.
		 */
		sprintf(ifp->ifname, "Internal Ethernet Segment %d", i + 1);
		ifp->ifType = 6;	/* ethernet	*/
		ifp->ifMtu = 1500;
		ifp->ifSpeed = 10000000;
		ncopy(ifp->ifPhysAddress, MyNid(i));
		ifp->ifAdminStatus = UP;
		ifp->ifOperStatus = UP;
	}

	/*
	** FDDI PORT
	**
	*/
	strcpy(ifp->ifname, "FDDI Port");
	ifp->ifType = 15;	/* FDDI	*/
	ifp->ifMtu = 1500;
	ifp->ifSpeed = 100000000;
	ncopy(ifp->ifPhysAddress, MyNid(i));
	ifp->ifAdminStatus = UP;
	ifp->ifOperStatus = UP;
	ifp++;

	/*
	 *	The admin bus port
	 *	There is no mac address for the admin bus
	 */

	strcpy(ifp->ifname, "HLS Admin Bus");
	ifp->ifType = 1;	/* other	*/
	ifp->ifMtu = 512;
	ifp->ifSpeed = 8000000;
	ifp->ifAdminStatus = UP;
	ifp->ifOperStatus = UP;
	AdmIfentry = ifp;
}

IsPacketForMe(DBD *d)  {

	/*
	 *	If I am in the boot-up stage. I'll accept any packet if
	 *	it matches any one of my MAC addresses.
	 *	Otherwise, I'll accept the packet if it matches
	 *	the MAC address of the incoming port.
	 */
	if (!InBootStage)
		{
		if(ncompare(d->db_buffer, MyNid(d->db_rcvportno)))
			return TRUE;
		else
		if(d->db_rcvportno == 3) {
			return ncompare(d->db_buffer, &Port4EthNid[0]);	
		}
		else
			return FALSE;
		}
	else {
		return IsMyNid(d->db_buffer, d->db_rcvportno);
	}
}

/*
 *	Initialise the network drivers
 */
InstallSonic(int (*UpCall)(), int PromiscuousMode)
{
	int	ret = 0;
	int	PortNo;
	int	PortsFailed = 0;      /* How many ports have failed */
    int mode;
	int	i;

	Di();
	/*
	 *	Config the sonic driver and init the
	 *	dbd buffer management.
	 */
	
	set_leds(LED_MONO, LED_MONO_COLOR, 0xff);
    
     /* put some delay */
    for(i=0;i<0xfffe;i++)
        ;

    /* Do ethernet ports only */
	chnl_config(0,PromiscuousMode,0x50000000,0x70000080);
	chnl_config(1,PromiscuousMode,0x50010000,0x70000100);
	chnl_config(2,PromiscuousMode,0x50020000,0x70000180); 

	for(i=0;i<NumberOfSonicPort;i++)
	{
	    ret=chnl_start(i);
	} 

	if (!PromiscuousMode)
	{
		for (PortNo = 0; PortNo < NumberOfSonicPort; PortNo++)
		{
			if (AddMyAddressesToCam(PortNo) != 0 || 
				chnl_cam_add(PortNo, ETBROADCAST) != 0 )
		/*		chnl_cam_add(PortNo, SpanningTreeAdd) != 0) */
				PortsFailed++;
		}
	}

	chnl_set_upcall(UpCall);
	
	pkt_proc_upcall = UpCall;
	

	snc_init=1;
	
	Ei();
	/*
	 *	Return ok if at least one port is
	 *	working.
	 */
	return PortsFailed == SV_NMBR_PORT ? 1 : 0;
}



/* NVR_FDDI nvr_fddi_rec; */
/* extern int nvr_fddi_rec; */
Load_FebConfiguration()
{

	LoadEeprom();
	if( InitNvram(NVRAM, eep_mfg_rec.eep_nvram_size) != NVRAM_AOK )
		printf("NVRAM Error: Cannot init NVRAM\n");

	if( GetFDDIRec(&nvr_fddi_rec) != NVRAM_AOK)
		PutFDDIRec(&nvr_fddi_rec);
#ifdef notdef
	if (Nvram_Load(NVR_FDDI_ADDR, &nvr_fddi_rec, NVR_FDDI_SIZE) != NVRAM_AOK)
        {
		printf("NVRAM Error: Cannot read the FDDI record\n");
		setNVRAM_FDDIDefaults();
		if(Nvram_Updt(NVR_FDDI_ADDR, &nvr_fddi_rec, NVR_FDDI_SIZE) != NVRAM_AOK)
			printf("NVRAM Error: Cannot default the FDDI record\n");
		}
#endif

	return;
}

void fs_dummy(int i) {

	if(i == 1)
		putchar('1');
	else
	if(i==2)
		putchar('2');
	else
	if(i==3)
		putchar('3');
	else
	if(i==4)
		putchar('4');
	else
		putchar('f');
}	

Init_offline_phys() {
}
