#include <krnl.h>
#include <types.h>
#include <ether.h>
#include <error.h>
#include <netbuf.h>
#include <tcpip.h>
#include <pkt.h>
#include "/b/gregs/fddi/fddicon/drv/include/bsi.h"

extern ushort chnl_flk_rx_led;
extern ushort chnl_flk_tx_led;
extern unsigned int Fddi_Rcv_Pkt;
extern BSI_ADDR_TYPE bsi_dev[];
#define	BSI_NUM	0

/*-------------------------------------------------------------------
* Used by both protocol stack and bridging module
* Return:
*	0 if ok
*	1 otherwise
*-------------------------------------------------------------------*/
fddi_transmit_pkt( pp, dummy )
PKT	*pp;
int dummy;
{
	extern unsigned drv_init_flag;
     register BSI_REQCH_TYPE *ch_ptr;
	 register uint32 ch_num;

	if(!drv_init_flag) {
	   
		/* Free chained pkt if it exists */
		if(pp->pktBufLink)
			((pp->pktBufLink)->pktFree)(pp->pktBufLink);

		/* Now free the pkt */
		pp->pktFree(pp);
		return(0);
	}

	pp->pktXmtPort &= ~0x08;
	/*
	* send with mac 0, async
	*/
	chnl_flk_tx_led |= 0x08;
#ifdef FS_PERF
	DRV_SendFrameBr(pp, 8);
#endif
	 #define BR_MAC_NUM      0       /* fddi-eth bridge only has one MAC */

	 ch_ptr = bsi_dev->rch0;
	 if (ch_ptr->info_ptr->queued_cnt >= BSI_QUEUE_MAX_SLOT) {
		  ch_ptr = bsi_dev->rch1;
		 if (ch_ptr->info_ptr->queued_cnt >= BSI_QUEUE_MAX_SLOT) {
			FreePktBuf(pp);
			return ERR_NORSRC;
						   /* both queues full */
		 }
	}  

	return (BSI_SendReq(8,BR_MAC_NUM,ch_ptr,pp,TRUE));
}

/*-------------------------------------------------------------------
* PKT *GetFddiPkt()
*-------------------------------------------------------------------*/

PKT *GetFddiPkt()
{
	register PKT* pp = 0;
	static int GetOneRx_cnt = 0;
	extern unsigned drv_init_flag;

	
	if(!drv_init_flag)
	    return(pp);


	if( GetOneRx_cnt++ < 1 )	 {
		pp = (PKT *)RxLLCFrameIsr(BSI_NUM);

	}

	if( !pp ) {
		GetOneRx_cnt=0;
		/* get a rcvd ch2 frame from FDDI */
		pp = (PKT *)DRV_GetOneRxPkt(BSI_NUM);
		if(pp)
		  Fddi_Rcv_Pkt++;    /* Count Rcv Uni-Cast Frames */
	}


	if( pp )		/* if we got one */
	{
	  chnl_flk_rx_led  |= 0x08;
	  pp->pktRcvPort    = 0x03;
	  pp->pktDataPtr   -= 1;
	}

	return( pp );
}	

void ProcessFddiFrames() {

	extern BSI_ADDR_TYPE bsi_dev[];
	volatile BSI_REG_TYPE *r_ptr;
	register byte mar, rar;

	r_ptr = bsi_dev[BSI_NUM].base_addr;
	mar = r_ptr->mar;

	if (mar & BSI_MAR_NSA)    /* take care of the BSI no space attention */
		NoSpaceAtten(BSI_NUM,r_ptr);
 
	BSI_ProcessCNF(BSI_NUM);

	/* take care of the request attention */
	if (mar & BSI_MAR_RQA) {
		rar = r_ptr->rar;
		ReqAttenISR(BSI_NUM,r_ptr,rar);
	}
}
