/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      cmdtree.c
*
*       $Log:   /b/gregs/bridge/declike/main/cmdtree.c_v  $
 * 
 *    Rev 1.10   12 Oct 1993 10:25:12   vinay
 * added a branch for hls smem
 * 
 *    Rev 1.9   07 Sep 1993 18:59:16   gregs
 * lsh 9/07/93 Changed the minimum length required for some commands.
 * 
 *    Rev 1.8   03 Sep 1993 11:42:56   vinay
 * changed the kw length to conform with the ERS and removed the def fddi mac
 * tpri command
 * 
 *    Rev 1.7   20 Aug 1993 11:19:40   gregs
 * 
 *    Rev 1.6   29 Jul 1993 17:32:04   gregs
 * lsh jul-29-93 Removed fddi_interface_br[] and put the sub-branches under
 * define_fddi_br directly.
 * 
 *    Rev 1.5   29 Jul 1993 16:32:34   vinay
 * 
 *    Rev 1.4   28 Jun 1993 16:38:28   vinay
 * made changes to clear fddi traffic command branch
 * 
 *    Rev 1.3   11 Jun 1993 12:05:48   vinay
 * added the ring command
 * 
 *    Rev 1.2   03 Jun 1993 18:34:48   vinay
 * end of day checkin
 * 
 *    Rev 1.1   10 May 1993 17:52:44   vinay
 * Added FDDI support
 * 
 *    Rev 1.0   04 May 1993 16:03:26   franks
 * Initial revision.
 * 
 *    Rev 1.5   14 May 1992 09:14:38   franks
 * 1). Split cl mod ipaddress -> cl mod ip address
 * 
 *    Rev 1.4   13 May 1992 14:49:36   franks
 * 1). Lots of changes made. The command syntax for the following is now
 *     different, define brg iprouter -> primary router & secondary router
 *     serverIP -> tftp server, requestfile -> request file
 *     tftp -> load, show bri tftp -> sh bri load parameters ,
 *     bootpreq -> bootp, def bri aui -> def port 4 ext inf 
 * 
 *    Rev 1.3   04 May 1992 12:18:38   franks
 * No change
 * 
 *    Rev 1.2   16 Apr 1992 15:43:50   pvcs
 * No change.
 * 
 *    Rev 1.1   14 Apr 1992 13:07:44   franks
 * 1). Added support for hidden command for the windows console.
 * 2). Added new hidden command to display hidden command help info.
 * 3). Added new hidden command to jump to the kernel menu. gokrnl.
*
*       Comments:      Developed for i960 platform.
*                      	
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		
******************************************************************************/
#include <types.h>
#include <krnl.h>
#include <dbd.h>
#include <cpb.h>
#include <priv_tbl.h>
#include <cmdtree.h>

/* EXTERNAL FUNCTION DEFINITIONS */
extern int root_help();
extern int SetDate();
extern int define();
extern int diag();
extern int Exit();
extern int Echo();

extern int InitBrg();
extern int Modify();
extern int PktUtil();
extern int Ping();
extern int Save();
extern int show_brg();
extern int Tester();
extern int Tftp();
extern int SetTime();

/* THE SHOW BRANCH */
extern int STPStatusScreen();

/* THE SHOW DATABASE BRANCH */
extern int ShowDBSaved();
extern int ShowDBStatus();
extern int ShowDBWorking();

/* SHOW BRIDGE BRANCH */
extern int ShowBrgActivity();
extern int ShowAlarmMgr();
extern int ShowBrgStatus();
extern int ShowBrgLog();
extern int ShowBitMask();
extern int ShowBrgContact();
extern int ShowBrgIP();
extern int ShowBrgLocation();
extern int ShowBrgName();
extern int ShowBrgRLog(); 
extern int ShowBrgSNMP();
extern int ShowBrgTftp(); 
extern int ShowBrgTraffic();
extern int ShowBrgUDPFilter();

extern int ShowFddiMac();
extern int ShowFddiPath();
extern int ShowFddiPorts();
extern int ShowSmt();
extern int ShowBrgFddi();
/********************************/
/* THE SHOW PORT BRANCH 	*/
/********************************/
extern int ShowPortFilAddr(); 
extern int ShowPortFilBitmask(); 
extern int ShowPortFilProt();
extern int ShowPortLearn();
extern int ShowPortPacSize();
extern int ShowPortState();
extern int ShowPortStatus();
extern int ShowPortThreshold();

/* DEFINE BRANCH */
extern int DefineDB();

/* DEFINE BRIDGE BRANCH */
extern int DefineBrg();
extern int DefineAlarmMgr();
extern int DefineBrgAutoCfg();
extern int DefineBrgAuthent();
extern int DefineBrgBMDefine();
extern int DefineBrgCfgFile();
extern int DefineBrgContact(); 
extern int DefineBrgIPAddr();
extern int DefineBrgPrimaryRouter();
extern int DefineBrgSecondaryRouter();
extern int DefineBrgLocation(); 
extern int DefineBrgName(); 
extern int DefineBrgNetMask(); 
extern int DefineBrgRqstFile();
extern int DefineBrgSrvrIP();
extern int DefineBrgStpMode();
extern int DefineBrgSymbolic();
extern int DefineBrgTerminal();
extern int DefineBrgTimeOut();
extern int DefineBrgUDPFilter();
extern int DefineBrgRing();

/* DEFINE PORT BRANCH */
extern int DefinePort();
extern int DefinePortBlock();
extern int DefinePortPacSize();
extern int DefinePortLearn();
extern int DefinePortPacSize();
extern int DefinePortPermit();
extern int DefinePrtProt();
extern int DefinePrtBitmask();
extern int DefinePortRestrict();
extern int DefinePortState();
extern int DefinePortThrshld();
extern int DefinePortUnkMCast();
extern int DefinePortUnkUCast();
extern int DefinePortExternal();

/* DEFINE STP BRANCH */
extern int DefineStpBrgPriority();
extern int STP_dft_rst();
extern int DefineStpForward();
extern int DefineStpHello();
extern int DefineStpLifeTime();
extern int DefineStpPathCost();
extern int DefineStpPortPriority();

/* CLEAR BRANCH */
extern int ClearDataBase();

/* CLEAR BRIDGE BRANCH */
extern int ClearBrgBMask();
extern int ClearBrgContact();
extern int ClearBrgIPAddr(); 
extern int ClearBrgLocation();
extern int ClearBrgLog();
extern int ClearBrgName();
extern int ClearBrgRLog();

extern int ClearSmtConn();
extern int defFddiPort();
extern int defineFddiIntPath();
extern int DefineFddiPortAction();
extern int DefineFddiAttachPolicy();
extern int DefineFddiConnPolicies();
extern int DefineFddiPortType();
extern int DefineFddiPortMacLoop();
extern int DefineFddiLerAlarm();
extern int DefineFddiLerCutoff();
extern int DefineFddiPortMalineSt();
extern int DefineFddiPortTbMax();
extern int DefFddiMacAction();
extern int DefFddiTraceMax();
extern int DefFddiT_Max();
extern int DefFddiTvx();
extern int DefFddiLatency();
extern int DefFddiRmode();
extern int DefFddiMacFrameErrTh();
#ifdef notdefined
extern int DefFddiMacFrameSta();
#endif
extern int DefFddiMacNotCopiedTh();
extern int DefFddiMacPath();
extern int DefFddiMacState();
extern int DefFddiMacStripping();
extern int DefFddiMacT_Max();
extern int DefFddiMacT_Min();
extern int DefFddiMacT_Pri();
extern int DefFddiMacT_Req();
extern int DefFddiMacTvx();
extern int DefineModSMTConfig();
extern int DefineModSMTConn();
extern int DefineModSMTOPversion();
extern int DefineModSMTReport();
extern int DefineModSMTT_Notify();
extern int DefineModSMTUserData();

/*********/
extern int ClearBrgTraffic();
extern int ClearBrgUDP();
extern int ClearFddiTrafficCounters();

/* CLEAR PORT BRANCH */
extern int ClearPortProtocol();
extern int ClearPortBMExpr();

/* THE HLS BRANCH of hidden commands */
extern int GoDebug();
extern int ShowArp();
extern int FlushArp();
extern int GoKernel();
extern int HiddenHlp();
extern int WinPortStatusScrn();
extern int ShowMemory();
extern int WinVendorProtocols();
extern int WinUserProtocols();
extern int WinPortTraffic();

/* EXTERNAL STRUCTURE AND VARIABLE DEFINITIONS */
extern CMDNODE_T root_br[];
extern CMDNODE_T help_br[];
extern CMDNODE_T show_br[];
extern CMDNODE_T clear_br[];
extern CMDNODE_T clear_brg_br[];
extern CMDNODE_T clear_mod_br[];
extern CMDNODE_T clear_mod_smt_conn[];
extern CMDNODE_T clear_brg_smt_conn[];
extern CMDNODE_T define_br[];
extern CMDNODE_T define_port_br[];
extern CMDNODE_T define_stp_br[];
extern CMDNODE_T save_db[];
extern CMDNODE_T show_port_br[];
extern CMDNODE_T hls_br[];

extern CMDNODE_T show_fddi_br[];
extern CMDNODE_T define_fddi_br[];
extern CMDNODE_T fddi_port_br[];
extern CMDNODE_T fddi_interface_br[];
extern CMDNODE_T fddi_mac_br[];
extern CMDNODE_T fddi_path_br[];
extern CMDNODE_T def_mod_smt[];
extern CMDNODE_T def_brg_smt[];
/****************************************/
/* THE ROOT BRANCH 			*/ 
/****************************************/
extern char TROOT_HELP[]; 
extern char TCLEAR[];  
extern char TDATE[];
extern char TDEFINE[];
extern char TDIAG[]; 
extern char TEXIT[];
/**********/
extern char TECHO[];
/********************/
extern char THELP[];
extern char TINIT[];
extern char TTFTP[];
extern char TLOGOUT[];
extern char TMODIFY[];
extern char TPKTUTL[];
extern char TPASSWD[];
extern char TPING[];
extern char TSAVE[];
extern char TSHOW[];
extern char TTIME[];

/* THE SHOW BRANCH */
extern char TSBRIDGE[];
extern char TSDATABASE[];
extern char TSPORT[];
extern char TSTP[];

extern char TDFDDI[];
extern char TSFDDIMAC[];
extern char TSFDDIPATH[];
extern char TSFDDIPORTS[];
/****************************/

/* THE SHOW BRIDGE BRANCH */
extern char TACTIVITY[];
extern char TALARMMGR[];
extern char TBITMASK[];
extern char TCONTACT[]; 
extern char TIP[];
extern char TLOCATION[];
extern char TLOG[];   
extern char TMSGLOG[]; 
extern char TNAME[];
extern char TRLOG[];
extern char TSNMP[];
extern char TSTATUS[];
extern char TSTFTP[];
extern char TTRAFFIC[];
extern char TUDPDIR[];

extern char TCSMTCONN[];
extern char TCLEARSMTCONN[];
extern char TSMT[];
extern char TFDDI[];
/******************************/

/* THE SHOW DATABASE BRANCH */
extern char TDSAVED[];
extern char TDSTATUS[];
extern char TDWORK[];

/* THE SHOW PORT BRANCH */
extern char TPFILTER[];
extern char TPLEARN[];
extern char TPPACSIZE[];
extern char TPSTATE[];
extern char TPSTATUS[];   
extern char TPTHRESHOLD[];

/* THE SHOW PORT FILTER BRANCH */
extern char TPFADDRESS[];
extern char TPFPROTOCOL[];
extern char TPFBITMASK[];

/* THE DEFINE BRANCH */
extern char TDBRIDGE[];
extern char TDDATABASE[];
extern char TDSTP[];

/* THE DEFINE BRIDGE BRANCH */
extern char TDALARMMGR[];
extern char TDSMT[];
extern char TSFDDI[];
extern char TDRING[];
/***********************/
extern char TDAUI[];
extern char TDAUTHENT[];
extern char TBMASK[];
extern char TDBOOTPREQ[];
extern char TDCFGFILE[];
extern char TDCONTACT[];
extern char TDIPADDRESS[];
extern char TDPRIROUTER[];
extern char TDSECROUTER[];
extern char TDLOCATION[];
extern char TDNAME[];
extern char TDNETMASK[];
extern char TDPASSWORD[];
extern char TDRQSTFILE[];
extern char TDSRVRIP[];
extern char TDSTPMODE[];
extern char TDSYMBOLIC[];
extern char TDTERM[];
extern char TTIMEOUT[];
extern char TDUDPFILTER[];

/* THE DEFINE PORT BRANCH */
extern char TDPORT[];
extern char TDBLOCK[];
extern char TDLEARN[];
extern char TDPACSIZE[];
extern char TDPERMIT[];
extern char TDRESTRICT[];
extern char TDSTATE[];
extern char TDTHRESHLD[];
extern char TDUNKMCAST[];
extern char TDUNKUCAST[];
extern char TDPROTOCOL[];
extern char TDBITMASK[];
extern char TPPROTOCOL[];
extern char TPBITMASK[];

/* THE DEFINE STP BRANCH */
extern char TDSBRGPRI[];
extern char TDSDEFAULT[];
extern char TDSFORW[];
extern char TDSHELLO[];
extern char TDSLIFE[];
extern char TDSPATHCOST[];
extern char TDSPORTPRI[];

/* THE CLEAR BRANCH */
extern char TCBRIDGE[];
extern char TCDATABASE[];
extern char TCPORT[];
extern char TCFDDITRAFFIC[];

/* THE CLEAR BRIDGE BRANCH */
extern char TCBITMASK[];
extern char TCCONTACT[];
extern char TCIPADDRESS[];
extern char TCIPROUTER[];
extern char TCLOCATION[];
extern char TCLOG[];
extern char TCMSGLOG[];
extern char TCNAME[];
extern char TCNETMASK[];
extern char TCRLOG[];
extern char TCTRAFFIC[];
extern char TCUDP[];

/* THE CLEAR PORT BRANCH */
extern char TCPROTOCOL[];
extern char TCBMEXPR[];

/* THE SAVE DATABASE BRANCH */
extern char TSDB[];

extern char TDEFINTERFACE[];
extern char TDEFPORT[];
/*****************************************************
	fddi_port_br
******************************************************/
extern char TDSACTION[];
extern char TDSATTACHMENT[];
extern char TDSCONNECTION[];
extern char TDSFDDIPORT[];
extern char TDSPORTMAC[];
extern char TDSLERALARM[];
extern char TDSLERCUTOFF[];
extern char TDSMAINTLINESTATE[];
extern char TDSTB_MAX[];

/*******************************************
	fddi_mac_br
********************************************/
extern char TDSFRAMEERRTH[];
extern char TDSFRAMESTATUS[];
extern char TDSFDDIMACACTION[];
extern char TDSNOTCOPIED[];
extern char TDSMACPATHREQ[];
extern char TDSMACSTATE[];
extern char TDSMACSTRIPPING[];
extern char TDSMACT_MAX[];
extern char TDSMACT_MIN[];
extern char TDSMACT_PRI[];
extern char TDSMACT_REQ[];
extern char TDSMACTVX[];

/***********************************************
	fddi_path_br
***********************************************/
extern char TDSTRACE_MAX[];
extern char TDST_MAX[];
extern char TDSTVX[];
extern char TDSLATENCY[];
extern char TDSRMODE[];

/***********************************************
	def_mod_smt
***********************************************/
extern char TDSSMTCONFIG[];
extern char TDSSMTCONN[];
extern char TDSSMTOPVER[];
extern char TDSSMTREPORT[];
extern char TDSSMTT_NOTIFY[];
extern char TDSSMTUSERDATA[];

/**************************/

/* THE HLS BRANCH of hidden commands */
extern char HDEBUG[];
extern char HSHARP[];
extern char HSHMEM[];	/* show memory */
extern char HFLArp[];
extern char HGOKRNL[];
extern char HPRTST[];     /* Win Port Status Screen */
extern char HVPROTS[];    /* Win Vendor Protocols   */
extern char HUPROTS[];    /* Win User Protocols     */
extern char HPRTRFIC[];   /* Win Port Traffic Cnts  */



/***************************************************************************
NAME: Cmd_Tree

PURPOSE: The following data structure represents the command tree
****************************************************************************/


/********************************************************
**
**     SHOW BRIDGE BRANCH
**
*********************************************************/
CMDNODE_T show_brg_br[] = {

   /*
   {SACTIVITY, 0, PROOT_HELP,ShowBrgActivity,TACTIVITY,
     (char *)&show_br[SHOW_BRG_IDX],0,PARM_OPT,0,2,0x0,0},
   */

   {SBITMASK, 0, PROOT_HELP, ShowBitMask,TBITMASK,
     (char *)&show_br[SHOW_BRG_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {SCONTACT, 0, PROOT_HELP,ShowBrgContact ,TCONTACT,
     (char *)&show_br[SHOW_BRG_IDX],0,NEED_NO_PARM,0,4,0x0,0},

   {SFDDI, STRAFFIC, PROOT_HELP,ShowBrgFddi ,TFDDI,
     (char *)&show_br[SHOW_BRG_IDX],0,NEED_NO_PARM,2,2,0x0,0},

   {SIP, 0, PROOT_HELP,ShowBrgIP ,TIP,
     (char *)&show_br[SHOW_BRG_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {SLOAD, SPARAM, PROOT_HELP,ShowBrgTftp ,TSTFTP,
     (char *)&show_br[SHOW_BRG_IDX],0,NEED_NO_PARM,0,3,0x0,0},

   {SLOCATION, 0, PROOT_HELP,ShowBrgLocation ,TLOCATION,
     (char *)&show_br[SHOW_BRG_IDX],0,NEED_NO_PARM,0,3,0x0,0},

   {SLOG, 0, PROOT_HELP,ShowBrgLog ,TLOG,     /* reset log */
     (char *)&show_br[SHOW_BRG_IDX],0,NEED_NO_PARM,0,3,0x0,0},

   {SNAME, 0, PROOT_HELP,ShowBrgName ,TNAME,
     (char *)&show_br[SHOW_BRG_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {SRLOG, 0, PROOT_HELP,ShowBrgRLog ,TRLOG,    /* relearn log */
     (char *)&show_br[SHOW_BRG_IDX],0,PARM_OPT,0,2,0x0,0},

   {SSNMP, 0, PROOT_HELP,ShowBrgSNMP ,TSNMP,
     (char *)&show_br[SHOW_BRG_IDX],0,NEED_NO_PARM,0,4,0x0,0},

   {SSNMPMGR, 0, PROOT_HELP,ShowAlarmMgr,TALARMMGR,
     (char *)&show_br[SHOW_BRG_IDX],0,NEED_NO_PARM,0,5,0x0,0},

   {SSMT, 0, PROOT_HELP,ShowSmt,TSMT,
     (char *)&show_br[SHOW_BRG_IDX],0,NEED_NO_PARM,0,3,0x0,0},

   {SSTATUS, 0, PROOT_HELP,ShowBrgStatus ,TSTATUS,
     (char *)&show_br[SHOW_BRG_IDX],0,NEED_NO_PARM,0,4,0x0,0},

   {STRAFFIC, 0, PROOT_HELP,ShowBrgTraffic ,TTRAFFIC,
     (char *)&show_br[SHOW_BRG_IDX],0,PARM_OPT,0,2,0x0,0},

   {SUDPDIR, 0, PROOT_HELP,ShowBrgUDPFilter ,TUDPDIR,
     (char *)&show_br[SHOW_BRG_IDX],0,NEED_NO_PARM,0,2,0x0,0},

	{0}
	};

/********************************************************
**
**     SHOW MODULE BRANCH
**
*********************************************************/
CMDNODE_T show_mod_br[] = {

   /*
   {SACTIVITY, 0, PROOT_HELP,ShowBrgActivity,TACTIVITY,
     (char *)&show_br[SHOW_MOD_IDX],0,PARM_OPT,0,2,0x0,0},
   */

   {SBITMASK, 0, PROOT_HELP, ShowBitMask,TBITMASK,
     (char *)&show_br[SHOW_MOD_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {SCONTACT, 0, PROOT_HELP,ShowBrgContact ,TCONTACT,
     (char *)&show_br[SHOW_MOD_IDX],0,NEED_NO_PARM,0,4,0x0,0},

   {SFDDI, STRAFFIC, PROOT_HELP,ShowBrgFddi ,TFDDI,
     (char *)&show_br[SHOW_MOD_IDX],0,NEED_NO_PARM,2,4,0x0,0},

   {SIP, 0, PROOT_HELP,ShowBrgIP ,TIP,
     (char *)&show_br[SHOW_MOD_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {SLOAD, SPARAM, PROOT_HELP,ShowBrgTftp ,TSTFTP,
     (char *)&show_br[SHOW_MOD_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {SLOCATION, 0, PROOT_HELP,ShowBrgLocation ,TLOCATION,
     (char *)&show_br[SHOW_MOD_IDX],0,NEED_NO_PARM,0,3,0x0,0},

   {SLOG, 0, PROOT_HELP,ShowBrgLog ,TLOG,     /* reset log */
     (char *)&show_br[SHOW_MOD_IDX],0,NEED_NO_PARM,0,3,0x0,0},

   {SNAME, 0, PROOT_HELP,ShowBrgName ,TNAME,
     (char *)&show_br[SHOW_MOD_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {SRLOG, 0, PROOT_HELP,ShowBrgRLog ,TRLOG,    /* relearn log */
     (char *)&show_br[SHOW_MOD_IDX],0,PARM_OPT,0,2,0x0,0},

   {SSNMP, 0, PROOT_HELP,ShowBrgSNMP ,TSNMP,
     (char *)&show_br[SHOW_MOD_IDX],0,NEED_NO_PARM,0,4,0x0,0},

   {SSNMPMGR, 0, PROOT_HELP,ShowAlarmMgr,TALARMMGR,
     (char *)&show_br[SHOW_MOD_IDX],0,NEED_NO_PARM,0,5,0x0,0},

   {SSMT, 0, PROOT_HELP,ShowSmt,TSMT,
     (char *)&show_br[SHOW_MOD_IDX],0,NEED_NO_PARM,0,3,0x0,0},

   {SSTATUS, 0, PROOT_HELP,ShowBrgStatus ,TSTATUS,
     (char *)&show_br[SHOW_MOD_IDX],0,NEED_NO_PARM,0,4,0x0,0},

   {STRAFFIC, 0, PROOT_HELP,ShowBrgTraffic ,TTRAFFIC,
     (char *)&show_br[SHOW_MOD_IDX],0,PARM_OPT,0,2,0x0,0},

   {SUDPDIR, 0, PROOT_HELP,ShowBrgUDPFilter ,TUDPDIR,
     (char *)&show_br[SHOW_MOD_IDX],0,NEED_NO_PARM,0,2,0x0,0},

	{0}
	};

/********************************************************
**
**     SHOW DATABASE BRANCH
**
*********************************************************/
CMDNODE_T show_databs_br[] = {

   {SDSAVED, 0, PROOT_HELP,ShowDBSaved,TDSAVED,
     (char *)&show_br[SHOW_DB_IDX],0,PARM_OPT,0,2,0x0,0},

   {SDSTATUS, 0, PROOT_HELP,ShowDBStatus,TDSTATUS,
     (char *)&show_br[SHOW_DB_IDX],0,NEED_NO_PARM,0,4,0x0,0},

   {SDWORK, 0, PROOT_HELP,ShowDBWorking,TDWORK, 
	 (char *)&show_br[SHOW_DB_IDX],0,PARM_OPT,0,2,0x0,0},

	{0}
};

/*********************************************************
**
**     SHOW PORT FILTER BRANCH 
**
*********************************************************/

CMDNODE_T show_prt_fil[] = {

   {SPFADDRESS, 0, PROOT_HELP,ShowPortFilAddr ,TPFADDRESS,
   	(char *)&show_port_br[SHOW_PRT_FIL_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {SPFBITMASK, 0, PROOT_HELP,ShowPortFilBitmask ,TPFBITMASK,
   	(char *)&show_port_br[SHOW_PRT_FIL_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {SPFPROTOCOL, 0, PROOT_HELP,ShowPortFilProt ,TPFPROTOCOL,
   	(char *)&show_port_br[SHOW_PRT_FIL_IDX],0,NEED_NO_PARM,0,2,0x0,0},

	{0}
};

/*********************************************************
**
**     SHOW PORT BRANCH 
**
*********************************************************/

CMDNODE_T show_port_br[] = {

   {SPFILTER, 0, PROOT_HELP,0 ,TPFILTER,
       (char *)&show_br[SHOW_PORT_IDX],(char *)show_prt_fil,
       MORE_TO_COME,0,2,0x0,0},

   {SPLEARN, 0, PROOT_HELP,ShowPortLearn ,TPLEARN,
     (char *)&show_br[SHOW_PORT_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {SPPACSIZE, 0, PROOT_HELP,ShowPortPacSize ,TPPACSIZE,
     (char *)&show_br[SHOW_PORT_IDX],0,NEED_NO_PARM,0,3,0x0,0},

   {SPSTATE, 0, PROOT_HELP,ShowPortState ,TPSTATE,
     (char *)&show_br[SHOW_PORT_IDX],0,NEED_NO_PARM,0,5,0x0,0},

   {SPSTATUS, 0, PROOT_HELP,ShowPortStatus ,TPSTATUS,
     (char *)&show_br[SHOW_PORT_IDX],0,PARM_OPT,0,4,0x0,0},

   /*
   {SPTHRESHOLD, 0, PROOT_HELP,ShowPortThreshold ,TPTHRESHOLD,
     (char *)&show_br[SHOW_PORT_IDX],0,PARM_OPT,0,2,0x0,0},
   */
	{0}
};

/***************************************************************************
	THE DEFINE BRIDGE BRANCH 
****************************************************************************/
CMDNODE_T define_brg_br[] = {

   /*
   {DAUTHENT, 0, PROOT_HELP,0,TDAUTHENT,
     (char *)&define_br[DEF_BRG_IDX],0,NEED_NO_PARM,0,2,0x0,0},
   */

   {DBITMASK, 0, PROOT_HELP, DefineBrgBMDefine,TBMASK,
     (char *)&define_br[DEF_BRG_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DBOOTPREQ, 0, PROOT_HELP,DefineBrgAutoCfg,TDBOOTPREQ,
     (char *)&define_br[DEF_BRG_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DCFG, DFILE, PROOT_HELP,DefineBrgCfgFile ,TDCFGFILE,
     (char *)&define_br[DEF_BRG_IDX],0,MORE_TO_COME,0,4,0x0,0},

   {DCONTACT, 0, PROOT_HELP,DefineBrgContact ,TDCONTACT,
     (char *)&define_br[DEF_BRG_IDX],0,PARM_OPT,0,4,0x0,0},

   {DDATE,0,PROOT_HELP,SetDate,TDATE,
   (char *)&define_br[DEF_BRG_IDX],0,MORE_TO_COME,0,4,0x0,0},

   {DIP, DADDRESS, PROOT_HELP,DefineBrgIPAddr ,TDIPADDRESS,
     (char *)&define_br[DEF_BRG_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DLOCATION, 0, PROOT_HELP,DefineBrgLocation ,TDLOCATION,
     (char *)&define_br[DEF_BRG_IDX],0,PARM_OPT,0,3,0x0,0},

   {DNAME, 0, PROOT_HELP,DefineBrgName ,TDNAME,
     (char *)&define_br[DEF_BRG_IDX],0,PARM_OPT,0,2,0x0,0},

   {DNETMASK, 0, PROOT_HELP,DefineBrgNetMask ,TDNETMASK,
     (char *)&define_br[DEF_BRG_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DPASSWORD, 0, PROOT_HELP,DefineBrgAuthent,TDPASSWORD,
     (char *)&define_br[DEF_BRG_IDX],0,NEED_NO_PARM,0,3,0x0,0},

   {DPRIMARY, DROUTER, PROOT_HELP,DefineBrgPrimaryRouter ,TDPRIROUTER,
     (char *)&define_br[DEF_BRG_IDX],0,MORE_TO_COME,0,3,0x0,0},

   {DRQST, DFILE, PROOT_HELP,DefineBrgRqstFile,TDRQSTFILE,
     (char *)&define_br[DEF_BRG_IDX],0,PARM_OPT,0,2,0x0,0},

   {DRING, NULL, PROOT_HELP,DefineBrgRing,TDRING,
     (char *)&define_br[DEF_BRG_IDX],0,MORE,0,2,0x0,0},

   {DSECONDARY, DROUTER, PROOT_HELP,DefineBrgSecondaryRouter ,TDSECROUTER,
     (char *)&define_br[DEF_BRG_IDX],0,MORE_TO_COME,0,3,0x0,0},

   {DSNMPMGR, 0, PROOT_HELP,DefineAlarmMgr,TDALARMMGR,
     (char *)&define_br[DEF_BRG_IDX],0,MORE_TO_COME,0,5,0x0,0},

   {DSMT, 0, PROOT_HELP,define ,TDSMT,
    (char *)&define_br[DEF_BRG_IDX],(char *)def_brg_smt,MORE_TO_COME,0,3,0x0,0},

   {DSTPMODE, 0, PROOT_HELP,DefineBrgStpMode ,TDSTPMODE,
     (char *)&define_br[DEF_BRG_IDX],0,MORE_TO_COME,0,4,0x0,0},

   {DSYMBOLIC, 0, PROOT_HELP,DefineBrgSymbolic ,TDSYMBOLIC,
     (char *)&define_br[DEF_BRG_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DTFTP, DSERVER, PROOT_HELP,DefineBrgSrvrIP,TDSRVRIP,
     (char *)&define_br[DEF_BRG_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DTIME,0,PROOT_HELP,SetTime,TTIME,
    (char *)&define_br[DEF_BRG_IDX], 0,MORE_TO_COME,0,4,0,0},

   {DTIMEOUT,0,PROOT_HELP,DefineBrgTimeOut,TTIMEOUT,
    (char *)&define_br[DEF_BRG_IDX], 0,MORE_TO_COME,0,5,0,0},

   {DUDPFILTER, 0, PROOT_HELP,DefineBrgUDPFilter ,TDUDPFILTER,
     (char *)&define_br[DEF_BRG_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DVT, 0, PROOT_HELP,DefineBrgTerminal ,TDTERM,
     (char *)&define_br[DEF_BRG_IDX],0,MORE_TO_COME,0,2,0x0,0},

	{0}
	};

/***************************************************************************
	THE DEFINE MODULE BRANCH 
****************************************************************************/
CMDNODE_T define_mod_br[] = {

   /*
   {DAUTHENT, 0, PROOT_HELP,0,TDAUTHENT,
     (char *)&define_br[DEF_MOD_IDX],0,NEED_NO_PARM,0,2,0x0,0},
   */
   {DBITMASK, 0, PROOT_HELP, DefineBrgBMDefine,TBMASK,
     (char *)&define_br[DEF_MOD_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DBOOTPREQ, 0, PROOT_HELP,DefineBrgAutoCfg,TDBOOTPREQ,
     (char *)&define_br[DEF_MOD_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DCFG, DFILE, PROOT_HELP,DefineBrgCfgFile ,TDCFGFILE,
     (char *)&define_br[DEF_MOD_IDX],0,MORE_TO_COME,0,4,0x0,0},

   {DCONTACT, 0, PROOT_HELP,DefineBrgContact ,TDCONTACT,
     (char *)&define_br[DEF_MOD_IDX],0,PARM_OPT,0,4,0x0,0},

   {DDATE,0,PROOT_HELP,SetDate,TDATE,
   (char *)&define_br[DEF_MOD_IDX],0,MORE_TO_COME,0,4,0x0,0},

   {DIP, DADDRESS, PROOT_HELP,DefineBrgIPAddr ,TDIPADDRESS,
     (char *)&define_br[DEF_MOD_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DLOCATION, 0, PROOT_HELP,DefineBrgLocation ,TDLOCATION,
     (char *)&define_br[DEF_MOD_IDX],0,PARM_OPT,0,3,0x0,0},

   {DNAME, 0, PROOT_HELP,DefineBrgName ,TDNAME,
     (char *)&define_br[DEF_MOD_IDX],0,PARM_OPT,0,2,0x0,0},

   {DNETMASK, 0, PROOT_HELP,DefineBrgNetMask ,TDNETMASK,
     (char *)&define_br[DEF_MOD_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DPASSWORD, 0, PROOT_HELP,DefineBrgAuthent,TDPASSWORD,
     (char *)&define_br[DEF_MOD_IDX],0,NEED_NO_PARM,0,3,0x0,0},

   {DPRIMARY, DROUTER, PROOT_HELP,DefineBrgPrimaryRouter ,TDPRIROUTER,
     (char *)&define_br[DEF_MOD_IDX],0,MORE_TO_COME,0,3,0x0,0},

   {DRQST, DFILE, PROOT_HELP,DefineBrgRqstFile,TDRQSTFILE,
     (char *)&define_br[DEF_MOD_IDX],0,PARM_OPT,0,2,0x0,0},

   {DRING, NULL, PROOT_HELP,DefineBrgRing,TDRING,
     (char *)&define_br[DEF_MOD_IDX],0,MORE,0,2,0x0,0},

   {DSECONDARY, DROUTER, PROOT_HELP,DefineBrgSecondaryRouter ,TDSECROUTER,
     (char *)&define_br[DEF_MOD_IDX],0,MORE_TO_COME,0,3,0x0,0},

   {DSNMPMGR, 0, PROOT_HELP,DefineAlarmMgr,TDALARMMGR,
     (char *)&define_br[DEF_MOD_IDX],0,MORE_TO_COME,0,5,0x0,0},

   {DSMT, 0, PROOT_HELP,define ,TDSMT,
    (char *)&define_br[DEF_MOD_IDX],(char *)def_mod_smt,MORE_TO_COME,0,3,0x0,0},

   {DSTPMODE, 0, PROOT_HELP,DefineBrgStpMode ,TDSTPMODE,
     (char *)&define_br[DEF_MOD_IDX],0,MORE_TO_COME,0,4,0x0,0},

   {DSYMBOLIC, 0, PROOT_HELP,DefineBrgSymbolic ,TDSYMBOLIC,
     (char *)&define_br[DEF_MOD_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DTFTP, DSERVER, PROOT_HELP,DefineBrgSrvrIP,TDSRVRIP,
     (char *)&define_br[DEF_MOD_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DTIME,0,PROOT_HELP,SetTime,TTIME,
    (char *)&define_br[DEF_MOD_IDX], 0,MORE_TO_COME,0,4,0,0},

   {DTIMEOUT,0,PROOT_HELP,DefineBrgTimeOut,TTIMEOUT,
    (char *)&define_br[DEF_MOD_IDX], 0,MORE_TO_COME,0,5,0,0},

   {DUDPFILTER, 0, PROOT_HELP,DefineBrgUDPFilter ,TDUDPFILTER,
     (char *)&define_br[DEF_MOD_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DVT, 0, PROOT_HELP,DefineBrgTerminal ,TDTERM,
     (char *)&define_br[DEF_MOD_IDX],0,MORE_TO_COME,0,2,0x0,0},

	{0}
	};

/***************************************************************************
	THE DEFINE PORT BLOCK BRANCH 
****************************************************************************/
CMDNODE_T def_port_blk_br[] = {

   {DPBITMASK, 0, PROOT_HELP,DefinePrtBitmask,TDBITMASK,
     (char *)&define_port_br[DEF_PRT_BLK_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DPPROTOCOL, 0, PROOT_HELP,DefinePrtProt,TDPROTOCOL,
     (char *)&define_port_br[DEF_PRT_BLK_IDX],0,MORE_TO_COME,0,2,0x0,0},

	{0}
};
	
/***************************************************************************
	THE DEFINE PORT PERMIT BRANCH 
****************************************************************************/
CMDNODE_T def_port_per_br[] = {

   {DPBITMASK, 0, PROOT_HELP,DefinePrtBitmask,TPBITMASK,
     (char *)&define_port_br[DEF_PRT_PER_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {DPPROTOCOL, 0, PROOT_HELP,DefinePrtProt,TPPROTOCOL,
     (char *)&define_port_br[DEF_PRT_PER_IDX],0,MORE_TO_COME,0,2,0x0,0},

	{0}
};
	

/***************************************************************************
	THE DEFINE PORT BRANCH 
****************************************************************************/
CMDNODE_T define_port_br[] = {

   {DBLOCK, 0,PROOT_HELP, DefinePortBlock, TDBLOCK,
   (char *)&define_br[DEF_PORT_IDX],(char *)def_port_blk_br,MORE_TO_COME,0,2,0,0},
#ifdef notdefined
   {DEXTERNAL, DINTFC , PROOT_HELP, DefinePortExternal,TDAUI,
     (char *)&define_br[DEF_PORT_IDX],0,MORE_TO_COME,0,2,0x0,0},
#endif
   {DLEARN, 0,PROOT_HELP, DefinePortLearn, TDLEARN,
   (char *)&define_br[DEF_PORT_IDX],0,MORE_TO_COME,0,2,0,0},

   {DPACSIZE, 0,PROOT_HELP, DefinePortPacSize, TDPACSIZE,
   (char *)&define_br[DEF_PORT_IDX],0,MORE_TO_COME,0,2,0,0},


   {DPERMIT, 0,PROOT_HELP, DefinePortPermit, TDPERMIT,
   (char *)&define_br[DEF_PORT_IDX],(char *)def_port_per_br,MORE_TO_COME,0,2,0,0},

   {DRESTRICT, 0,PROOT_HELP, DefinePortRestrict, TDRESTRICT,
   (char *)&define_br[DEF_PORT_IDX],0,MORE_TO_COME,0,4,0,0},

   {DPSTATE, 0,PROOT_HELP, DefinePortState, TDSTATE,
   (char *)&define_br[DEF_PORT_IDX],0,MORE_TO_COME,0,5,0,0},

   /*
   {DPTHRESHLD, 0,PROOT_HELP, DefinePortThrshld, TDTHRESHLD,
   (char *)&define_br[DEF_PORT_IDX],0,MORE_TO_COME,0,2,0,0},
   */

   {DPUNKMCAST, 0,PROOT_HELP, DefinePortUnkMCast, TDUNKMCAST,
   (char *)&define_br[DEF_PORT_IDX],0,MORE_TO_COME,0,4,0,0},

   {DPUNKUCAST, 0,PROOT_HELP, DefinePortUnkUCast, TDUNKUCAST,
   (char *)&define_br[DEF_PORT_IDX],0,MORE_TO_COME,0,4,0,0},

	{0}
	};


/**************************************************************************
	THE DEFINE FDDI BRANCH Vinay 5.4.93
**************************************************************************/

CMDNODE_T define_fddi_br[] = {

	{DSMAC, 0,PROOT_HELP, define, TDEFINE,
   (char *)&define_br[DEF_FDDI_IDX],(char *)fddi_mac_br,MORE_TO_COME,0,3,0,0},

	{DSPATH, 0,PROOT_HELP, defineFddiIntPath, TDEFINE,
   (char *)&define_br[DEF_FDDI_IDX],(char *)fddi_path_br,MORE_TO_COME,0,2,0,0},

   {DSPORT, 0,PROOT_HELP, defFddiPort, TDEFPORT,
   (char *)&define_br[DEF_FDDI_IDX],(char *)fddi_port_br,MORE_TO_COME,0,2,0,0},

	{0}
	};

CMDNODE_T fddi_port_br[] = {
	{DSACTION, 0,PROOT_HELP, DefineFddiPortAction, TDSACTION,
   (char *)&define_fddi_br[FDDI_PORT_IDX],NULL,MORE,0,3,0,0},

	{DSATTACHMENT, DSPOLICY,PROOT_HELP, DefineFddiAttachPolicy, TDSATTACHMENT,
   (char *)&define_fddi_br[FDDI_PORT_IDX],NULL,MORE,2,2,0,0},

	{DSCONNECTION, DSPOLICIES,PROOT_HELP, DefineFddiConnPolicies, TDSCONNECTION,
   (char *)&define_fddi_br[FDDI_PORT_IDX],NULL,MORE,2,4,0,0},

	{/*DSTYPE*/DSLOCATION, /*DSFDDIPORT*/0,PROOT_HELP, DefineFddiPortType, TDSFDDIPORT,
   (char *)&define_fddi_br[FDDI_PORT_IDX],NULL,MORE,0,3,0,0},

	{DSMACLOOP, 0,PROOT_HELP, DefineFddiPortMacLoop, TDSPORTMAC,
   (char *)&define_fddi_br[FDDI_PORT_IDX],NULL,MORE,0,3,0,0},

	{DSLERALARM, 0,PROOT_HELP, DefineFddiLerAlarm, TDSLERALARM,
   (char *)&define_fddi_br[FDDI_PORT_IDX],NULL,MORE,0,4,0,0},

	{DSLERCUTOFF, 0,PROOT_HELP, DefineFddiLerCutoff, TDSLERCUTOFF,
   (char *)&define_fddi_br[FDDI_PORT_IDX],NULL,MORE,0,4,0,0},

	{DSMAINTLINESTATE,0,PROOT_HELP,DefineFddiPortMalineSt,TDSMAINTLINESTATE,
   (char *)&define_fddi_br[FDDI_PORT_IDX],NULL,MORE,2,2,0,0},

	{DSTB_MAX, 0,PROOT_HELP, DefineFddiPortTbMax, TDSTB_MAX,
   (char *)&define_fddi_br[FDDI_PORT_IDX],NULL,MORE,0,3,0,0},

	{0},
	};

CMDNODE_T fddi_mac_br[] = {
#ifdef notdefined
	{DSACTION, NULL,PROOT_HELP, DefFddiMacAction, TDSFDDIMACACTION,
   (char *)&define_fddi_br[FDDI_MAC_IDX],NULL,MORE,0,3,0,0},
#endif

	{DSFRAMEERRTH, DSFRAME,PROOT_HELP, DefFddiMacFrameErrTh, TDSFRAMEERRTH,
   (char *)&define_fddi_br[FDDI_MAC_IDX],NULL,PREFIX+MORE,3,3,0,0},

	{DSNOTCOPIED,DTHRESHOLD,PROOT_HELP, DefFddiMacNotCopiedTh, TDSNOTCOPIED,
   (char *)&define_fddi_br[FDDI_MAC_IDX],NULL,MORE,2,4,0,0},

#ifdef notdefined
	{DSPATH, DSREQUESTED,PROOT_HELP, DefFddiMacPath, TDSMACPATHREQ,
   (char *)&define_fddi_br[FDDI_MAC_IDX],NULL,MORE,0,2,0,0},

	{DSFRAMESTATUS, DSFRAME,PROOT_HELP, DefFddiMacFrameSta, TDSFRAMESTATUS,
   (char *)&define_fddi_br[FDDI_MAC_IDX],NULL,PREFIX+MORE,3,4,0,0},

	{DSSTATE, NULL,PROOT_HELP, DefFddiMacState, TDSMACSTATE,
   (char *)&define_fddi_br[FDDI_MAC_IDX],NULL,MORE,0,3,0,0},

	{DSSTRIPPING, NULL,PROOT_HELP, DefFddiMacStripping, TDSMACSTRIPPING,
   (char *)&define_fddi_br[FDDI_MAC_IDX],NULL,MORE,0,3,0,0},
#endif

	{DST_MAX, NULL,PROOT_HELP, DefFddiMacT_Max, TDSMACT_MAX,
   (char *)&define_fddi_br[FDDI_MAC_IDX],NULL,MORE,0,3,0,0},

	{DST_MIN, NULL,PROOT_HELP, DefFddiMacT_Min, TDSMACT_MIN,
   (char *)&define_fddi_br[FDDI_MAC_IDX],NULL,MORE,0,3,0,0},

#ifdef REMOVED
	{DST_PRI, NULL,PROOT_HELP, DefFddiMacT_Pri, TDSMACT_PRI,
   (char *)&define_fddi_br[FDDI_MAC_IDX],NULL,MORE,0,4,0,0},
#endif

	{DST_REQ, NULL,PROOT_HELP, DefFddiMacT_Req, TDSMACT_REQ,
   (char *)&define_fddi_br[FDDI_MAC_IDX],NULL,MORE,0,4,0,0},

	{DSTVX, NULL,PROOT_HELP, DefFddiMacTvx, TDSMACTVX,
   (char *)&define_fddi_br[FDDI_MAC_IDX],NULL,MORE,0,3,0,0},

	{0},
	};


CMDNODE_T fddi_path_br[] = {

	{DSLATENCY, DSRING,PROOT_HELP, DefFddiLatency, TDSLATENCY,
   (char *)&define_fddi_br[FDDI_PATH_IDX],NULL,MORE+PREFIX,2,2,0,0},

	{DSRMODE, 0,PROOT_HELP, DefFddiRmode, TDSRMODE,
   (char *)&define_fddi_br[FDDI_PATH_IDX],NULL,MORE,0,2,0,0},

	{DSTRACE_MAX, 0,PROOT_HELP, DefFddiTraceMax, TDSTRACE_MAX,
   (char *)&define_fddi_br[FDDI_PATH_IDX],NULL,MORE,0,3,0,0},

	{DST_MAX, DSLOWER,PROOT_HELP, DefFddiT_Max, TDST_MAX,
   (char *)&define_fddi_br[FDDI_PATH_IDX],NULL,MORE,2,3,0,0},

	{DSTVX, DSLOWER,PROOT_HELP, DefFddiTvx, TDSTVX,
   (char *)&define_fddi_br[FDDI_PATH_IDX],NULL,MORE,2,3,0,0},

	{0},
	};
/****************************************************************************
	THE DEFINE MOD SMT BRANCH
****************************************************************************/
CMDNODE_T def_mod_smt[] = {

   {DSCONFIG, DSPOLICY,PROOT_HELP, DefineModSMTConfig, TDSSMTCONFIG,
   (char *)&define_mod_br[DEF_SMT_IDX],0,MORE,3,4,0,0},

   {DSCONNECTION, DSPOLICY,PROOT_HELP, DefineModSMTConn, TDSSMTCONN,
   (char *)&define_mod_br[DEF_SMT_IDX],0,MORE,3,4,0,0},

   {DSOPVERSION, 0,PROOT_HELP, DefineModSMTOPversion, TDSSMTOPVER,
   (char *)&define_mod_br[DEF_SMT_IDX],0,MORE,0,2,0,0},

   {DSREPORT, DSLIMIT,PROOT_HELP, DefineModSMTReport, TDSSMTREPORT,
   (char *)&define_mod_br[DEF_SMT_IDX],0,MORE,2,2,0,0},

   {DST_NOTIFY, 0,PROOT_HELP, DefineModSMTT_Notify, TDSSMTT_NOTIFY,
   (char *)&define_mod_br[DEF_SMT_IDX],0,0,MORE,3,0,0},

   {DSUSERDATA, 0,PROOT_HELP, DefineModSMTUserData, TDSSMTUSERDATA,
   (char *)&define_mod_br[DEF_SMT_IDX],0,MORE,0,2,0,0},

	{0}
	};
/***************************************************************************
	DEF BRG SMT branch
***************************************************************************/
CMDNODE_T def_brg_smt[] = {

   {DSCONFIG, DSPOLICY,PROOT_HELP, DefineModSMTConfig, TDSSMTCONFIG,
   (char *)&define_brg_br[DEF_SMT_IDX],0,MORE,3,4,0,0},

   {DSCONNECTION, DSPOLICY,PROOT_HELP, DefineModSMTConn, TDSSMTCONN,
   (char *)&define_brg_br[DEF_SMT_IDX],0,MORE,3,4,0,0},

   {DSOPVERSION, 0,PROOT_HELP, DefineModSMTOPversion, TDSSMTOPVER,
   (char *)&define_brg_br[DEF_SMT_IDX],0,MORE,0,2,0,0},

   {DSREPORT, DSLIMIT,PROOT_HELP, DefineModSMTReport, TDSSMTREPORT,
   (char *)&define_brg_br[DEF_SMT_IDX],0,MORE,2,2,0,0},

   {DST_NOTIFY, 0,PROOT_HELP, DefineModSMTT_Notify, TDSSMTT_NOTIFY,
   (char *)&define_brg_br[DEF_SMT_IDX],0,0,MORE,8,0,0},

   {DSUSERDATA, 0,PROOT_HELP, DefineModSMTUserData, TDSSMTUSERDATA,
   (char *)&define_brg_br[DEF_SMT_IDX],0,MORE,0,2,0,0},

	{0}
	};
/***************************************************************************
	THE DEFINE STP BRANCH 
****************************************************************************/
CMDNODE_T define_stp_br[] = {

   {DSBRGPRI, 0,PROOT_HELP, DefineStpBrgPriority, TDSBRGPRI,
   (char *)&define_br[DEF_STP_IDX],0,MORE_TO_COME,0,2,0,0},

   {DSDEFAULT, 0,PROOT_HELP, STP_dft_rst, TDSDEFAULT,
   (char *)&define_br[DEF_STP_IDX],0,NEED_NO_PARM,0,4,0,0},

   {DSFORW, 0,PROOT_HELP, DefineStpForward, TDSFORW,
   (char *)&define_br[DEF_STP_IDX],0,MORE_TO_COME,0,2,0,0},

   {DSHELLO, 0,PROOT_HELP, DefineStpHello, TDSHELLO,
   (char *)&define_br[DEF_STP_IDX],0,MORE_TO_COME,0,2,0,0},

   {DSLIFE, 0,PROOT_HELP, DefineStpLifeTime, TDSLIFE,
   (char *)&define_br[DEF_STP_IDX],0,MORE_TO_COME,0,2,0,0},

   {DSPATHCOST, 0,PROOT_HELP, DefineStpPathCost, TDSPATHCOST,
   (char *)&define_br[DEF_STP_IDX],0,MORE_TO_COME,0,3,0,0},

   {DSPORTPRI, 0,PROOT_HELP, DefineStpPortPriority, TDSPORTPRI,
   (char *)&define_br[DEF_STP_IDX],0,MORE_TO_COME,0,4,0,0},

{0}
	};


/***************************************************************************
	THE DEFINE BRANCH 
****************************************************************************/

CMDNODE_T define_br[]={

     {DBRIDGE,0,PROOT_HELP,DefineBrg,TDBRIDGE,
       (char *)&help_br[DEFINE_IDX],(char *)define_brg_br,MORE_TO_COME,0,2,0,0},

     {DDATABASE,0,PROOT_HELP,DefineDB,TDDATABASE,
       (char *)&help_br[DEFINE_IDX],0,MORE_TO_COME,0,4,0,0},

        {SFDDI,0,PROOT_HELP,define,TDFDDI,
       (char *)&help_br[DEFINE_IDX],(char *)define_fddi_br,MORE_TO_COME,0,2,0,0}
,
     {DMODULE,0,PROOT_HELP,DefineBrg,TDBRIDGE,
       (char *)&help_br[DEFINE_IDX],(char *)define_mod_br,MORE_TO_COME,0,2,0,0},

     {DPORTS,0,PROOT_HELP,DefinePort,TDPORT,
     (char *)&help_br[DEFINE_IDX],(char *)define_port_br,MORE_TO_COME,0,2,0,0},

     {DSTP,0,PROOT_HELP,0,TDSTP,
     (char *)&help_br[DEFINE_IDX],(char *)define_stp_br,MORE_TO_COME,0,3,0,0},

{(char *)0}
};


/*********************************************************************
**
**     SHOW BRANCH 
**
********************************************************************/

CMDNODE_T show_br[]={

     {SBRIDGE,0,PROOT_HELP,ShowBrgStatus,TSBRIDGE,
	  (char *)&help_br[SHOW_IDX],(char *)show_brg_br,PARM_OPT,0,2,0,0},

     {SDATABASE,0,PROOT_HELP,0,TSDATABASE,
        (char *)&help_br[SHOW_IDX],(char *)show_databs_br,MORE_TO_COME,0,4,0,0},

     {SFDDI,0,PROOT_HELP,0,TSFDDI,
        (char *)&help_br[SHOW_IDX],(char *)show_fddi_br,MORE_TO_COME,0,2,0,0},

     {SMODULE,0,PROOT_HELP,ShowBrgStatus,TSBRIDGE,
	  (char *)&help_br[SHOW_IDX],(char *)show_mod_br,PARM_OPT,0,2,0,0},

     {SPORTS,0,PROOT_HELP,0,TSPORT,
     (char *)&help_br[SHOW_IDX],(char *)show_port_br,MORE_TO_COME,0,2,0,0},

     {SSTP,0,PROOT_HELP,STPStatusScreen,TSTP,
     (char *)&help_br[SHOW_IDX],0,NEED_NO_PARM,0,3,0,0},

{(char *)0}
};


CMDNODE_T show_fddi_br[] = {
/* show fddi mac */
     {SFDDIMAC,0,PROOT_HELP,ShowFddiMac,TSFDDIMAC,
	  (char *)&show_br[SHOW_FDDI_IDX],(char *)NULL,NEED_NO_PARM,0,3,0,0},

/* show fddi path*/
     {SFDDIPATH,0,PROOT_HELP,ShowFddiPath,TSFDDIPATH,
	  (char *)&show_br[SHOW_FDDI_IDX],(char *)NULL,NEED_NO_PARM,0,2,0,0},

/* show fddi ports */
     {SFDDIPORTS,0,PROOT_HELP,ShowFddiPorts,TSFDDIPORTS,
	  (char *)&show_br[SHOW_FDDI_IDX],(char *)NULL,NEED_NO_PARM,0,2,0,0},

{(char *)0}
};
/**************************************************/

/***************************************************************************
	THE CLEAR BRIDGE BRANCH
****************************************************************************/

CMDNODE_T clear_brg_br[] = {

   {CBITMASK, 0, PROOT_HELP, ClearBrgBMask,TCBITMASK,
     (char *)&clear_br[CLR_BRG_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {CCONTACT, 0, PROOT_HELP,ClearBrgContact ,TCCONTACT,
     (char *)&clear_br[CLR_BRG_IDX],0,NEED_NO_PARM,0,4,0x0,0},

     {SFDDI,0/*CTRAFFIC*/,PROOT_HELP,ClearFddiTrafficCounters,TCFDDITRAFFIC,
       (char *)&clear_br[CLR_BRG_IDX],0,MORE,0,2,0,0},

   {CIP,CADDR, PROOT_HELP,ClearBrgIPAddr ,TCIPADDRESS,
     (char *)&clear_br[CLR_BRG_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {CLOCATION, 0, PROOT_HELP,ClearBrgLocation ,TCLOCATION,
     (char *)&clear_br[CLR_BRG_IDX],0,NEED_NO_PARM,0,3,0x0,0},

   {CLOG, 0, PROOT_HELP,ClearBrgLog ,TCLOG,
     (char *)&clear_br[CLR_BRG_IDX],0,NEED_NO_PARM,0,3,0x0,0},

   {CNAME, 0, PROOT_HELP,ClearBrgName ,TCNAME,
     (char *)&clear_br[CLR_BRG_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {CRLOG, 0, PROOT_HELP,ClearBrgRLog ,TCRLOG,
     (char *)&clear_br[CLR_BRG_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {CSMTCONNECTION, CCONNECTION, PROOT_HELP,ClearSmtConn ,TCSMTCONN,
     (char *)&clear_br[CLR_BRG_IDX],0,MORE,4,3,0x0,0},

   {CTRAFFIC, 0, PROOT_HELP,ClearBrgTraffic, TCTRAFFIC,
     (char *)&clear_br[CLR_BRG_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {CUDP, 0, PROOT_HELP,ClearBrgUDP, TCUDP,
     (char *)&clear_br[CLR_BRG_IDX],0,MORE_TO_COME,0,3,0x0,0},

	{0}
	};


/***************************************************************************
	THE CLEAR MODULE BRANCH
****************************************************************************/

CMDNODE_T clear_mod_br[] = {

   {CBITMASK, 0, PROOT_HELP, ClearBrgBMask,TCBITMASK,
     (char *)&clear_br[CLR_MOD_IDX],0,MORE_TO_COME,0,2,0x0,0},

   {CCONTACT, 0, PROOT_HELP,ClearBrgContact ,TCCONTACT,
     (char *)&clear_br[CLR_MOD_IDX],0,NEED_NO_PARM,0,4,0x0,0},

     {SFDDI,0/*CTRAFFIC*/,PROOT_HELP,ClearFddiTrafficCounters,TCFDDITRAFFIC,
       (char *)&clear_br[CLR_MOD_IDX],0,MORE,0,2,0,0},

   {CIP,CADDR, PROOT_HELP,ClearBrgIPAddr ,TCIPADDRESS,
     (char *)&clear_br[CLR_MOD_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {CLOCATION, 0, PROOT_HELP,ClearBrgLocation ,TCLOCATION,
     (char *)&clear_br[CLR_MOD_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {CLOG, 0, PROOT_HELP,ClearBrgLog ,TCLOG,
     (char *)&clear_br[CLR_MOD_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {CNAME, 0, PROOT_HELP,ClearBrgName ,TCNAME,
     (char *)&clear_br[CLR_MOD_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {CRLOG, 0, PROOT_HELP,ClearBrgRLog ,TCRLOG,
     (char *)&clear_br[CLR_MOD_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {CSMTCONNECTION, CCONNECTION, PROOT_HELP,ClearSmtConn ,TCSMTCONN,
     (char *)&clear_br[CLR_MOD_IDX],0,MORE,4,3,0x0,0},

   {CTRAFFIC, 0, PROOT_HELP,ClearBrgTraffic, TCTRAFFIC,
     (char *)&clear_br[CLR_MOD_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {CUDP, 0, PROOT_HELP,ClearBrgUDP, TCUDP,
     (char *)&clear_br[CLR_MOD_IDX],0,MORE_TO_COME,0,3,0x0,0},

	{0}
	};

/***************************************************************************
	THE CLEAR MOD SMT CONNECTION
CMDNODE_T clear_mod_smt_conn[] = {
   {CCONNECTION, 0, PROOT_HELP,ClearSmtConn,TCSMTCONN,
     (char *)&clear_mod_br[CLR_MOD_SMT_CONN_IDX],0,MORE,0,4,0x0,0},
	
	{0}
	};
****************************************************************************/
/***************************************************************************
	THE CLEAR BRIDGE SMT CONNECTION
CMDNODE_T clear_brg_smt_conn[] = {
   {CCONNECTION, 0, PROOT_HELP,ClearSmtConn,TCSMTCONN,
     (char *)&clear_brg_br[CLR_BRG_SMT_CONN_IDX],0,MORE,0,4,0x0,0},
	
	{0}
	};
****************************************************************************/

/***************************************************************************
	THE CLEAR PORT BRANCH
****************************************************************************/

CMDNODE_T clear_port_br[] = {

   {CBMEXPR, 0, PROOT_HELP,ClearPortBMExpr,TCBMEXPR,
     (char *)&clear_br[CLR_PORT_IDX],0,NEED_NO_PARM,0,2,0x0,0},

   {CPROTOCOL, 0, PROOT_HELP,ClearPortProtocol ,TCPROTOCOL,
     (char *)&clear_br[CLR_PORT_IDX],0,PARM_OPT,0,2,0x0,0},

	{0}
	};

/***************************************************************************
	THE CLEAR BRANCH
****************************************************************************/

CMDNODE_T clear_br[]={

     {CBRIDGE,0,PROOT_HELP,0,TCBRIDGE,
       (char *)&help_br[CLEAR_IDX],(char *)clear_brg_br,MORE_TO_COME,0,2,0,0},

     {CDATABASE,0,PROOT_HELP,ClearDataBase,TCDATABASE,
       (char *)&help_br[CLEAR_IDX],0,MORE_TO_COME,0,4,0,0},

     {CMODULE,0,PROOT_HELP,0,TCBRIDGE,
       (char *)&help_br[CLEAR_IDX],(char *)clear_mod_br,MORE_TO_COME,0,2,0,0},

     {CPORTS,0,PROOT_HELP,DefinePort,TCPORT,
     (char *)&help_br[CLEAR_IDX],(char *)clear_port_br,MORE_TO_COME,0,2,0,0},

     {0}
};


/***************************************************************************
	THE SAVE DATABASE BRANCH
****************************************************************************/

CMDNODE_T save_db[]={

     {SDB,0,PROOT_HELP,Save,TSDB,
       (char *)&help_br[SAVE_IDX],0,NEED_NO_PARM,0,2,0,0},

{(char *)0}
};

/***************************************************************************
	THE HLS BRANCH
    These commands are intended for engineering use only. There purpose is
	to aid in debugging the bridge.
****************************************************************************/

CMDNODE_T hls_br[]={

     {HDEBUG,0,PROOT_HELP,GoDebug,HDEBUG,
       (char *)&help_br[HLS_IDX],0,NEED_NO_PARM,0,2,0,0},

     {HFLARP,0,PROOT_HELP,FlushArp,HFLARP,
       (char *)&help_br[HLS_IDX],0,NEED_NO_PARM,0,2,0,0},

     {HGOKRNL,0,PROOT_HELP,GoKernel,HGOKRNL,
       (char *)&help_br[HLS_IDX],0,NEED_NO_PARM,0,2,0,0},

     {HHELP,0,PROOT_HELP,HiddenHlp,HHELP,
       (char *)&help_br[HLS_IDX],0,NEED_NO_PARM,0,4,0,0},

     {HPRTRFIC,0,PROOT_HELP,WinPortTraffic,HPRTRFIC,
       (char *)&help_br[HLS_IDX],0,NEED_NO_PARM,0,4,0,0},

     {HPRTST,0,PROOT_HELP,WinPortStatusScrn,HPRTST,
       (char *)&help_br[HLS_IDX],0,NEED_NO_PARM,0,4,0,0},

     {HSHARP,0,PROOT_HELP,ShowArp,HSHARP,
       (char *)&help_br[HLS_IDX],0,NEED_NO_PARM,0,2,0,0},

     {HSHMEM,0,PROOT_HELP,ShowMemory,HSHMEM,
       (char *)&help_br[HLS_IDX],0,PARM_OPT,0,4,0,0},

     {HUPROTS,0,PROOT_HELP,WinUserProtocols,HUPROTS,
       (char *)&help_br[HLS_IDX],0,NEED_NO_PARM,0,2,0,0},

     {HVPROTS,0,PROOT_HELP,WinVendorProtocols,HVPROTS,
       (char *)&help_br[HLS_IDX],0,NEED_NO_PARM,0,2,0,0},

{(char *)0}
};

/***************************************************************************
	THE HELP BRANCH
****************************************************************************/

CMDNODE_T help_br[]={ 

   {SCLEAR,0,PROOT_HELP,0,TCLEAR,
   (char *)&root_br[0],(char *)clear_br,MORE_TO_COME,0,2,0x0,0},

   {SDEFINE,0,PROOT_HELP,define,TDEFINE,
   (char *)&root_br[0],(char *)define_br,PROC_HELP,0,2,0,0},

   {SECHO,0,PROOT_HELP,Echo,TECHO,
   (char *)&root_br[0],(char *)0,0,0,2,0,0},

   {SEXIT,0,PROOT_HELP,Exit,TEXIT,
   (char *)&root_br[0],(char *)0,NEED_NO_PARM,0,2,0,0},

   {SHLP,0,PROOT_HELP,0,THELP,
	(char *)&root_br[0],(char *)0,NEED_NO_PARM,0,2,0,0},

   {SHLS,0,PROOT_HELP,0,THELP,
	(char *)&root_br[0],(char *)hls_br,MORE_TO_COME,0,2,0,0},

   {SINIT,0,PROOT_HELP,InitBrg,TINIT,
   (char *)&root_br[0],(char *)0,PARM_OPT,0,2,0x0,0},

   /***************************************************
   {SLOAD,0,PROOT_HELP,Tftp,TTFTP,
    (char *)&root_br[0],(char *)0,NEED_NO_PARM,0,3,0,0},
	**************************************************/
   {SLOGOUT,0,PROOT_HELP,Exit,TLOGOUT,
   (char *)&root_br[0],(char *)0,NEED_NO_PARM,0,2,0,0},

   {SMODIFY,0,PROOT_HELP,Modify,TMODIFY,
   (char *)&root_br[0],(char *)0,MORE_TO_COME,0,4,0,0},
   
   /*
   {SPKTUTL,0,PROOT_HELP,PktUtil,TPKTUTL,
   (char *)&root_br[0],0,NEED_NO_PARM,0,2,0,0},
   */
   
   {SPING,0,PROOT_HELP,Ping,TPING,
   (char *)&root_br[0],(char *)0,MORE_TO_COME,0,2,0,0},

   {SSAVE,0,PROOT_HELP,0,TSAVE,
   (char *)&root_br[0], (char *)save_db,MORE_TO_COME,0,2,0,0},

   {SSHOW,0,PROOT_HELP,0,TSHOW,
    (char *)&root_br[0], (char *)show_br,MORE_TO_COME,0,2,0,0},

   /************************************************************
   {STESTER,0,PROOT_HELP,Tester,TDIAG,
	(char *)&root_br[0],(char *)0,NEED_NO_PARM,0,2,0x0,0},
 	************************************************************/
 
	{(char *) 0}
};


/***************************************************************************
	THE ROOT BRANCH
****************************************************************************/

CMDNODE_T root_br[]={ 
         {SHLP,0,PROOT_HELP,root_help,TROOT_HELP,
	     (char *)0,(char *)help_br,SKIP_ALL+NOREMOTE+PARM_OPT,0,0
		 ,0,0},
 
    {(char *)0}
};


CMDNODE_T root_node = 
         {0,0,PROOT_HELP,0,0,0,(char *)root_br,0,0,0,0,0};

