
#define CONSOLE_PORT 0
/**************************************************************
**
**    port mode
**
**************************************************************/

#define   CMDMODE         0        /* command mode   */
#define   HELPMODE        1        /* HELPMODE mode */
#define   DATAMODE        2        /* data mode      */
#define   ESCMODE         3        /* Esc sequence mode */
#define   LOGINMODE       4        /* Login mode       */
#define  CALLMODE         5        /* calling mode */
#define  LOOPMODE         6        /* loopback mode */
#define INPUTMODE         7        /* input mode */
#define  LOCKMODE         8        /* port lock mode */
#define  PASSWORDMODE     9        /* waiting for input password */
#define PFXMODE          10        /* waiting for input PFX response */

/***********************************************************
**
**
**        Port Information Table(PIT) Definitioni
**
**     PIT1 contains information of the port which will
**     reset to default value when the system is reset
**     for any reasons.
**
**     PIT2 conatins a copy of port information which is kept
**     in the non-volatile RAM. 
**
************************************************************/

typedef  struct pit_struct {
	unsigned int ii;           /* command line index */
	unsigned int ndi;          /* network data buffer index */
    u_short  mode;             /* mode of the port */
	u_short  prevmode;         /* previous mode of the port */
	short    idle_timer;       /* octart input idel timer */
	short    cmdind;           /* command index */
	u_char   misc[2];          /* use for misc purpose */
	u_char   logged;           /* log in user index, 0xff- no log in */
	char     access;           /* access level */
	unsigned char cmd_line[MAX_CL]; /* command line buffer */
	unsigned char prev[MAX_CL];     /* prev command line buffer */
	u_char   nbuf[260];        /* network data buffer */
    char     *fdata;           /* pointer to far data */
} RAM_PIT;

