/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      fddicmd.c
*
*       $Log:   /b/gregs/bridge/declike/cmd/fddicmd.c_v  $
 * 
 *    Rev 1.12   12 Oct 1993 10:20:06   vinay
 * removed the command def fddi mac frame status 
 * 
 *    Rev 1.11   14 Sep 1993 13:02:54   vinay
 * fixed smt report limit range
 * 
 *    Rev 1.10   08 Sep 1993 09:40:04   franks
 * 
 *    Rev 1.9   31 Aug 1993 10:37:20   gregs
 * lsh aug/31/93 added fixes for M_M  connection checking.
 * 
 *    Rev 1.8   30 Aug 1993 10:54:56   vinay
 * fixed bugs related to the command length and a bug in def mod smt userdata
 * 
 *    Rev 1.7   29 Jul 1993 16:37:40   vinay
 * 
 *    Rev 1.6   11 Jun 1993 12:07:14   vinay
 * cleaned up the debug statements
 * 
 *    Rev 1.5   04 Jun 1993 17:44:38   vinay
 * end of day checkin
 * 
 *    Rev 1.4   03 Jun 1993 18:33:18   vinay
 * end of day checkin
 * 
 *    Rev 1.3   02 Jun 1993 18:29:54   vinay
 * bug fixed version
 * 
 *    Rev 1.2   21 May 1993 17:36:52   vinay
 * not complete yet more rev's to come
 * 
 *    Rev 1.1   17 May 1993 17:55:30   vinay
 * ADded code to all the functions and this is a temp copy and there are lot of
 * changes and addtions to come
 * 
 *    Rev 1.0   10 May 1993 17:57:04   vinay
 * Initial revision.
*
*       Comments:      	Most of the command service functions use
*			ChangeMIBAttr to change the value of an 
*			attribute as that is the recomended way. In some
*			cases the value is written to nvram so that the
*			effect of the change will take place after the 
*			card is reset.			
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		
******************************************************************************/


#include <types.h>
#include <target.h>
#include <bridges.h>
#include <filter.h>
#include <utility.h>
#include <prcadr.h> 
#include <krnl.h>
#include <prcctl.h> 
#include <sncvar.h>
#include <eeprecs.h>
#include <nvrecs.h>
#include <nvram.h>
/******
#include <stp.h>
*******/
#include <tcpip.h>
#include <time.h>
#include <sys.h>
#include <cpb.h>
#include <834error.h>
#include <snmp.h>

#include <smtmacro.h>
#include <smtdefs.h>
#include <mibdefs.h>
#include <smttypes.h>
#include <fddihdr.h>
#include <rfc1285.h>
#include <edfddinvr.h>
#include <drv.h>
#include <define.h>

#include <ctype.h>
#include <smtmsg.h>
#include <fbmframe.h>

extern char *errmsg[];

extern char *port_type[];
extern char *port_location[];
extern char *port_action[];
extern char *port_attach_policy[];
extern char *port_conn_policy[];
extern char *port_maintline_state[];
extern char *frame_status_parm[];
extern char *mac_action_parm[];
extern char *mac_path_requested[];
extern char *mac_state[];
extern char *mac_stripping[];
extern char *smt_config_policy[];
extern char *connection_policy_parm[];

int echo_flag;
int strippingflag;

/****************************************************************************
**	These variables remembers the counter values when a clear 
**	fddi traffic counters command is executed.
****************************************************************************/
 uint MacTx_Ct = 0L;
 uint MACCopied_Ct = 0L;
 uint MACToken_Ct = 0L;
 uint MACError_Ct = 0L;
 uint MACLost_Ct = 0L;
 uint MACTvxExpired_Ct = 0L;
 uint MACRingOp_Ct = 0L;
 uint MACNotCopied_Ct = 0L;
/*
NVR_FDDI nvr_fddi_rec;
extern void MakeFrameMessage( SendFrameBuf *, uInt16, uChar * );
*/
extern TIMER EchoReqTimer;
MBOX EchoReqMBox;
#define ECHO_REQ_INTERVAL (5000)

extern char PRIMARY[];
extern char SECONDARY[];

static TLVSetCountType  setCount; /* Used as a semaphore in changing the
					mib attribute */
static SMTStationIdType myStationId; /* My Station Id */

/************************************************************************
**
**	Function to pick up the port A or B in parmptr
**
************************************************************************/
int defFddiPort(CPB_P pcpb)
{
	char *kw;
	int kw_sz;
	int j;
		
	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if((j = validPort(kw)) == -1)
		return KW_UN_AMB;
	pcpb->parmptr[0] = j;
	pcpb->parmptr[1] = 0;
	pcpb->cl_idx += kw_sz;
	return 0;
}

/***************************************************************************
**
**	Function to pick up the PRIMARY OR SECONDARY in parmptr
**
***************************************************************************/
int defineFddiIntPath(CPB_P pcpb)
{
	char *kw;
	int kw_sz,j;
#ifdef removed
	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if(strcmpi(kw,PRIMARY) == 0 )
		pcpb->parmptr[0] = 1;
	else if(strcmpi(kw,SECONDARY) == 0 )
		pcpb->parmptr[0] = 2;
	else 
		return KW_UN_AMB;

	pcpb->cl_idx += kw_sz;
#endif
	pcpb->parmptr[0] = 1;
	return 0;
}

/**************************************************************************
**
**		Service routine for clear mod smt conn command
**
**************************************************************************/
int ClearSmtConn(CPB_P pcpb)
{
	int idx, j, temp = 0;
	char *kw;
	int kw_sz;
	int result;
	TLVParamType    buffer;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if((j = chk_parm(kw,connection_policy_parm)) == -1)
		return(KW_UN_AMB);

	if((1 << j) & 0x8000)	/* The bit for M_M cannot be cleared */
		return ERR_CANNOT_MODIFY;

	pcpb->cl_idx += kw_sz;

	buffer.paramType = fddiSMTConnectionPolicy;
	buffer.paramLen  = 0;

	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	if(result != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;

	temp = buffer.SMTPARAM16;

	if(~temp & (1 << j))	/* check if the connection is defined */
		return ERR_CONN_POLICY;

	buffer.paramType = fddiSMTConnectionPolicy;
	buffer.paramLen  = 4;
	temp &= ~(1 << j);
	temp |= (1 << 15); /* THIS BIT FOR M_M HAS TO BE SET ALWAYS */
	buffer.SMTPARAM16 = temp;

	do{
		result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer,&setCount, &myStationId);
	}while (result == RC_BAD_SET_COUNT);

	if(result != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;
	return 0;
}

/**************************************************************************
**
**		Service routine for def fddi port {a|b} action command
**
**************************************************************************/
int DefineFddiPortAction(CPB_P pcpb)
{
	char    *kw;
	int     kw_sz, i,j,k;
	int     port,setCount;
	TLVParamType    buffer;
	uint    res;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if((k = chk_parm(kw,port_action)) == -1)
		return(KW_UN_AMB);

	pcpb->cl_idx += kw_sz;

	buffer.paramType = fddiPORTAction;
	buffer.paramLen = 8;
	buffer.PORTINDEX = pcpb->parmptr[0];
	buffer.PORTPARAM16 = k;

	do{
	res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,&setCount,
					&myStationId);
	}while(res == RC_BAD_SET_COUNT);

	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;
	return 0;
}

/**************************************************************************
**
**		Service routine for def fddi port {a|b} attach command
**
**************************************************************************/
int DefineFddiAttachPolicy(CPB_P pcpb)
{
	char    *kw;
	int     kw_sz, i,j;
	int     port;
	int 	k;
	TLVParamType    buffer;
	uint    res;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if((k = chk_parm(kw,port_attach_policy)) == -1)
		return(KW_UN_AMB);


	pcpb->cl_idx += kw_sz;
	for(i=1; i<3; i++) {

		buffer.paramType = fddiATTACHMENTInsertPolicy;
		buffer.paramLen = 8;
		buffer.ATTACHINDEX = i; 
		buffer.ATTACHPARAM8 = k;

		do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,&setCount,
					&myStationId);
		}while (res == RC_BAD_SET_COUNT);

	}
	/* Store the info in nvram. */
	nvr_fddi_rec.ATTACHMENTInfo[0].opticalBypassPresent = k;
	nvr_fddi_rec.ATTACHMENTInfo[1].opticalBypassPresent = k;
	PutFDDIRec(&nvr_fddi_rec);

	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;

	return 0;
}

/**************************************************************************
**
**		Service routine for def fddi port {a|b} connection command
**
**************************************************************************/
int DefineFddiConnPolicies(CPB_P pcpb)
{
	char    *kw;
	int     kw_sz, i;
	int     k;
	TLVParamType    buffer;
	uint    res;
	byte j = 0x00;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if(((k = chk_parm(kw,port_conn_policy)) == -1) &&
		strcmpi(kw,"NONE") != 0)
		return(KW_UN_AMB);

	pcpb->cl_idx += kw_sz;

	if(strcmpi(kw,"NONE") != 0)
	{
		buffer.paramType = fddiPORTConnectionPolicies;
		buffer.paramLen  = 4;
		buffer.PORTINDEX = pcpb->parmptr[0];
		res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
		j = (int)  buffer.PORTPARAM8;
		j |= (1 << k);
	}
	else
		j = 0x00;

	buffer.paramType = fddiPORTConnectionPolicies;
	buffer.paramLen = 8;
	buffer.PORTINDEX = pcpb->parmptr[0];
	buffer.PORTPARAM8 = j;

	do{
	res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,&setCount,
					&myStationId);
	} while (res == RC_BAD_SET_COUNT);

	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;

	return 0;
}

/**************************************************************************
**
**		Service routine for def fddi port {a|b} Location command
**		The name sounds funny but this command really just sets
**		the default locations front/back for the FDDI PHY inputs.
**************************************************************************/
int DefineFddiPortType(CPB_P pcpb)
{
	char    *kw;
	int     kw_sz;
	int 	k;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if((k = chk_parm(kw,port_location)) == -1) 
		return KW_UN_AMB;

	pcpb->cl_idx += kw_sz;
	if(pcpb->cmdlen > pcpb->cl_idx)
		return CMD_SYNTAX_ERR;

	if(k == 0)
	{
		if(pcpb->parmptr[0] == 1)
			nvr_fddi_rec.UI_Defaults.Port1_PC_Type = 0;
		else
		if(pcpb->parmptr[0] == 2)
			nvr_fddi_rec.UI_Defaults.Port6_PC_Type = 1;

		PutFDDIRec(&nvr_fddi_rec);
		insert_hub_ring(0, get_ring_number());
	}
	else
	if(k == 1)
	{
		if(pcpb->parmptr[0] == 1)
			nvr_fddi_rec.UI_Defaults.Port1_PC_Type = 3;
		else
		if(pcpb->parmptr[0] == 2)
			nvr_fddi_rec.UI_Defaults.Port6_PC_Type = 3;
		PutFDDIRec(&nvr_fddi_rec);
		insert_hub_ring(0, get_ring_number());
	}
	else 
		return KW_UN_AMB;
	return 0;
}

/* ***********************************************************************
**	This function changes the port type.  This is also used 
**	by the SNMP service routine.
**************************************************************************/
ChangePortPcType(portno,type)
int portno,type;
{
	int k,port;

	type--;

	k = (portno == 2)?1:0; 
	if(type == 2)
	{
		port = (portno == 1)?1:0; /* if port is A, 1 according to SNMP
					  ** select the port B and set it to type 
					  ** s.
					  */
		if(nvr_fddi_rec.PORTInfo[port].PC_Type != PC_Type_S) 
		{
			nvr_fddi_rec.PORTInfo[port].PC_Type = PC_Type_S;
		}
		nvr_fddi_rec.PORTInfo[k].PC_Type = PC_Type_S;
	}
	else if(type == 0 || type == 1)
	{
		nvr_fddi_rec.PORTInfo[1].PC_Type = PC_Type_B;
		nvr_fddi_rec.PORTInfo[0].PC_Type = PC_Type_A;

	}
	else 
		return NO_SUCH_NAME;

	PutFDDIRec(&nvr_fddi_rec);
	return 0;
}


/**************************************************************************
**
**		Service routine for def fddi port {a|b} macloop command
**
**************************************************************************/
int DefineFddiPortMacLoop(CPB_P pcpb)
{
	char    *kw;
	int     kw_sz;
	TLVParamType    buffer;
	uint    res;
	uint 	value;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += kw_sz;

	if(pcpb->cmdlen > pcpb->cl_idx)
		return KW_UN_AMB;

	if ( verify_timer_input(kw, &value) != 0 )
		return KW_UN_AMB;
	/* RANGE >= 2500000 && < MAX_TIMER_VAL */
	if(value < 2500000 || value > MAX_TIMER_VAL) 
		return OUT_OF_RANGE;


	buffer.paramType = fddiPORTMACLoop_Time;
	buffer.paramLen  = 8;
	buffer.PORTINDEX = pcpb->parmptr[0];
	buffer.PORTPARAM32 = value;

	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&myStationId);
	}while (res == RC_BAD_SET_COUNT);

	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;
	return 0;
}

/**************************************************************************
**
**		Service routine for def fddi port {a|b} leralarm command
**
**************************************************************************/
int DefineFddiLerAlarm(CPB_P pcpb)
{
	char    *kw;
	int     kw_sz, i,j;
	int     port,value;
	TLVParamType    buffer;
	uint    res;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if(!atod(kw,&value))
		return KW_UN_AMB;

	if(value < 4 || value > 15 )
		return OUT_OF_RANGE;
	pcpb->cl_idx += kw_sz;
	buffer.paramType = fddiPORTLer_Alarm;
	buffer.paramLen  = 8;
	buffer.PORTINDEX = pcpb->parmptr[0];
	buffer.PORTPARAM8 = value;
	do {
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&myStationId);
	}while (res == RC_BAD_SET_COUNT);

	if (res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;
	return 0;
}
/**************************************************************************
**
**		Service routine for def fddi port {a|b} lercutoff command
**
**************************************************************************/
int DefineFddiLerCutoff(CPB_P pcpb)
{
	char    *kw;
	int     kw_sz;
	uint    value;
	uint    res;
	TLVParamType    buffer;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if(!atod(kw,&value))
		return KW_UN_AMB;


	if(value < 4 || value > 15 )
		return OUT_OF_RANGE;
	pcpb->cl_idx += kw_sz;
	buffer.paramType = fddiPORTLer_Cutoff;
	buffer.paramLen  = 8;
	buffer.PORTINDEX = pcpb->parmptr[0];
	buffer.PORTPARAM8 = value;
	do {
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&myStationId);
	}while (res == RC_BAD_SET_COUNT);

	if (res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;
	return 0;
}
/**************************************************************************
**
**		Service routine for def fddi port {a|b} maintline command
**
**************************************************************************/
int DefineFddiPortMalineSt(CPB_P pcpb)
{
	char    *kw;
	int     kw_sz, i,j,k;
	int     port;
	TLVParamType    buffer;
	uint    res;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if((k = chk_parm(kw,port_maintline_state)) == -1)
		return(KW_UN_AMB);

	pcpb->cl_idx += kw_sz;

	buffer.paramType = fddiPORTMaintLineState;
	buffer.paramLen  = 8;
	buffer.PORTINDEX = pcpb->parmptr[0];
	buffer.PORTPARAM8 = k;

	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&setCount,&myStationId);
	} while (res == RC_BAD_SET_COUNT);

	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;

	return 0;
}
/**************************************************************************
**
**		Service routine for def fddi port {a|b} tb_max command
**
**************************************************************************/
int DefineFddiPortTbMax(CPB_P pcpb)
{
	char    *kw;
	int     kw_sz;
	uint    value;
	uint	res;
	TLVParamType    buffer;


	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += kw_sz;

	if(pcpb->cmdlen > pcpb->cl_idx)
		return KW_UN_AMB;

	if ( verify_timer_input(kw, &value) != 0 )
		return KW_UN_AMB;


	if(value < MIN_TIMER_VAL || value > MAX_TIMER_VAL )
		return OUT_OF_RANGE;


	buffer.paramType = fddiPORTTB_Max;
	buffer.paramLen = 8;
	buffer.PORTINDEX = pcpb->parmptr[0];
	buffer.PORTPARAM32 = -value;
	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&setCount,&myStationId);
	} while (res == RC_BAD_SET_COUNT);

	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;

	return 0;
}
/**************************************************************************
**
**		Service routine for def fddi port {a|b} tracemax command
**
**************************************************************************/
int DefFddiTraceMax(CPB_P pcpb)
{
	char *kw;
	TLVParamType    buffer;
	uint	res,req_val;
	int 	kw_sz,value;


	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if ( verify_timer_input(kw, &value) != 0 )
		return OUT_OF_RANGE;
	pcpb->cl_idx += kw_sz;

	if ( value < MIN_TIMER_VAL || value > MAX_TIMER_VAL )
		return OUT_OF_RANGE;

	buffer.paramType = fddiPATHClassTrace_MaxExpiration;
	buffer.paramLen  = 8;
	buffer.PATHINDEX = pcpb->parmptr[0];
	buffer.PATHPARAM32 = -value;
	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&setCount,&myStationId);
	} while (res == RC_BAD_SET_COUNT);

	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;

	return 0;
}
/**************************************************************************
**
**		Service routine for def fddi port {a|b} t_max command
**
**************************************************************************/
int DefFddiT_Max(CPB_P pcpb)
{
	char *kw;
	TLVParamType    buffer;
	uint	res;
	uint	kw_sz,value;
	uint 	max_value,min_value;
	uint	TvxValue;


	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if ( verify_timer_input(kw, &value) != 0 )
		return OUT_OF_RANGE;

	pcpb->cl_idx += kw_sz;
	if ( value < MIN_TIMER_VAL || value > MAX_TIMER_VAL )
		return OUT_OF_RANGE;

	buffer.paramType = fddiPATHClassT_MaxLowerBound;
	buffer.paramLen  = 8;
	buffer.PATHINDEX = pcpb->parmptr[0];
	buffer.PATHPARAM32 = -value;

	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&setCount,&myStationId);
	} while (res == RC_BAD_SET_COUNT);
	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;

	return 0;
}

/**************************************************************************
**
**		Service routine for def fddi path {PRI|SEC}  mac tvx command
**
**************************************************************************/
int DefFddiTvx(CPB_P pcpb)
{
	char *kw;
	TLVParamType    buffer;
	uint	res;
	uint	kw_sz,value;
	uint 	min_value,max_value;


	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if ( verify_timer_input(kw, &value) != 0 )
		return OUT_OF_RANGE;

	pcpb->cl_idx += kw_sz;
	if ( value < MIN_TIMER_VAL || value > MAX_TIMER_VAL )
		return OUT_OF_RANGE;
	buffer.paramType = fddiPATHClassTVXLowerBound;
	buffer.paramLen  = 8;
	buffer.PATHINDEX = pcpb->parmptr[0];
	buffer.PATHPARAM32 = -value;
	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&setCount,&myStationId);
	} while (res == RC_BAD_SET_COUNT);
	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;
	return 0;
}
/**************************************************************************
**
**	Service routine for def fddi path {PRI|SEC}  latency  command
**
**************************************************************************/
int DefFddiLatency(CPB_P pcpb)
{
	uint kw_sz, value;
	char *kw;
	TLVParamType    buffer;
	uint	res;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if ( verify_timer_input(kw, &value) != 0 )
		return KW_UN_AMB;

	if ( value < MIN_TIMER_VAL || value > MAX_TIMER_VAL )
		return OUT_OF_RANGE;

	pcpb->cl_idx += kw_sz;
	buffer.paramType = fddiPATHClassPATHRingLatency;
	buffer.paramLen  = 8;
	buffer.PATHINDEX = pcpb->parmptr[0];
	buffer.PATHPARAM32 = -value;

	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&setCount,&myStationId);
	} while (res == RC_BAD_SET_COUNT);

	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;
	
	return 0;
}
/**************************************************************************
**
**	Service routine for def fddi path {PRI|SEC}  rmode  command
**
**************************************************************************/
int DefFddiRmode(CPB_P pcpb)
{
	uint kw_sz, value;
	char *kw;
	TLVParamType    buffer;
	uint	res;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if ( verify_timer_input(kw, &value) != 0 )
		return KW_UN_AMB;
	if ( value < MIN_TIMER_VAL || value > MAX_TIMER_VAL )
		return OUT_OF_RANGE;

	pcpb->cl_idx += kw_sz;
	buffer.paramType = fddiPATHClassPATHT_Rmode;
	buffer.paramLen  = 8;
	buffer.PATHINDEX = pcpb->parmptr[0];
	buffer.PATHPARAM32 = -value;

	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&setCount,&myStationId);
		ReSchedule();
	} while (res == RC_BAD_SET_COUNT);

	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;
	
	return 0;
}
/**************************************************************************
**
**	Service routine for def fddi int mac frame error command
**
**************************************************************************/
int DefFddiMacFrameErrTh(CPB_P pcpb)
{
	uint kw_sz, num;
	char *kw;
	TLVParamType    buffer;
	uint	res;

	 kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if ( !atod(kw,&num) )
		return KW_UN_AMB;

	if ( num < MIN_THRESHOLD_VALUE || num > MAX_THRESHOLD_VALUE )
		return OUT_OF_RANGE;
	pcpb->cl_idx += kw_sz;

	buffer.paramType = fddiMACFrameErrorThreshold;
	buffer.paramLen  = 8;
	buffer.MACINDEX = 1;
	buffer.MACPARAM16 = num;

	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&setCount,&myStationId);
	} while (res == RC_BAD_SET_COUNT);

	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;

	return 0;
}

#ifdef notsupported
/**************************************************************************
**
**	Service routine for def fddi int mac frame status command
**
**************************************************************************/
int DefFddiMacFrameSta(CPB_P pcpb)
{

	int kw_sz, j;
	int res;
	char *kw;
	TLVParamType    buffer;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if((j = chk_parm(kw,frame_status_parm)) == -1)
		return(KW_UN_AMB);

	pcpb->cl_idx += kw_sz;
	if(pcpb->cmdlen > pcpb->cl_idx) 
		return CMD_SYNTAX_ERR;

	j = 1 << j;

	buffer.paramType = fddiMACFrameStatus;
	buffer.paramLen = 8;
	buffer.MACINDEX = 1;
	buffer.MACPARAM16 = (ushort)j;

	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&setCount,&myStationId);
	} while (res == RC_BAD_SET_COUNT);
	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;
	return 0;
}
#endif

/**************************************************************************
**
**	Service routine for def fddi int mac action command
**
**************************************************************************/
int DefFddiMacAction(CPB_P pcpb)
{
	int kw_sz, j;
	char *kw;
	TLVParamType    buffer;
	uint	res;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if((j = chk_parm(kw,mac_action_parm)) == -1)
		return(KW_UN_AMB);

	pcpb->cl_idx += kw_sz;

	buffer.paramType = fddiMACAction;
	buffer.paramLen  = 8;
	buffer.MACINDEX = 1;
	buffer.MACPARAM16 = j ;
	
	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&setCount,&myStationId);
	} while (res == RC_BAD_SET_COUNT);

	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;

	return 0;
}
/**************************************************************************
**
**	Service routine for def fddi int mac notcopied command
**
**************************************************************************/
int DefFddiMacNotCopiedTh(CPB_P pcpb)
{
	int kw_sz, j;
	char *kw;
	uint num;

	TLVParamType    buffer;
	uint	res;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if ( !atod(kw,&num) )
		return KW_UN_AMB;

	if ( num < 0 || num > 0xffff )
		return OUT_OF_RANGE;

	pcpb->cl_idx += kw_sz;

	buffer.paramType = fddiMACNotCopiedThreshold;
	buffer.paramLen  = 8;
	buffer.MACINDEX = 1;
	buffer.MACPARAM16 = num;
	
	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&setCount,&myStationId);
		ReSchedule();
	} while (res == RC_BAD_SET_COUNT);

	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;

	return 0;
}
/**************************************************************************
**
**	Service routine for def fddi int mac path command
**
**************************************************************************/
int DefFddiMacPath(CPB_P pcpb)
{
	int kw_sz, j;
	char *kw;

	TLVParamType    buffer;
	u_int 	res;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if((j = chk_parm(kw,mac_path_requested)) == -1)
		return(KW_UN_AMB);

	if(j == 2) j = 3;
	j |= (1 << j);

	pcpb->cl_idx += kw_sz;

	buffer.paramType = fddiMACPathsRequested;
	buffer.paramLen  = 8;
	buffer.MACINDEX = 1;
	buffer.MACPARAM8 = j ;
	
	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&setCount,&myStationId);
		ReSchedule(); /* reschedule so that this loop
				will not exceed max time reqd to
				reset */
	} while (res == RC_BAD_SET_COUNT);

	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;

	return 0;
}
/**************************************************************************
**
**	Service routine for def fddi int mac state command
**
**************************************************************************/
#ifdef notused

int DefFddiMacState(CPB_P pcpb)
{
	int kw_sz, j;
	char *kw;

	TLVParamType    buffer;
	uint	res;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if((j = chk_parm(kw,mac_state)) == -1)
		return(KW_UN_AMB);

	pcpb->cl_idx += kw_sz;
	pcpb->cl_idx = pcpb->cmdlen;

	buffer.paramType = fddiPORTPathsRequested;
	buffer.paramLen  = 8;
	buffer.MACINDEX = 1;
	buffer.MACPARAM16 = j ;
	
	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
				&setCount,&myStationId);
	} while (res == RC_BAD_SET_COUNT);

	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;

	return 0;
}
/**************************************************************************
**
**	Service routine for def fddi int mac stripping command
**
**************************************************************************/
int DefFddiMacStripping(CPB_P pcpb)
{
	int kw_sz, j;
	char *kw;

	int macno;

	TLVParamType    buffer;
	uint	res,req_val;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if((j = chk_parm(kw,mac_stripping)) == -1)
		return(KW_UN_AMB);

	pcpb->cl_idx += kw_sz;

	macno = 0;

	if(j == 1)  
	{
		req_val = DRV_ENABLE;
		strippingflag = 1;
	}
	else
	{
		req_val = DRV_DISABLE;
		strippingflag = 0;
	}

	DRV_ControlReq(macno, HLS_CTRL_MAC_STRIP, req_val);
	return 0;
}
#endif

/**************************************************************************
**
**	Service routine for def fddi int mac t_max command
**
**************************************************************************/
int DefFddiMacT_Max(CPB_P pcpb)
{
	uint kw_sz, num;
	char *kw;
	int max_value, min_value, TvxValue;
	int macno;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if ( verify_timer_input(kw, &num) != 0 )
		return KW_UN_AMB;

	pcpb->cl_idx += kw_sz;

	/* ShowMibAttr () gets the values for the specified type and
	   the value is returned in the last parameter TvxValue
	   in this case */

	ShowMibAttr(1 /* GET THE MAC ATTR*/,fddiMACTvxValue,4,
			1/* MACINDEX */,&TvxValue);

	TvxValue = MFddi2Usecs(-TvxValue);
	/* convert min and max values for TMAX to FDDITIME */
	min_value = MUsecs2Fddi(T_MAX_MIN(TvxValue)) ;
	max_value  =  MUsecs2Fddi(T_MAX_MAX) ;
	if(num < min_value || num > max_value)
		return OUT_OF_RANGE;

	macno = 0;

	nvr_fddi_rec.MACInfo[macno].T_Max =  -num;
	PutFDDIRec(&nvr_fddi_rec);
	return 0;
}
/**************************************************************************
**
**	Service routine for def fddi int mac t_min command
**
**************************************************************************/
int DefFddiMacT_Min(CPB_P pcpb)
{
	uint kw_sz, num;
	char *kw;
	int max_value, min_value, TvxValue;
	int macno;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += kw_sz;

	if ( verify_timer_input(kw, &num) != 0 )
		return KW_UN_AMB;

	/* convert Min and Max for Tvx value to Fdditime */
	max_value = MUsecs2Fddi(T_MIN_MAX) ;

	if ( num < MIN_TMIN || num > max_value )
		return OUT_OF_RANGE;
	macno = 0;
	nvr_fddi_rec.MACInfo[macno].T_Min = -num;
	PutFDDIRec(&nvr_fddi_rec);
	return 0;
}
/**************************************************************************
**
**	Service routine for def fddi int mac t_pri command
**
**************************************************************************/
int DefFddiMacT_Pri(CPB_P pcpb)
{
	int kw_sz, num;
	char *kw;
	int min_value, max_value;
	int macno,index;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += kw_sz;

	if(!atod(kw,&index))
		return KW_UN_AMB;

	if(index < 0 || index > 6)
		return OUT_OF_RANGE;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += kw_sz;

	if ( verify_timer_input(kw, &num) != 0 )
		return KW_UN_AMB;
	macno = 0;
	if ( num < MIN_TMIN || num > MAX_TIMER_VAL )
		return OUT_OF_RANGE;

	nvr_fddi_rec.MACInfo[macno].T_Pri[index] =  -num;
	PutFDDIRec(&nvr_fddi_rec);
	return 0;
}
/**************************************************************************
**
**	Service routine for def fddi int mac t_req command
**
**************************************************************************/
int DefFddiMacT_Req(CPB_P pcpb)
{

	uint kw_sz, num;
	char *kw;
	int t_max, t_min;
	TLVParamType    buffer;
	uint	res,req_val;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += kw_sz;

	if ( verify_timer_input(kw, &num) != 0 )
		return KW_UN_AMB;


	/* ShowMibAtte () gets the values for the specified type and
	   the value is returned in the last parameter t_max and t_min
	   in this case */

	ShowMibAttr(1 /* GET THE MAC ATTR*/,fddiMACT_Max,0,1,&t_max);
	ShowMibAttr(1 /* GET THE MAC ATTR*/,fddiMACT_Min,0,1,&t_min);


	if (num < -t_min || num > -t_max)
		return OUT_OF_RANGE;

	buffer.paramType = fddiMACT_Req;
	buffer.paramLen  = 4;
	buffer.MACINDEX = 1;
	buffer.MACPARAM32 = -num;

	do{
	res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,&setCount,
				&myStationId);
	} while (res == RC_BAD_SET_COUNT);
	
	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;
	return 0;
}
/**************************************************************************
**
**	Service routine for def fddi int mac tvx command
**
**************************************************************************/
int DefFddiMacTvx(CPB_P pcpb)
{
	uint idx, num,kw_sz;
	char *kw,b;
	uint max_value, min_value;
	int macno;
	int f;

	idx = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += idx;


	if ( verify_timer_input(kw, &num) != 0 )
		return KW_UN_AMB;

	min_value  =  MUsecs2Fddi(TVX_MIN) ;
	max_value  =  MUsecs2Fddi(TVX_MAX) ;

	if ( num < min_value || num > max_value )
		return OUT_OF_RANGE;

	macno = 0;
	nvr_fddi_rec.MACInfo[macno].TVXValue =  -num;
	PutFDDIRec(&nvr_fddi_rec);
	return 0;
}
/**************************************************************************
**
**	Service routine for def mod smt config command
**
**************************************************************************/
int DefineModSMTConfig(CPB_P pcpb)
{
	int kw_sz, j;
	char *kw;
	int macno;
	TLVParamType    buffer;
	uint	res,req_val;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += kw_sz;

	if((j = chk_parm(kw,smt_config_policy)) == -1)
		return(KW_UN_AMB);

	j = (j == 0) ? 2:1; /* set the bit 2 if CF_WRAP_AB else set bit 1 */

#ifdef 0
	buffer.paramType = fddiSMTConfigPolicy;
	buffer.paramLen  = 0;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	j |= buffer.SMTPARAM16 ;
#endif

	macno = 0;

	buffer.paramType = fddiSMTConfigPolicy;
	buffer.paramLen  = 4;
	buffer.SMTPARAM16 = j;
	do{
	res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,&setCount,
				&myStationId);
	} while (res == RC_BAD_SET_COUNT);
	
	if(res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;
	return 0;
}
int DefineModSMTConn(CPB_P pcpb)
{

	TLVParamType    buffer;
	uint            res, temp;
	int 		kw_sz;
	int 		k;
	ushort 		j;
	char 		*kw;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += kw_sz;

	if((k = chk_parm(kw,connection_policy_parm)) == -1)
		return(KW_UN_AMB);

	buffer.paramType = fddiSMTConnectionPolicy;
	buffer.paramLen  = 0;

	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	j = buffer.SMTPARAM16;
	j |= (1 << k);
	j |= (1 << 15);	/* Connection policy must always reject
			   M_M.  If this is not set the ChangeMIBAttr
			   will return OUT_OF_RANGE */
	
	buffer.paramType = fddiSMTConnectionPolicy;
	buffer.paramLen  = 4;
	buffer.SMTPARAM16 = j;
	do
	{
	res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
	&setCount, &myStationId);
	ReSchedule();
	
	} while (res == RC_BAD_SET_COUNT);
	
	if (res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;
	return 0;
}
int DefineModSMTOPversion(CPB_P pcpb)
{
	TLVParamType    buffer;
	uint            res, temp;
	int 		kw_sz, j;
	int		max_value,min_value;
	uint 		num;
	char *kw;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);


	if ( !atod(kw,&num) )
		return KW_UN_AMB;

	pcpb->cl_idx += kw_sz;

	/* Get the minimum value */
	buffer.paramType = fddiSMTLoVersionId;
	buffer.paramLen = 0;
	GetMIBAttr(sizeof(buffer), &buffer,(TLVSetCountType *) NULL);
	min_value = (int) buffer.SMTPARAM16;

	/* Get the maximum value */
	buffer.paramType = fddiSMTHiVersionId;
	GetMIBAttr(sizeof(buffer), &buffer,(TLVSetCountType *) NULL);
	max_value = (int) buffer.SMTPARAM16;
	if ( num < min_value  || num > max_value )
		return OUT_OF_RANGE;
		
	buffer.paramType = fddiSMTOpVersionId;
	buffer.paramLen  = 4;
	buffer.SMTPARAM16 = num;
	do
	{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
			&setCount, &myStationId);
	
	} while (res == RC_BAD_SET_COUNT);
	
	if (res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;
	return 0;
}

int DefineModSMTReport(CPB_P pcpb)
{
	int kw_sz; 
	uint num;
	char *kw;
	TLVParamType    buffer;
	int res;
	char *eptr;
	
	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	num = strtoul(kw,&(char *)eptr,10);

	
	pcpb->cl_idx += kw_sz;
	if (num < 1 || num >= MAX_INT_VALUE )
		return OUT_OF_RANGE;

	buffer.paramType = fddiSMTReportLimit;
	buffer.paramLen  = 4;
	buffer.SMTPARAM32 = num;

	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
			&setCount, &myStationId);
	
	} while (res == RC_BAD_SET_COUNT);
	
	if (res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;
	return 0;
}
int DefineModSMTT_Notify(CPB_P pcpb)
{
	int kw_sz, num;
	char *kw;
	TLVParamType    buffer;
	uint res;
	
	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if ( verify_timer_input(kw, &num) != 0 )
		return KW_UN_AMB;

	/* store value in secs */
	num =  MFddi2Usecs(num) / 1000000;

	if ( num < 2 || num > 30 )
		return OUT_OF_RANGE;

	pcpb->cl_idx += kw_sz;
	buffer.paramType = fddiSMTT_Notify;
	buffer.paramLen  = 4;
	buffer.SMTPARAM16 = num;

	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
			&setCount, &myStationId);
	
	} while (res == RC_BAD_SET_COUNT);
	
	if (res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;

	return 0;
}
int DefineModSMTUserData(CPB_P pcpb)
{
	int kw_sz = 0;
	char *kw,temp[34];
	TLVParamType    buffer;
	uint res;
	int value,i;
	
	memset(temp,0,34);
	kw = &pcpb->cmd[pcpb->cl_idx];

	if(*kw != '"')
		return CMD_SYNTAX_ERR;
	kw++;

	while(kw[kw_sz] != '"' && kw_sz <= 32)
		if(kw[kw_sz] == '"')
			break;
		else
			kw_sz++;

	if(kw[kw_sz] != '"' )
		return CMD_SYNTAX_ERR;

	kw[kw_sz] = '\0';	
	if(strlen(kw) > 32)
		return ERR_STR_TOO_LONG;
	pcpb->cl_idx += kw_sz+2;
	strcpy(temp,kw);

	if(pcpb->cl_idx < pcpb->cmdlen)
	{
		kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
		if(strlen(kw) != 0)
			return CMD_SYNTAX_ERR;
	}

		
	buffer.paramType = fddiSMTUserData;
	buffer.paramLen  = 32;
	memcpy(buffer.SMTOTHER, temp, 32);

	do{
		res = ChangeMIBAttr(sizeof(buffer), (u_char *)&buffer,
			&setCount, &myStationId);
	
	} while (res == RC_BAD_SET_COUNT);
	
	if (res != RC_SUCCESS)
		return ERR_CANNOT_MODIFY;

	return 0;
}

int ClearFddiTrafficCounters(CPB_P pcpb)
{
	int kw_sz;
        char *kw;
        TLVParamType buffer;
        uint res;
        uint value = 0L;

        kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if(strcmpi(kw, "TRAFFIC") != 0 && strlen(kw) < 2)
		return KW_UN_AMB;

	pcpb->cl_idx += kw_sz;

	/*
	* show mod fddi traffic displays the actual count-the counters
	* values remembered here.  This gives the effect of clear
	* counters without having to stop the mac 
	*/	
	
	ShowMibAttr(1,fddiMACTransmit_Ct,4,1,&MacTx_Ct);
	ShowMibAttr(1,fddiMACCopied_Ct,4,1,&MACCopied_Ct);
	ShowMibAttr(1,fddiMACToken_Ct,4,1,&MACToken_Ct);
	ShowMibAttr(1,fddiMACError_Ct,4,1,&MACError_Ct);
	ShowMibAttr(1,fddiMACLost_Ct,4,1,&MACLost_Ct);
	ShowMibAttr(1,fddiMACTvxExpired_Ct,4,1,&MACTvxExpired_Ct);
	ShowMibAttr(1,fddiMACRingOp_Ct,4,1,&MACRingOp_Ct);
	ShowMibAttr(1,fddiMACNotCopied_Ct,4,1,&MACNotCopied_Ct);

	return 0;

}
int DefineBrgRing(CPB_P pcpb)
{
	int kw_sz;	
	char *kw;
	TLVParamType buffer;
	uint res;
	ushort num;

	extern int s;

	kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += kw_sz;

	if(strcmpi(kw,"NONE") == 0)
		num = 0xffff;
	else if(!atod(kw,&num))
		return KW_UN_AMB;


	/*
	* for scc debug
	if (strcmpi(kw, "ON") == 0)
		SetSccMonitor(1);
	else if (strcmpi(kw, "OFF") == 0)
		SetSccMonitor(0);

	if(!atod(kw,&num))
		return KW_UN_AMB;
	return NOT_IMPLEMENTED;
	*/

	if((num < 0 || num > 15) && num != 0xffff)
		return OUT_OF_RANGE;
	eep_boot_rec.eep_ring_number = num;	
	PutEeprom(EEP_BOOT_ADDR,&eep_boot_rec,EEP_BOOT_SIZE);

	/*
	* for scc debug
	*/
	insert_hub_ring(0, get_ring_number());

	return 0;
}

void EchoTimeOut()
{
        /* reset echo flag */
        echo_flag = 0;
        printf("Time out; Echo Response not received\n");
}

int Echo(CPB_P lcpb)
{
        char    *kw;
        int     kw_sz, i,j, retcode, index;
        unsigned char phy[6];
        SendFrameBuf buf;
        unsigned char echo_str[255];
        uInt16 MAP_ActiveMACID = 0;/* ONLY ONE MAC IS ON THE FDDI-ENET BRG */

        kw_sz = pick_a_kw(&lcpb->cmd[lcpb->cl_idx],&kw,CASE_INSENSITIVE);

        lcpb->cl_idx += kw_sz;

        if ((retcode=interpret_name(kw,kw_sz,phy))!=0)
            return(retcode);

        if (phy[0]==0 && phy[1]==0 && phy[2]==0 &&
                phy[3]==0 && phy[4]==0 && phy[5]==0)
                        return(INV_PHY_ADDR);

	if (phy[0]==0xff && phy[1]==0xff && phy[2]==0xff &&
                phy[3]==0xff && phy[4]==0xff && phy[5]==0xff)
                        return(INV_PHY_ADDR);
        printf("Sending Echo Request Frame with the message:\n");
        printf("\t Hughes LAN Systems FDDI-ENET Bridge \n");
        printf("to ");
        for (i=0;i<6;i++)
                printf( "%2x.",phy[i]);
        printf("\n");
        memcpy(&buf.frameData.ecf.destAddr, &phy[0],6);
        strcpy(echo_str, "Hughes LAN Systems FDDI-ENET Bridge \n");

        buf.frameData.ecf.FC = SMT_INFO_FC;
        buf.frameClass = ECHO_CLASS;
        buf.frameType = SMTREQUEST;

        /* send echo request on mac specified by user */
        buf.frameData.ecf.sourceMAC = MAP_ActiveMACID;
        MakeFrameMessage (&buf, strlen (echo_str), echo_str);
        StartTimerCall(&EchoReqTimer, ECHO_REQ_INTERVAL,EchoTimeOut, 0);

        echo_flag = 1;

        return(0);
}
int ProcessEchoResponse(msg)
SMTMessage *msg;
{
MACAddr48       destAddr;
RecFrameBuf     *recBuf;
SMTFrameHdrType *frameHdr;
MACAddr48       SrcAddr, UNAAddr;
uInt16          MacNum, i;
ParamHdrType    *phdr;
EchoParamType    *unaptr;
Int16           compare;

        if ( echo_flag  == 0)
        /* echo frame not for UI  or echo request timed out */
                return 0;

        StopTimer(&EchoReqTimer);

        /* get smt frame */
        frameHdr = (SMTFrameHdrType *) msg->p2;

       /*
        *       Get parameter header.
        */
        phdr = (ParamHdrType *) (frameHdr + 1);

        if ( (ntohs (phdr->type)) == ECHO_PARAM_TYPE)
        {
                unaptr = (EchoParamType *) phdr;
        }
        else
        {
                printf("\nFatal Error: Echo parameter not in info field\n");
                return 0;
        }

        printf("\tEcho Response:");
        for (i = 0 ; i < 36; i++ )
        {
                if (unaptr->echo_data[i] ==  ' ')
                        printf(" ");
                else
                        printf("%c", unaptr->echo_data[i]);
        }

        printf("\n");
        echo_flag = 0;
        /* echo response received for UI */
        return 1;
}
