
/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      834cmd3.c
*
*       $Log:   /b/gregs/bridge/declike/cmd/834cmd3.c_v  $
 * 
 *    Rev 1.3   25 Oct 1993 15:52:36   gregs
 * Added debug routine to sh data command.
 * 
 *    Rev 1.2   29 Jul 1993 16:34:12   vinay
 * 
 *    Rev 1.1   24 Jun 1993 08:59:08   franks
 * 
 *    Rev 1.0   04 May 1993 16:03:48   franks
 * Initial revision.
 * 
 *    Rev 1.5   13 May 1992 14:24:12   franks
 * 1). Fixed the problem of command line options for the sh db, cl db
 *     being sensitve to spaces.
 * 
 *    Rev 1.4   04 May 1992 10:50:02   franks
 * No change.
 * 
 *    Rev 1.3   17 Apr 1992 16:15:42   franks
 * 1). Fixed problem in ShowDBSaved so that the user can display records
 *     based on flag information alone.
 * 
 *    Rev 1.2   16 Apr 1992 14:46:34   franks
 * No change.
 * 
 *    Rev 1.1   14 Apr 1992 12:59:58   franks
 * No change.
 * 
 *    Rev 1.0   30 Mar 1992 17:48:04   pvcs
 * Initial revision.
*
*       Comments:      Developed for i960 platform.
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		
******************************************************************************/


#include <types.h>
#include <target.h>
#include <bridges.h>
#include <utility.h>
#include <prcadr.h> 
#include <krnl.h>
#include <prcctl.h>
#include <sncvar.h>
#include <eeprecs.h>
#include <nvrecs.h>
#include <stp.h>
#include <tcpip.h>
#include <time.h>
#include <sys.h>
#include <cpb.h>
#include <834error.h>

/* EXTERNAL VARIABLE DEFINITIONS */
extern char *APPLSOFTVERSION;
extern IP IPDevice[];
extern PRCCTL prc;
extern NVR_BSTATUS *BridgeStatus;
extern ERRORLOG ErrorLogTable[];
extern Port_data port_info[];
extern Bridge_data bridge_info;
extern void BitmaskStatusScreen();
extern TIMER IntervalTimer;
extern MBOX  TrRcvMBox;
extern tcpip *_initp;
extern unsigned long InitTimeSeconds;
extern unsigned long InitDateSeconds;
extern long GmtOffset;
extern uint quit;



/******************************************************************************/
						/*	Start ShowDBWorking()  */
ShowDBWorking( CPB_P pcpb )  {

	unsigned int FuncReturnCode, NextArg;
	RECORDMASK ValueMask;
	unsigned int PortMask = 0;
	uint length;
	uint Len;
	char *First;
	char *kw;
	char *str;
	char *Arg;
	char Buffer[STRLN];
	char ALLNIDS[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

	memset(Buffer, NULL, sizeof(Buffer));
	memset(&ValueMask, NULL, sizeof(RECORDMASK));

	/*	Only the command list is entered  */
	if (pcpb->cl_idx >= pcpb->cmdlen)
	{
		memcpy(&ValueMask.AddressValue, ALLNIDS, sizeof(ALLNIDS));
		memcpy(&ValueMask.AddressMask, ALLNIDS, sizeof(ALLNIDS));
		DisplayAddressOrPort(&ValueMask, RAM);
	}
			/*	The list command with one or more arguments entered  */
	else  {
	
        /* skip leading spaces */
        while( pcpb->cmd[pcpb->cl_idx] == SPACE )
            pcpb->cl_idx++;

		First = &pcpb->cmd[pcpb->cl_idx];
		GetWord(Buffer, First);	/*	Get the first argument  */

		if( strncmp(Buffer, "deb", 3) == 0 )
			DisplayLocalNid();

		if( strncmp(Buffer, "xlate", 4) == 0)
			DisplayXlateNid();

		if( strncmp(Buffer, "cam", 3) == 0 )
			CamDisplay();

		/* If the list is based on flag information */
		if ((*First == 's') ||
			(*First == 'r')
		   )  {
		
			memcpy(&ValueMask.AddressValue, ALLNIDS, sizeof(ALLNIDS));
			memcpy(&ValueMask.AddressMask, ALLNIDS, sizeof(ALLNIDS));

			/*  Check to see if there is any problems while */
			/*  scanning the attributes  */
			
			if (SetAttribute(First, &ValueMask, &Len))
				return ( CMD_SYNTAX_ERR );

			DisplayNid(&ValueMask, RAM);
			pcpb->cl_idx = pcpb->cmdlen;
			return(0);
		}

		/* Adjust the command line pointer */
		length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
        pcpb->cl_idx += length;

		/*	Only the address mask argument is entered  */
		
		if((strlen(Buffer) == 12) && (pcpb->cl_idx >= pcpb->cmdlen)) {

		/*	Check to see if there is any problems in the address convertion  */

			if (HexToMask(Buffer, &ValueMask, 6))
				return (ERR_HEX12_ADR);
			else

				DisplayAddressOrPort(&ValueMask, RAM);
		}
				/*	More than one arguments entered  */
		else
		if ((strlen(Buffer) == 12) && (pcpb->cl_idx < pcpb->cmdlen))		
		{
		/*	Check to see if there are any problems in the address convertion  */

			if (HexToMask(Buffer, &ValueMask, 6))
				return (ERR_HEX12_ADR);

            /* skip leading spaces */
            while( pcpb->cmd[pcpb->cl_idx] == SPACE )
                pcpb->cl_idx++;
			Arg = &pcpb->cmd[pcpb->cl_idx];

            if( (*Arg == CHARACTER_ONE)   ||
			    (*Arg == CHARACTER_TWO)   ||
			    (*Arg == CHARACTER_THREE) ||
			    (*Arg == CHARACTER_FOUR)  ||
		/*	    (*Arg == CHARACTER_FIVE)  || 5PORT -- Uncomment */
			    (*Arg == CHARACTER_ALL)
		      )
		    {
                FuncReturnCode = PortArgument(Arg, &PortMask, &length);
                if( FuncReturnCode )
                    return( FuncReturnCode );
			
				pcpb->cl_idx += length; 
                ValueMask.PortMask = (unsigned char) PortMask;

                /* If there are flag arguments */

				if(pcpb->cl_idx < pcpb->cmdlen) {
                    if(SetAttribute(&pcpb->cmd[pcpb->cl_idx], &ValueMask,&Len))
                        return( CMD_SYNTAX_ERR );
                    DisplayNid(&ValueMask, RAM);
                }
                else
                    DisplayAddressAndPort( &ValueMask, RAM );
            }
			else
			{
            /* Check to see if there are any problems while */
			/* scanning the attributes  */

				if (SetAttribute(Arg, &ValueMask, &Len))
					return ( CMD_SYNTAX_ERR );

				DisplayNid(&ValueMask, RAM);
			}
		}

		else
		if ( (*First == CHARACTER_ONE)   ||
			 (*First == CHARACTER_TWO)   ||
			 (*First == CHARACTER_THREE) ||
			 (*First == CHARACTER_FOUR)  ||
	/*		 (*First == CHARACTER_FIVE)  || 5PORT -- Uncomment for 5 ports */
			 (*First == CHARACTER_ALL)
		   )
		{
			PortMask = 0;

			FuncReturnCode = PortArgument(First, &PortMask, &length);
			if (FuncReturnCode)
				return (FuncReturnCode);

			ValueMask.PortMask = (unsigned char)PortMask;

            /* skip leading spaces */
            while( pcpb->cmd[pcpb->cl_idx] == SPACE )
                pcpb->cl_idx++;

			Arg = &pcpb->cmd[pcpb->cl_idx];

			if ((strncmp(Arg, "s", 1) == 0) ||
				(strncmp(Arg, "r", 1) == 0))
			{
			/*	Check to see if there is any problems while */
			/*  scanning the attributes  */

				if (SetAttribute(Arg, &ValueMask, &Len))
					return ( CMD_SYNTAX_ERR );

				DisplayNidPort(&ValueMask, RAM);
			}
			else  {
				switch( *Arg )   {
						
						case CHARACTER_ONE:
						case CHARACTER_TWO:
						case CHARACTER_THREE:
						case CHARACTER_FOUR:
						case NULL:
						case CHARACTER_ALL:   
				           		DisplayAddressOrPort(&ValueMask, RAM);
						 		break;

						default:
								return( CMD_SYNTAX_ERR );
				}
			}
		}
		else
			return( CMD_SYNTAX_ERR );
	}
	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/*	End ShowDBWorking()	*/


/******************************************************************************/
						/*	Start ShowDBSaved()  */
ShowDBSaved( CPB_P pcpb )  {

	unsigned int FuncReturnCode, NextArg;
	RECORDMASK ValueMask;
	unsigned int PortMask = 0;
	uint length;
	uint Len;
	char *First;
	char *kw;
	char *str;
	char *Arg;
	char Buffer[STRLN];
	char ALLNIDS[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

	memset(Buffer, NULL, sizeof(Buffer));
	memset(&ValueMask, NULL, sizeof(RECORDMASK));

	/*	Only the command list is entered  */
	if (pcpb->cl_idx >= pcpb->cmdlen)
	{
		memcpy(&ValueMask.AddressValue, ALLNIDS, sizeof(ALLNIDS));
		memcpy(&ValueMask.AddressMask, ALLNIDS, sizeof(ALLNIDS));
		DisplayAddressOrPort(&ValueMask, NVRam);
	}
			/*	The list command with one or more arguments entered  */
	else  {
	
        /* skip leading spaces */
        while( pcpb->cmd[pcpb->cl_idx] == SPACE )
            pcpb->cl_idx++;
		First = &pcpb->cmd[pcpb->cl_idx];
		GetWord(Buffer, First);	/*	Get the first argument  */

		

		/* If the list is based on flag information */
		if ((*First == 's') ||
			(*First == 'r')
		   )  {
		
			memcpy(&ValueMask.AddressValue, ALLNIDS, sizeof(ALLNIDS));
			memcpy(&ValueMask.AddressMask, ALLNIDS, sizeof(ALLNIDS));

			/*  Check to see if there is any problems while */
			/*  scanning the attributes  */
			
			if (SetAttribute(First, &ValueMask, &Len))
				return ( CMD_SYNTAX_ERR );

			DisplayNid(&ValueMask, NVRam);
            pcpb->cl_idx = pcpb->cmdlen;
            return(0);
		}

        /* Adjust the command line pointer */
		length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
        pcpb->cl_idx += length;

		/*	Only the address mask argument is entered  */
		
		if((strlen(Buffer) == 12) && (pcpb->cl_idx >= pcpb->cmdlen)) {

		/*	Check to see if there is any problems in the address convertion  */

			if (HexToMask(Buffer, &ValueMask, 6))
				return (ERR_HEX12_ADR);
			else

				DisplayAddressOrPort(&ValueMask, NVRam);
		}
				/*	More than one arguments entered  */
		else
		if ((strlen(Buffer) == 12) && (pcpb->cl_idx < pcpb->cmdlen))		
		{
		/*	Check to see if there are any problems in the address convertion  */

			if (HexToMask(Buffer, &ValueMask, 6))
				return (ERR_HEX12_ADR);

            /* skip leading spaces */
            while( pcpb->cmd[pcpb->cl_idx] == SPACE )
                pcpb->cl_idx++;
			Arg = &pcpb->cmd[pcpb->cl_idx];

            if( (*Arg == CHARACTER_ONE)   ||
			    (*Arg == CHARACTER_TWO)   ||
			    (*Arg == CHARACTER_THREE) ||
			    (*Arg == CHARACTER_FOUR)  ||
		/*	    (*Arg == CHARACTER_FIVE)  || 5PORT -- Uncomment */
			    (*Arg == CHARACTER_ALL)
		      )
		    {
                printf("\nPort Specified!\n");
                FuncReturnCode = PortArgument(Arg, &PortMask, &length);
                if( FuncReturnCode )
                    return( FuncReturnCode );
				

				/* pcpb->cl_idx += length; */
                ValueMask.PortMask = (unsigned char) PortMask;

                /* If there are flag arguments */

				if(pcpb->cl_idx < pcpb->cmdlen) {
                    if( SetAttribute(&pcpb->cmd[pcpb->cl_idx], &ValueMask,&Len))
                        return( CMD_SYNTAX_ERR );
                    DisplayNid(&ValueMask, NVRam);
                }
                else
                    DisplayAddressAndPort( &ValueMask, NVRam );
            }
			else
			{
            /* Check to see if there are any problems while */
			/* scanning the attributes  */

				if (SetAttribute(Arg, &ValueMask, &Len))
					return ( CMD_SYNTAX_ERR );

				DisplayNid(&ValueMask, NVRam);
			}
		}

		else
		if ( (*First == CHARACTER_ONE)   ||
			 (*First == CHARACTER_TWO)   ||
			 (*First == CHARACTER_THREE) ||
			 (*First == CHARACTER_FOUR)  ||
	/*		 (*First == CHARACTER_FIVE)  || 5PORT -- Uncomment for 5 ports */
			 (*First == CHARACTER_ALL)
		   )
		{
			PortMask = 0;

			FuncReturnCode = PortArgument(First, &PortMask, &length);
			if (FuncReturnCode)
				return (FuncReturnCode);

			ValueMask.PortMask = (unsigned char)PortMask;

            /* skip leading spaces */
            while( pcpb->cmd[pcpb->cl_idx] == SPACE )
                pcpb->cl_idx++;

			Arg = &pcpb->cmd[pcpb->cl_idx];

			if ((strncmp(Arg, "s", 1) == 0) ||
				(strncmp(Arg, "r", 1) == 0))
			{
			/*	Check to see if there is any problems while */
			/*  scanning the attributes  */

				if (SetAttribute(Arg, &ValueMask, &Len))
					return ( CMD_SYNTAX_ERR );

				DisplayNidPort(&ValueMask, NVRam);
			}
			else  {
				switch( *Arg )   {
						
						case CHARACTER_ONE:
						case CHARACTER_TWO:
						case CHARACTER_THREE:
						case CHARACTER_FOUR:
						case NULL:
						case CHARACTER_ALL:   
				           		DisplayAddressOrPort(&ValueMask, NVRam);
						 		break;

						default:
								return( CMD_SYNTAX_ERR );
				}
			}
		}
		else
			return( CMD_SYNTAX_ERR );
	}
	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/*	End ShowDBSaved()	*/

/******************************************************************************/
/* Start ShowDBStatus() */
ShowDBStatus() {

	Header();
	Copyright();
	printf("\t\t\t\t\t\t\t\t%s\n\n\n", "DATABASE STATUS SCREEN");

	DisplayAddrCnt( RAM );
	DisplayAddrCnt( NVRam );

	Scroll(12);
	return( 0 ); 
}

/******************************************************************************/
/*	Start Modify()  */
Modify( CPB_P pcpb )
{
	char *First;
	char *SecArg;
	char *kw;
	char Buffer[STRLN];
    uint hash;
	uint Len;
	uint length;
    uint PortMask;
	uint RetValue;
	uint NextArg;
	uint savelen;
    ADR  AdrNode;
	ADR  *ap;


	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	
	memset(Buffer, NULL, sizeof(Buffer));

	if ( strncmp(kw, "DATABASE", 2) == 0)   {

		pcpb->cl_idx += length;
		length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&First,CASE_INSENSITIVE);

		/* Get the 1st argument, should be an address */
		/* or a port              			          */
		GetWord(Buffer, First); 

        /*  If the first argument is an address  */
		/*  then modify just that address record */
		if ( (strlen(Buffer) == 12) )  {

            /*	Check for problems in the address conversion  */
			if (HexToNid(Buffer, &AdrNode, 6))
				return (ERR_HEX12_ADR);

            /* Get the hash value */
            hash = HashNid( &AdrNode.adr_low );

            /* Does the address exist? */
            if(FindNid( &AdrNode, &ap ))
                return( ADR_NOT_FOUND );

			pcpb->cl_idx += length;
            /* Get new attributes */

			memset(Buffer, NULL, sizeof(Buffer));
			length = GetWord(Buffer, &pcpb->cmd[pcpb->cl_idx]);
			strupr(Buffer);
			SecArg = &pcpb->cmd[pcpb->cl_idx];
			pcpb->cl_idx += length;

			/* Is this the clear argument? */
            if( strncmp(Buffer, "CLEAR", 3) == NULL ) {

                /* Clear the address record attributes */
				ClrNidAttribute( ap );
				SetInUse( ap );
			}
			
			/* Is this a port specifier? */
			if(*Buffer == CHARACTER_ONE ||
			   *Buffer == CHARACTER_TWO ||
			   *Buffer == CHARACTER_THREE ||
			   *Buffer == CHARACTER_FOUR )  { 

            	if( (strlen( Buffer ) != 1) )   /* only one port allowed! */
                	return( CMD_SYNTAX_ERR );
            	else {

			   		ap->adr_hom = NULL;		   /* clear port info */
               		switch( *Buffer )  {          /* set port bit */

                  		case CHARACTER_ONE:
                                   ap->adr_hom |= PORT1; 
                                   break;

                  		case CHARACTER_TWO:
                                   ap->adr_hom |= PORT2; 
                                   break;

                  		case CHARACTER_THREE:
                                   ap->adr_hom |= PORT3;
                                   break;

                  		case CHARACTER_FOUR:
                                   ap->adr_hom |= PORT4; 
                                   break;

						/* 5PORT -- Uncomment when using 5 ports.....
                  		case CHARACTER_FIVE:
                                   ap->adr_hom |= PORT5; 
                                   break;
                        */
                  		default:
                        			return( CMD_SYNTAX_ERR );
               		}
            	}
            	/* Set flags if specified. */
            	if( pcpb->cl_idx < pcpb->cmdlen ) {
                	ClrNidAttribute( ap );
					SetInUse( ap );
               	    RetValue = SetNidAttribute( SecArg+2, ap, &Len );
				    if( RetValue == FAIL )
				    	return( CMD_SYNTAX_ERR );
				    pcpb->cl_idx += (pcpb->cmdlen - Len);
				    pcpb->cl_idx += Len;
            	}
			}
			/* No new port specified, just new flag information */
			else  
            if( *Buffer == 'S' || *Buffer == 'R' ) {
               	ClrNidAttribute( ap );
				SetInUse( ap );
               	RetValue = SetNidAttribute( SecArg, ap, &Len );
				if(RetValue)
					return( CMD_SYNTAX_ERR );
				pcpb->cl_idx += (pcpb->cmdlen - Len);
				pcpb->cl_idx += Len;
			}
			else
			if(*Buffer == 'C' &&  *(Buffer+1) == 'L') {
				ClrNidAttribute( ap );
				SetInUse( ap );
			}
		}
        else  
		if(*First == CHARACTER_ONE   ||
		   *First == CHARACTER_TWO   ||
		   *First == CHARACTER_THREE ||
		   *First == CHARACTER_FOUR     )  {

           /* See if first argument is a port specifier.     */
		   /* then modify all address records on those ports */

           memset( Buffer, NULL, sizeof(Buffer) );

           if( GetPortLst( Buffer, First )) {

				savelen = length;
				PortMask = 0;
				RetValue = PortArgument(First, &PortMask, &length);
				if (RetValue)
					return (RetValue);
				else
				if( *(First+length) > '4' && *(First+length) <= '9' ) {
					return( CMD_SYNTAX_ERR );
				}

				pcpb->cl_idx += savelen;

				memset(Buffer, NULL, sizeof(Buffer));
				length = GetWord(Buffer, &pcpb->cmd[pcpb->cl_idx]);
				strupr(Buffer);
				SecArg = &pcpb->cmd[pcpb->cl_idx];

			    /* Is this the clear argument? */
                if( strncmp(Buffer, "CLEAR", 3) == NULL ) {

                    /* Clear the address record attributes */
					ModPort( PortMask, Buffer, TRUE , &Len);
					pcpb->cl_idx += length;
			    }
		        else	
			  	if((strncmp(Buffer, "S", 1) == 0) ||
			   	   (strncmp(Buffer, "R", 1) == 0))  {
							Len = 0;
              				RetValue= ModPort(PortMask, SecArg, FALSE, &Len);
							if(RetValue)
								return( CMD_SYNTAX_ERR );
							pcpb->cl_idx += Len;
							pcpb->cl_idx += (pcpb->cmdlen - Len);
			  	}
			  	else
					return( CMD_SYNTAX_ERR );
           }
		   else
				return( CMD_SYNTAX_ERR );
        }
	}
	/* All is well */
	return( 0 );
}
/*	End Modify()  */

/*****************************************************************************/

ShowBrgActivity( CPB_P pcpb ) {

	uint Term = BridgeStatus->TermType;
	uint value = 0;
	uint length;
	uint i;
	char *kw;
	char ch;

	/* If there are more parameters */
	if( pcpb->cl_idx < pcpb->cmdlen ) {
		sscanf(&pcpb->cmd[pcpb->cl_idx],"%d", &value);	
		length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
   		pcpb->cl_idx += length;
	}

	if( Term == VT100 ) {
		TermCrsOff();
		TermClrScr();
		TermHome();
	}

	do {
			

		BrgActivityScreen();

		ch = getch();
		if( ch == ESC ) {
			if( Term == VT100 ) {

				StopTimer( &IntervalTimer ); 
				TermClrScr();
				for(i=0; i<0xfffff; i++);
				TermHome();
				for(i=0; i<0xfffff; i++);
				TermCrsOn();
				for(i=0; i<0xfffff; i++);
				TermCrsBlock();
				return(0);
			}
			else {

				StopTimer( &IntervalTimer );
				printf("\n\n\n\n\n");
				return(0);
			}
		}
		else
		if( ch == 'c' )
			ClearMainTrScrn();

		if( value > 0 && Term == VT100 ) {

			printf("\n\n\t\t\t\t\t     ");
			TermRevVid();
			printf("**** Press  C to Clear ****\n");
			TermNormVid();
			printf("\t\t\t\t\t     ");
			TermRevVid();
			printf("**** Press ESC to quit ****\n");
			TermNormVid();
			TermHome();
			StartTimer( &IntervalTimer, 10, &TrRcvMBox ); 
		}
		else
		if( value > 0 ) {

			printf("\n\n\t\t\t\t\t     ");
			printf("**** Press  C to Clear ****\n");
			printf("\t\t\t\t\t     ");
			printf("**** Press ESC to quit ****\n\n");
			StartTimer( &IntervalTimer, (value*100), &TrRcvMBox ); 
		}
		else
			printf("\n\n\n\n\n");

	} while(  value > 0 && RcvMessage( &TrRcvMBox ))  ;

	if( Term == VT100 ) {
		TermCrsOn();
	}
	return( 0 );
}
