
/**
*	Program Name:	BOOTER
*
*	Filename:	testnvram.c
*
*	$Log:   /b/gregs/bridge/booter/tester/testnvram.c_v  $
 * 
 *    Rev 1.0   16 Jul 1993 16:25:48   franks
 * Initial revision.
 * 
 *    Rev 1.1   15 Apr 1992 17:32:04   kwok
 * Adding the pvcs keyword $Log$ in the file header
*
*	Comments:
*
*	Copyright (c) 1992 by Huges LAN Systems.
**/

#include <types.h>
#include <memory.h>
#include <eeprecs.h>

static unsigned char *TestNvramLock(unsigned char *LastPage);

/*
 *	Test the Nvram 
 */
int TestNvram()

	{
	unsigned char	*ErrorAddress;
	unsigned char	*LastPage;	/*	of eeprom 	*/
	int	ret;
	EEP_MFG	*MfgPtr = &eep_mfg_rec; 

	EnableNvram();
	ret = RamTest(NVRAM, MfgPtr->eep_nvram_size, "NVRAM");
	DisableNvram();
	if (ret != 0)
		return ret;

	/*
	 *	Test the last page only.
	 */
	LastPage =  (unsigned char *)NVRAM + MfgPtr->eep_nvram_size - EEP_PAGE_SIZE; 
	if ((ErrorAddress = TestNvramLock(LastPage)) != NULL)
		{
		printf("\nNVRAM error: Protection circuitry failed\n");
		return 1;
		}
	return 0;
	}


static unsigned char *TestNvramLock(unsigned char *LastPage)

	{
	unsigned char	data[EEP_PAGE_SIZE];
	int	RecordSize;

	/*
	 *	Save the original data
	 */
	memcpy(data, LastPage, EEP_PAGE_SIZE);
	/*
	 *	Write to the nvram without releasing the lock.
	 */
	DisableNvram();	/* make sure it is disabled	*/
	for (RecordSize = 0; RecordSize < EEP_PAGE_SIZE; RecordSize++)
		{
		LastPage[RecordSize] = ~data[RecordSize];
		}
	/*
	 *	Since we have not release the lock, the data should 
	 *	not be changed at all.
	 */
	for (RecordSize = 0; RecordSize < EEP_PAGE_SIZE; RecordSize++)
		{
		if (LastPage[RecordSize] != data[RecordSize])
			{
			/*
			 *	Record has been modified, we have to
			 *	restore data and return an error
			 */
			memcpy(LastPage, data, EEP_PAGE_SIZE);
			return LastPage + RecordSize;
			}
		}
	return NULL;
	}
