' Filename: SaveTraceScript.bas
' Purpose:  Script that saves a buffer to a file before it is opened to be viewed.
'
Sub Main
	Dim msg, NL
	Dim snifferApp As Object
	Dim captureObj As Object
	Dim tempFileName$
	Dim FileExtension$

	'create Sniffer objs
	Set snifferApp = CreateObject("Sniffer.Application.2")
	Set captureObj = snifferApp.GetCaptureObject()

	'Medium value
    'NdisMedium802_3 = 0
    'NdisMedium802_5 = 1
    'NdisMediumFddi = 2 
    'NdisMediumWan = 3
    'NdisMediumLocalTalk = 4
    'NdisMediumDix = 5    
    'NdisMediumArcnetRaw = 6
    'NdisMediumArcnet878_2 = 7
    'NdisMediumAtm = 8

	Dim mediumType As Integer
	mediumType = SnifferApp.GetMedium()
	If mediumType = 1 Then
		FileExtension$ = "trc"
		GoTo NextLine
	End If
	
	If mediumType = 2 Then
		FileExtension$ = "fdc"
		GoTo NextLine
	End If

	If mediumType = 3 Then
		FileExtension$ = "syc"
		GoTo NextLine
	End If

	If mediumType = 8 Then
		FileExtension$ = "atc"
		GoTo NextLine
	End If

	FileExtension$ = "enc"

NextLine:
	'if capturing, stop the capture
	If captureObj.IsCapturing() Then
		captureObj.Stop(FALSE)
	End If

	'if any data captured
	If captureObj.IsPacketCaptured() Then
		If captureObj.IsCaptureDataReady() = FALSE Then
			'get the capture data
			If captureObj.GetData() Then
				While captureObj.IsCaptureDataReady() = FALSE
					'wait until the capture data is transfered from RMON
					' could be from remote probe that will take a long time
					' should have some way to cancel this waiting
				Wend
			Else
				MsgBox("Failed to get capture data")
				Stop
			End If
		End If
		'capture data is ready, let's save it to a temp file
		tempFileName$ = MakeTempFileName(FileExtension$)
		If captureObj.SaveFile(tempFileName) Then
			MsgBox "Save data to " & tempFileName
			'
			'Run Examine Engine here
			'
		End If
	Else
		MsgBox("No capture data")
		Stop
	End If
End Sub

Function MakeTempFileName(Extension As String) As String
	On Error GoTo Found
	Dim Isfile As Integer, FHandle As Integer, Cntr As Integer, Seed As Integer
	Dim WinTemp As String, TF As String

	Isfile = False
	FHandle = FreeFile
	Seed = Second(Time)

	Do
		WinTemp = ""
		For Cntr = 1 To 8
			WinTemp = WinTemp & Mid(LTrim(Str(CInt(Rnd * Seed))), 1, 1)
		Next Cntr
		TF = Trim(WinTemp$) & "." & Extension

		Open TF For Input As #1		'if file not exist, goto Found
		Close #1
	Loop

Found:
	MakeTempFileName = TF

End Function

