' Filename: ImpNovAddr.bas
' This scripts imports entries from a file containing Novell Netware 4.0 
' Directory Service Name into Sniffer Pro's Address Book.  Refer to the format below. 
' User Name = The login name of the user
' Address   = The network address
' Node      = The network node
'
' Input format:
' 161.69.252.2    T1-6036-4.04/5.02-TR/TR
' #161.69.252.3    T2-4016-4.04/5.06-TR/TR
' 161.69.252.4    W4-401A-4.03/5.05-TR/SIA/TR
' 161.69.252.5    T3-3011-2.22/4.40-TR/TR
' 161.69.251.2    F1-703F-4.31/5.31-TR/FDDI
' 161.69.251.3    T4-7036-4.31/5.09c
' 161.69.251.4    T5-3016-4.03
' 161.69.6.141    F3-502F-4.06-EN/FDDI
' 161.69.6.145    F4-502F-4.04-EN/FDDI

Declare Sub mcb App (ByVal ctx&, ByVal type%, ByVal errno%, ByVal str$)
Declare Function OpenTextFile App (ByVal filename$) As Integer
Declare Function CloseTextFile App (ByVal fid%) As Integer
Declare Function ReadTextLine App (ByVal fid%, ByVal buf$) As Integer
Declare Function MyGetOpenFilename App (ByVal filename$, ByVal fileExt$, ByVal fileInit$, ByVal filter$) As Integer

Dim g_linebuf As String * 256
Dim g_buflen As Integer
Dim g_filename As String * 256

Sub Main ()
	Dim fid As Integer
	Dim a_char As String
	Dim buf$
	Dim appObj As object
	Dim addrBookObj As object
	Dim FileExt$
	Dim FileInitName$
	Dim FileFilter$
	Dim addrName$

	Set appObj = CreateObject("Sniffer.Application.2")
	Set addrBookObj = appObj.GetAddressBookDoc()

	FileInitName$ = "*.txt"
	FileFilter$ = "TXT (Text) | *.txt ||"
	FileExt$ = "txt"

	bOpen% = MyGetOpenFilename(g_filename, FileExt$, FileInitName$, FileFilter$)
	If bOpen% = 0 Then
		GoTo CancelOpen
	End If

	fid = OpenTextFile(g_filename)
	If fid > 0 Then
		Do
NextLine:
			g_buflen = ReadTextLine(fid, g_linebuf)
			If g_buflen <= 0 Then		
				'Exit Do
				GoTo EndOfFile
			End If

			'make sure there is a [
			StartAddrPos% = InStr( 1, g_linebuf, "[" )
			if StartAddrPos% <= 0 Then
				GoTo NextLine
			End If

			'get the User Name
			addrName$ = Left$(g_linebuf, StartAddrPos% - 1)
			addrName$ = Trim(addrName$)
			addrName2$ = addrName$
			If Len(addrName2$) > 0 Then		
				bHasName = 1
				'remove the * from the name's 1st char
				a_char = Left$(addrName2$, 1)
				If a_char = "*" Then
					addrName$ = Right(addrName$, Len(addrName2$) - 1)
				End If
			End If

			'get the rest of the str excluding the 1st [
			buf$ = Right(g_linebuf, g_buflen - StartAddrPos%)
			'not enough data
			If Len(buf$) < 10 Then		
				GoTo NextLine
			End If

			'get the Network Address field
			Pos% = InStr( 1, buf$, "]" )
			if Pos% <= 0 Then
				GoTo NextLine
			End If
			NetAddr$ = Left$(buf$, Pos% - 1)
			NetAddr$ = Trim(NetAddr$)

			'get the rest of the str excluding the 2nd [
			buf$ = Right(buf$, Len(buf$) - Pos% - 1)
			'not enough data
			If Len(buf$) < 10 Then		
				GoTo NextLine
			End If

			'get the Hardware Address field
			Pos% = InStr( 1, buf$, "]" )
			if Pos% <= 0 Then
				GoTo NextLine
			End If
			HwAddr$ = Left$(buf$, Pos% - 1)
			HwAddr$ = Trim(HwAddr$)
			HwAddr2$ = HwAddr$
			If Len(HwAddr2$) <= 6 Then		
				GoTo NextLine
			End If

			While Len(HwAddr2$) < 12
				HwAddr$ = "0" & HwAddr$
			HwAddr2$ = HwAddr$
			Wend

			'Add ************************************************
			Dim Net_HWAddr
			Net_HWAddr$ = NetAddr$ & "." & HwAddr$
			'Debug***********************************************
			Dim msg
			msg = "NetAddr: " & NetAddr$ & Chr(10)
			msg = msg & "HwAddr: "  & HwAddr$ & Chr(10)
			msg = msg & "Net and HW: " & Net_HWAddr$ & Chr(10)
			MsgBox msg

			bAddOK = 0
			If bHasName = 1 Then
				' bAddOK = addrBookObj.AddNewAddr(addrName$, HwAddr$, "000.000.000.000", "Workstation", "From import file")
				' Add******************************************************
				bAddOK = addrBookObj.AddNewAddr(addrName$, HwAddr$, "000.000.000.000", "Workstation", "From import file", Net_HWAddr$, "Ethernet" )
			End If

		Loop While g_buflen > 0

EndOfFile:
		CloseTextFile(fid)
	End If

	Response = MsgBox("Import file completed!", MB_OK, "Sniffer")

CancelOpen:
	i = 0
End Sub

'Get a token
Function GetToken (Buf$ As String) As String
	Dim a_char$, tabCh$, crCh$, lfCh$
	Dim temp$
	tabCh$ = Chr$(9)
	crCh$ = Chr$(13)
	lfCh$ = Chr$(10)
	Pos = 1
	buflen% = Len(Buf$)
	For Pos = 1 To buflen%
		a_char$ = Mid$(Buf$, Pos, 1)
		If a_char$ = " " Or a_char$ = tabCh$ Or a_char$ = crCh$ Or a_char$ = lfCh$ Then
			GetToken = temp$
			Exit Function
		End If
		If Pos = 1 Then
			temp$ = a_char$
		Else
			temp$ = temp$ + a_char$
		End If
	Next Pos

	GetToken = temp$
End Function

'remove the leading space and tab chars
Function StripLeadingSpace (Buf As String) As String
	Dim a_char$, tabCh$
	Dim temp$
	temp$ = Buf
	tabCh$ = Chr$(9)
	While (Len(temp$) > 0)
		a_char$ = Left$(temp$, 1)
		If a_char$ <> " " And a_char$ <> tabCh$ Then
			StripLeadingSpace = temp$
			Exit Function
		End If
		temp$ = Right$(temp$, Len(temp$) - 1)
	Wend

	StripLeadingSpace = temp$
End Function
