' Filename: ImpIPHosts.bas
' This scripts imports entries from a TCP/IP local hosts file into Sniffer Pro's
' Address Book.  Refer to the format below.
'
' Input format:
'
' 161.69.252.2    T1-6036-4.04/5.02-TR/TR
' #161.69.252.3    T2-4016-4.04/5.06-TR/TR
' 161.69.252.4    W4-401A-4.03/5.05-TR/SIA/TR
' 161.69.252.5    T3-3011-2.22/4.40-TR/TR
' 161.69.251.2    F1-703F-4.31/5.31-TR/FDDI
' 161.69.251.3    T4-7036-4.31/5.09c
' 161.69.251.4    T5-3016-4.03
' 161.69.6.141    F3-502F-4.06-EN/FDDI
' 161.69.6.145    F4-502F-4.04-EN/FDDI

Declare Sub mcb App (ByVal ctx&, ByVal type%, ByVal errno%, ByVal str$)
Declare Function OpenTextFile App (ByVal filename$) As Integer
Declare Function CloseTextFile App (ByVal fid%) As Integer
Declare Function ReadTextLine App (ByVal fid%, ByVal buf$) As Integer
Declare Function MyGetOpenFilename App (ByVal filename$, ByVal fileExt$, ByVal fileInit$, ByVal filter$) As Integer

Dim g_linebuf As String * 256
Dim g_buflen As Integer
Dim g_filename As String * 256

Sub Main ()
	Dim fid As Integer
	Dim a_char As String
	Dim buf$
	Dim appObj As object
	Dim addrBookObj As object
	Dim FileExt$
	Dim FileInitName$
	Dim FileFilter$
	Dim addrName$
        Dim addrType$

	Set appObj = CreateObject("Sniffer.Application.2")
	Set addrBookObj = appObj.GetAddressBookDoc()

	FileInitName$ = "hosts"
	FileFilter$ = "All Files (*.*)|*.*||"
	FileExt$ = ""

	bOpen% = MyGetOpenFilename(g_filename, FileExt$, FileInitName$, FileFilter$)
	If bOpen% = 0 Then
		GoTo CancelOpen
	End If

	fid = OpenTextFile(g_filename)
	If fid > 0 Then
		Do
NextLine:
			g_buflen = ReadTextLine(fid, g_linebuf)
			If g_buflen <= 0 Then		
				'Exit Do
				GoTo EndOfFile
			End If

			buf$ = StripLeadingSpace(g_linebuf)

			'not enough data
			'g_buflen = Len(buf$)
			If Len(buf$) < 5 Then		
				GoTo NextLine
			End If

			'skip the comment
			a_char = Left$(buf$, 1)
			If a_char = "#" Then		
				GoTo NextLine
			End If

			'get the address type field
                        addrType$ = "Ethernet"

			'get the IP token
			ip$ = GetToken(buf$)
			ip2$ = ip$

			bHasName = 0
			buf$ = Right$(buf$, Len(buf$)-Len(ip$))
			buf$ = StripLeadingSpace(buf$)
			If Len(buf$) > 0 Then		
				'get the 1st Name token
				addrName$ = GetToken(buf$)
				bHasName = 1
			End If

			bAddOK = 0
			If bHasName = 1 Then
				bAddOK = addrBookObj.AddNewAddr(addrName$, "000000000000", ip2$, "", "From hosts file", "00000000000000000000", addrType$)
			End If

		Loop While g_buflen > 0

EndOfFile:
		CloseTextFile(fid)
	End If

	Response = MsgBox("Import file completed!", MB_OK, "Sniffer")

CancelOpen:
	i = 0
End Sub

'Get a token
Function GetToken (Buf$ As String) As String
	Dim a_char$, tabCh$, crCh$, lfCh$
	Dim temp$
	tabCh$ = Chr$(9)
	crCh$ = Chr$(13)
	lfCh$ = Chr$(10)
	Pos = 1
	buflen% = Len(Buf$)
	For Pos = 1 To buflen%
		a_char$ = Mid$(Buf$, Pos, 1)
		If a_char$ = " " Or a_char$ = tabCh$ Or a_char$ = crCh$ Or a_char$ = lfCh$ Then
			GetToken = temp$
			Exit Function
		End If
		If Pos = 1 Then
			temp$ = a_char$
		Else
			temp$ = temp$ + a_char$
		End If
	Next Pos

	GetToken = temp$
End Function

'remove the leading space and tab chars
Function StripLeadingSpace (Buf As String) As String
	Dim a_char$, tabCh$
	Dim temp$
	temp$ = Buf
	tabCh$ = Chr$(9)
	While (Len(temp$) > 0)
		a_char$ = Left$(temp$, 1)
		If a_char$ <> " " And a_char$ <> tabCh$ Then
			StripLeadingSpace = temp$
			Exit Function
		End If
		temp$ = Right$(temp$, Len(temp$) - 1)
	Wend

	StripLeadingSpace = temp$
End Function
