'Filename: ImpAddrBook.bas
'Purpose:  Gives an example of how to import a previously saved Address Book into the
'          current Sniffer session.

Declare Sub mcb App (ByVal ctx&, ByVal type%, ByVal errno%, ByVal str$)
Declare Function OpenTextFile App (ByVal filename$) As Integer
Declare Function CloseTextFile App (ByVal fid%) As Integer
Declare Function ReadTextLine App (ByVal fid%, ByVal buf$) As Integer
Declare Function MyGetOpenFilename App (ByVal filename$, ByVal fileExt$, ByVal fileInit$, ByVal filter$) As Integer

Dim g_linebuf As String * 256
Dim g_buflen As Integer
Dim g_filename As String * 256

Sub Main ()
	Dim bFirstLine%
	Dim bIpxAddr%
	Dim fid As Integer
	Dim a_char As String
	Dim buf$
	Dim appObj As object
	Dim addrBookObj As object
	Dim FileExt$
	Dim FileInitName$
	Dim FileFilter$
	Dim addrName$
	Dim AddrMedium$
	Dim HwAddr$
	Dim IPAddr$
	Dim IPXAddr$
	Dim nodeType$
	Dim nodeDesc$

	Set appObj = CreateObject("Sniffer.Application.2")
	Set addrBookObj = appObj.GetAddressBookDoc()

	FileInitName$ = "*.csv"
	FileFilter$ = "CSV (Comma delimited) | *.csv ||"
	FileExt$ = "csv"

	bOpen% = MyGetOpenFilename(g_filename, FileExt$, FileInitName$, FileFilter$)
	If bOpen% = 0 Then
		GoTo CancelOpen
	End If
	
	bIpxAddr% = 0

	fid = OpenTextFile(g_filename)
	If fid > 0 Then
		bFirstLine% = 1
		Do
NextLine:
			g_buflen = ReadTextLine(fid, g_linebuf)
			If g_buflen <= 0 Then		
				'Exit Do
				GoTo EndOfFile
			End If

			if bFirstLine% = 1 Then
				'Skip the header line
				bFirstLine% = 0
				'Search for valid IPX address field
				Pos% = InStr( 1, g_linebuf, "IPX" )
				if Pos% > 0 Then
					bIpxAddr% = 1
				End If	
				GoTo NextLine
			End If

			'get the Name field
			Pos% = InStr( 1, g_linebuf, "," )
			if Pos% <= 0 Then
				GoTo NextLine
			End If
			addrName$ = Left$(g_linebuf, Pos% - 1)
			addrName$ = Trim(addrName$)
			'get the rest of the data
			g_linebuf = Right(g_linebuf, Len(g_linebuf) - Pos%)

			'get the Address Medium field and the HW Address field
			a_char = Left$(g_linebuf$, 1)
			If a_char = "," Then
				'no HW Address		
				HwAddr$ = "000000000000"
				g_linebuf = Right(g_linebuf, Len(g_linebuf) - 1)
			Else
				'Check ":" to see if there is medium specified for the Hardware address
				Pos% = InStr( 1, g_linebuf, ":" )
				AddrMedium$ = "Ethernet"
				if Pos% > 0 Then
					AddrMedium$ = Left$(g_linebuf, Pos% - 1)
					AddrMedium$= Trim(AddrMedium$)
					'get the rest of the data
					g_linebuf = Right(g_linebuf, Len(g_linebuf) - Pos%)
					If AddrMedium$ = "Ethr" Then
						AddrMedium$ = "Ethernet"
					ElseIf AddrMedium$ = "Tokn" Then
						AddrMedium$ = "Token Ring"
					ElseIf AddrMedium$ = "Fddi" Then
						AddrMedium$ = "Fddi"
					ElseIf AddrMedium$ = "Atm" Then
						AddrMedium$ = "ATM(Address)"
					ElseIf AddrMedium$ = "AtmX" Then
						AddrMedium$ = "ATM(Connection)"
					ElseIf AddrMedium$ = "Fram" Then
						AddrMedium$ = "Wan(FrameRelay)"
					ElseIf AddrMedium$ = "Rout" Then
						AddrMedium$ = "Wan(Router)"
					ElseIf AddrMedium$ = "X.25" Then
						AddrMedium$ = "Wan(X.25)"
					End If
				End If

				Pos% = InStr( 1, g_linebuf, "," )
				If Pos% <= 0 Then
					GoTo NextLine
				End If
				HwAddr$ = Left$(g_linebuf, Pos% - 1)
				HwAddr$ = Trim(HwAddr$)
				'get the rest of the data
				g_linebuf = Right(g_linebuf, Len(g_linebuf) - Pos%)
			End If

			'get the IP Address field
			a_char = Left$(g_linebuf$, 1)
			If a_char = "," Then
				'no IP Address		
				IPAddr$ = "000.000.000.000"
				g_linebuf = Right(g_linebuf, Len(g_linebuf) - 1)
			Else
				Pos% = InStr( 1, g_linebuf, "," )
				if Pos% <= 0 Then
					GoTo NextLine
				End If
				IPAddr$ = Left$(g_linebuf, Pos% - 1)
				IPAddr$ = Trim(IPAddr$)
				'get the rest of the data
				g_linebuf = Right(g_linebuf, Len(g_linebuf) - Pos%)
			End If

			'get the IPX Address field
			IPXAddr$ = "00000000.000000000000"
			If bIpxAddr% = 1 Then
				a_char = Left$(g_linebuf$, 1)
				If a_char = "," Then
					'no IPX Address		
					g_linebuf = Right(g_linebuf, Len(g_linebuf) - 1)
				Else
					Pos% = InStr( 1, g_linebuf, "," )
					if Pos% <= 0 Then
						GoTo NextLine
					End If
					IPXAddr$ = Left$(g_linebuf, Pos% - 1)
					IPXAddr$ = Trim(IPXAddr$)
					'get the rest of the data
					g_linebuf = Right(g_linebuf, Len(g_linebuf) - Pos%)
				End If
			End If

			'get the Type field
			a_char = Left$(g_linebuf$, 1)
			If a_char = "," Then
				'no NodeType description
				nodeType$ = "WorkStation"
				g_linebuf = Right(g_linebuf, Len(g_linebuf) - 1)
			Else
				Pos% = InStr( 1, g_linebuf, "," )
				if Pos% <= 0 Then
					GoTo NextLine
				End If
				nodeType$ = Left$(g_linebuf, Pos% - 1)
				nodeType$ = Trim(nodeType$)
				'get the rest of the data
				g_linebuf = Right(g_linebuf, Len(g_linebuf) - Pos%)
			End If

			'get the Description field
			g_linebuf = StripCRLF(g_linebuf)
			g_linebuf = Trim(g_linebuf)
			If Len(g_linebuf) <= 0 Then
				nodeDesc$ = "From import file"
			Else
				Pos% = InStr( 1, g_linebuf, "," )
				if Pos% > 0 Then
					g_linebuf = Right(g_linebuf, Len(g_linebuf) - Pos%)
				End If
				nodeDesc$ = g_linebuf
				nodeDesc$ = Trim(nodeDesc$)
			End If

			'Debug***********************************************
			'Dim msg
			'msg = "addrName: " & addrName$ & Chr(10)
			'msg = msg & "HWAddr: "  & HWAddr$ & Chr(10)
			'msg = msg & "IPAddr: " & IPaddr$ & Chr(10)
			'msg = msg & "nodeType: " & nodeType$ & Chr(10)
			'msg = msg & "nodeDesc: " & nodeDesc$ & Chr(10)
			'msg = msg & "IPXAddr: " & IPXAddr$ & Chr(10)
                        'msg = msg & "addrType: " & AddrMedium$ & Chr(10)
			'MsgBox msg

			bAddOK = 0
			bAddOK = addrBookObj.AddNewAddr(addrName$, HwAddr$, IPAddr$, nodeType$, nodeDesc$, IPXAddr$, AddrMedium$)

		Loop While g_buflen > 0

EndOfFile:
		CloseTextFile(fid)
	End If

	Response = MsgBox("Import file completed!", MB_OK, "SnifferPro")

CancelOpen:
	i = 0
End Sub

'remove the leading space and tab chars
Function StripCRLF (Buf As String) As String
	Dim a_char$, crCh$, lfCh$
	Dim temp$
	crCh$ = Chr$(13)
	lfCh$ = Chr$(10)
	Pos = 1
	buflen% = Len(Buf$)
	For Pos = 1 To buflen%
		a_char$ = Mid$(Buf$, Pos, 1)
		If a_char$ = crCh$ Or a_char$ = lfCh$ Then
			StripCRLF = temp$
			Exit Function
		End If
		If Pos = 1 Then
			temp$ = a_char$
		Else
			temp$ = temp$ + a_char$
		End If
	Next Pos

	StripCRLF = temp$
End Function
