'Purpose:  Gives an example of how to export history window data into
'          an MS Excel file.
'Note:	   The History window to be exported must be opened and active in
'          Sniffer.
'	   MS Excel must be installed on the Sniffer system.
'	   Both single and multiple History samples are supported.

Sub Main()
        '
	'for Sniffer objs
	Dim SnifferApp As Object
	Dim historyObj As Object
	Dim histDataObjs As Object

	'for Excel objs
	Dim excelApp as Object
	Dim wb as Object
	Dim ws as Object

	'create Sniffer objs
	Set SnifferApp = CreateObject("Sniffer.Application.2")
	Dim rVal As Integer
	rVal = SnifferApp.IsHistoryOpened()

        If rVal = 0 Then
		Msg = "Please make sure there is at least 1 history window is opened!"
		DlgDef = MB_OK + MB_ICONEXCLAMATION
		Title = "Sniffer"
		Response = MsgBox(Msg, dlgDef, Title)
		GoTo ByeBye
	End If

	Set historyObj = SnifferApp.GetFirstHistory()
	nItems% = historyObj.GetNumofItems()

	'create Excel objs
	Set excelApp = CreateObject("Excel.Application")
	excelApp.Visible = TRUE
	Set wb = excelApp.Workbooks.Add
	Set ws = excelApp.Worksheets(1)

	ws.Cells(1, 1).Value = "Time"
	
	For j = 1 To nItems%
	  	ws.Cells(1, (j+1)).Value = historyObj.GetSampleItemName(j-1)
		Set histDataObjs = historyObj.GetDataObjects()
		If j = 1 Then	
			n = histDataObjs.Count
		End If

	 	For i = 1 To n
		  'MsgBox "Time(" & i & ") = " & histDataObjs.Item(i).GetTimeStr()
		  'MsgBox "Data(" & i & ") = " & histDataObjs.Item(i).GetData()
		  If j = 1 Then	
		    	ws.Cells(i+1, 1).Value = histDataObjs.Item(i).GetTimeStr()
		  End If
		  ws.Cells(i+1, j+1).Value = histDataObjs.Item(i).GetData()
		Next i
       	Next j

	MsgBox "Done."
ByeBye:
End Sub
