/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Datum;
import javachart.chart.Gc;
import javachart.chart.Globals;
import javachart.chart.Plotarea;
import javachart.chart.Transform;

public class Line
implements Serializable {
    AxisInterface yAxis;
    AxisInterface xAxis;
    Plotarea plotarea;
    boolean scatterPlot;
    boolean doClip = false;
    boolean useDisplayList = true;
    Globals globals;
    Dataset[] datasets;
    int labelAngle;
    int labelFormat = 1;
    boolean labelsOn = false;
    int labelPrecision = 2;
    Transform dataXfm;
    double xAxisStart;
    double xAxisEnd;
    double yAxisStart;
    double yAxisEnd;
    protected int numDataSets;

    public Line(Dataset[] datasetArray, AxisInterface axisInterface, AxisInterface axisInterface2, Plotarea plotarea) {
        this.datasets = datasetArray;
        this.xAxis = axisInterface;
        this.yAxis = axisInterface2;
        this.plotarea = plotarea;
        this.globals = this.plotarea.globals;
    }

    public void setYAxis(AxisInterface axisInterface) {
        this.yAxis = axisInterface;
    }

    public AxisInterface getYAxis() {
        return this.yAxis;
    }

    public void setXAxis(AxisInterface axisInterface) {
        this.xAxis = axisInterface;
    }

    public AxisInterface getXAxis() {
        return this.xAxis;
    }

    public void setPlotarea(Plotarea plotarea) {
        this.plotarea = plotarea;
    }

    public Plotarea getPlotarea() {
        return this.plotarea;
    }

    public void setDatasets(Dataset[] datasetArray) {
        this.datasets = datasetArray;
    }

    public Dataset[] getDatasets() {
        return this.datasets;
    }

    public void setScatterPlot(boolean bl) {
        this.scatterPlot = bl;
    }

    public boolean isScatterPlot() {
        return this.scatterPlot;
    }

    public boolean getUseDisplayList() {
        return this.useDisplayList;
    }

    public void setUseDisplayList(boolean bl) {
        this.useDisplayList = bl;
    }

    public boolean getClip() {
        return this.doClip;
    }

    public void setClip(boolean bl) {
        this.doClip = bl;
    }

    public boolean getLabelsOn() {
        return this.labelsOn;
    }

    public void setLabelsOn(boolean bl) {
        this.labelsOn = bl;
    }

    public int getLabelAngle() {
        return this.labelAngle;
    }

    public void setLabelAngle(int n) {
        this.labelAngle = n;
    }

    public int getLabelPrecision() {
        return this.labelPrecision;
    }

    public void setLabelPrecision(int n) {
        this.labelPrecision = n;
    }

    public int getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(int n) {
        if (n < 0 || n > 2) {
            return;
        }
        this.labelFormat = n;
    }

    public void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.doLines(graphics, this.scatterPlot);
    }

    protected void buildDataXfm() {
        this.xAxisStart = this.xAxis.getAxisStart();
        this.xAxisEnd = this.xAxis.getAxisEnd();
        this.yAxisStart = this.yAxis.getAxisStart();
        this.yAxisEnd = this.yAxis.getAxisEnd();
        this.dataXfm = new Transform(this.xAxisStart, this.yAxisStart, this.xAxisEnd, this.yAxisEnd, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY), this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY));
        this.dataXfm.logXScaling = this.xAxis.getLogScaling();
        this.dataXfm.logYScaling = this.yAxis.getLogScaling();
    }

    protected synchronized void doLines(Graphics graphics, boolean bl) {
        this.numDataSets = this.datasetsInUse();
        this.buildDataXfm();
        if (this.doClip) {
            Point point = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
            Point point2 = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
            graphics.clipRect(point.x, this.globals.maxY - point2.y, point2.x - point.x, point2.y - point.y);
        }
        int n = 0;
        while (n < this.numDataSets) {
            if (bl) {
                this.doMarkers(graphics, this.numDataSets - 1 - n);
            } else {
                this.doLine(graphics, this.numDataSets - 1 - n);
                this.doMarkers(graphics, this.numDataSets - 1 - n);
            }
            if (this.labelsOn) {
                this.doLabels(graphics);
            }
            ++n;
        }
        if (this.doClip) {
            graphics.clipRect(0, 0, this.globals.maxX, this.globals.maxY);
        }
    }

    synchronized void drawSet(Graphics graphics, int n, boolean bl) {
        this.buildDataXfm();
        this.numDataSets = 1;
        if (this.doClip) {
            Point point = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
            Point point2 = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
            graphics.clipRect(point.x, this.globals.maxY - point2.y, point2.x - point.x, point2.y - point.y);
        }
        if (bl) {
            this.doMarkers(graphics, n);
        } else {
            this.doLine(graphics, n);
            this.doMarkers(graphics, n);
        }
        if (this.labelsOn) {
            this.doLabels(graphics);
        }
        if (this.doClip) {
            graphics.clipRect(0, 0, this.globals.maxX, this.globals.maxY);
        }
    }

    private synchronized int datasetsInUse() {
        int n = 0;
        while (n < this.datasets.length) {
            if (this.datasets[n] == null) {
                return n;
            }
            ++n;
        }
        return n;
    }

    protected void doLine(Graphics graphics, int n) {
        double[] dArray = this.datasets[n].getXValues();
        double[] dArray2 = this.datasets[n].getYValues();
        if (!this.globals.threeD) {
            this.datasets[n].gc.drawPolyline(graphics, this.dataXfm.pointList(dArray, dArray2));
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addPolyline((Object)this.datasets[n], this.dataXfm.pointList(dArray, dArray2));
                this.globals.displayList.addPolyline((Object)this, this.dataXfm.pointList(dArray, dArray2));
                return;
            }
        } else {
            int n2 = this.globals.xOffset / this.numDataSets;
            int n3 = this.globals.yOffset / this.numDataSets;
            int n4 = n2 * n;
            int n5 = n3 * n;
            Point[] pointArray = new Point[4];
            int n6 = 0;
            while (n6 < dArray.length - 1) {
                pointArray[0] = this.dataXfm.point(dArray[n6], dArray2[n6]);
                pointArray[0].translate(n4, n5);
                pointArray[1] = new Point(pointArray[0].x + n2, pointArray[0].y + n3);
                pointArray[3] = this.dataXfm.point(dArray[n6 + 1], dArray2[n6 + 1]);
                pointArray[3].translate(n4, n5);
                pointArray[2] = new Point(pointArray[3].x + n2, pointArray[3].y + n3);
                this.datasets[n].gc.drawPolygon(graphics, pointArray);
                this.datasets[n].gc.drawPolyline(graphics, pointArray);
                if (this.useDisplayList && this.globals.useDisplayList) {
                    this.globals.displayList.addPolygon((Object)this.datasets[n], pointArray);
                    this.globals.displayList.addPolyline((Object)this, pointArray);
                }
                ++n6;
            }
        }
    }

    protected void doMarkers(Graphics graphics, int n) {
        int n2;
        int n3;
        boolean bl = true;
        if (this.datasets[n].gc.image == null) {
            if (this.useDisplayList) {
                bl = false;
            } else {
                return;
            }
        }
        double[] dArray = this.datasets[n].getXValues();
        double[] dArray2 = this.datasets[n].getYValues();
        if (bl) {
            n3 = this.datasets[n].gc.image.getWidth(null);
            n2 = this.datasets[n].gc.image.getHeight(null);
        } else {
            n3 = 2;
            n2 = 2;
        }
        int n4 = 0;
        while (n4 < dArray2.length) {
            if (bl) {
                this.datasets[n].gc.drawImage(graphics, this.dataXfm.point(dArray[n4], dArray2[n4]));
            }
            if (this.useDisplayList && this.globals.useDisplayList) {
                Point point = this.dataXfm.point(dArray[n4], dArray2[n4]);
                point.translate(n3 / 2, n2 / 2);
                Point point2 = new Point(point.x - n3, point.y - n2);
                this.globals.displayList.addRectangle((Object)this.datasets[n].getDataElementAt(n4), point2, point);
                this.globals.displayList.addRectangle((Object)this.datasets[n], point2, point);
                this.globals.displayList.addRectangle((Object)this, point2, point);
            }
            ++n4;
        }
    }

    protected void doLabels(Graphics graphics) {
        int n = 0;
        while (this.datasets[n] != null) {
            int n2 = 0;
            while (n2 < this.datasets[n].data.size()) {
                this.doElementLabel(graphics, n, n2);
                ++n2;
            }
            ++n;
        }
    }

    protected void doElementLabel(Graphics graphics, int n, int n2) {
        String string;
        Datum datum = this.datasets[n].getDataElementAt(n2);
        double d = datum.x;
        double d2 = datum.y;
        if (datum.label != null) {
            string = datum.label;
        } else {
            string = Double.toString(datum.y);
            int n3 = string.indexOf("e");
            if (n3 == -1) {
                n3 = string.indexOf("E");
            }
            if (n3 == -1) {
                string = Gc.formattedLabel((String)string, (int)this.labelFormat, (int)this.labelPrecision);
            } else {
                string = Gc.nonSciNumberStr((String)string, (int)n3);
                string = Gc.formattedLabel((String)string, (int)this.labelFormat, (int)this.labelPrecision);
            }
        }
        graphics.setFont(this.datasets[n].labelFont);
        graphics.setColor(this.datasets[n].labelColor);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Point point = this.dataXfm.point(d, d2);
        this.datasets[n].gc.drawSmartString(graphics, point.x, point.y + 2, 2, this.labelAngle, fontMetrics, string);
    }
}

