/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import javachart.chart.Dataset;
import javachart.chart.Gc;
import javachart.chart.Globals;
import javachart.chart.LegendInterface;
import javachart.chart.Transform;

public class Legend
implements LegendInterface,
Serializable {
    Globals globals;
    Gc backgroundGc;
    Font labelFont;
    Color labelColor;
    boolean verticalLayout = true;
    boolean backgroundVisible = true;
    double llX;
    double llY;
    double urX;
    double urY;
    double iconHeight = 0.05;
    double iconWidth = 0.07;
    double iconGap = 0.01;
    boolean useDisplayList = true;
    Dataset[] datasets;
    Transform transform;
    int gWidth = 640;
    int gHeight = 480;
    static final double backgroundFudge = 0.02;

    public Legend(Dataset[] datasetArray, Globals globals) {
        this.globals = globals;
        this.backgroundGc = new Gc(Color.white, globals);
        this.labelFont = new Font("TimesRoman", 0, 12);
        this.labelColor = Color.black;
        this.datasets = datasetArray;
        this.llX = 0.2;
        this.llY = 0.6;
    }

    public void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.recalculateSize(graphics);
        if (this.backgroundVisible) {
            this.backgroundGc.fillRect(graphics, this.transform.point(this.llX, this.llY), this.transform.point(this.urX, this.urY));
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addRectangle(this, this.transform.point(this.llX, this.llY), this.transform.point(this.urX, this.urY));
            }
        }
        if (this.verticalLayout) {
            this.doVerticalIcons(graphics);
            return;
        }
        this.doHorizontalIcons(graphics);
    }

    public void resize(int n, int n2) {
        this.gWidth = n;
        this.gHeight = n2;
        this.transform = new Transform(0.0, 0.0, 1.0, 1.0, 0, 0, this.gWidth, this.gHeight);
    }

    public boolean getUseDisplayList() {
        return this.useDisplayList;
    }

    public void setUseDisplayList(boolean bl) {
        this.useDisplayList = bl;
    }

    public Gc getBackgroundGc() {
        return this.backgroundGc;
    }

    public void setBackgroundGC(Gc gc) {
        this.backgroundGc = gc;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public boolean getVerticalLayout() {
        return this.verticalLayout;
    }

    public void setVerticalLayout(boolean bl) {
        this.verticalLayout = bl;
    }

    public boolean getBackgroundVisible() {
        return this.backgroundVisible;
    }

    public void setBackgroundVisible(boolean bl) {
        this.backgroundVisible = bl;
    }

    public double getLlX() {
        return this.llX;
    }

    public void setLlX(double d) {
        this.llX = d;
    }

    public double getLlY() {
        return this.llY;
    }

    public void setLlY(double d) {
        this.llY = d;
    }

    public double getUrX() {
        return this.urX;
    }

    public double setUrY() {
        return this.urY;
    }

    public double getIconWidth() {
        return this.iconWidth;
    }

    public void setIconWidth(double d) {
        this.iconWidth = d;
    }

    public double getIconHeight() {
        return this.iconHeight;
    }

    public void setIconHeight(double d) {
        this.iconHeight = d;
    }

    public double getIconGap() {
        return this.iconGap;
    }

    public void setIconGap(double d) {
        this.iconGap = d;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + "urX " + this.urX + "urY " + this.urY + "llX " + this.llX + "llY " + this.llY + "]";
    }

    synchronized int datasetsInUse() {
        int n = 0;
        while (n < this.datasets.length) {
            if (this.datasets[n] == null) {
                return n;
            }
            ++n;
        }
        return n;
    }

    protected synchronized void doVerticalIcons(Graphics graphics) {
        graphics.setFont(this.labelFont);
        int n = this.datasetsInUse();
        double d = this.llX + 0.02;
        double d2 = this.llY + 0.02;
        double d3 = d + this.iconWidth;
        double d4 = d2 + this.iconHeight;
        int n2 = 0;
        while (n2 < n) {
            this.datasets[n2].gc.fillRect(graphics, this.transform.point(d, d2), this.transform.point(d3, d4));
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addRectangle(this.datasets[n2], this.transform.point(d, d2), this.transform.point(d3, d4));
            }
            Point point = this.transform.point(d3, d2);
            graphics.setColor(this.labelColor);
            this.backgroundGc.drawString(graphics, point.x + 2, point.y, this.datasets[n2].setName);
            d4 = (d2 += this.iconHeight + this.iconGap) + this.iconHeight;
            ++n2;
        }
    }

    protected synchronized void doHorizontalIcons(Graphics graphics) {
        graphics.setFont(this.labelFont);
        int n = this.datasetsInUse();
        double d = this.llX + 0.02;
        double d2 = this.llY + 0.02;
        double d3 = d + this.iconWidth;
        double d4 = d2 + this.iconHeight;
        int n2 = 0;
        while (n2 < n) {
            this.datasets[n2].gc.fillRect(graphics, this.transform.point(d, d2), this.transform.point(d3, d4));
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addRectangle(this.datasets[n2], this.transform.point(d, d2), this.transform.point(d3, d4));
            }
            Point point = this.transform.point(d3, d2);
            graphics.setColor(this.labelColor);
            this.backgroundGc.drawString(graphics, point.x + 2, point.y, this.datasets[n2].setName);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            d3 = (d += this.iconWidth + this.iconGap + this.iconGap + (double)fontMetrics.stringWidth(this.datasets[n2].setName) / (double)this.gWidth) + this.iconWidth;
            ++n2;
        }
    }

    public synchronized void recalculateSize(Graphics graphics) {
        int n = 0;
        double d = 0.0;
        int n2 = 0;
        graphics.setFont(this.labelFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = this.datasetsInUse();
        if (this.verticalLayout) {
            int n4 = 0;
            while (n4 < n3) {
                n = fontMetrics.stringWidth(this.datasets[n4].setName);
                if (n > n2) {
                    n2 = n;
                }
                d += this.iconGap + this.iconHeight;
                ++n4;
            }
            this.urX = this.llX + this.iconWidth + 0.04 + (double)n / (double)this.gWidth;
            this.urY = this.llY + d + 0.04 + d / (double)this.gHeight;
            return;
        }
        int n5 = 0;
        while (n5 < n3) {
            n2 += fontMetrics.stringWidth(this.datasets[n5].setName);
            ++n5;
        }
        this.urX = this.llX + (double)n + 0.04 + (double)n3 * (this.iconWidth + this.iconGap) + this.iconWidth + this.iconGap + (double)n2 / (double)this.gWidth;
        this.urY = this.llY + d + 0.04 + this.iconHeight;
    }
}

