/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.FontMetrics;
import java.awt.Point;
import java.io.Serializable;
import java.util.Vector;
import javachart.chart.Globals;

public class DisplayList
implements Serializable {
    Vector primitiveList;
    Vector objectList;
    Globals globals;

    public DisplayList(Globals globals) {
        this.globals = globals;
        this.primitiveList = new Vector();
        this.objectList = new Vector();
    }

    protected void addLine(Object object, Point point, Point point2) {
        Point point3 = new Point(point.x - 2, point.y);
        Point point4 = new Point(point2.x + 2, point2.y);
        this.addRectangle(object, point3, point4);
    }

    protected synchronized void addRectangle(Object object, Point point, Point point2) {
        Point[] pointArray = new Point[]{new Point(point.x, point.y), new Point(point.x, point2.y), new Point(point2.x, point2.y), new Point(point2.x, point.y)};
        this.primitiveList.addElement(pointArray);
        this.objectList.addElement(object);
    }

    protected synchronized void addTextString(Object object, int n, int n2, String string, FontMetrics fontMetrics) {
        int n3 = fontMetrics.stringWidth(string);
        int n4 = fontMetrics.getHeight();
        Point[] pointArray = new Point[]{new Point(n, n2), new Point(n, n2 + n4), new Point(n + n3, n2 + n4), new Point(n + n3, n2)};
        this.primitiveList.addElement(pointArray);
        this.objectList.addElement(object);
    }

    protected synchronized void addPolygon(Object object, Point[] pointArray) {
        this.primitiveList.addElement(pointArray);
        this.objectList.addElement(object);
    }

    protected synchronized void addPolyline(Object object, Point[] pointArray) {
        Point[] pointArray2 = new Point[pointArray.length * 2];
        int n = 0;
        while (n < pointArray.length) {
            pointArray2[n] = pointArray[n];
            pointArray2[n].translate(0, 2);
            pointArray2[pointArray2.length - n - 1] = new Point(pointArray[n].x, pointArray[n].y - 4);
            ++n;
        }
        this.primitiveList.addElement(pointArray2);
        this.objectList.addElement(object);
    }

    protected synchronized void addArc(Object object, Point point, Point point2, int n, int n2) {
        double d = 0.06283185307179587;
        double d2 = (double)n / 180.0 * Math.PI;
        double d3 = (double)n2 / 180.0 * Math.PI;
        int n3 = (int)(d3 / d);
        Point[] pointArray = new Point[n3 + 2];
        pointArray[n3 + 1] = point;
        int n4 = point.x + (int)(Math.cos(d2 + d3) * (double)(point2.x / 2));
        int n5 = point.y + (int)(Math.sin(d2 + d3) * (double)(point2.y / 2));
        pointArray[n3] = new Point(n4, n5);
        int n6 = 0;
        while (n6 < n3) {
            n4 = point.x + (int)(Math.cos(d2) * (double)(point2.x / 2));
            n5 = point.y + (int)(Math.sin(d2) * (double)(point2.y / 2));
            pointArray[n6] = new Point(n4, n5);
            d2 += d;
            ++n6;
        }
        this.primitiveList.addElement(pointArray);
        this.objectList.addElement(object);
    }

    public synchronized boolean contains(Point point, Vector vector) {
        return this.traverseList(point, vector);
    }

    public synchronized void clear() {
        this.primitiveList = new Vector();
        this.objectList = new Vector();
    }

    private boolean traverseList(Point point, Vector vector) {
        boolean bl = false;
        Point point2 = new Point(point.x, this.globals.maxY - point.y);
        int n = 0;
        while (n < this.primitiveList.size()) {
            Point[] pointArray = (Point[])this.primitiveList.elementAt(n);
            if (this.inPolygon(point2, pointArray)) {
                vector.addElement(this.objectList.elementAt(n));
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private boolean inPolygon(Point point, Point[] pointArray) {
        int n = 0;
        int n2 = 0;
        int n3 = pointArray.length;
        int n4 = 0;
        while (n4 < n3) {
            long l;
            int n5 = n4 + 1;
            if (n5 == n3) {
                n5 = 0;
            }
            int n6 = pointArray[n4].x - point.x;
            int n7 = pointArray[n4].y - point.y;
            int n8 = pointArray[n5].x - point.x;
            int n9 = pointArray[n5].y - point.y;
            if (!(n6 <= 0 && n8 <= 0 || n7 <= 0 && n9 <= 0 || n6 > 0 && n8 > 0 || (l = (long)(n6 * n9 - n7 * n8)) == 0L || l > 0L != n6 - n8 > 0)) {
                ++n;
                if (l < 0L) {
                    --n2;
                }
                if (l > 0L) {
                    ++n2;
                }
            }
            ++n4;
        }
        if ((n &= 1) == 0 && n2 != 0) {
            n = 1;
        }
        return n == 1;
    }
}

