/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import javachart.chart.Gc;
import javachart.chart.Globals;

public class Background
implements Serializable {
    Gc gc;
    Color titleColor;
    Font titleFont;
    String titleString;
    boolean useDisplayList = true;
    Globals globals;
    int gWidth = 640;
    int gHeight = 480;
    Point startPoint;

    public Background(Globals globals) {
        this.globals = globals;
        this.gc = new Gc(Color.white, this.globals);
        this.startPoint = new Point(0, 0);
        this.titleColor = Color.black;
        this.titleFont = new Font("TimesRoman", 0, 12);
        this.titleString = null;
    }

    public Gc getGc() {
        return this.gc;
    }

    public void setGc(Gc gc) {
        this.gc = gc;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public String getTitleString() {
        return this.titleString;
    }

    public void setTitleString(String string) {
        this.titleString = string;
    }

    public boolean getUseDisplayList() {
        return this.useDisplayList;
    }

    public void setUseDisplayList(boolean bl) {
        this.useDisplayList = bl;
    }

    public synchronized void draw(Graphics graphics) {
        if (graphics == null) {
            System.out.println("null graphics in background");
            return;
        }
        this.gc.fillRect(graphics, this.startPoint, this.gWidth, this.gHeight);
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.globals.displayList.addRectangle(this, this.startPoint, new Point(this.gWidth, this.gHeight));
        }
        if (this.titleString == null) {
            return;
        }
        graphics.setFont(this.titleFont);
        graphics.setColor(this.titleColor);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (this.gWidth - this.startPoint.x) / 2 - fontMetrics.stringWidth(this.titleString) / 2;
        int n2 = fontMetrics.getMaxAscent() + 10;
        graphics.drawString(this.titleString, n, n2);
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.globals.displayList.addTextString(this, n, n2, this.titleString, fontMetrics);
        }
    }

    protected synchronized void resize(int n, int n2) {
        this.gWidth = n;
        this.gHeight = n2;
    }
}

