/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Gc;
import javachart.chart.Globals;
import javachart.chart.Plotarea;
import javachart.chart.Transform;

public class Axis
implements AxisInterface,
Serializable {
    boolean autoScale = true;
    double axisStart;
    double axisEnd = 10.0;
    boolean majTickVis = true;
    boolean minTickVis = false;
    boolean gridVis = false;
    boolean labelVis = true;
    boolean lineVis = true;
    boolean titleRotation = false;
    String titleString;
    Color titleColor;
    Font titleFont;
    boolean useDisplayList = true;
    Color labelColor;
    Font labelFont;
    int labelPrecision = 2;
    int labelAngle;
    int labelFormat = 0;
    Gc lineGc;
    Gc gridGc;
    Gc tickGc;
    int numMajTicks = 5;
    int numGrids = 5;
    int numMinTicks = 10;
    int numLabels = 5;
    int majTickLength = 5;
    int minTickLength = 4;
    int side = 1;
    boolean logScaling = false;
    protected Globals globals;
    boolean isXAxis = false;
    boolean barScaling = false;
    protected int numAxLabels;
    protected Dataset[] datasets;
    protected double stepSize = 2.0;
    protected Plotarea plotarea;
    Point startPoint;
    Point endPoint;
    float increment;
    protected static final int axisLabels = 1;
    protected static final int gridLines = 2;
    protected static final int minTicks = 3;
    protected static final int majTicks = 4;
    final double NODIV = 5.0;
    private int axMagnitude;
    static double[] twoFiveSteps;
    static double[] oneTwoSteps;

    public Axis(Dataset[] datasetArray, boolean bl, Plotarea plotarea) {
        this.isXAxis = bl;
        if (this.isXAxis) {
            this.side = 0;
        }
        this.plotarea = plotarea;
        this.datasets = datasetArray;
        this.globals = this.plotarea.globals;
        this.titleColor = Color.black;
        this.titleFont = new Font("TimesRoman", 0, 12);
        this.labelColor = Color.black;
        this.labelFont = new Font("TimesRoman", 0, 12);
        this.lineGc = new Gc(this.globals);
        this.gridGc = new Gc(this.globals);
        this.tickGc = new Gc(this.globals);
    }

    public synchronized void draw(Graphics graphics) {
        if (this.autoScale) {
            this.scale();
        } else if (this.logScaling) {
            this.checkLogAx();
        }
        if (this.lineVis) {
            this.drawLine(graphics);
        }
        this.drawTicks(graphics);
        if (this.gridVis) {
            if (!this.globals.threeD) {
                this.drawGrids(graphics);
            } else {
                this.draw3Dgrids(graphics);
            }
        }
        if (this.labelVis) {
            this.drawLabels(graphics);
        }
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.buildDisplayList();
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + " xAxis? " + this.isXAxis + " stepSize " + this.stepSize + " axisStart " + this.axisStart + " axisEnd " + this.axisEnd + " numMajTicks " + this.numMajTicks + " numMinTicks " + this.numMinTicks + " numLabels " + this.numLabels + " ]";
    }

    public synchronized void addLabels(String[] stringArray) {
    }

    public void scale() {
        if (!this.logScaling) {
            this.linearScale();
            return;
        }
        if (!this.logScale()) {
            this.logScaling = false;
            this.linearScale();
        }
    }

    public Dataset[] getDatasets() {
        return this.datasets;
    }

    public void setDatasets(Dataset[] datasetArray) {
        this.datasets = datasetArray;
    }

    public boolean getLogScaling() {
        return this.logScaling;
    }

    public void setLogScaling(boolean bl) {
        this.logScaling = bl;
    }

    public boolean getAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean bl) {
        this.autoScale = bl;
    }

    public double getAxisStart() {
        return this.axisStart;
    }

    public void setAxisStart(double d) {
        this.axisStart = d;
    }

    public double getAxisEnd() {
        return this.axisEnd;
    }

    public void setAxisEnd(double d) {
        this.axisEnd = d;
    }

    public boolean getLineVis() {
        return this.lineVis;
    }

    public void setLineVis(boolean bl) {
        this.lineVis = bl;
    }

    public boolean getMajTickVis() {
        return this.majTickVis;
    }

    public void setMajTickVis(boolean bl) {
        this.majTickVis = bl;
    }

    public boolean getMinTickVis() {
        return this.minTickVis;
    }

    public void setMinTickVis(boolean bl) {
        this.minTickVis = bl;
    }

    public String getTitleString() {
        return this.titleString;
    }

    public void setTitleString(String string) {
        this.titleString = string;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public boolean getLabelVis() {
        return this.labelVis;
    }

    public void setLabelVis(boolean bl) {
        this.labelVis = bl;
    }

    public boolean getGridVis() {
        return this.gridVis;
    }

    public void setGridVis(boolean bl) {
        this.gridVis = bl;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public int getLabelPrecision() {
        return this.labelPrecision;
    }

    public void setLabelPrecision(int n) {
        this.labelPrecision = n;
    }

    public int getLabelAngle() {
        return this.labelAngle;
    }

    public void setLabelAngle(int n) {
        this.labelAngle = n;
    }

    public Gc getLineGc() {
        return this.lineGc;
    }

    public void setLineGc(Gc gc) {
        this.lineGc = gc;
    }

    public Gc getGridGc() {
        return this.gridGc;
    }

    public void setGridGc(Gc gc) {
        this.gridGc = gc;
    }

    public Gc getTickGc() {
        return this.tickGc;
    }

    public void setTickGc(Gc gc) {
        this.tickGc = gc;
    }

    public int getNumMajTicks() {
        return this.numMajTicks;
    }

    public void setNumMajTicks(int n) {
        this.numMajTicks = n;
    }

    public int getNumGrids() {
        return this.numGrids;
    }

    public void setNumGrids(int n) {
        this.numGrids = n;
    }

    public int getNumMinTicks() {
        return this.numMinTicks;
    }

    public void setNumMinTicks(int n) {
        this.numMinTicks = n;
    }

    public int getNumLabels() {
        return this.numLabels;
    }

    public void setNumLabels(int n) {
        this.numLabels = n;
    }

    public int getMajTickLength() {
        return this.majTickLength;
    }

    public void setMajTickLength(int n) {
        this.majTickLength = n;
    }

    public int getMinTickLength() {
        return this.minTickLength;
    }

    public void setMinTickLength(int n) {
        this.minTickLength = n;
    }

    public int getSide() {
        return this.side;
    }

    public void setSide(int n) {
        this.side = n;
    }

    public boolean getBarScaling() {
        return this.barScaling;
    }

    public void setBarScaling(boolean bl) {
        this.barScaling = bl;
    }

    public boolean getUseDisplayList() {
        return this.useDisplayList;
    }

    public void setUseDisplayList(boolean bl) {
        this.useDisplayList = bl;
    }

    public void setLabelFormat(int n) {
        if (n < 0 || n > 2) {
            return;
        }
        this.labelFormat = n;
    }

    public int getLabelFormat() {
        return this.labelFormat;
    }

    public void setTitleRotated(boolean bl) {
        this.titleRotation = bl;
    }

    public boolean isTitleRotated() {
        return this.titleRotation;
    }

    private synchronized boolean inRange(double d, double d2, double d3) {
        return d <= d3 && d >= d2;
    }

    private synchronized double getNormalizedIncrement(double d, double d2) {
        if (this.inRange(d, 0.0, 0.1)) {
            return 0.1 * d2;
        }
        if (this.inRange(d, 0.1, 0.25)) {
            return 0.25 * d2;
        }
        if (this.inRange(d, 0.25, 0.5)) {
            return 0.5 * d2;
        }
        if (this.inRange(d, 0.5, 1.0)) {
            return d2;
        }
        if (this.inRange(d, 1.0, 9.0)) {
            return 2.0 * d2;
        }
        return d2;
    }

    protected synchronized int datasetsInUse() {
        int n = 0;
        while (n < this.datasets.length) {
            if (this.datasets[n] == null) {
                return n;
            }
            ++n;
        }
        return n;
    }

    protected double getMaxValsFromData(int n) {
        double d = -9.0E35;
        if (!this.isXAxis) {
            int n2 = 0;
            while (n2 < n) {
                d = Math.max(d, this.datasets[n2].maxY());
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                d = Math.max(d, this.datasets[n3].maxX());
                ++n3;
            }
        }
        return d;
    }

    protected double getMinValsFromData(int n) {
        double d = 9.0E35;
        if (!this.isXAxis) {
            int n2 = 0;
            while (n2 < n) {
                d = Math.min(d, this.datasets[n2].minY());
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                d = Math.min(d, this.datasets[n3].minX());
                ++n3;
            }
        }
        return d;
    }

    private synchronized boolean linearScale() {
        double d;
        double d2 = 9.0E35;
        double d3 = -9.0E35;
        boolean bl = true;
        int n = this.datasetsInUse();
        if (n == 0) {
            return false;
        }
        double d4 = this.getMaxValsFromData(n);
        double d5 = this.getMinValsFromData(n);
        if (n > 1 || this.datasets[0].data.size() > 1) {
            bl = false;
        }
        if (this.barScaling) {
            if (d5 > 0.0) {
                d5 = 0.0;
            }
            if (d4 < 0.0) {
                d4 = 0.0;
            }
        }
        double d6 = bl || d4 == d5 ? (d5 != 0.0 ? Math.abs(d5 * 2.0) : (d4 == 0.0 ? 2.0 : d4)) : d4 - d5;
        double d7 = Transform.log10(d6);
        double d8 = d7 < 0.0 ? Math.pow(10.0, Math.ceil(d7)) : Math.pow(10.0, Math.floor(d7));
        double d9 = d6 / (5.0 * d8);
        this.stepSize = d = this.getNormalizedIncrement(d9, d8);
        d2 = Math.floor(d5 / d) * d;
        while ((d2 += d) <= d5) {
        }
        d3 = d2 -= d;
        while ((d3 += d) < d4) {
        }
        this.axisStart = d2;
        this.axisEnd = d3;
        this.numMajTicks = this.numLabels = (int)((d3 - d2) / this.stepSize);
        this.numGrids = this.numLabels;
        this.numMinTicks = 2 * this.numMajTicks;
        return true;
    }

    protected void drawLine(Graphics graphics) {
        switch (this.side) {
            case 0: {
                this.lineGc.drawLine(graphics, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY), this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY));
                return;
            }
            case 1: {
                this.lineGc.drawLine(graphics, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY), this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY));
                return;
            }
            case 2: {
                this.lineGc.drawLine(graphics, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY), this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY));
                return;
            }
            case 3: {
                this.lineGc.drawLine(graphics, this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY), this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY));
                return;
            }
        }
    }

    private void buildDisplayList() {
        switch (this.side) {
            case 0: {
                this.globals.displayList.addRectangle(this, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY), this.plotarea.transform.point(this.plotarea.urX, 0.0));
                return;
            }
            case 1: {
                this.globals.displayList.addRectangle(this, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY), this.plotarea.transform.point(0.0, this.plotarea.urY));
                return;
            }
            case 2: {
                this.globals.displayList.addRectangle(this, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY), this.plotarea.transform.point(this.plotarea.urX, 1.0));
                return;
            }
            case 3: {
                this.globals.displayList.addRectangle(this, this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY), this.plotarea.transform.point(1.0, this.plotarea.llY));
                return;
            }
        }
    }

    float getIncrement(int n, int n2, int n3) {
        return ((float)n - (float)n2) / (float)n3;
    }

    protected int whereOnAxis(int n, int n2) {
        if (this.logScaling) {
            return this.whereOnLogAxis(n, n2);
        }
        if (this.side == 0 || this.side == 2) {
            return this.startPoint.x + (int)(this.increment * (float)n);
        }
        return this.startPoint.y + (int)(this.increment * (float)n);
    }

    protected void drawTicks(Graphics graphics) {
        int n;
        int n2;
        if (this.majTickVis) {
            switch (this.side) {
                case 0: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                    n2 = this.startPoint.y;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                    this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numMajTicks);
                    n = 0;
                    while (n < this.numMajTicks) {
                        this.tickGc.drawLine(graphics, this.whereOnAxis(n, 4), n2, this.whereOnAxis(n, 4), n2 - this.majTickLength);
                        ++n;
                    }
                    this.tickGc.drawLine(graphics, this.endPoint.x, n2, this.endPoint.x, n2 - this.majTickLength);
                    break;
                }
                case 1: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                    n2 = this.startPoint.x;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                    this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numMajTicks);
                    n = 0;
                    while (n < this.numMajTicks) {
                        this.tickGc.drawLine(graphics, n2, this.whereOnAxis(n, 4), n2 - this.majTickLength, this.whereOnAxis(n, 4));
                        ++n;
                    }
                    this.tickGc.drawLine(graphics, n2, this.endPoint.y, n2 - this.majTickLength, this.endPoint.y);
                    break;
                }
                case 2: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                    n2 = this.startPoint.y;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                    this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numMajTicks);
                    n = 0;
                    while (n <= this.numMajTicks) {
                        this.tickGc.drawLine(graphics, this.whereOnAxis(n, 4), n2, this.whereOnAxis(n, 4), n2 + this.majTickLength);
                        ++n;
                    }
                    this.tickGc.drawLine(graphics, this.endPoint.x, n2, this.endPoint.x, n2 + this.majTickLength);
                    break;
                }
                case 3: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                    n2 = this.startPoint.x;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                    this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numMajTicks);
                    n = 0;
                    while (n <= this.numMajTicks) {
                        this.tickGc.drawLine(graphics, n2, this.whereOnAxis(n, 4), n2 + this.majTickLength, this.whereOnAxis(n, 4));
                        ++n;
                    }
                    this.tickGc.drawLine(graphics, n2, this.endPoint.y, n2 + this.majTickLength, this.endPoint.y);
                    break;
                }
            }
        }
        if (this.minTickVis) {
            switch (this.side) {
                case 0: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                    n2 = this.startPoint.y;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                    this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numMinTicks);
                    n = 0;
                    while (n < this.numMinTicks) {
                        this.tickGc.drawLine(graphics, this.whereOnAxis(n, 3), n2, this.whereOnAxis(n, 3), n2 - this.minTickLength);
                        ++n;
                    }
                    this.tickGc.drawLine(graphics, this.endPoint.x, n2, this.endPoint.x, n2 - this.minTickLength);
                    return;
                }
                case 1: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                    n2 = this.startPoint.x;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                    this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numMinTicks);
                    n = 0;
                    while (n < this.numMinTicks) {
                        this.tickGc.drawLine(graphics, n2, this.whereOnAxis(n, 3), n2 - this.minTickLength, this.whereOnAxis(n, 3));
                        ++n;
                    }
                    this.tickGc.drawLine(graphics, n2, this.endPoint.y, n2 - this.minTickLength, this.endPoint.y);
                    return;
                }
                case 2: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                    n2 = this.startPoint.y;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                    this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numMinTicks);
                    n = 0;
                    while (n < this.numMinTicks) {
                        this.tickGc.drawLine(graphics, this.whereOnAxis(n, 3), n2, this.whereOnAxis(n, 3), n2 + this.minTickLength);
                        ++n;
                    }
                    return;
                }
                case 3: {
                    this.startPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                    n2 = this.startPoint.x;
                    this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                    this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numMinTicks);
                    n = 0;
                    while (n < this.numMinTicks) {
                        this.tickGc.drawLine(graphics, n2, this.whereOnAxis(n, 3), n2 + this.minTickLength, this.whereOnAxis(n, 3));
                        ++n;
                    }
                    this.tickGc.drawLine(graphics, n2, this.endPoint.y, n2 + this.minTickLength, this.endPoint.y);
                    return;
                }
            }
        }
    }

    protected void drawGrids(Graphics graphics) {
        this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
        this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
        switch (this.side) {
            case 0: 
            case 2: {
                this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numGrids);
                int n = 0;
                while (n < this.numGrids) {
                    this.gridGc.drawLine(graphics, this.whereOnAxis(n, 2), this.startPoint.y, this.whereOnAxis(n, 2), this.endPoint.y);
                    ++n;
                }
                this.gridGc.drawLine(graphics, this.endPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
                return;
            }
            case 1: 
            case 3: {
                this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numGrids);
                int n = 0;
                while (n < this.numGrids) {
                    this.gridGc.drawLine(graphics, this.startPoint.x, this.whereOnAxis(n, 2), this.endPoint.x, this.whereOnAxis(n, 2));
                    ++n;
                }
                this.gridGc.drawLine(graphics, this.startPoint.x, this.endPoint.y, this.endPoint.x, this.endPoint.y);
                return;
            }
        }
    }

    protected void draw3Dgrids(Graphics graphics) {
        this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
        this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
        switch (this.side) {
            case 0: 
            case 2: {
                this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numGrids);
                int n = 0;
                while (n < this.numGrids) {
                    this.gridGc.drawLine(graphics, this.whereOnAxis(n, 2), this.startPoint.y, this.whereOnAxis(n, 2) + this.globals.xOffset, this.startPoint.y + this.globals.yOffset);
                    ++n;
                }
                this.gridGc.drawLine(graphics, this.endPoint.x, this.startPoint.y, this.endPoint.x + this.globals.xOffset, this.startPoint.y + this.globals.yOffset);
                n = 0;
                while (n < this.numGrids) {
                    this.gridGc.drawLine(graphics, this.whereOnAxis(n, 2) + this.globals.xOffset, this.startPoint.y + this.globals.yOffset, this.whereOnAxis(n, 2) + this.globals.xOffset, this.endPoint.y + this.globals.yOffset);
                    ++n;
                }
                this.gridGc.drawLine(graphics, this.endPoint.x + this.globals.xOffset, this.startPoint.y + this.globals.yOffset, this.endPoint.x + this.globals.xOffset, this.endPoint.y + this.globals.yOffset);
                return;
            }
            case 1: 
            case 3: {
                this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numGrids);
                int n = 0;
                while (n < this.numGrids) {
                    this.gridGc.drawLine(graphics, this.startPoint.x, this.whereOnAxis(n, 2), this.startPoint.x + this.globals.xOffset, this.whereOnAxis(n, 2) + this.globals.yOffset);
                    ++n;
                }
                this.gridGc.drawLine(graphics, this.startPoint.x, this.endPoint.y, this.startPoint.x + this.globals.xOffset, this.endPoint.y + this.globals.yOffset);
                n = 0;
                while (n < this.numGrids) {
                    this.gridGc.drawLine(graphics, this.startPoint.x + this.globals.xOffset, this.whereOnAxis(n, 2) + this.globals.yOffset, this.endPoint.x + this.globals.xOffset, this.whereOnAxis(n, 2) + this.globals.yOffset);
                    ++n;
                }
                this.gridGc.drawLine(graphics, this.startPoint.x + this.globals.xOffset, this.endPoint.y + this.globals.yOffset, this.endPoint.x + this.globals.xOffset, this.endPoint.y + this.globals.yOffset);
                return;
            }
        }
    }

    protected String getLabel(double d, int n) {
        if (this.logScaling) {
            return this.getLogLabel(d, n);
        }
        return this.fmtLabel(d);
    }

    private String fmtLabel(double d) {
        int n;
        String string = Double.toString(d);
        int n2 = string.indexOf(".");
        if (n2 != -1 && n2 == (n = string.length()) - 2 && string.charAt(n - 1) == '0') {
            string = string.substring(0, n2);
        }
        if (this.labelFormat == 0) {
            return string;
        }
        n2 = string.indexOf("e");
        if (n2 == -1) {
            n2 = string.indexOf("E");
        }
        if (n2 != -1) {
            string = Gc.nonSciNumberStr(string, n2);
        }
        return Gc.formattedLabel(string, this.labelFormat, this.labelPrecision);
    }

    protected void drawLabels(Graphics graphics) {
        graphics.setFont(this.labelFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(this.labelColor);
        int n = 0;
        switch (this.side) {
            case 0: {
                String string;
                this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                int n2 = this.startPoint.y - this.majTickLength - 2;
                this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numLabels);
                double d = (this.axisEnd - this.axisStart) / (double)this.numLabels;
                int n3 = 0;
                while (n3 < this.numLabels) {
                    string = this.getLabel(this.axisStart + d * (double)n3, n3);
                    this.lineGc.drawSmartString(graphics, this.whereOnAxis(n3, 1), n2, this.side, this.labelAngle, fontMetrics, string);
                    ++n3;
                }
                if (this.barScaling && this.isXAxis) break;
                string = this.getLabel(this.axisEnd, n3);
                this.lineGc.drawSmartString(graphics, this.whereOnAxis(n3, 1), n2, this.side, this.labelAngle, fontMetrics, string);
                break;
            }
            case 1: {
                int n4;
                String string;
                this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                this.endPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numLabels);
                double d = (this.axisEnd - this.axisStart) / (double)this.numLabels;
                int n5 = 0;
                while (n5 < this.numLabels) {
                    string = this.getLabel(this.axisStart + d * (double)n5, n5);
                    int n6 = fontMetrics.stringWidth(string);
                    if (n6 > n) {
                        n = n6;
                    }
                    n4 = this.startPoint.x - this.majTickLength - 2;
                    this.lineGc.drawSmartString(graphics, n4, this.whereOnAxis(n5, 1), this.side, this.labelAngle, fontMetrics, string);
                    ++n5;
                }
                if (this.barScaling && this.isXAxis) break;
                string = this.getLabel(this.axisEnd, n5);
                n4 = this.startPoint.x - this.majTickLength - 2;
                this.lineGc.drawSmartString(graphics, n4, this.whereOnAxis(n5, 1), this.side, this.labelAngle, fontMetrics, string);
                break;
            }
            case 2: {
                String string;
                this.startPoint = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                int n7 = this.startPoint.y + this.majTickLength + 2 + fontMetrics.getMaxDescent();
                this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                this.increment = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numLabels);
                double d = (this.axisEnd - this.axisStart) / (double)this.numLabels;
                int n8 = 0;
                while (n8 < this.numLabels) {
                    string = this.getLabel(this.axisStart + d * (double)n8, n8);
                    this.lineGc.drawSmartString(graphics, this.whereOnAxis(n8, 1), n7, this.side, this.labelAngle, fontMetrics, string);
                    ++n8;
                }
                if (this.barScaling && this.isXAxis) break;
                string = this.getLabel(this.axisEnd, n8);
                this.lineGc.drawSmartString(graphics, this.whereOnAxis(n8, 1), n7, this.side, this.labelAngle, fontMetrics, string);
                break;
            }
            case 3: {
                String string;
                this.startPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                this.endPoint = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                this.increment = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numLabels);
                double d = (this.axisEnd - this.axisStart) / (double)this.numLabels;
                int n9 = this.startPoint.x + this.majTickLength + 2;
                int n10 = 0;
                while (n10 < this.numLabels) {
                    string = this.getLabel(this.axisStart + d * (double)n10, n10);
                    int n11 = fontMetrics.stringWidth(string);
                    if (n11 > n) {
                        n = n11;
                    }
                    this.lineGc.drawSmartString(graphics, n9, this.whereOnAxis(n10, 1), this.side, this.labelAngle, fontMetrics, string);
                    ++n10;
                }
                if (this.barScaling && this.isXAxis) break;
                string = this.getLabel(this.axisEnd, n10);
                n9 = this.startPoint.x + this.majTickLength + 2;
                this.lineGc.drawSmartString(graphics, n9, this.whereOnAxis(n10, 1), this.side, this.labelAngle, fontMetrics, string);
                break;
            }
        }
        if (n == 0) {
            n = fontMetrics.getMaxAscent();
        }
        if (this.titleString != null) {
            this.drawTitle(graphics, this.majTickLength + n + 4);
        }
    }

    protected void drawTitle(Graphics graphics, int n) {
        graphics.setFont(this.titleFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(this.titleColor);
        switch (this.side) {
            case 0: {
                Point point = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                Point point2 = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                this.lineGc.drawString(graphics, point.x + (point2.x - point.x) / 2 - fontMetrics.stringWidth(this.titleString) / 2, point.y - n - fontMetrics.getHeight(), this.titleString);
                return;
            }
            case 1: {
                Point point = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
                Point point3 = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                if (!this.titleRotation) {
                    this.lineGc.drawString(graphics, point.x - fontMetrics.stringWidth(this.titleString) / 2, point3.y + 4, this.titleString);
                    return;
                }
                this.lineGc.drawSmartString(graphics, point.x - n, point.y + (point3.y - point.y) / 2, this.side, 90, fontMetrics, this.titleString);
                return;
            }
            case 2: {
                Point point = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
                Point point4 = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                this.lineGc.drawString(graphics, point.x + (point4.x - point.x) / 2 - fontMetrics.stringWidth(this.titleString) / 2, point.y + n, this.titleString);
                return;
            }
            case 3: {
                Point point = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.llY);
                Point point5 = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
                if (!this.titleRotation) {
                    this.lineGc.drawString(graphics, point.x - fontMetrics.stringWidth(this.titleString) / 2, point5.y + 4, this.titleString);
                    return;
                }
                this.lineGc.drawSmartString(graphics, point.x + n + fontMetrics.getMaxAscent(), point.y + (point5.y - point.y) / 2, this.side, 90, fontMetrics, this.titleString);
                return;
            }
        }
    }

    private synchronized boolean logScale() {
        int n = this.datasetsInUse();
        if (n == 0) {
            return false;
        }
        double d = this.getMaxValsFromData(n);
        double d2 = this.getMinValsFromData(n);
        if (d <= 0.0 || d2 <= 0.0) {
            return false;
        }
        try {
            this.axisStart = Math.floor(Transform.log10(d2));
            this.axisEnd = Math.ceil(Transform.log10(d));
            this.axMagnitude = (int)(this.axisEnd - this.axisStart);
            if (this.axMagnitude < 2) {
                this.numMajTicks = this.numMinTicks = 10 * this.axMagnitude;
                this.numGrids = this.numMinTicks;
                this.numLabels = this.numMinTicks;
            } else if (this.axMagnitude < 3) {
                this.numGrids = this.numMajTicks = 3 * this.axMagnitude;
                this.numLabels = this.numMajTicks;
                this.numMinTicks = 10 * this.axMagnitude;
            } else {
                this.numMajTicks = this.numMinTicks = this.axMagnitude;
                this.numGrids = this.numMinTicks;
                this.numLabels = this.numMinTicks;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private int checkItemQ(int n, int n2, int n3) {
        n = n >= n2 ? n2 : (n >= n3 ? n3 : this.axMagnitude);
        return n;
    }

    private void checkLogAx() {
        this.axisStart = Math.floor(this.axisStart);
        this.axisEnd = Math.ceil(this.axisEnd);
        this.axMagnitude = (int)(this.axisEnd - this.axisStart);
        int n = this.axMagnitude * 10;
        int n2 = this.axMagnitude * 3;
        this.numLabels = this.checkItemQ(this.numLabels, n, n2);
        this.numGrids = this.checkItemQ(this.numGrids, n, n2);
        this.numMinTicks = this.checkItemQ(this.numMinTicks, n, n2);
        this.numMajTicks = this.checkItemQ(this.numMajTicks, n, n2);
    }

    private String getLogLabel(double d, int n) {
        double d2;
        if (this.numLabels > this.axMagnitude * 3) {
            double d3 = Math.pow(10.0, (double)(n / 10) + this.axisStart);
            int n2 = n % 10;
            d2 = d3 * (double)(n2 + 1);
        } else if (this.numLabels > this.axMagnitude) {
            double d4 = Math.pow(10.0, (double)(n / 3) + this.axisStart);
            int n3 = n % 3;
            switch (n3) {
                case 0: {
                    d2 = d4;
                    break;
                }
                case 1: {
                    d2 = d4 * 2.0;
                    break;
                }
                case 2: {
                    d2 = d4 * 5.0;
                    break;
                }
                default: {
                    d2 = d4;
                    break;
                }
            }
        } else {
            d2 = Math.pow(10.0, this.axisStart + (double)n);
        }
        return this.fmtLabel(d2);
    }

    private int whereOnLogAxis(int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        switch (n2) {
            case 1: {
                if (this.numLabels > this.axMagnitude * 3) {
                    bl2 = true;
                    break;
                }
                if (this.numLabels <= this.axMagnitude) break;
                bl = true;
                break;
            }
            case 2: {
                if (this.numGrids > this.axMagnitude * 3) {
                    bl2 = true;
                    break;
                }
                if (this.numGrids <= this.axMagnitude) break;
                bl = true;
                break;
            }
            case 3: {
                if (this.numMinTicks > this.axMagnitude * 3) {
                    bl2 = true;
                    break;
                }
                if (this.numMinTicks <= this.axMagnitude) break;
                bl = true;
                break;
            }
            case 4: {
                if (this.numMajTicks > this.axMagnitude * 3) {
                    bl2 = true;
                    break;
                }
                if (this.numMajTicks <= this.axMagnitude) break;
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        n3 = bl2 ? (int)((double)((float)(n - n % 10) * this.increment) + (double)this.increment * oneTwoSteps[n % 10]) : (bl ? (int)((double)((float)(n - n % 3) * this.increment) + (double)this.increment * twoFiveSteps[n % 3]) : (int)(this.increment * (float)n));
        if (this.side == 0 || this.side == 2) {
            return this.startPoint.x + n3;
        }
        return this.startPoint.y + n3;
    }

    static {
        double[] dArray = new double[3];
        dArray[1] = 0.903;
        dArray[2] = 2.097;
        twoFiveSteps = dArray;
        double[] dArray2 = new double[10];
        dArray2[1] = 3.01;
        dArray2[2] = 4.771;
        dArray2[3] = 6.02;
        dArray2[4] = 6.989;
        dArray2[5] = 7.781000000000001;
        dArray2[6] = 8.451;
        dArray2[7] = 9.031;
        dArray2[8] = 9.542;
        dArray2[9] = 10.0;
        oneTwoSteps = dArray2;
    }
}

