/*
 * Decompiled with CFR 0.152.
 */
package javachart.applet;

import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.net.MalformedURLException;
import java.net.URL;
import javachart.chart.Transform;

class MessageFrame
extends Frame {
    AppletContext appletContext;
    Button okBut;
    Button jumpBut;
    Panel buttonPanel;
    Transform logoTransform;
    static double[] poly1X = new double[]{0.12, 0.375, 0.325, 0.05};
    static double[] poly1Y = new double[]{0.925, 0.2, 0.035, 0.795};
    static double[] poly2X = new double[]{0.53, 0.66, 0.393, 0.335};
    static double[] poly2Y = new double[]{0.95, 0.97, 0.235, 0.4};
    static double[] poly3X = new double[]{0.445, 0.49, 0.95, 0.9};
    static double[] poly3Y = new double[]{0.285, 0.41, 0.41, 0.285};
    static double[] poly4X = new double[]{0.54, 0.585, 1.06, 1.01};
    static double[] poly4Y = new double[]{0.554, 0.681, 0.681, 0.554};
    static double[] poly5X = new double[]{0.635, 0.675, 1.16, 1.116};
    static double[] poly5Y = new double[]{0.822, 0.935, 0.935, 0.822};

    MessageFrame() {
        this.setLayout(new BorderLayout());
        this.buttonPanel = new Panel();
        this.add("South", this.buttonPanel);
        this.buttonPanel.setLayout(new FlowLayout());
        this.okBut = new Button("OK");
        this.buttonPanel.add(this.okBut);
        this.jumpBut = new Button("Tell me more...");
        this.buttonPanel.add(this.jumpBut);
        this.setTitle("KavaChart Information");
        ((Component)this).reshape(0, 0, 450, 200);
        this.logoTransform = new Transform(0.0, 0.0, 1.2, 1.2, 390, 50, 440, 100);
        this.setResizable(false);
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.size().width, this.size().height);
        graphics.setColor(Color.black);
        int n = 70;
        graphics.drawString("Free KavaChart applets copyright (c) 1998, Visual Engineering, Inc.", 10, n);
        graphics.drawString("Commercial and educational versions also available at minimal cost", 10, n += fontMetrics.getMaxAscent() + 5);
        graphics.drawString("Contact us at (650) 856-5694, info@ve.com, www.ve.com", 10, n += fontMetrics.getMaxAscent() + 5);
        this.paintComponents(graphics);
        MessageFrame.drawLogo(graphics, this, this.logoTransform);
    }

    void setAppletContext(AppletContext appletContext) {
        this.appletContext = appletContext;
    }

    public boolean handleEvent(Event event) {
        block5: {
            if (event.id == 201) {
                ((Component)this).hide();
                return true;
            }
            if (event.id != 1001) {
                return false;
            }
            if (event.target.equals(this.okBut)) {
                ((Component)this).hide();
            }
            if (!event.target.equals(this.jumpBut) || this.appletContext == null) break block5;
            try {
                this.appletContext.showDocument(new URL("http://www.ve.com/javachart/index.html"), "_blank");
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Can't open www.ve.com");
            }
        }
        return true;
    }

    static void drawLogo(Graphics graphics, Component component, Transform transform) {
        graphics.setColor(Color.blue);
        MessageFrame.fillPolygon(graphics, poly1X, poly1Y, component, transform);
        MessageFrame.fillPolygon(graphics, poly2X, poly2Y, component, transform);
        MessageFrame.fillPolygon(graphics, poly3X, poly3Y, component, transform);
        MessageFrame.fillPolygon(graphics, poly4X, poly4Y, component, transform);
        MessageFrame.fillPolygon(graphics, poly5X, poly5Y, component, transform);
    }

    static void fillPolygon(Graphics graphics, double[] dArray, double[] dArray2, Component component, Transform transform) {
        int[] nArray = new int[dArray.length];
        int[] nArray2 = new int[dArray2.length];
        Point[] pointArray = transform.pointList(dArray, dArray2);
        int n = 0;
        while (n < dArray.length) {
            nArray[n] = pointArray[n].x;
            nArray2[n] = component.size().height - 20 - pointArray[n].y;
            ++n;
        }
        graphics.fillPolygon(nArray, nArray2, nArray.length);
    }
}

