/* rcsid[] = "$Header: dispmgr.h,v 800.0 85/08/06 14:09:36 root Exp $" */
/* sccsid[] = "%W% %Y% %Q% %G%" */


/************************************************************************
 *									*
 *	dispmgr.h -- header file for emulation software			*
 *									*
 *	(See main.c for general remarks and documentation)		*
 *									*
 *	Justin Douglas Tygar			September 3, 1982	*
 *	Continuation by Justin Douglas Tygar and Steven Sargent		*
 *	Window package by J. D. Tygar	January 31, 1984		*
 *	Continuation by John Oswalt					*
 *									*
 ************************************************************************/

/************************************************************************
 *                                                                      *
 *			Copyright 1982, 1983, 1984			*
 *		    VALID LOGIC SYSTEMS INCORPORATED			*
 *									*
 * 	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	the written consent of an officer of Valid Logic Systems	*
 *	Incorporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or            *
 *      unintentional public disclosure.				*
 *									*
 ************************************************************************/

/*	
 *  SOME NOTES ON COORDINATE SYSTEMS USED IN THE DISPLAY MANAGER
 *
 *	The display manager uses a number of incompatible coordinate
 *	systems.  The different systems reflect whether character or
 *	pixel operations are being preformed; whether the operation
 *	is done in the VGB code by a high-level routine (like bitblt())
 *	or a low-level routine (like colbitgraph()), e.g., a high-level
 *	routine is further from the construction of a direct 7220 (NEC GDC)
 *	command; and whether 3270 or VT100 emulation is being done.
 *
 *	Character operations are usually expressed in line and column
 *	numbers, measured from the upper left corner, which is
 *	line=0, col=0.  Operations describing fullscreen activites
 *	and operations like blankout(), flipcursor(), drawchar(), etc,
 *	use the upper-left area of the screen as the origin, other
 *	references use the upper left corner of the window margins as
 *	operative references.
 *
 *	3270 emulation use a linear array to describe locations -- e.g.
 *	3270_position = line*80 + col.  However, to make life truly miserable,
 *	standard 3271 protocol expresses this address as two six-bit words,
 *	each of which is encoded in a printing EBCDIC character.  See the
 *	description before the declaration of ibm_address[] in tables.c for
 *	more information on this.
 *
 *	Bitgraph pixel positions are described in x and y coordinates
 *	using the following chart as a guide
 *
 *	 0 		 X COORD	1023
 *	7+---------------------------------+
 *	9|				   |
 *	9|				   |
 *	 |				   |
 *	 |				   |
 *	Y|				   |
 *	 |				   |
 *	C|				   |
 *	O|				   |
 *	O|				   |
 *	R|				   |
 *	D|				   |
 *	 |				   |
 *	 |				   |
 *	 |				   |
 *	 |				   |
 *	 |				   |
 *	0+---------------------------------+
 *
 *	The coordinates in the bitgraph position, or course, refer only to 
 *	displayable memory.  Usually all coordinates refer to positions
 *	relative to the lower-left hand corner.  Unfortunately, the BBN
 *	set origin escape sequence allows one to define another point as
 *	the effective origin other pixels are reported relative to.  
 *
 *	Undisplayed memory on the GDC chip is represented as a single array
 *	of 16-pixel rows, (since the colbitblt() operation only acts on
 *	16-pixel columns) which are stored beneath the bottom pixel-line of
 *	the display in 64 columns.  0 is the 16 bit row in the upper left
 *	corner, 1 is the 16 bit row in the second line beneath 0, 223 is in
 *	the lower left corner, 224 is in the top line next to 0, etc.
 *
 *	An additional coordinate system, the GDC coordinate system, is
 *	used for colbitgraph() and is described in interface.a86 where
 *	colbitgraph is defined
 */

/************************************************************************
 *									*
 *				BAUD RATES				*
 *									*
 ************************************************************************/

/*
 * The baud rates for the codes are adapted from "Hardware Reference Manual--
 * Octal Serial Interface", (c) 1980 Central Data Corporation, which in
 * turn was adapted from the data sheets for the Signetics 2651 UART.
 */

#define NBAUDS		16		/*  there are 16 distinct rates  */
#define NBAUDMASK	(NBAUDS-1)	/*  x % NBAUDS = x & NBAUDSMASK  */

/*
 *  The default value; number 14 in the baud rate table.
 */
#define POSof9600	14

/************************************************************************
 *									*
 *			ASCII AND EBCDIC CODES				*
 *									*
 ************************************************************************/

/*	ASCII codes  	*/
#define BEL	'\007'		/*  ASCII Bell */
#define BACKSP	'\010'		/*  ASCII Backspace  */
#define HT	'\011'		/*  ASCII Horizontal Tab  */
#define LF	'\012'		/*  ASCII Line Feed  */
#define VT	'\013'		/*  ASCII Vertical Tab  */
#define FF	'\014'		/*  ASCII Form Feed  */
#define CR	'\015'		/*  ASCII Carriage Return  */
#define SO	'\016'		/*  ASCII Shift Out  (select G1 char set)  */
#define SI	'\017'		/*  ASCII Shift In  (select G0 char set  */
#define DC1	'\021'		/*  ASCII DC1  */
#define DC3	'\023'		/*  ASCII DC3  */
#define CAN	'\030'		/*  ASCII Cancel  */
#define SUB	'\032'		/*  ASCII Substitute  */
#define ESCAPE	'\033'		/*  The ASCII ESC  */
#define SPACE	' '		/*  ASCII ' ' */
#define DEL	'\177'		/*  The ASCII Delete  */

/*  Non-ascii ebcdic codes  */
#define SPECIAL 0200
#define CENT	(SPECIAL+1)	/*  Ebcdic cent ($) sign  */
#define NOT	(SPECIAL)	/*  Ebcdic not (upside down L) sign  */

/************************************************************************
 *									*
 *	 		DEFINITIONS OF BITS IN BYTES			*
 *									*
 ************************************************************************/

/*  IBM ATTRIBUTE CHARACTER BIT DEFINITION  */
#define	ATT		128	/*  IS THIS A PACKED ATTRIBUTE CHAR  ?  */
#define ON		64	/*  ATTRIBUTE CHARACTER  */
#define PROTECTED	32	/*  FIELD IS PROTECTED  */
#define NUMERIC		16	/*  FIELD IS ALPHAMERIC  */
#define INTENSE		8	/*  INTENSIFIED DISPLAY  */
#define DETECT		4	/*  FIELD DECTABLE  */
#define MDT		1	/*  MODIFIED DATA TAGS  */

/*  IBM WRITE CHARACTER BIT DEFINITION  */
#define WCC		64	/*  CHARACTER IS ON  */
#define ALARM		4	/*  BELL AT END OF COMMAND  */
#define KEYRESET	2	/*  Keyboard restore  */
#define RESETMDT	1	/*  Reset MDT Bits  */

/*  Definitions of various bits for keyboard status byte  */
#define CTRL		(keystatus & CTRLFLAG)
#define SUPER		(keystatus & SUPERFLAG)
#define SHIFT		(keystatus & SHIFTFLAG)
#define HYPER		(keystatus & HYPERFLAG)
#define	META		(keystatus & METAFLAG)
#define CPLK		(BCA <= keystroke && keystroke <= BCZ)
#define TESTSHIFT	(SHIFT || CPLK)
#define UP(x)		(0200 + x)

/*  The bit assignments for keyboard status byte (see wait in interface.a86) */
#define SHIFTFLAG	1
#define CTRLFLAG	2
#define SUPERFLAG	4
#define HYPERFLAG	8
#define METAFLAG	16

/*  Status byte 1, p. 5-22, GA23-0060-0  */
#define TRANSMISSION_CHECK	1
#define DEVICE_END		2	/* Machine is turned on */
#define UNIT_SPECIFY		4
#define DEVICE_BUSY		8

/*  Status byte 2, p. 5-22, GA23-0060-0  */
#define OPERATION_CHECK		1
#define CONTROL_CHECK		2	/* Machine is turned off */
#define DATA_CHECK		4
#define EQUIPMENT_CHECK		8
#define INTERVENTION_REQUIRED	16
#define COMMAND_REJECT		32

/*
 * Ports and queues.  Ports (which are indicies into the www array)
 * are mapped directly onto queues (through which we communicate with
 * the outside world).  This means that KEYQUEUE has a port which is
 * unused, and exists only to simplify logic.
 */

#define	NUMQUEUES	16	/*  Number of VGB queues  */
#define	UNIXQUEUE	0	/*  First of NUMUNIX unix queues  */
#define KEYQUEUE	12	/*  Keyboard raw input  */
#define IBMQUEUE	13	/*  3270 input comes in on the unlucky port  */
#define VAXQUEUE	14	/*  Passthrough VT 100 I/O  */
#define WMQUEUE		15	/*  Window manager packets */
#define IOCTLQUEUE	15	/*  Ioctl information */
#define TILED		15	/*  Fake port number meaning all tiled w's */

#ifndef WHITE
#define NUMUNIX		12	/*  Maximum number of UNIX windows  */
#else WHITE
#define NUMUNIX		1	/*  Maximum number of UNIX windows  */
#endif WHITE

/*
 *  Types of passthrough operations
 *  Beware that some tests are made >= GRAPHPASS, which assume that this is 
 *  equivelant to == GRAPHPASS || == SIMULATOR.  In other words, be careful
 *  if you add any new passthrough values.
 */

#define UNIXPASS  0		/*  VT100 emulation connected to UNIX  */
#define DECPASS   1		/*  VT100 emulation connected to VAX  */
#define IBMPASS   2		/*  3270 emulation connected to IBM 370-oid  */
#define GRAPHPASS 3		/*  Graphics mode  */
#define	SIMULATOR 4		/*  Line GRAPHPASS, but partial screen scrolling allowed  */

/*  Parity for ACK's--see acknowledge()  */

#define EVEN		0
#define ODD		1
#define UNKNOWN		2
#define SILENT		3

/*
 *  The intensity flags for the draw command.  NORMAL and BOLD represent
 *  printing characters in normal and intensified mode.  DIMERASEBOLD
 *  represents printing a character in NORMAL mode but erasing a BOLD
 *  character that previously was under it.
 */

#define NORMAL		0
#define BOLD		1
#define DIMERASEBOLD 	2

/*
 *  Bits for reverse video and underlining.
 */

#define RVBIT		4
#define ULBIT		8

/*  What kind of cursor do we have?  */

#define BLOCK		0
#define UNDERSCORE	1

/*  Which char set is selected?  */
#define G0SELECTED	0
#define G1SELECTED	1

/*  Value for missing parameters in BBN escape sequences */

#define UNDECL		(-1)

/*
 *  The following definition is used in tables.c to represent, in the 
 *  (keystrokes ->-> ascii chars) mapping a keystroke which is not to be
 *  printed or transmitted, such as the control key.  Note that it is defined
 *  as an octal short, even though it is a char.  This is because the alignment
 *  on the compiler screws up when you give it, for example, '\377' or 
 *  (char) -1.  (And it does really dumb stuff when you give it '\0377'.)
 *  This is a bug in the compiler.
 */
#define BADCHAR		0377

#define FINAL		(-2)
#define UNASSIGNED	(-1)
#define NOPORT		(-1)
#define FALSE		0
#define TRUE		1		/*  What is truth?  */
#define HONOR		1
#define SHAME		0

/*  What character set are we using -- see VT100 manual p. 39  */
#define ASCIISET	0
#define GRAPHSET	1


/************************************************************************
 *									*
 *	RASTER OPERATION MODE FOR BITGRAPH WINDOW SEQUENCES		*
 *									*
 ************************************************************************/

#define REPLACE		0
#define	COMPLEMENT	1
#define	CLEAR		2
#define	SET		3
#define	NOOP		7	/*  This is a number from heaven */

/*  Sequences for interacting with the Unix-Based Window Manager */

#define	WMSIGNAL	0xff	/*  Start packet  */
#define	WM_CREATE	1	/*  New window created  */
#define	WM_DESTROY	2	/*  Window deleted  */
#define WM_SIZE		3	/*  Window re-sized  */
#define WM_COVER	4	/*  Window suspended (covered)  */
#define WM_UNCOVER	5	/*  Undo of above  */
#define WM_QUIT		6	/*  Went back to compatiblity mode  */
#define WM_SAVE		7	/*  Save screen on disk */
#define WM_RESTORE	8	/*  Restore screen from disk */
#define WM_PACKET_SIZE	13	/*  Packet size for window stuff  */

/*  Dimensions  -- in pixel lengths! */

#define FLOOR		(YSIZE-(HEIGHT+1)*FONTHEIGHT)

/*  Dimensions in pixel lengths of ENTIRE screen  */
#ifndef WHITE
#define	XSIZE		1024
#define	YSIZE		800
#else WHITE
#define	XSIZE		720
#define	YSIZE		560
#endif WHITE

#ifndef KERNEL
/*
 *  Undead storage is done in chunks of 16-pixel wide, 56-pixel deep, segments.
 *  We have an array containing UNDEADSIZE many shorts, each of which is
 *  UNASSIGNED if the corresponding undead area have no data stored in it;
 *  FINAL if it is the final chunk in a sequence, and has a pointer to the
 *  next index in the linked list of storage otherwise.
 */
#define SEGPERCOL	4			/*  undead segments  */
#define SEGSIZE		(XSIZE-YSIZE)/SEGPERCOL
#define	UNDEADSIZE	(XSIZE/COLSIZE)*SEGPERCOL
#endif KERNEL


#ifndef WHITE
#define FONTWIDTH	10	/*  Horizontal width of font chars  */
#define FONTHEIGHT	12	/*  Vertical length of font chars  */
#else WHITE
#define FONTWIDTH	9	/*  Horizontal width of font chars  */
#define FONTHEIGHT	16	/*  Vertical length of font chars  */
#endif WHITE
#define YOFFSET		(FONTHEIGHT/2)
#define XOFFSET		(FONTWIDTH/2)
#define YFIX		4

#define COLSIZE		16	/*  Most efficient size for Bitblt ops */
#define NUMCOLS		((XSIZE+1)/COLSIZE)	/*  Number of storage cols  */

/************************************************************************
 *									*
 *	CONSTANTS FOR PROPER IMPLEMENTATION (TO MATCH OUTSIDE SPECS)	*
 *									*
 ************************************************************************/

/*  3270 Commands (see p. 3-1 of GA23-0060-0  */
#define WRITE		0xf1
#define ERASEWRITE	0xf5
#define READBUFFER	0xf2
#define READMODIFIED	0xf6
#define EAU		0x6f	/*  Erase all unprotected  */

#define	HEIGHT		63	/*  No. of lines (-2 for status) in screen  */
#define ACTUALHEIGHT	66	/*  The real thing, dad		*/
#define WIDTH		80	/*  How wide a screen can we remember?  */
#define ACTUALWIDTH	102	/*  Ain't nothin like it	*/
#define IHEIGHT 	24	/*  IBM Model 2 Height  */
#define BUFSIZE		(WIDTH*IHEIGHT)
#define COMMSIZE	104	
#define RLISTSIZE	20
#define OUTBUFSIZE	TEXTBLOCKSIZE
#define INBUFSIZE	2560	/*  Should be equal to MAXBLOCKDATA below */
#define VGSIZE		36	/*  Size of VGB buffer  */
#define VGSIGNAL	0xfe

#define	MODELINE	(ACTUALHEIGHT-2)
#define	TFKEYLINE	(ACTUALHEIGHT-1)

/*  How large are the blocks of outgoing data that we permitted?  */
/*  SEE KLUDGE NOTE IN BISYNC.C  */
#define TEXTBLOCKSIZE	(256 - RLISTSIZE)

/*  Maximum size of inbound text blocking  */
#define PARTBLOCKSIZE	(TEXTBLOCKSIZE - 10)

/*  
 *  The following set of polling and selection address are taken from
 *  p. 5-12 of GA23-0060-0.
 */

#define	CUPOLL		0x40		/*  CU Zero -- Polling Address */
#define CUSELECT	0x60		/*  CU Zero -- Selection Address  */
#define GENERALPOLL	0x7f		/*  Address for general poll  */

/************************************************************************
 *									*
 *			     PARAMETERS					*
 *									*
 ************************************************************************/

#ifndef WHITE
#define NUMSTATIONS	4	/*  How many display stations use software  */
#define NUMWIND		14	/*  How many windows on each station?  */
#else WHITE
#define NUMSTATIONS	1	/*  How many display stations use software  */
#define NUMWIND		1	/*  How many windows on each station?  */
#endif WHITE
#define	ESSIZE		20	/*  Max. size of ESC seq  */
#define MAXPARAMS 	15	/*  Max number of params in an esc seq  */
#define MAXIB		20	/*  Max number of inputbuffer  */
#define MAXSCRATCHSIZE	2000	/*  Size of largest outgoing message  */
#define PATNSIZE	16	/*  Magic size for patterns for texture()  */

/************************************************************************
 *									*
 *		    GLOBAL VARIABLES AND DATA TYPES			*
 *									*
 ************************************************************************/

#ifndef WHITE
typedef struct pointxy {

	short x, y;
	char mode;

} pointxy; 

typedef struct glp {

	struct glp * next, *prev;
	char type;
	short aligner;
	pointxy *first, *second;

} glp; 

typedef struct recforgraph {	/* GED's type Record_For_Graphics_Processor */

      char operation;			/* {what operation to perform} */
      char flags;    			
      char mode;			/* GED's type Graphics_Mode */
      char inten;			/* GED's type Intensity  */
      short xmin, ymin, xmax, ymax;	/* {clipping boundaries} */
      unsigned short scaler;		/* {32768=1, but 32767=max} */
      short xoff, yoff;			/* {screen = page*scale+xoff} */
      short dx, dy;			/* {added in if dynamic} */
      unsigned short alignr;		/* {historical, memory alignment} */
      glp *pointer;			/* GED's type Graphics_List_Pointer */

} recforgraph;
#endif WHITE

typedef unsigned char  uchar;
typedef unsigned char  bool;
/*typedef unsigned short ushort;*/

#ifndef WHITE
/*
 *  BITBLT communications area --
 *    This is the communications buffer which is passed to the bitblt() and
 *    texture() graphics primitives.
 */

typedef struct bbcomm
{
	short		dstx,		/*  Upper left corner of destination */
			dsty,
			windxl,		/*  Window lower left corner */
			windxr,
			windyb,		/*  Window upper right corner */
			windyt,
			patn[PATNSIZE];
} bbcomm;
#endif WHITE

#ifndef WHITE
#define QSIZE 256

struct clist
{
	int	cc;		/* character count */
	char	c[QSIZE];	/* space for queue */
};
#endif WHITE

/*
 *	This is the basic data structure used to manipulate windows
 */

typedef struct
{
#ifdef WHITE
	/* byte offsets are not magic -- just given to help debugging */
	uchar	charatts,	/*  0: Character attributes */
		oldcharatts;	/*  1: Old character attributes */
	bool	ansi, 		/*  2: ANSI or VT52 flag  */
		curdrwn,	/*  3: Is the cursor drawn?  */
		om,		/*  4: origin mode  */
		puck,		/*  5: Should puck sequences be sent? */
		wrap,		/*  6: Wraparound flag  */
		wrapln;		/*  7: Is the current line about to be wraped? */
	short 	col, line,	/*  8,A: The width and length of the display  */
		curcol, curline,/*  C,E: The line & col of the cursor (VT100) */
		duckstate,	/*  10: Duck_mode FSM control */
		oldcol, oldline,/*  12,14: Saved cursor positions  */
		passthrough,	/*  16: Type of pass through */
		startcol,	/*  18,1A: The "true" (e.g. character) margins of */
		startline,	/*     the window we are manipulating  */
		topsc, botsc,	/*  1C,1E: Top and bottom of scrolling region  */
		wxl, wxr,	/*  20,22,24,26: Margins for the windows  */
		wyb, wyt;
	unsigned short t_local;	/*  28: local mode word */
	char 	seq[ESSIZE];	/*  2A: Escape sequence  */
#else WHITE
	/*  VT 100 specific variables  */
	uchar	charatts,	/*  Character attributes */
		oldcharatts;	/*  Old character attributes */
	bool	ansi, 		/*  ANSI or VT52 flag  */
		application,	/*  Application mode or numeric mode flag  */
		curdrwn,	/*  Is the cursor drawn?  */
		curkey, 	/*  Cursor key or application key mode  */
		g0charset,	/*  The g0 character graphics set  */
		g1charset,	/*  The g1 character graphics set  */
		graphics,	/*  Are we displaying pseudo-graphics mode?  */
		fullscreen,	/*  Is this a fullscreen window? */
		inuse,		/*  Window is currently in use  */
		oldgraphics,	/*  Former graphics mode  */
		om,		/*  origin mode  */
		puck,		/*  Should puck sequences be sent? */
		under,		/*  Is the cursor an underscore?  */
		whichcharset,	/*  Is the g1 charset selected  ?  */
		wrap,		/*  Wraparound flag  */
		wrapln;		/*  Is the current line about to be wraped? */
	short 	col, line,	/*  The width and length of the display  */
		curcol, curline,/*  The line & col of the cursor (VT100) */
		duckstate,	/*  Duck_mode FSM control */
		jumpscroll,	/*  Number of lines to scroll at a time */
		oldcol, oldline,/*  Saved cursor positions  */
		oldjump,	/*  Previous value of jumpscroll. */
		overlap[NUMWIND+1],/*portion of wndw overlpng w/current wndw  */
		passthrough,	/*  Type of pass through */
		port,		/*  Which port are we attached to?  */
		startcol,	/*  The "true" (e.g. character) margins of */
		startline,	/*     the window we are manipulating  */
		topsc, botsc,	/*  Top and bottom of scrolling region  */
		wxl, wxr,	/*  Margins for the windows  */
		wyb, wyt;
	char 	seq[ESSIZE],	/*  Escape sequence  */
		name[10];

	struct clist t_rawq;
	unsigned short t_flags;
	unsigned short t_local;	/* local mode word */

/* 	-------------------------------------------------------------------
 *	The next 14 characters must be in this order to
 *	match the packet comming from the kernel on ioctl changes.
 */
	char	t_erase;	/* erase character */
	char	t_kill;		/* kill character */
	char	t_intrc;	/* interrupt */
	char	t_quitc;	/* quit */
	char	t_startc;	/* Start output character (ctrl-q usually) */
	char	t_stopc;	/* Stop output character (ctrl-s usually) */
	char	t_eofc;		/* end-of-file */
	char	t_brkc;		/* input delimiter (like nl) */
	char	t_suspc;	/* stop process signal */
	char	t_dsuspc;	/* delayed stop process signal (UNUSED) */
	char	t_rprntc;	/* reprint line */
	char	t_flushc;	/* flush output (toggles) */
	char	t_werasc;	/* word erase */
	char	t_lnextc;	/* char indicating next char is literal */
/*
 *	End of characters which must match packet from kernel.
 *	--------------------------------------------------------------------
 */

	char	t_lstate;	/* local state */
	char	t_rocount;	/* chars input since a ttwrite() */
	char	t_rocol;	/* curcol when first input this line */

#endif WHITE
} window, *windowp;

/*
 *  This is the structure used to contain data for a single display
 */

typedef struct
{
#ifdef WHITE
	window	*curwindow,	/*  Current window being modified  */
		*select;	/*  Window chosen by user  */
				/*  (In WHITE there IS only one window!) */
	bool	puckdrawn;	/*  Is the puck cursor drawn? */
#else WHITE
	window	www[NUMWIND+1],	/*  Linked list of window structures  */
		*curwindow,	/*  Current window being modified  */
		*select;	/*  Window chosen by user  */

	/*  VT 100 specific variables  */
	bool	map,		/*  Map BS->DEL to un-brain-damage VMS  */
		mapRCtoCR,	/*  Map right cntrl->CR (emulate 3277-ENTER)  */
		odd,		/*  Odd parity?  */
		parity,		/*  Parity set?  */
		puckdrawn;	/*  Is the puck cursor drawn? */

	/*  IBM 3270 specific variables  */
	bool	disable,	/*  Is keyboard disabled?  */
		insert,		/*  Is it in insert mode?  */
		wentoff,	/*  Has the IBM window just been deleted? */
		wenton;		/*  Has the IBM window just been created? */
	short	bufloc,		/*  The current buffer address  */
		busylock,	/*  Tset lock for a busy board  */
		curloc,		/*  The location of the cursor  (IBM 3270)  */
		update;		/*  It is time to update the screen  */
	uchar	aid,		/*  Attention Identification Char  */
		ibmdisp[BUFSIZE];	/*  3270 screen  */

	/*  Common variables  */
	bool	doauto,		/*  Should we do autorepeat? */
		peacock;	/*  Is this a peacock? */
	short	baudrate,	/*  encoded version of operating baud rate */
		devicenumber,	/*  Which device number are we?  */
		fastwait,	/*  OK for wait to wait forever for input? */
		keystatus,	/*  What modified keys are up or down?  */
		lastkey,	/*  Last key held down  */
		layer[NUMWIND],	/*  Array of values indicating window layers  */
 		lockcount,	/*  How long have queues been locked out? */
		nfullwind,	/*  How many fullscreen windows are there? */
		puckx, pucky,	/*  Puck cooridinates  */
		puckbutton,	/*  Button pressed when puck activated  */
		refcount,	/*  Reference count of number of free lines
				    in freelist  */
		timer,		/*  Used for auto-repeat */
		undead[UNDEADSIZE];
	windowp weirdstate;	/*  Real top window but stipple shows */
	unsigned short waitfor;	/* Bitmask of currently interesting ports */
	unsigned short savewait;/* Where waitfor is saved during lockout */
	unsigned short swaitf;  /* Where waitfor is saved during fullscreen */
#endif WHITE
} display, *pdisp;

/*
 *  The following struct is formatted the way it is to facilitate
 *  the loading together of all the data structures required to interface
 *  with Carol's code in the appropriate order.  Later, the value of pibbuf 
 *  will be loaded at location 2 in the segment (see interface.a86).
 *
 *  The important parts of this struct are the in and out buffers which
 *  represent the in and out buffers, respectively, used to communicate
 *  down the bisync line.
 */

struct
{
	uchar	comm[COMMSIZE];
	uchar	out[OUTBUFSIZE];
	uchar	rlist[RLISTSIZE];
	uchar	in[INBUFSIZE];
} pibbuf;


/*  Global data  */
short	state;				/*  State of bisync FSM (in bisync.c) */
uchar	scratch[MAXSCRATCHSIZE];	/*  Large buffer for formatting reads */
display	ddd[NUMSTATIONS];		/*  This is where all the data live  */
window fakew;				/*  Fake window for various tricks */
short vgblock;				/*  Semaphore so only one vgb tries to
				 	    save or restore screen at a time */
short	junk;				/*  Who cares what this is!  */

#ifndef WHITE
extern bool	bisyncalive;		/*  Is the bisync line functioning?  */

/*  Tables  */
extern uchar 	norm_ibm[],	/*  Maps keystrokes ->-> ebcdic  */
		caps_ibm[],	/*  Maps keystrokes w/caps ->-> ebcdic  */
		ibm_address[],	/*  Maps integers ->-> ibm addresses  */
		norm_ascii[],	/*  Maps keystrokes ->-> ascii  */
		caps_ascii[],	/*  Maps keystrokes w/caps ->-> ascii  */
		control_ascii[],/*  Maps keystrokes w/ctrl ->-> ascii  */
		ebcdic[],	/*  Maps ebcdic ->-> ascii  */
		special[],	/*  Maps non-ebcdic internal ->-> non-ebcdic */
		oddparity[],	/*  Maps ascii ->-> ascii w/odd parity  */
		numkeys[],	/*  Maps function keystrokes -> numbers */
		rasttable[],	/*  Maps BBN raster ops -> Chuang's raster */
		partab[],	/*  Parity table for character cooking    */
		sizebig[],
		g2mbus[],
		sizesmall[],
		reversedma[];
extern char	funkeys[],	/*  Maps function keystrokes -> functions */
		version[];	/*  Version info generated by makeversion */

extern unsigned short colortable[256][3];
#else WHITE
extern char	version[];	/*  Version info generated by makeversion */
#endif WHITE


/************************************************************************
 *									*
 *			MISCELLANEOUS MACROS				*
 *									*
 ************************************************************************/

#ifndef KERNEL
#define MIN(x,y)	((x) < (y) ? (x) : (y))
#define MAX(x,y)	((x) > (y) ? (x) : (y))
#endif KERNEL

#define	CNTRL(c)	('c'&037)


/*  Is it a location l, c in 3270 software protected? */
#define WRITEPROT(w, l) \
	(PROTECTED & getfield((w), (l), NULLSHORT))
#define PIBWRITEPROT(w, l) \
	(PROTECTED & pbgetfield((w), (l), NULLSHORT))

#define MOD(x)		((x + BUFSIZE) % BUFSIZE)

/*
 *  Isanatt -- if the location is an attribute char, returns TRUE else, false
 */
#define isanatt(w, loc)	(ATT & w->ibmdisp[loc])

/*
 *  Isprotected -- if the location is protected att char, return TRUE
 */
#define isprotected(w, loc)	(isanatt(w,loc) && (PROTECTED&w->ibmdisp[loc]))

/*
 *  Isunprotected -- if the location is an unprotected att char, return TRUE
 */
#define isunprotected(w, loc)	(isanatt(w,loc)&&!(PROTECTED&w->ibmdisp[loc]))

/*
 *  Readmod -- is the char an aid for a read modified  operation?
 *
 * If it is then it not 6B, 6C, 6D, or 6E, that is, it is not inbetween
 *	an EBcomma and an EBgt.
 * IBM manual p. 3-4.
 */
#define READMOD(aid)	(aid < EBcomma || EBgt < aid)

/*
 *  BYTE1, BYTE2 -- these perform the inverse operation of getaddress in
 *	ibm3270.c.  This inverse mapping is a lot easier since we need only
 *	shift the value and then '&' it with 0x3f.
 */
#define BYTE1(x)	ibm_address[(x >> 6) & 0x3f]
#define BYTE2(x)	ibm_address[x & 0x3f]

#ifndef KERNEL
#define DEBUG debug
#endif KERNEL

/************************************************************************
 *									*
 *			       LINT STUFF				*
 *									*
 ************************************************************************/

#ifndef KERNEL
#define NULL		((uchar *)   0)
#endif KERNEL

#define NULLCHAR	((char  *)   0)
#define NULLSHORT	((short *)   0)
#define NULLWINDOW	((windowp)   0)
#define NULLZOMBIE	((zombie *)  0)
#define NULLSTORAGE	((storage *) 0)

#ifdef 	LINT
#define IGNORE(x)
#else 	LINT
#define IGNORE(x)	x
#endif

/************************************************************************
 *									*
 *			FUNCTION TYPE DECLARATIONS			*
 *									*
 ************************************************************************/

#ifdef LINT
#define ALLOCATE(d,x)	(x *) (d-d)
#else
#define	ALLOCATE(d,x)	(x *) malloc(d,sizeof(x))
#endif

#define FREE(d,x)	free(d,(char *)(x))
