static char rcsid[] = "$Header: apple.c,v 800.0 85/08/06 14:06:06 root Exp $";
static char sccsid[] = "%W% %Y% %Q% %G%";

/*
 * apple.c 840829 sbs
 *	interrupt service on the apple slots (currently wired to level 2)
 *	swiped from corvus lvl1.c
 */
#include "../s32/vectors.h"
#include "../s32/reentrant.h"
#include "../white/config.h"


	/* slot bit defs */
#define S1IRQ	0x10
#define S2IRQ	0x20
#define S3IRQ	0x40
#define S4IRQ	0x80
#define S1NMI	0x01
#define S2NMI	0x02
#define S3NMI	0x04
#define S4NMI	0x08


appleinit() {
	extern appleint();

	IRQ2vector = appleint;
}

reentrant(appleint)
{
	register char *slotstatus = (char *)(IOBASE + 0x30a01);
	register unsigned int stat;
	extern	(*appleslots[])();

	if (stat = ~(*slotstatus)) {
		do {
			if(stat&S1IRQ)
				(*appleslots[0])(0);
			if(stat&S2IRQ)
				(*appleslots[1])(1);
			if(stat&S3IRQ)
				(*appleslots[2])(2);
			if(stat&S4IRQ)
				(*appleslots[3])(3);
		} while (stat = ~(*slotstatus));
	} else
		mdint(0);
}

/* dummy for empty slots */

int noslot(snum) {
	printf("ap%d: spurious interrupt\n", snum);
}
