/* sccsid[] = "%W% %Y% %Q% %G%" */
/* rcsid[] = "$Header: exos_decnet.h,v 800.1 85/10/21 16:21:11 root Exp $" */
/*
 *
 *
 *       TCI/EXCELAN DECnet FEP INTERFACE DEFINITIONS
 *
 *
 */

#define	NLL	10			/* Number of logical links */

/*
 * Standard EXOS DECnet FEP mode message header
 *
 *	Each DECnet message in the request and reply message queues has
 *	the following message header.
 *
 */


/* Values for bufdescr.discr */
#define	BFD_SHARED	0	/* Address points to shared memory */
#define	BFD_IMMEDIATE	1	/* Address is offset to following data */
#define	BFD_USER	2	/* Address points into host address space */


/* Common Link Level return codes decnet_exos structure reply */
#define	DNok		0x01	/* Successful completion */

/*
 * Fields for cmd_type in the decnet_exos structure
 */
#define	DNopen		0x01
#define	DNread		0x02
#define	DNwrite		0x03
#define	DNclose		0x04
#define	DNioctl		0x05


/*
 * The following device types are placed in the dev_type field of the
 * ExosPacket.
 */
#define	DEV_UNKNOWN	0
#define	DEV_LL		1
#define	DEV_NETM	2
#define	DEV_DAP		3
#define	DEV_DGS		4
#define	NUM_DEVICES	4




/*  BUFFER DESCRIPTOR  */
typedef struct _exos_bd_
	{
	tbits eb_disc;		/* discriminant       */
	char eb_resv;		/* reserved byte      */
	short eb_len;		/* lenth of data      */
	char  *eb_addr;		/* address of data    */
	} ExosBd;



/*  HOST EXOS MESSAGE FORMAT  */
typedef struct decnet_exos
	{
	u_char	ex_resrv1[7];		/* Reserved bytes                */
	tbits	ex_status;		/* reserved for exos sync.       */
	short	ex_length;		/* Length of msg in bytes        */
	tiny	ex_exsid;		/* Exos service id               */
	tiny	ex_hsid;		/* Host service id               */
	long	ex_recp;		/* Recipient- used to sync addr. */
	long	ex_orig;		/* Originator - not used         */
	short	ex_msg_class;		/* message class                 */
	short	ex_resp;		/* Request/Reply code            */
	char	ex_recv2[2];		/* Reserved bytes                */
	tiny	ex_nids;		/* Number of channel ids         */
	tiny	ex_bds;			/* Number of buffer descriptors  */
	tiny	ex_dev_type;		/* Device type opened from pc    */ 
	tiny	ex_fd;			/* File descriptor from pc       */ 
	short	ex_lcn;			/* Logical channel number        */
	ExosBd	ex_bd;			/* Buffer descriptor             */
	short	ex_cmd_type;		/* Command type                  */
	union	msg_data		/* Message data can be:          */
		{
		short  ioctl_func;	/* Ioctl function type from pcdrv*/
		short  ret_status;	/* Return status from lldrv      */
		} ex_mdata;
	} ExosPacket;


/* Values for ll_info.state */
#define	LI_FREE	0x00		/* Link not being used */
#define	LI_TAKEN	0x01		/* Link is being used (llopen) */
#define	LI_OPEN	0x02		/* Link is open (SES_SERVER, SES_CLIENT) */
#define	LI_FAILED	0x04		/* Link open failed */
#define	LI_DISC	0x08		/* Link has been disconnected/aborted */
#define	LI_CLOSED	0x10		/* Close has been issued on the link */
#define	LI_ACTIVE	0x20		/* An connect or server request was issued */


typedef struct ll_info
	{
	struct inode *li_iptr;	/* inode pointer for this logical link */
	short li_minor;		/* Character special device for link */
	tbits li_state;		/* Current link state */
	short li_link;			/* Link Id on EXOS controller */
	tiny	li_command;		/* Current outstanding command */
	tiny li_ctrlr;			/* EXOS controller unit number */
	struct proc *li_proc;	/* Process that opened link */
	ushort li_pid;			/* Process id of thar process */
	} LinkInfo;

#define	NUMFDS	16

#ifdef	DEBUG
#define	DPRINT( a, b, c )	if( a > b ) { printf c; }
#else
#define	DPRINT( a, b, b )
#endif	DEBUG

