static char rcsid[] = "$Header: kern_exit.c,v 820.1 86/12/04 19:57:58 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	kern_exit.c	6.1	83/07/29	*/

#include "../machine/reg.h"
#include "../machine/psl.h"
#ifdef	M68020_REV_B
#include "../machine/context.h"
#endif	M68020_REV_B

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/map.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/kernel.h"
#include "../h/proc.h"
#include "../h/buf.h"
#include "../h/wait.h"
#include "../h/vm.h"
#include "../h/file.h"
#include "../h/mbuf.h"
#include "../h/inode.h"

/*
 * Exit system call: pass back caller's arg
 */
rexit()
{
	register struct a {
		int	rval;
	} *uap;

	uap = (struct a *)u.u_ap;
	exit((uap->rval & 0377) << 8);
}

/*
 * Release resources.
 * Save u. area for parent to look at.
 * Enter zombie state.
 * Wake up parent and init processes,
 * and dispose of children.
 */
exit(rv)
	int rv;
{
	register int i;
	register struct proc *p, *q;
	register int x;
	struct mbuf *m = m_getclr(M_WAIT, MT_ZOMBIE);

#ifdef s32	/* PGINPROF */
	vmsizmon();
#endif
	p = u.u_procp;
	p->p_flag &= ~(STRC|SULOCK);
	p->p_flag |= SWEXIT;
	p->p_sigignore = ~0;
	p->p_cpticks = 0;
	p->p_pctcpu = 0;
	for (i = 0; i < NSIG; i++)
		u.u_signal[i] = SIG_IGN;
	untimeout(realitexpire, (caddr_t)p);
	/*
	 * Release virtual memory.  If we resulted from
	 * a vfork(), instead give the resources back to
	 * the parent.
	 */
	if ((p->p_flag & SVFORK) == 0)
#ifdef USE_CTXT
		/*
		 * Invalidate context inside of vrelvm()
		 */
		vrelvm();
#else USE_CTXT
		vrelvm();
#endif USE_CTXT
	else {
		p->p_flag &= ~SVFORK;
		wakeup((caddr_t)p);
		while ((p->p_flag & SVFDONE) == 0)
			sleep((caddr_t)p, PZERO - 1);
		p->p_flag &= ~SVFDONE;
#ifdef USE_CTXT
		ctxt_invalidate(p);
#endif USE_CTXT
	}
	for (i = 0; i < NOFILE; i++) {
		struct file *f;

		f = u.u_ofile[i];
		u.u_ofile[i] = NULL;
		u.u_pofile[i] = 0;
		closef(f);
	}
	ilock(u.u_cdir);
	iput(u.u_cdir);
	if (u.u_rdir) {
		ilock(u.u_rdir);
		iput(u.u_rdir);
	}
	u.u_rlimit[RLIMIT_FSIZE].rlim_cur = RLIM_INFINITY;
	acct();
#ifdef QUOTA
	qclean();
#endif
	/*
	 * Get all resource usage information out of the u. page BEFORE
	 * releasing it (vrelu).
	 */
	if (m == 0) {
		panic("exit: out of mbufs");
	}
	p->p_ru = mtod(m, struct rusage *);
	*p->p_ru = u.u_ru;
	ruadd(p->p_ru, &u.u_cru);

	/*
	 *
	 *	If we are in dire need of memory it probably is not a
	 *	good idea to release the pte pages and then reference
	 *	them in order to release the u page.  This could cause
	 *	severe problems as the pte's get garbled.
	 *	The following lines were reversed:
	 *		vrelpt(u.u_procp);
	 *		vrelu(u.u_procp, 0);
	 *
	 *	ELP - 3/10/86
	 */
	vrelu(p, 0);
	vrelpt(p);		/* we'd like to believe that p == u.u_procp */
	(void) spl5();		/* hack for mem alloc race XXX */
	multprog--;
	p->p_stat = SZOMB;
	noproc = 1;
	i = PIDHASH(p->p_pid);
	x = p - proc;
	if (pidhash[i] == x)
		pidhash[i] = p->p_idhash;
	else {
		for (i = pidhash[i]; i != 0; i = proc[i].p_idhash)
			if (proc[i].p_idhash == x) {
				proc[i].p_idhash = p->p_idhash;
				goto done;
			}
		panic("exit");
	}
	if (p->p_pid == 1)
		panic("init died");
done:
	p->p_xstat = rv;
	for (q = proc; q < procNPROC; q++)
		if (q->p_pptr == p) {
			if (q->p_osptr)
				q->p_osptr->p_ysptr = q->p_ysptr;
			if (q->p_ysptr)
				q->p_ysptr->p_osptr = q->p_osptr;
			if (proc[1].p_cptr)
				proc[1].p_cptr->p_ysptr = q;
			q->p_osptr = proc[1].p_cptr;
			q->p_ysptr = NULL;
			proc[1].p_cptr = q;

			q->p_pptr = &proc[1];
			q->p_ppid = 1;
			wakeup((caddr_t)&proc[1]);
			/*
			 * Traced processes are killed
			 * since their existence means someone is screwing up.
			 * Stopped processes are sent a hangup and a continue.
			 * This is designed to be ``safe'' for setuid
			 * processes since they must be willing to tolerate
			 * hangups anyways.
			 */
			if (q->p_flag&STRC) {
				q->p_flag &= ~STRC;
				psignal(q, SIGKILL);
			} else if (q->p_stat == SSTOP) {
				psignal(q, SIGHUP);
				psignal(q, SIGCONT);
			}
			/*
			 * Protect this process from future
			 * tty signals, clear TSTP/TTIN/TTOU if pending.
			 */
			(void) spgrp(q, -1);
		}
	psignal(p->p_pptr, SIGCHLD);
	wakeup((caddr_t)p->p_pptr);
#ifdef	M68020_REV_B
	{	register fireDoor = 0;

		/*
		 * Empty out the list and reset the extrema ptrs
		 * to reflect same.
		 */
		while (HEAD && (fireDoor++ < maxVSmaps(p))) {
			delAtHead(); 	/* HEAD is updated		*/
		}
		emptyVSmapList ();	/* Paranoia: Empty LRU list	*/
		u.u_vSmapsInUse	= 0;	/* # of virt smaps in use	*/
	}
#endif	M68020_REV_B

#ifdef	CTXT_DEMUX
	/*
	 * The the current context may be an aggregation
	 * of 16Mb constitiuents.
	 * We contitionally remap the constitiuents
	 * to insure a viable kernel-map
	 * if the aggregation is dissembled into it parts.
	 *
	 * NOTE: Actually we only disassemble the agregated contexts
	 * if they are larger than the "normal" size context we use;
	 * meaning that we never instantiate anything smaller
	 * than "normal"; nor to we need to take apart "normal" contexts.
	 *
	 * BUG:  I hope that I've delayed any dismantling long enough
	 * to no longer be referencing any of the material
	 * in the kernel area near the TOP of the virtual address space.
	 */
	if (p->p_mmuIndx > normalMmuIndx) {
		ctxt_deMux(p);
	}
#endif	CTXT_DEMUX

	/*
	 * Paranoia: Reset to some rational process vaddr size.
	 *
	 * BUG:  This may override a subsequent high vaddr reference,
	 * or the like.
	 */
	p->p_mmuIndx	    = normalMmuIndx;	/* Initialized in startup1() */
	p->p_mmuStatRegBits = 0;    /* Status reg bits: A<26..24> -> ctxtReg */
	swtch();
}

wait()
{
#ifdef s32
	register struct a {
		caddr_t	status;
		int	options;
		caddr_t	rusage;
	} *uap;
	struct rusage ru;

	uap = (struct a *)u.u_ap;
	u.u_error = wait1(uap->options, &ru);
	if (u.u_error)
		return;
	if (uap->rusage &&
	      copyout((caddr_t)&ru, uap->rusage, sizeof(struct rusage)) ||
	    uap->status &&
	      copyout((caddr_t)&u.u_r.r_val2, uap->status, sizeof(union wait)))
		u.u_error = EFAULT;
#else s32
	struct rusage ru, *rup;

	if ((u.u_ar0[PS] & PSL_ALLCC) != PSL_ALLCC) {
		u.u_error = wait1(0, (struct rusage *)0);
		return;
	}
	rup = (struct rusage *)u.u_ar0[R1];
	u.u_error = wait1(u.u_ar0[R0], &ru);
	if (u.u_error)
		return;
	(void) copyout((caddr_t)&ru, (caddr_t)rup, sizeof (struct rusage));
#endif s32
}

/*
 * Wait system call.
 * Search for a terminated (zombie) child,
 * finally lay it to rest, and collect its status.
 * Look also for stopped (traced) children,
 * and pass back status from them.
 */
wait1(options, ru)
	register int options;
	struct rusage *ru;
{
	register f;
	register struct proc *p, *q;

	f = 0;
loop:
	for (p = proc; p < procNPROC; p++)
	if (p->p_pptr == u.u_procp) {
		f++;
		if (p->p_stat == SZOMB) {
			u.u_r.r_val1 = p->p_pid;
			u.u_r.r_val2 = p->p_xstat;
			p->p_xstat = 0;
			if (ru)
				*ru = *p->p_ru;
			ruadd(&u.u_cru, p->p_ru);
			(void) m_free(dtom(p->p_ru));
			p->p_ru = 0;
			p->p_stat = NULL;
			p->p_pid = 0;
			p->p_ppid = 0;
			if (q = p->p_ysptr)
				q->p_osptr = p->p_osptr;
			if (q = p->p_osptr)
				q->p_ysptr = p->p_ysptr;
			if ((q = p->p_pptr)->p_cptr == p)
				q->p_cptr = p->p_osptr;
			p->p_pptr = 0;
			p->p_ysptr = 0;
			p->p_osptr = 0;
			p->p_cptr = 0;
			p->p_sig = 0;
			p->p_sigcatch = 0;
			p->p_sigignore = 0;
			p->p_sigmask = 0;
			p->p_pgrp = 0;
			p->p_flag = 0;
			p->p_wchan = 0;
			p->p_cursig = 0;
			return (0);
		}
		if (p->p_stat == SSTOP && (p->p_flag&SWTED)==0 &&
		    (p->p_flag&STRC || options&WUNTRACED)) {
			p->p_flag |= SWTED;
			u.u_r.r_val1 = p->p_pid;
			u.u_r.r_val2 = (p->p_cursig<<8) | WSTOPPED;
			return (0);
		}
	}
	if (f == 0)
		return (ECHILD);
	if (options&WNOHANG) {
		u.u_r.r_val1 = 0;
		return (0);
	}
#ifdef INTERMEDSIG
	if (((u.u_procp->p_flag&SOUSIG) == 0 || (u.u_procp->p_flag&SNUSIG)) &&
	    setjmp(&u.u_qsave)) {
#else INTERMEDSIG
	if ((u.u_procp->p_flag&SOUSIG) == 0 && setjmp(&u.u_qsave)) {
#endif INTERMEDSIG
		u.u_eosys = RESTARTSYS;
		return (0);
	}
	sleep((caddr_t)u.u_procp, PWAIT);
	goto loop;
}
