static char rcsid[] = "$Header: header.c,v 10.1 86/07/21 14:56:20 bog Exp $";

/************************************************************************\
**									**
**				Copyright 1986				**
**			VALID LOGIC SYSTEMS INCORPORATED		**
**									**
**	This listing contains confidential proprietary information	**
**	which is not to be disclosed to unauthorized persons without	**
**	written consent of an officer of Valid Logic Systems 		**
**	Incoroporated.							**
**									**
**	The copyright notice appearing above is included to provide	**
**	statutory protection in the event of unauthorized or 		**
**	unintentional public disclosure.				**
**									**
\************************************************************************/
/*
 * Boot program: system console driver (s32)
 *
 * %W% %Y% %Q% %G%
 * $Header: sc.c,v 86.1 86/07/21 14:57:07 bog Exp $
 * $Log:	sc.c,v $
 * Revision 86.1  86/07/21  14:57:07  bog
 * Working Standalone MKFS using disk labels (bog).
 * 
 * Revision 86.0  86/07/17  18:59:09  bog
 * This version works with Standalone Mkfs
 * 
 * Revision 2.0  86/06/24  13:46:43  bog
 * Checkin before debugging starts: code is in place but not running (bog)
 * 
 * Revision 800.0  85/10/22  12:55:58  root
 * Initial VALID checkin for 8.0 release
 * 
 * Revision 1.3  85/08/06  12:12:38  ed
 * Everything works, but needs to be cleaned up
 * 
 * Revision 1.2  85/06/21  15:37:40  ed
 * Got 'Boot' to come out on te screen
 * 
 * Revision 1.1  85/06/17  14:18:42  ed
 * Before I touch ed it, direct from tape
 * 
 * Revision 1.1  85/03/12  16:26:26  sbs
 * Initial revision
 * 
 *
 * Copyright (C) 1985 Valid Logic Systems, Inc.
 */
#include "../h/types.h"
#include "../h/param.h"
#include "../h/dir.h"
#include "../s32/reg.h"
#include "../h/map.h"
#include "../s32/setjmp.h"
#include "../s32/scCpu.h"
#include "../s32/necuart.h"
#include "../s32/clock.h"
#include "../s32/cpu.h"

long (*crm)() = (long (*)()) 0x10000; /* for jumping to boot prom */

char uartinit = 1;

/*
 * inituart -- Fire up the uarts
 */

inituart()
{
	register struct uart	*uart = CUART;
	register u_char oldstatus = V_STATUS;

	if (chipType == CHIPTYPE_68010)
		V_STATUS &= ~V_ENBKDET;		/* No resets please */

	uart->ucmd	= UCMDCLR;
	uart->umode	= UM1INIT;
	uart->umode	= (u_char) UM2INIT;
	uart->ucmd	= UCMDINI;

	V_STATUS = oldstatus;
	uartinit = 1;
}

#define ctrl(c)		((c) & 0x1f)

/*
** watchcuart -- watch the console uart.  If we get a ^X or ^C, return 1
**			    else return 0.
*/

watchcuart()
{
    register u_long c;

    if (CUART->ustatus & SUrxrdy) {
	c = CUART->udata & 0x7f;
	if (c  == ctrl('S')) /* wait for ^Q */
	    while (getchar() != ctrl('Q'));
	else if ((c == ctrl('X')) || (c == ctrl('C'))) {
	    return(1);
	}
    }
    return(0);
}

putchar(c) {
	int s;

	V_STATUS |= V_GREENLED;
	if (!uartinit) inituart();
#ifndef	ED_O_MATIC
	if (watchcuart()) {	/* restart CRM */
	    printf("^C\n");
	    crm(); /* jump to boot prom */
	}
#endif  ED_O_MATIC
	if (c == '\n')
		putchar ('\r');
	s = spl5();      /* prevent xmitter interrupts */
#ifdef DEBUG
	SUcommand(0) = UENABLE;  /* enable xmitter first */
#endif

	while (!(SUstatus(0) & SUtxrdy))  /* wait til ready */
		;

	SUdata(0) = c;            /* then output */
	while (!(SUstatus(0) & SUtxrdy)) /* wait til done */
		;
#ifdef DEBUG
	SUcommand(0) = UTRADIS;  /* then disable xmitter */
#endif
	splx(s);
	V_STATUS &= ~V_GREENLED;
}

getchar() {
	char c;

anotherchar:
	V_STATUS |= V_GREENLED;
	if (!uartinit) inituart();
	while (!(SUstatus(0) & SUrxrdy))
		;

	c = (char) (SUdata(0) & 0x7f);

	if (c == ctrl('C')) {
		printf("^C\nGood bye.\n");
		crm(); /* Return to resident monitor */
	}
#ifdef	USE_ERM
	else if (c == ctrl('E')) {
		trap15();
		goto anotherchar;
	}
#endif	USE_ERM
	else if (c == '\r')
		putchar ('\n');
	else if (c >= ' ');
		putchar (c);
	V_STATUS &= ~V_GREENLED;
	return (c);
}
