/* static char rcsid[] = "$Header: startup.c,v 1.3 85/07/02 17:42:48 root Exp $" */

/************************************************************************
 *									*
 *				Copyright 1985				*
 *			VALID LOGIC SYSTEMS INCORPORATED		*
 *									*
 *	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	written consent of an officer of Valid Logic Systems 		*
 *	Incoroporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or 		*
 *	unintentional public disclosure.				*
 *									*
 ************************************************************************/

#include <sys/types.h>
#include "cpu.h"
#include "erm.h"

extern char erm_start, erm_bpt_trace;
extern struct display dispfmt;
extern u_char *erm_fmt;
extern struct bpt bpts[];
extern u_char erm_inp_radix, erm_out_radix;
extern u_char erm_hex_fmt[];
extern struct commtable *curr_comms, commtable[];

/*
 * The version number of ERM should agree with the SCCS/RCS
 * version of the program.  IT WOULD BE STUPID IF THIS
 * WASN'T KEPT UP!!!  DON'T BLOW IT.
 */
extern ermversion[];

/*
 * startup -- startup code for ERM
 */
erm_startup(notrap)
register int notrap;
{
	register struct bpt *bpt_ptr;

	erm_initvecs ();
	dispfmt.format = '%';
	dispfmt.type = 'x';
	dispfmt.null = 0;
	dispfmt.len = 4;
	erm_inp_radix = 16;
	erm_out_radix = 16;
	erm_fmt = erm_hex_fmt;
	curr_comms = commtable;	/* Initialize command table */
	/* Clear breakpoint area */
	for (bpt_ptr = bpts; bpt_ptr < &bpts[ERM_MAXBPT]; bpt_ptr++)
		bpt_ptr -> bpt_flag = 0;
	erm_bpt_trace = 0;
	erm_syminit ();
	erm_start = 1;
	if (!notrap) {
		printf("%s installed\n", ermversion);
		trap15();		/* Trap into debugger */
	}

}
