/* rcsid[]="$Header: fpu68881.h,v 820.1 86/12/04 19:53:21 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	fpu68881.h	1.0	82/10/08	*/

#ifndef	FPU68881_ALREADY_DEFINED
#define	FPU68881_ALREADY_DEFINED

#ifdef	KERNEL
#include "../h/types.h"
#else	KERNEL
#include <sys/types.h>
#endif	KERNEL

#ifdef	M68881
/*
 * Motorola MC68881 Floating Point Co-Processor support.
 *	a) 8 32-bit FPU data    registers;
 *	b) 3 32-bit FPU control registers;
 */

/*
 * M68881 80-bit FPU Data Registers,
 * which are stored in memory as 12-bytes/3-longs
 */
typedef	union	{
	struct	{
		u_short
			fpu68881_signBit_B	:  1,	/* For mantissa  */
			fpu68881_exponent_B	: 15,
						: 16;	/* Zeroed filler */
		u_long	fpu68881_mantissa[2];		/* 64-bits	*/
	} fpu68881DataReg;

	u_char		fpu68881_chars_C[10+2];	/* 80-bits padded to longs */
	u_short		fpu68881_shorts_S[5+1];
} fpu68881DataReg_t;



/*
 * M68881 FPU Control Register
 */
struct	fpu68881CntlReg_s {
	unsigned
				: 16,	/* Fill/0			*/
		/*
		 * Exception ENABLE byte
		 */
#define		FPU_MASK_ENBL	0x0000FF00

		fpu_BSUN_enbl_B	: 1,	/* Branch/set on unordered	*/
#define		FPU_BSUN_ENBL	0x00008000

		fpu_SNAN_enbl_B	: 1,	/* Signalling not a number	*/
#define		FPU_SNAN_ENBL	0x00004000

		fpu_OPERR_enbl_B: 1,	/* Operand error		*/
#define		FPU_OPERR_ENBL	0x00002000

		fpu_OVFL_enbl_B	: 1,	/* Overflow			*/
#define		FPU_OVFL_ENBL	0x00001000

		fpu_UNFL_enbl_B	: 1,	/* Underflow			*/
#define		FPU_UNFL_ENBL	0x00000800

		fpu_DZ_enbl_B	: 1,	/* Divide by zero		*/
#define		FPU_DZ_ENBL	0x00000400

		fpu_INEX2_enbl_B: 1,	/* Inexact operation		*/
#define		FPU_INEX2_ENBL	0x00000200

		fpu_INEX1_enbl_B: 1,	/* Inexact decimal input	*/
#define		FPU_INEX1_ENBL	0x00000100


		/*
		 * Rounding precision
		 */
		fpu_prec_B	: 2,	/* Rounding PRECISION		*/
#define	FPU_MODE_PRECMASK	0x60	/* Bit-mask for the 2-bit field	*/
#define	FPU_MODE_PRECSHIFT	6	/* Bit-shift for the field	*/

#define	FPU_MODE_EXTENDED	0	/* Extended			*/
#define	FPU_MODE_SINGLE		1	/* Single			*/
#define	FPU_MODE_DOUBLE		2	/* Double			*/
#define	FPU_MODE_UNDEF		3	/* Undefined/reserved		*/


		/*
		 * Rounding mode
		 */
		fpu_rnd_B	: 2,	/* Rounding MODE		*/
#define	FPU_MODE_RNDMASK	0x30	/* Bit-mask for the 2-bit field	*/
#define	FPU_MODE_RNDSHIFT	4	/* Bit-shift for the field	*/

#define	FPU_MODE_NEAREST	0	/* To nearest			*/
#define	FPU_MODE_ZERO		1	/* Toward zero			*/
#define	FPU_MODE_MINUS_INFINITY	2	/* Toward minus infinity	*/
#define	FPU_MODE_PLUS_INFINITY	3	/* Toward plus  infinity	*/

				: 4;	/* Fill/0			*/
};

typedef union {
	struct	fpu68881CntlReg_s	fpu68881CntlReg;
	u_char				fpu_cntlRegChars_C[4];
	u_short				fpu_cntlRegShorts_S[2];
	u_long				fpu_cntlRegLong;
} fpu68881CntlReg_t;



/*
 * M68881 FPU Status Register
 */
struct	fpu68881StatReg_s {
	unsigned
		/*
		 * Condition-code byte
		 */
				: 4,	/* Fill/0			*/
#define		FPU_MASK_CCODE	0x0F000000

		fpu_N_B		: 1,	/* CC: Negative			*/
#define		FPU_N_CCODE	0x08000000

		fpu_Z_B		: 1,	/* CC: Zero			*/
#define		FPU_Z_CCODE	0x04000000

		fpu_I_B		: 1,	/* CC: Infinity			*/
#define		FPU_I_CCODE	0x02000000

		fpu_NAN_B	: 1,	/* CC: Not a number or unordered*/
#define		FPU_NAN_CCODE	0x01000000

/*
 * Standard IEEE definitions
 * for floating-point comparison condition-code results.
 */
#define		FPU_EQ_CCODE	 FPU_Z_CCODE
#define		FPU_GT_CCODE	(FPU_N_CCODE|FPU_NAN_CCODE|FPU_N_CCODE)
#define		FPU_LT_CCODE	 FPU_GT_CCODE
#define		FPU_UN_CCODE	 FPU_NAN_CCODE		/* (UNordered) */


		/*
		 * QUOTIENT byte
		 */
		fpu_S_B		: 1,	/* Sign of quotient		*/
#define		FPU_S_QUOT	0x00800000

		fpu_quotient_B	: 7,	/* Seven least sig. bit of quot.*/
#define		FPU_QUOTIENT	0x007f0000


		/*
		 * Exception STATUS byte
		 */
#define		FPU_MASK_STAT	0x0000FF00

		fpu_BSUN_stat_B	: 1,	/* Branch/set on unordered	*/
#define		FPU_BSUN_STAT	0x00008000

		fpu_SNAN_stat_B	: 1,	/* Signalling not a number	*/
#define		FPU_SNAN_STAT	0x00004000

		fpu_OPERR_stat_B: 1,	/* Operand error		*/
#define		FPU_OPERR_STAT	0x00002000

		fpu_OVFL_stat_B	: 1,	/* Overflow			*/
#define		FPU_OVFL_STAT	0x00001000

		fpu_UNFL_stat_B	: 1,	/* Underflow			*/
#define		FPU_UNFL_STAT	0x00000800

		fpu_DZ_stat_B	: 1,	/* Divide by zero		*/
#define		FPU_DZ_STAT	0x00000400

		fpu_INEX2_stat_B: 1,	/* Inexact operation		*/
#define		FPU_INEX2_STAT	0x00000200

		fpu_INEX1_stat_B: 1,	/* Inexact decimal input	*/
#define		FPU_INEX1_STAT	0x00000100


		/*
		 * Accrued EXCEPTION byte
		 */
#define		FPU_MASK_EXCPT	0x000000FF

		fpu_IOP_excpt_B	: 1,	/* Invalid operation		*/
#define		FPU_IOP_EXCPT	0x00000080

		fpu_OVFL_excpt_B: 1,	/* Overflow			*/
#define		FPU_OVFL_EXCPT	0x00000040

		fpu_UNFL_excpt_B: 1,	/* Underflow			*/
#define		FPU_UNFL_EXCPT	0x00000020

		fpu_DZ_excpt_B	: 1,	/* Divide by zero		*/
#define		FPU_DZ_EXCPT	0x00000010

		fpu_INEX_excpt_B: 1,	/* Inexact			*/
#define		FPU_INEX_EXCPT	0x00000008

				: 3;	/* Fill/0			*/
};

typedef	union	{
	struct	 fpu68881StatReg_s	fpu68881StatReg;
	u_char				fpu_statRegChars_C[4];
	u_short				fpu_statRegShorts_S[2];
	u_long				fpu_statRegLong;
} fpu68881StatReg_t;



typedef	u_long	fpu68881AddrReg_t;	/* Instruction Address Register */

/*
 * Savearea for maximum of 0xb8 bytes worth of FPU system internals;
 *	NULL:	0x04 bytes of system state frame;
 *	IDLE:	0x1c bytes;
 *	BUSY:	0xB8 bytes.
 */
typedef	u_long	fpu68881SysStateFrame_t[0xB8 >> 2];

#endif	M68881

#endif	FPU68881_ALREADY_DEFINED
