/*	../netinet/arp.h	1.0	85/03/08	*/

/*
 * Address Resolution Protocol (ARP) header for user interface.
 * Other relevant files are:	if_ether.h	c.f. RFC 826.
 */

/*
 * Address Resolution Protocol (arp) structure
 * returned by or passed to ioctl request to the arp driver:
 * ARP_DELETE, ARP_SET, ARP_SHOWONE, ARP_SHOWNEXT.
 */
struct	arpreq {
	short	index;		/* which arptab entry is to be shown next */
	u_short	hdwtype;	/* hardware address type, e.g. Ethernet */
	u_short	prototype;	/* protocol address type, e.g. IP */
	u_short	flags;		/* arptab entry status flags, e.g. complete */
	u_char	hdwaddr[8];	/* hdw address: format dependent on hdw type */
	u_char	protoaddr[8];	/* prptocol address: format dependent on the
				   protocol being used.  The  [8]  size is
				   believed to be large enough for current
				   and future implementations. */
/* For example: IP over Ethernet: hdwaddr uses 6 bytes; protoaddr 32 bits. */
};

/* ARP ioctl commands */
#define ARP_DELETE	_IOWR(_IO_ARP, 1, struct arpreq)
#define ARP_SET		_IOWR(_IO_ARP, 2, struct arpreq)
#define ARP_SHOWONE	_IOWR(_IO_ARP, 3, struct arpreq)
#define ARP_SHOWNEXT	_IOWR(_IO_ARP, 4, struct arpreq)
#define ARP_PUBLISH	_IOWR(_IO_ARP, 5, struct arpreq)
