/* rcsid[]="$Header: vmparam.h,v 820.1 86/12/04 19:54:58 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	vmparam.h	4.13	82/12/17	*/

#ifndef	VMPARAM_ALREADY_DEFINED
#define	VMPARAM_ALREADY_DEFINED

/*
 * Machine dependent constants
 *
 * jht 860201 -- Add code for variable maximum process size: SETTABLE_MMU_SIZE.
 * jht 860312 -- Reduced SYSPTSIZE from 222 to 210 to allow for larger UPAGES.
 * jht 860323 -- Increasing SYSPTSIZE toward 222 to to allow for larger physmem.
 */

/*
 * Number of virtual pages
 */

#ifdef WHITE
#define BIGPAGES	0x0800		/* Size of map (pages) */
#else WHITE
#define SMALLMAP_PAGES	0x0400		/* Size of small map (pages) */
#define BIGMAP_PAGES	0x8000		/* 128Mb map (pages)	*/
#if	0
#define BIGMAP_PAGES	0x1000		/*  16Mb map (pages)	*/
#define BIGMAP_PAGES	0x2000		/*  32Mb map (pages)	*/
#define BIGMAP_PAGES	0x4000		/*  64Mb map (pages)	*/
#define BIGMAP_PAGES	0x8000		/* 128Mb map (pages)	*/
#endif	0
#endif WHITE

/*
 * Number of segment maps
 */

#include "../machine/ecm.h"		/* MAXPHYSMEM_PAGES */
/*
 * NSMAPS is the lesser
 * of MAXPHYSMEM_PAGES and BIGMAP_PAGES,
 * since we are representing the amount
 * of real memory that can be mapped
 * by the MMU.
 */
#if	MAXPHYSMEM_PAGES < BIGMAP_PAGES
#define	NSMAPS		PTOS(MAXPHYSMEM_PAGES)	/* # of segment maps to alloc */
#else	

#if 0	/* BUG: ifdef-clause inoperative: ==> NSMAPS=0x2000 */
#define	NSMAPS		256			/* Number of segment maps */
#else 0
#define	NSMAPS		PTOS(BIGMAP_PAGES)
#endif 0
#endif	MAXPHYSMEM_PAGES < BIGMAP_PAGES


#define USRTEXT		(KVSIZE*NBPG)	/* Start of user text */
#define	LOWPAGES	btoc(USRTEXT)	/* Pages missing from low end */
#define	HIGHPAGES	(UPAGES+UWASTE)	/* Pages above stack in page tables */

/*
 * Virtual memory related constants
 */

/*
 * For Valid we only use the stack and data maximum
 * sizes for resource limit initialization and checking.
 * We only use the text maximum size because DXDAD in text.h
 * depends on it.
 *
 * chksize() in vm_machdep.c only checks that the entire
 * program will fit when segment aligned.
 */
#define	SLOP	32
#ifdef WHITE
#define	MAXTSIZ		(1024-SLOP)	/* max text size (clicks) */
#ifndef MAXDSIZ
#define	MAXDSIZ		(2048-SLOP)	/* max data size (clicks) */
#endif
#define	MAXSSIZ		(2048-SLOP)	/* max stack size (clicks) */
#else WHITE
/*
 * We need new limits for these variables.  We now have a VM limit of
 * 128 MB and anyway the stack stuff is too restrictive for SVS Pascal
 * stuff which puts globals, including multi meg arrays, on the stack.
 */
#ifdef M68020_REV_B
#include "../machine/cpu.h"
#define	MAXTSIZ		(btoc(V_MAXVA)-SLOP)	/* max text size (clicks) */
#ifndef MAXDSIZ
#define	MAXDSIZ		(btoc(V_MAXVA)-SLOP)	/* max data size (clicks) */
#endif
#define	MAXSSIZ		(btoc(V_MAXVA)-SLOP)	/* max stack size (clicks) */
#else	M68020_REV_B
#define	MAXTSIZ		(1024-SLOP)	/* max text size (clicks) */
#ifndef MAXDSIZ
#define	MAXDSIZ		(4096-SLOP)	/* max data size (clicks) */
#endif
#define	MAXSSIZ		(4096-SLOP)	/* max stack size (clicks) */
#endif	M68020_REV_B
#endif WHITE

/*
 * Sizes of the system and user portions of the system page table.
 */

#ifndef	M68020_REV_B
#define	SYSPTSIZE	222		/* Assumes that kernel-text + the pages
					   unused below kernel + buffers that're
					   allocated in startup() (via valloc())
					   fit in 1024K-32K bytes (224 pages) */

#else	M68020_REV_B
#define	SYSPTSIZE	216		/* Assumes that kernel-text + the pages
					   unused below kernel + buffers that're
					   allocated in startup() (via valloc())
					   fit in 1024K-32K bytes (224 pages) */
#endif	M68020_REV_B
/*
 * User portion of the system page table.
 * UPPER BOUND checked in machine/startup.c
 */
#ifndef	STARTUP_SIZING
#define	USRPTSIZE 	(MAXUSERS*PROCSPERUSER+20)  /* == NPROC in param.c */
#else	STARTUP_SIZING
#define	USRPTSIZE 	128		/* This is an UPPER BOUND checked
					   in machine/startup.c */
#endif	STARTUP_SIZING

/*
 * The size of the clock loop.
 */
#define	LOOPPAGES	(maxfree - firstfree)

/*
 * The time for a process to be blocked before being very swappable.
 * This is a number of seconds which the system takes as being a non-trivial
 * amount of real time.  You probably shouldn't change this;
 * it is used in subtle ways (fractions and multiples of it are, that is, like
 * half of a ``long time'', almost a long time, etc.)
 * It is related to human patience and other factors which don't really
 * change over time.
 */
#define	MAXSLP 		20

/*
 * A swapped in process is given a small amount of core without being bothered
 * by the page replacement algorithm.  Basically this says that if you are
 * swapped in you deserve some resources.  We protect the last SAFERSS
 * pages against paging and will just swap you out rather than paging you.
 * Note that each process has at least UPAGES+CLSIZE pages which are not
 * paged anyways (this is currently 8+2=10 pages or 5k bytes), so this
 * number just means a swapped in process is given around 25k bytes.
 * Just for fun: current memory prices are 4600$ a megabyte on VAX (4/22/81),
 * so we loan each swapped in process memory worth 100$, or just admit
 * that we don't consider it worthwhile and swap it out to disk which costs
 * $30/mb or about $0.75.
 */
#define	SAFERSS		8		/* nominal ``small'' resident set size
					   protected against replacement */

/*
 * DISKRPM is used to estimate the number of paging i/o operations
 * which one can expect from a single disk controller.
 */
#define	DISKRPM		60

/*
 * Klustering constants.  Klustering is the gathering
 * of pages together for pagein/pageout, while clustering
 * is the treatment of hardware page size as though it were
 * larger than it really is.
 *
 * KLMAX gives maximum cluster size in CLSIZE page (cluster-page)
 * units.  Note that KLMAX*CLSIZE must be <= DMMIN in dmap.h.
 */

/*
 * NOTE: (KLMAX * CLBYTES) must be <= 32768 since swsize (an unsigned short)
 * is used to contain a number this great during paging.
 */

#define	KLMAX	(4/CLSIZE)		/* See note immediately above */
#define	KLSEQL	(2/CLSIZE)		/* in klust if vadvise(VA_SEQL) */
#define	KLIN	(1/CLSIZE)		/* default data/stack in klust */
#define	KLTXT	(1/CLSIZE)		/* default text in klust */
#define	KLOUT	(4/CLSIZE)

/*
 * KLSDIST is the advance or retard of the fifo reclaim for sequential
 * processes data space.
 */
#define	KLSDIST	3		/* klusters advance/retard for seq. fifo */

#ifdef s32
/*
 * Paging thresholds (see vm_sched.c).
 * Modified by ELP.
 * Strategy of 9/15/85:
 *	lotsfree is 1/16 of memory free, but at most 512k.
 *	desfree is 64k bytes, but at most 1/32 of memory
 *	minfree is 32k bytes, but at most 1/2 of desfree
 *
 * The btop's are because our page size is different and we
 * won't hardwire it here like others.
 */
#define	LOTSFREE	btop(512 * 1024 * 1024)
#define	LOTSFREEFRACT	16
#define	DESFREE		btop(64 * 1024 * 1024)
#define	DESFREEFRACT	32
#define	MINFREE		btop(32 * 1024 * 1024)
#define	MINFREEFRACT	2
#else	s32
/*
 * Paging thresholds (see vm_sched.c).
 * Strategy of 4/22/81:
 *	lotsfree is 1/4 of memory free.
 *	desfree is 200k bytes, but at most 1/8 of memory
 *	minfree is 64k bytes, but at most 1/2 of desfree
 */
#define	LOTSFREEFRACT	4
#define	DESFREE		(200 * 1024)
#define	DESFREEFRACT	8
#define	MINFREE		(64 * 1024)
#define	MINFREEFRACT	2
#endif	s32

/*
 * Believed threshold (in megabytes) for which interleaved
 * swapping area is desirable.
 */
#define	LOTSOFMEM	2

/*
 * BEWARE THIS DEFINITION WORKS ONLY WITH COUNT OF 1
 */
#ifndef s32
#define	mapin(pte, v, pfnum, count, prot) \
	(*(int *)(pte) = (pfnum) | (prot), mtpr(TBIS, ptob(v)))
#endif s32

#endif	VMPARAM_ALREADY_DEFINED
