/* rcsid[]="$Header: pcb.h,v 820.1 86/12/04 19:53:48 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

#ifndef	PCB_ALREADY_DEFINED
#define	PCB_ALREADY_DEFINED

/*	pcb.h	4.6	82/10/26	*/

#ifdef KERNEL
#include "../h/types.h"
#else
#include "sys/types.h"
#endif KERNEL


struct pcb
{
	label_t	pcb_regs;	/* saved registers (MUST BE FIRST) */
	int	pcb_sr; 	/* program status word */
	struct pte *pcb_p0br;	/* pseudo-P0BR for sun */
	int	pcb_p0lr;	/* pseudo-P0LR for sun */
	struct pte *pcb_p1br;	/* pseudo-P1BR for sun */
	int	pcb_p1lr;	/* pseudo-P1LR for sun */
	int	pcb_szpt; 	/* number of pages of user page table */
	int	pcb_cmap2;
	int	*pcb_sswap;
};

#define	AST_CLR	0
#define	PME_CLR	0

#define AST_NONE 0

#define aston()		(astflag=1)
#define astoff()	(astflag=0)

#ifdef KERNEL
char astflag;
#endif KERNEL

#endif	PCB_ALREADY_DEFINED
