/* rcsid[]="$Header: dkio.h,v 820.1 86/12/04 19:53:16 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*			Copyright 1984 - 1986				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Ioctl calls for disk drives.
 *
 * DKIOCSETP, DKIOCGETP
 *	Set and get parameters, using the dk_param structure.
 *	Per drive.
 *
 * DKIOCSETS, DKIOCSETP
 *	Set and get per drive partition sizes.
 *
 * DKIOCFORMAT
 *	Format one track.  Track number is relative to beginning
 *	of partition.
 *
 * DKIOCMAP
 *	Map track to an alternate.  Track number is relative
 *	to the beginning of partition.  Data is not copied.
 *
 * DKIOCRESET
 *	Reset the controller and drives.
 *
 * DKIOCSETA, DKIOCGETA
 *	Set and get the automatic bad track mapping enable flag.
 *
 */

#define DKIOCSETP	_IOW(_IO_DK, 0, struct dk_param)
#define DKIOCGETP	_IOR(_IO_DK, 1, struct dk_param)
#define DKIOCSETS	_IOW(_IO_DK, 2, struct dk_sizes [DK_NSIZES])
#define DKIOCGETS	_IOR(_IO_DK, 3, struct dk_sizes [DK_NSIZES])
#define DKIOCFORMAT	_IOW(_IO_DK, 4, int)
#define DKIOCMAP	_IOW(_IO_DK, 5, int)
#define DKIOCRESET	_IO(_IO_DK,  6)
#define DKIOCSETA	_IOW(_IO_DK, 7, int)
#define DKIOCGETA	_IOR(_IO_DK, 8, int)
#define DKIOCHDR	_IO(_IO_DK,  9)	/* Next I/O will read/write header */

/*
 * Parameters for DKIOCSETP and DKIOCGETP.
 * Not all controllers use all of the information.
 */
struct dk_param {
	int dk_ncyl;		/* number of data cylinders */
	int dk_acyl;		/* number of alternate cylinders */
	int dk_a_alloc;		/* number of alternate tracks allocated */
	int dk_nhead;		/* number of heads */
	int dk_nsec;		/* number of sectors */
	int dk_type;		/* controller dependent type */

	/* formatting information */
	int dk_intrlv;		/* interleave factor */
	int dk_gap1;		/* gap1 size */
	int dk_gap2;		/* gap2 size */
	int dk_skew;		/* skew factor */
	int dk_group;		/* group size, Interphase only */
	int dk_cache;		/* cache mode, Interphase only */
 
 	/* Following are Storager only */
 	u_char  dk_zerolatency;	/* zero latency mode */
 	u_char  dk_drivedesc;	/* uib drive descriptor byte (byte 18 in uib) */
 	u_char  dk_gap3;	/* gap3 size */
 	u_char  dk_bufstep;	/* does drive accept buffered steps? */
 	u_char  dk_stepwidth;	/* step pulse width */
 	u_short dk_stepinter;	/* step pulse interval */
 	u_char  dk_headloadtime;/* head load time */
 	u_char  dk_seektime;	/* track to track seek time */
 	u_short dk_precomp;	/* write precompensation starting cylinder */
 	u_short dk_redwrite;	/* reduced write current starting cylinder */

#define	IPERR_NCLASSES	3
#ifdef ISERRORLOGGING
	/* Hideous kludge for the reporting of disk errors.  */
	int dkSoftErrors;
	int dkFirmErrors[IPERR_NCLASSES];
	int dkHardErrors[IPERR_NCLASSES];
#else  ISERRORLOGGING
	int dkwaste[1+IPERR_NCLASSES+IPERR_NCLASSES]; /* Pad */
#endif ISERRORLOGGING
};

/*
 * Partition size structure.
 */
struct dk_sizes {
	long sz_nblk;
	int sz_cyloff;
};
#define DK_NSIZES	16
