/* rcsid[]="$Header: efs_ioctl.h,v 820.1 86/12/04 19:47:41 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * ioctl calls used with the Extended
 * File System.
 *
 * jam 840207-21-23-28-0305
 * jht 850601--  efs/efs_ioctl.c depends upon efs/efs_ioctl.h, upon h/ioctl.h;
 * smj 850813 Permanently disable NEW_BCAST, USER_BCAST;
 *	      Permanently enable NEWRPC, NET_SUPER_USER.
 */

#ifdef	KERNEL
#include "../h/ioctl.h"
#else	KERNEL
#include <sys/ioctl.h>
#include <sys/time.h>
#endif	KERNEL

#define RPC_IOCGETSTATS		_IOR(_IO_RPC, 5, struct rpc_stats)
#define RPC_IOCNULLNULL		_IOW(_IO_RPC, 6, char *)
#define RPC_IOCNULLCALL		_IOW(_IO_RPC, 7, char *)

struct rpc_time {
	char *		name;
	struct timeval	timeval;
};
#define RPC_IOCGETTIME		_IOWR(_IO_RPC, 22, struct rpc_time)
#define RPC_IOCSETTIME		_IOW(_IO_RPC, 23, struct rpc_time)
#define RPC_IOCSETLOCALTIME	_IOWR(_IO_RPC, 27, struct rpc_time)

#define RPC_IOCSERVER		_IO(_IO_RPC, 28)

#define CONN_IOCENABLE		_IOW(_IO_CONN, 9, char *)
#define CONN_IOCDISABLE		_IO(_IO_CONN, 10)
#define CONN_IOCENUMERATE	_IOWR(_IO_CONN, 11, connection_t)
#define CONN_IOCNAME		_IOWR(_IO_CONN, 12, connection_t)
#define CONN_IOCSHUTDOWN	_IOW(_IO_CONN, 13, long)
#define CONN_IOCLISTEN		_IO(_IO_CONN, 14)
#define CONN_IOCNOLISTEN	_IO(_IO_CONN, 15)
#define CONN_IOCREMOVE		_IOW(_IO_CONN, 16, char *)
#define CONN_IOCSUSPECT		_IOW(_IO_CONN, 26, char *)

#ifdef	CONN_GROUPS
#define CONN_IOCADDGROUP	_IOW(_IO_CONN, 24, long)
#define CONN_IOCDELGROUP	_IOW(_IO_CONN, 25, long)
#endif	CONN_GROUPS

#define EFS_IOCGETSTATS		_IOR(_IO_EFS, 4, struct efs_stats)
#define EFS_IOCNULLCALL		_IOW(_IO_EFS, 8, char *)
#define EFS_IOCENABLE		_IO(_IO_EFS, 29)
#define EFS_IOCDISABLE		_IO(_IO_EFS, 30)

#define EFS_IOCSUMOST		_IO(_IO_EFS, 17)
#define EFS_IOCSUFEW		_IO(_IO_EFS, 18)
#define EFS_IOCSUUID		_IOW(_IO_EFS, 19, int)
#define EFS_IOCSUADD		_IOW(_IO_EFS, 20, char *)
#define EFS_IOCSURM		_IOW(_IO_EFS, 21, char *)

#define BULK_IOCCREATE		_IO(_IO_BULK, 31)
#define BULK_IOCDESTROY		_IO(_IO_BULK, 32)
#define BULK_IOCSEND		_IOW(_IO_BULK, 33, int[2])


#define RPCIOC_IFCONFIG		_IOW(_IO_RPC, 40, struct ifreq)
#define	CONNIOC_IFCONFIG	_IOW(_IO_CONN, 41, struct ifreq)
#define BCASTIOC_IFCONFIG	_IOW(_IO_BCAST, 42, struct ifreq)
#define BULKIOC_IFCONFIG	_IOW(_IO_BULK, 43, struct ifreq)

#ifdef	EFS_VCD
#define	EFS_IOCVCD		_IOW(_IO_EFS, 100, int)
#endif	EFS_VCD
